/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.api.service.PurchaseInformationRecordsRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseInformationRecordsBeanServiceImpl
implements PurchaseInformationRecordsRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;

    public void addBatch(List<PurchaseInformationRecordsDTO> list) {
        this.purchaseInformationRecordsService.addBatch((List)SysUtil.copyProperties(list, PurchaseInformationRecords.class));
    }

    public void insertBatchSomeColumn(List<PurchaseInformationRecordsDTO> purchaseInformationRecordsDTOList) {
        if (CollectionUtil.isNotEmpty(purchaseInformationRecordsDTOList)) {
            this.purchaseInformationRecordsService.saveBatch((Collection)SysUtil.copyProperties(purchaseInformationRecordsDTOList, PurchaseInformationRecords.class));
        }
    }

    public void cancelBySourceNumber(String sourceType, String sourceNumber, List<String> itemNumberList) {
        this.purchaseInformationRecordsService.cancelBySourceNumber(sourceType, sourceNumber, itemNumberList);
    }

    public PurchaseInformationRecordsDTO getEffectiveRecord(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        PurchaseInformationRecordsDTO purchaseInformationRecordsDTO = null;
        PurchaseInformationRecords purchaseInformationRecords = this.purchaseInformationRecordsService.getEffectiveRecord(materialNumber, materialGroup, factory, purchaseOrg, toElsAccount);
        if (purchaseInformationRecords != null) {
            purchaseInformationRecordsDTO = (PurchaseInformationRecordsDTO)SysUtil.copyProperties((Object)purchaseInformationRecords, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTO;
    }

    public List<PurchaseInformationRecordsDTO> getEffectiveRecordList(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        List effectiveRecordList = this.purchaseInformationRecordsService.getEffectiveRecordList(materialNumber, materialGroup, factory, purchaseOrg, toElsAccount);
        ArrayList purchaseInformationRecordsDTOList = null;
        if (CollectionUtil.isNotEmpty((Collection)effectiveRecordList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)effectiveRecordList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    public List<PurchaseInformationRecordsDTO> selectList(List<String> toElsAccounts, String auditStatus, String recordStatus, Date effectiveDate, Date expiryDate, String materialNumber, String purchaseOrg) {
        QueryWrapper purchaseInformationRecordsQueryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(toElsAccounts)) {
            purchaseInformationRecordsQueryWrapper.in((Object)"to_els_account", toElsAccounts);
        }
        purchaseInformationRecordsQueryWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue());
        purchaseInformationRecordsQueryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qw.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or(qw1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)qw1.eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue());
            });
        });
        purchaseInformationRecordsQueryWrapper.le((Object)"effective_date", (Object)new Date());
        purchaseInformationRecordsQueryWrapper.ge((Object)"expiry_date", (Object)new Date());
        purchaseInformationRecordsQueryWrapper.eq((Object)"material_number", (Object)materialNumber);
        purchaseInformationRecordsQueryWrapper.eq((Object)"purchase_org", (Object)purchaseOrg);
        purchaseInformationRecordsQueryWrapper.orderByAsc((Object)"price");
        List purchaseInformationRecordsList = this.purchaseInformationRecordsService.list((Wrapper)purchaseInformationRecordsQueryWrapper);
        ArrayList purchaseInformationRecordsDTOList = null;
        if (CollectionUtil.isNotEmpty((Collection)purchaseInformationRecordsList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)purchaseInformationRecordsList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    public List<PurchaseInformationRecordsDTO> selectListNoOrg(String auditStatus, String recordStatus, Date effectiveDate, Date expiryDate, List<String> materialNumbers) {
        QueryWrapper informationRecordsQueryWrapper = new QueryWrapper();
        informationRecordsQueryWrapper.in((Object)"material_number", materialNumbers);
        informationRecordsQueryWrapper.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue());
        informationRecordsQueryWrapper.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue());
        informationRecordsQueryWrapper.le((Object)"effective_date", (Object)new Date());
        informationRecordsQueryWrapper.ge((Object)"expiry_date", (Object)new Date());
        informationRecordsQueryWrapper.last("and purchase_org is not null and purchase_org!='' ");
        List purchaseInformationRecordList = this.purchaseInformationRecordsService.list((Wrapper)informationRecordsQueryWrapper);
        ArrayList purchaseInformationRecordsDTOList = null;
        if (CollectionUtil.isNotEmpty((Collection)purchaseInformationRecordList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)purchaseInformationRecordList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    public void cutOffPriceDate(PurchaseInformationRecordsDTO records) {
        PurchaseInformationRecords informationRecords = (PurchaseInformationRecords)Convert.convert(PurchaseInformationRecords.class, (Object)records);
        this.purchaseInformationRecordsService.cutOffPriceDate(informationRecords, false);
    }

    public void cutOffPriceDates(List<PurchaseInformationRecordsDTO> records) {
        List list = Convert.toList(PurchaseInformationRecords.class, records);
        list.forEach(r -> this.purchaseInformationRecordsService.cutOffPriceDate(r, false));
    }

    public void checkPriceIfExistByBidding(PurchaseInformationRecordsDTO recordsDTO) {
        PurchaseInformationRecords records = (PurchaseInformationRecords)Convert.convert(PurchaseInformationRecords.class, (Object)recordsDTO);
        records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        records.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
        boolean exist = this.purchaseInformationRecordsService.checkPriceIfCreateByType(records);
        if (exist) {
            throw new ELSBootException(String.format("%s:%s %s", records.getSourceNumber(), records.getSourceItemNumber(), I18nUtil.translate((String)"i18n_alert_umtHIObL_8def9438", (String)"\u4ef7\u683c\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\uff01")));
        }
    }

    public List<String> checkPriceForSome(List<String> stringList) {
        return this.purchaseInformationRecordsService.checkPriceForSome(stringList);
    }
}

