/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.api.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.SrmPageDTO;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.api.dto.BiOrganizationDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.mapper.PurchaseOrganizationInfoMapper;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseOrganizationInfoBeanServiceImpl
implements PurchaseOrganizationInfoRpcService {
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;
    @Resource
    private PurchaseOrganizationInfoMapper purchaseOrganizationInfoMapper;

    public Map<String, String> getOrganizationByCode(String elsAccount, String orgCode) {
        return this.purchaseOrganizationInfoService.getOrganizationByCode(elsAccount, orgCode);
    }

    public PurchaseOrganizationInfoDTO selectByElsAccountAndCode(String elsAccount, String orgCategoryCode, String orgCode) {
        PurchaseOrganizationInfo info = this.purchaseOrganizationInfoService.selectByElsAccountAndCode(elsAccount, orgCategoryCode, orgCode);
        return (PurchaseOrganizationInfoDTO)SysUtil.copyProperties((Object)info, PurchaseOrganizationInfoDTO.class);
    }

    public PurchaseOrganizationInfoDTO selectById(String id) {
        PurchaseOrganizationInfo info = (PurchaseOrganizationInfo)this.purchaseOrganizationInfoService.getById((Serializable)((Object)id));
        return (PurchaseOrganizationInfoDTO)SysUtil.copyProperties((Object)info, PurchaseOrganizationInfoDTO.class);
    }

    public List<PurchaseOrganizationInfoDTO> listByIdAndCateCode(String id, String elsAccount, String orgCategoryCode) {
        List list = this.purchaseOrganizationInfoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)orgCategoryCode));
        return SysUtil.copyProperties((List)list, PurchaseOrganizationInfoDTO.class);
    }

    public List<PurchaseOrganizationInfoDTO> selectOrgByIds(String[] ids, String orgCategoryCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BaseEntity::getId, (Object[])ids);
        if (StrUtil.isNotBlank((CharSequence)orgCategoryCode)) {
            queryWrapper.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)orgCategoryCode);
        }
        List list = this.purchaseOrganizationInfoService.list((Wrapper)queryWrapper);
        return SysUtil.copyProperties((List)list, PurchaseOrganizationInfoDTO.class);
    }

    public List<PurchaseOrganizationInfoDTO> getOrgForCalendar(String elsAccount, String orgCode) {
        List orgForCalendar = this.purchaseOrganizationInfoService.getOrgForCalendar(elsAccount, orgCode);
        return SysUtil.copyProperties((List)orgForCalendar, PurchaseOrganizationInfoDTO.class);
    }

    public List<PurchaseOrganizationInfoDTO> listByCateCode(String elsAccount, String orgCategoryCode) {
        List list = this.purchaseOrganizationInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)orgCategoryCode));
        return SysUtil.copyProperties((List)list, PurchaseOrganizationInfoDTO.class);
    }

    public Map<String, String> listDeptOrganization(List<String> ids) {
        return this.purchaseOrganizationInfoService.listDeptOrganization(ids);
    }

    public List<PurchaseOrganizationInfoDTO> listOrganizationInfoByTypeAndCode(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return Lists.newArrayList();
        }
        return this.purchaseOrganizationInfoMapper.listOrganizationInfoByTypeAndCode(typeCodeList, TenantContext.getTenant());
    }

    public boolean checkOrgCode(String orgCode) {
        return this.purchaseOrganizationInfoService.checkOrgCode(orgCode);
    }

    public Map<String, String> getDeptOrganization(String elsAccount) {
        return this.purchaseOrganizationInfoService.getDeptOrganization(elsAccount);
    }

    public SrmPageDTO<PurchaseOrganizationInfoDTO> getOrganizationPage(int pageSize, int currentPage, String elsAccount, String deptName, String deptCode, String nature) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Page page = new Page((long)currentPage, (long)pageSize);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
        queryWrapper.lambda().eq(PurchaseOrganizationInfo::getStatus, (Object)1);
        if (StrUtil.isNotBlank((CharSequence)nature)) {
            queryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgNature, (Object)nature);
        }
        if (StrUtil.isNotBlank((CharSequence)deptName)) {
            queryWrapper.lambda().like(PurchaseOrganizationInfo::getOrgName, (Object)deptName);
        }
        if (StrUtil.isNotBlank((CharSequence)deptCode)) {
            queryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCode, (Object)deptCode);
        }
        IPage pageList = this.purchaseOrganizationInfoService.page((IPage)page, (Wrapper)queryWrapper);
        ArrayList recordList = SysUtil.copyProperties((List)pageList.getRecords(), PurchaseOrganizationInfoDTO.class);
        return new SrmPageDTO(pageList.getTotal(), pageList.getPages(), (List)recordList);
    }

    public PurchaseOrganizationInfoDTO queryOrganizationInfoByOrgCode(String elsAccount, String orgCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
        queryWrapper.lambda().eq(PurchaseOrganizationInfo::getStatus, (Object)1);
        queryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgNature, (Object)"0");
        queryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCode, (Object)orgCode);
        List organizationInfos = this.purchaseOrganizationInfoService.list((Wrapper)queryWrapper);
        if (!organizationInfos.isEmpty()) {
            PurchaseOrganizationInfoDTO purchaseOrganizationInfoDTO = new PurchaseOrganizationInfoDTO();
            SysUtil.copyProperties(organizationInfos.get(0), (Object)purchaseOrganizationInfoDTO);
            return purchaseOrganizationInfoDTO;
        }
        return null;
    }

    public List<PurchaseOrganizationInfoDTO> listByIds(List<String> ids) {
        List purchaseOrganizationInfoList = this.purchaseOrganizationInfoService.listByIds(ids);
        return Convert.toList(PurchaseOrganizationInfoDTO.class, (Object)purchaseOrganizationInfoList);
    }

    public boolean updateBatchById(List<PurchaseOrganizationInfoDTO> list) {
        ArrayList purchaseOrganizationInfos = SysUtil.copyProperties(list, PurchaseOrganizationInfo.class);
        return this.purchaseOrganizationInfoService.updateBatchById((Collection)purchaseOrganizationInfos);
    }

    public List<PurchaseOrganizationInfoDTO> listByElsAccountAndCode(String elsAccount, List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return Collections.emptyList();
        }
        QueryWrapper purchaseOrganizationInfoQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)purchaseOrganizationInfoQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(PurchaseOrganizationInfo::getOrgCode, orgCodeList);
        List list = this.purchaseOrganizationInfoService.list((Wrapper)purchaseOrganizationInfoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return Convert.toList(PurchaseOrganizationInfoDTO.class, (Object)list);
    }

    public List<BiOrganizationDTO> getDeptOrganizationTree(String elsAccount) {
        List list = this.purchaseOrganizationInfoMapper.selectOrganization(elsAccount, "dept");
        List<BiOrganizationDTO> result = list.stream().map(node -> {
            BiOrganizationDTO dto = new BiOrganizationDTO();
            dto.setId(node.getId());
            dto.setParentId(node.getSuperExecutiveId());
            dto.setOrgCode(node.getOrgCode());
            dto.setName(node.getTitle());
            dto.setFullName(node.getTitle());
            return dto;
        }).collect(Collectors.toList());
        return this.buildTree(result, "");
    }

    private List<BiOrganizationDTO> buildTree(List<BiOrganizationDTO> all, String rootId) {
        ArrayList parent = com.google.common.collect.Lists.newArrayList();
        List ids = all.stream().map(BiOrganizationDTO::getId).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        for (BiOrganizationDTO commentNode : all) {
            commentNode.setSubOrganizations(this.getChildren(commentNode, all));
            if (!CharSequenceUtil.isEmpty((CharSequence)commentNode.getParentId()) && ids.contains(commentNode.getParentId()) || commentNode.getId().equals(commentNode.getParentId())) continue;
            parent.add(commentNode);
        }
        return parent;
    }

    private List<BiOrganizationDTO> getChildren(BiOrganizationDTO commentNode, List<BiOrganizationDTO> all) {
        ArrayList<BiOrganizationDTO> childList = new ArrayList<BiOrganizationDTO>(8);
        for (BiOrganizationDTO child : all) {
            if (!commentNode.getId().equals(child.getParentId()) || commentNode.getId().equals(commentNode.getParentId())) continue;
            child.setSubOrganizations(this.getChildren(child, all));
            childList.add(child);
        }
        return childList;
    }
}

