/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.modules.base.api.service.AiChatRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceAiChatRpcServiceImpl")
public class PriceAiChatRpcServiceImpl
implements AiChatRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;

    public Map<String, String> loadSchemaData(JSONObject param) {
        HashMap<String, String> priceMap = new HashMap<String, String>();
        priceMap.put("historyPriceSchema", "");
        if (null != param) {
            return priceMap;
        }
        List materialNumberList = param.getJSONArray("materialNumber").toJavaList(String.class);
        String groupFiled = param.getString("groupFiled");
        if (CollectionUtil.isEmpty((Collection)materialNumberList)) {
            return priceMap;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.in(PurchaseInformationRecords::getMaterialNumber, (Collection)materialNumberList)).in(PurchaseInformationRecords::getRecordStatus, new Object[]{"6"});
        List list = this.purchaseInformationRecordsService.list((Wrapper)wrapper);
        ArrayList<JSONObject> historyPriceList = new ArrayList<JSONObject>();
        for (PurchaseInformationRecords records : list) {
            String supplierName = records.getSupplierName();
            BigDecimal price = records.getPrice();
            BigDecimal netPrice = records.getNetPrice();
            Date quoteDate = records.getQuoteDate();
            if (null == quoteDate) {
                quoteDate = records.getEffectiveDate();
            }
            JSONObject item = new JSONObject();
            item.put("\u516c\u53f8\u540d\u79f0", (Object)supplierName);
            item.put("\u7269\u6599\u7f16\u7801", (Object)records.getMaterialNumber());
            item.put("\u542b\u7a0e\u5355\u4ef7", (Object)price);
            item.put("\u4e0d\u542b\u7a0e\u5355\u4ef7", (Object)netPrice);
            String dateFormat = quoteDate == null ? "" : DateUtil.format((Date)quoteDate, (String)"yyyy-MM-dd");
            item.put("\u4ef7\u683c\u65e5\u671f", (Object)dateFormat);
            historyPriceList.add(item);
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)groupFiled)) {
            Map<String, List<JSONObject>> historyPriceListMap = historyPriceList.stream().collect(Collectors.groupingBy(x -> x.getString(groupFiled)));
            priceMap.put("historyPriceSchema", JSON.toJSONString(historyPriceListMap));
        } else {
            priceMap.put("historyPriceSchema", JSON.toJSONString(historyPriceList));
        }
        return priceMap;
    }
}

