/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.price.enumerate.MaterialCreateSourceTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseMaterialSourceServiceImpl
extends ServiceImpl<PurchaseMaterialSourceMapper, PurchaseMaterialSource>
implements PurchaseMaterialSourceService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;

    @Override
    public void savePurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        if (StringUtils.isBlank((CharSequence)purchaseMaterialSource.getSourceId())) {
            purchaseMaterialSource.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)purchaseMaterialSource));
        }
        purchaseMaterialSource.setSourceType(MaterialCreateSourceTypeEnum.SRM.getValue());
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.INVALID.getValue());
        ((PurchaseMaterialSourceMapper)this.baseMapper).insert((Object)purchaseMaterialSource);
    }

    @Override
    public void updatePurchaseMaterialSource(PurchaseMaterialSource purchaseMaterialSource) {
        int count;
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialSourceType()), (String)I18nUtil.translate((String)"i18n_alert_SjAclS_2dcdb97f", (String)"\u8d27\u6e90\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLKWVSMSLAy_89390dcf", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7f16\u53f7"));
        } else if ("2".equals(purchaseMaterialSource.getMaterialSourceType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_SjAcLSLVKWVSMSLVlS_857af31e", (String)"\u8d27\u6e90\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        if ("1".equals(purchaseMaterialSource.getExclusionMark())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialSource.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_VSMTPAGjSLAy_bf5095dd", (String)"\u8bf7\u586b\u5199\u9700\u8981\u6392\u9664\u7684\u7269\u6599\u7f16\u53f7"));
        }
        if (purchaseMaterialSource.getEffectiveDate() != null) {
            if (Calendar.getInstance().getTime().before(purchaseMaterialSource.getEffectiveDate())) {
                purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.INVALID.getValue());
            } else {
                purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
            }
        }
        if ((count = ((PurchaseMaterialSourceMapper)this.baseMapper).updateById((Object)purchaseMaterialSource)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void frozenPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.FROZEN.getValue());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelPurchaseMaterialSource(String id) {
        PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)this.purchaseMaterialSourceMapper.selectById((Serializable)((Object)id)));
        purchaseMaterialSource.setStatus(MaterialSourceStatusEnum.CANCEL.getValue());
        purchaseMaterialSource.setExpiryDate(Calendar.getInstance().getTime());
        int count = this.purchaseMaterialSourceMapper.updateById((Object)purchaseMaterialSource);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delPurchaseMaterialSource(String id) {
        ((PurchaseMaterialSourceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseMaterialSource(List<String> idList) {
        ((PurchaseMaterialSourceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void addBatch(List<PurchaseMaterialSource> sourceList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("materialSource");
        for (PurchaseMaterialSource source : sourceList) {
            source.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            source.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            source.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion().toString());
            source.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
        }
        this.saveBatch(sourceList);
    }
}

