/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseInformationRecordsExcelHandler")
public class PurchaseInformationRecordsExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;

    public void importExcel(List<Map<String, Object>> dataList) {
        List headList;
        Map collect;
        List taxCode;
        List<String> supplierCode;
        Object head;
        Map collect2;
        List headList2;
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        com.els.common.util.Assert.isNotNull((Object)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u4ef7\u683c\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f\u3002");
        ArrayList<PurchaseInformationRecords> entityList = new ArrayList<PurchaseInformationRecords>();
        for (Map<String, Object> data : dataList) {
            PurchaseInformationRecords entity = (PurchaseInformationRecords)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseInformationRecords.class));
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setElsAccount(TenantContext.getTenant());
            entity.setSourceType(PriceSourceTypeEnum.SRM.getValue());
            entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            entity.setTaxRate(null);
            if (entity.getExpiryDate() != null && entity.getEffectiveDate() != null && entity.getExpiryDate().before(entity.getEffectiveDate())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
            }
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return;
        }
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPriceNumber", entityList.get(0), size);
        Assert.notEmpty((Collection)nextCodes, (String)"\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e\u7f16\u7801\u751f\u6210\u5f02\u5e38");
        int codeIndex = 0;
        for (PurchaseInformationRecords e : entityList) {
            e.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
        }
        List code = entityList.stream().map(PurchaseInformationRecords::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(code)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialHead::getMaterialNumber, PurchaseMaterialHead::getMaterialName, PurchaseMaterialHead::getMaterialDesc, PurchaseMaterialHead::getMaterialGroup, PurchaseMaterialHead::getBaseUnit});
            wrapper.in(PurchaseMaterialHead::getMaterialNumber, code);
            headList2 = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
            collect2 = headList2.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v1));
            if (CollUtil.isNotEmpty(collect2)) {
                for (PurchaseInformationRecords r : entityList) {
                    head = (PurchaseMaterialHead)((Object)collect2.get(r.getMaterialNumber()));
                    if (head == null) continue;
                    r.setMaterialName(head.getMaterialName());
                    r.setMaterialDesc(head.getMaterialDesc());
                    r.setMaterialGroup(head.getMaterialGroup());
                    r.setBasicUnit(head.getBaseUnit());
                }
            }
        }
        if (CollUtil.isNotEmpty(supplierCode = entityList.stream().map(PurchaseInformationRecords::getSupplierCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList())) && CollUtil.isNotEmpty(collect2 = (headList2 = this.priceInvokeSupplierRpcService.getSupplierMasterDataBySupplierCode(supplierCode)).stream().collect(Collectors.toMap(SupplierMasterDataDTO::getSupplierCode, Function.identity(), (v1, v2) -> v1)))) {
            for (PurchaseInformationRecords r : entityList) {
                head = (SupplierMasterDataDTO)collect2.get(r.getSupplierCode());
                if (head == null) continue;
                r.setSupplierCode(head.getSupplierCode());
                r.setSupplierName(head.getSupplierName());
                r.setToElsAccount(head.getToElsAccount());
            }
        }
        if (CollUtil.isNotEmpty(taxCode = entityList.stream().map(PurchaseInformationRecords::getTaxCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList())) && CollUtil.isNotEmpty(collect = (headList = this.invokeBaseRpcService.getElsTaxByCode(taxCode)).stream().collect(Collectors.toMap(ElsTaxDTO::getTaxCode, Function.identity(), (v1, v2) -> v1)))) {
            for (PurchaseInformationRecords r : entityList) {
                ElsTaxDTO head2 = (ElsTaxDTO)collect.get(r.getTaxCode());
                if (head2 != null) {
                    r.setTaxCode(head2.getTaxCode());
                    r.setTaxRate(head2.getTaxRate().toString());
                    continue;
                }
                r.setTaxCode(null);
                r.setTaxRate(null);
            }
        }
        for (PurchaseInformationRecords entity : entityList) {
            this.purchaseInformationRecordsService.calculatePrice(entity);
        }
        this.purchaseInformationRecordsService.addBatch(entityList);
    }
}

