/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.entity.TreeOrgNode;
import com.els.modules.org.enumerate.PurchaseOrganizationStatus;
import com.els.modules.org.excel.PurchaseOrganizationInfoExportServiceImpl;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u4f01\u4e1a\u7ec4\u7ec7\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/org/purchaseOrganizationInfo"})
public class PurchaseOrganizationInfoController
extends BaseController<PurchaseOrganizationInfo, PurchaseOrganizationInfoService> {
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseOrganizationInfo purchaseOrganizationInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseOrganizationInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.purchaseOrganizationInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u65b0\u589e")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    public Result<?> add(@RequestBody PurchaseOrganizationInfo purchaseOrganizationInfo) {
        if ("companyCode".equals(purchaseOrganizationInfo.getOrgCategoryCode()) && StringUtils.isBlank((CharSequence)purchaseOrganizationInfo.getChargeCurrency())) {
            throw new ELSBootException("\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u516c\u53f8\u65f6\uff0c\u8bb0\u8d26\u672c\u4f4d\u5e01\u4e0d\u80fd\u4e3a\u7a7a");
        }
        purchaseOrganizationInfo.setStatus(PurchaseOrganizationStatus.NORMAL.getValue());
        this.purchaseOrganizationInfoService.savePurchaseOrganizationInfo(purchaseOrganizationInfo);
        return Result.ok((Object)((Object)purchaseOrganizationInfo));
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    public Result<?> edit(@RequestBody PurchaseOrganizationInfo purchaseOrganizationInfo) {
        Assert.hasText((String)purchaseOrganizationInfo.getOrgCode(), (String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u7f16\u7801");
        Assert.hasText((String)purchaseOrganizationInfo.getOrgName(), (String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u540d\u79f0");
        Assert.hasText((String)purchaseOrganizationInfo.getOrgNature(), (String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u6027\u8d28");
        if ("companyCode".equals(purchaseOrganizationInfo.getOrgCategoryCode()) && StringUtils.isBlank((CharSequence)purchaseOrganizationInfo.getChargeCurrency())) {
            throw new ELSBootException("\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u516c\u53f8\u65f6\uff0c\u8bb0\u8d26\u672c\u4f4d\u5e01\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)purchaseOrganizationInfo.getId())) {
            this.add(purchaseOrganizationInfo);
        }
        if ("purchaseOrganization".equals(purchaseOrganizationInfo.getOrgCategoryCode())) {
            purchaseOrganizationInfo.setSuperBusinessId(null);
        } else {
            purchaseOrganizationInfo.setRelateBusinessId(null);
        }
        this.purchaseOrganizationInfoService.updatePurchaseOrganizationInfo(purchaseOrganizationInfo);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseOrganizationInfoService.delPurchaseOrganizationInfo(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseOrganizationInfoService.delBatchPurchaseOrganizationInfo(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u83b7\u53d6\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7\u6811")
    @ApiOperation(value="\u83b7\u53d6\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7\u6811")
    @GetMapping(value={"/getSuperOrgByBus"})
    public Result<?> getSuperOrgByBus() {
        Map<String, Object> resule = this.purchaseOrganizationInfoService.getSuperiorOrganization();
        return Result.ok((Object)resule.get("business"));
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u83b7\u53d6\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u6811")
    @ApiOperation(value="\u83b7\u53d6\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u6811")
    @GetMapping(value={"/getSuperOrgByExecutive"})
    public Result<?> getSuperOrgByExecutive() {
        Map<String, Object> resule = this.purchaseOrganizationInfoService.getSuperiorOrganization();
        return Result.ok((Object)resule.get("executive"));
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6811")
    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u884c\u653f\u7ec4\u7ec7\u6811")
    @GetMapping(value={"/getOrgTree"})
    public Result<?> getOrgTree() {
        List<TreeOrgNode> list = this.purchaseOrganizationInfoService.getExecutiveOrganization();
        return Result.ok(list);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u83b7\u53d6\u5de5\u5382\u7ec4\u7ec7\u6811")
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5382\u7ec4\u7ec7\u6811", notes="\u83b7\u53d6\u5de5\u5382\u7ec4\u7ec7\u6811")
    @GetMapping(value={"/getOrgFactoryTree"})
    public Result<?> getOrgFactoryTree() {
        List<TreeOrgNode> list = this.purchaseOrganizationInfoService.getFactoryOrganization();
        return Result.ok(list);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u83b7\u53d6\u7ea7\u8054\u7ec4\u7ec7\u67b6\u6784", busModule="\u7ec4\u7ec7\u67b6\u6784")
    @ApiOperation(value="\u83b7\u53d6\u7ea7\u8054\u7ec4\u7ec7\u67b6\u6784", notes="\u83b7\u53d6\u7ea7\u8054\u7ec4\u7ec7\u67b6\u6784")
    @GetMapping(value={"/getOrgCascader"})
    public Result<?> getOrgCascader() {
        List<TreeOrgNode> list = this.purchaseOrganizationInfoService.getOrgCascader();
        return Result.ok(list);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseOrganizationInfo purchaseOrganizationInfo = (PurchaseOrganizationInfo)((Object)this.purchaseOrganizationInfoService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)purchaseOrganizationInfo));
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u901a\u8fc7id\u51bb\u7ed3")
    @ApiOperation(value="\u901a\u8fc7id\u51bb\u7ed3", notes="\u901a\u8fc7id\u51bb\u7ed3")
    @GetMapping(value={"/frozen"})
    public Result<?> frozen(@RequestParam(name="id") String id, @RequestParam(name="status") String status) {
        this.purchaseOrganizationInfoService.frozen(id, status);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u6839\u636e\u5b50\u8d26\u53f7\u83b7\u53d6\u5bf9\u5e94\u7684\u7ec4\u7ec7")
    @ApiOperation(value="\u6839\u636e\u5b50\u8d26\u53f7\u83b7\u53d6\u5bf9\u5e94\u7684\u7ec4\u7ec7", notes="\u6839\u636e\u5b50\u8d26\u53f7\u83b7\u53d6\u5bf9\u5e94\u7684\u7ec4\u7ec7")
    @GetMapping(value={"/getOrgBySubAccount"})
    public Result<?> getOrgBySubAccount(@RequestParam(name="subAccount") String subAccount) {
        if (StringUtils.isBlank((CharSequence)subAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UVLLV_b45dfc16", (String)"\u7533\u8bf7\u4eba\u4e3a\u7a7a"));
        }
        List<PurchaseOrganizationInfo> orgList = this.purchaseOrganizationInfoService.getOrgBySubAccount(subAccount.split("_")[0]);
        Page page = new Page();
        page.setRecords(orgList);
        return Result.ok((Object)page);
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseOrganizationInfoExportServiceImpl.class);
    }

    @AutoLog(value="\u7ec4\u7ec7\u67b6\u6784-\u83b7\u53d6\u516c\u53f8\u7ec4\u7ec7\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u516c\u53f8\u7ec4\u7ec7\u4fe1\u606f", notes="\u83b7\u53d6\u516c\u53f8\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/queryCompanyByCode"})
    public Result<?> queryCompanyByCode(@RequestParam(name="orgCode") String orgCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCode, (Object)orgCode);
        queryWrapper.lambda().eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"companyCode");
        List list = this.purchaseOrganizationInfoService.list((Wrapper)queryWrapper);
        return Result.ok((Object)list);
    }
}

