/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.industryinfo.entity.TopManBean;
import com.els.modules.industryinfo.service.TopManService;
import com.mongodb.client.MongoCursor;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
@EnableScheduling
public class TopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TopManJob.class);
    @Resource
    private TopManService topManService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TOPMAN_COLLECTION_NAME = "tb_topman_data";
    private final int BATCH_SIZE = 5000;

    public void execute(String parameter) {
        log.info("------------start TopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_topman_data").find().noCursorTimeout(true).batchSize(5000).cursor();){
            ArrayList<TopManBean> entityList = new ArrayList<TopManBean>();
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                entityList.add(this.genTopMan(doc));
                if (++i % 1000 != 0) continue;
                this.topManService.saveOrUpdateBatch(entityList);
                entityList = new ArrayList();
            }
            this.topManService.saveOrUpdateBatch(entityList);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private BigDecimal stringToBigDecimal(String val) {
        if (val != null && !"null".equals(val)) {
            return new BigDecimal(val);
        }
        return new BigDecimal(0);
    }

    private TopManBean genTopMan(Document doc) {
        TopManBean bean = new TopManBean();
        bean.setId(doc.getString((Object)"_id"));
        bean.setElsAccount("100000");
        bean.setPlatform(doc.getString((Object)"platform"));
        bean.setTopManName(doc.getString((Object)"topman_name"));
        bean.setTopManId(doc.getString((Object)"topman_id"));
        bean.setTopManAvatar(doc.getString((Object)"topman_avatar"));
        bean.setFansNum(this.stringToBigDecimal(doc.getString((Object)"fans_num")));
        bean.setTopManSex(doc.getBoolean((Object)"topman_sex") != false ? new Long(1L) : new Long(0L));
        bean.setTag(doc.getString((Object)"tags_relation"));
        bean.setPredictCpm(this.stringToBigDecimal(doc.getString((Object)"prospective_60_cpm")));
        bean.setTopManRegion(doc.getString((Object)"province") + "-" + doc.getString((Object)"region"));
        bean.setQuote(this.stringToBigDecimal(doc.getString((Object)"price_60")));
        return bean;
    }

    @Scheduled(cron="0 0/30 * * * ?")
    public void doScheduled() {
        log.info("------------start TopManJob Scheduled-----------");
        this.execute(null);
    }
}

