/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.TopManInformationParam;
import com.els.modules.industryinfo.entity.TopManCollectBean;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.enumerate.MarkYn;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.excel.TopManInformationExportServiceImpl;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.els.modules.industryinfo.service.TopManInformationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/topMan"})
@Api(tags={"\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class TopManController
extends BaseController<TopManParamEntity, TopManInformationService> {
    @Autowired
    private TopManCollectService topManCollectService;
    @Autowired
    private TopManInformationService topManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list/{type}"})
    public Result<?> listAll(@RequestBody SimplePostRequestParam<TopManInformationParam> topManDto, @PathVariable(value="type") TopManQueryType topManQueryType) {
        try {
            IPage<? extends TopManResultEntity> pageList = this.topManInformationService.queryTopManList(topManDto, topManQueryType);
            return Result.ok(pageList);
        }
        catch (IllegalAccessException e) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u8f6c\u6362\u5f02\u5e38"));
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam(value="param") String param) {
        Map map = (Map)JSON.parseObject((String)param, Map.class);
        return super.exportXls(request, map, TopManInformationExportServiceImpl.class);
    }

    @GetMapping(value={"/collect/{yn}/{platform}/{topManId}"})
    @AutoLog(value="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c")
    public Result<?> collect(@PathVariable(value="yn") String yn, @PathVariable(value="platform") String platform, @PathVariable(value="topManId") String topManId) {
        if (StringUtils.isBlank((CharSequence)yn) || StringUtils.isBlank((CharSequence)platform) || StringUtils.isBlank((CharSequence)platform)) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        if (MarkYn.check(yn)) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(topManId);
            topManCollectBean.setPlatform(platform);
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
        queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
        queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)platform);
        queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)topManId);
        this.topManCollectService.remove((Wrapper)queryWrapper);
        return Result.ok();
    }
}

