/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.mapper.PurchaseBomHeadMapper;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseBomExcelHandler")
public class PurchaseBomExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Resource
    private PurchaseBomHeadMapper purchaseBomHeadMapper;

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("bom");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6eBOM\u8868\u5355\u4e1a\u52a1\u6a21\u677f\u3002");
        ArrayList<PurchaseBomHead> entityList = new ArrayList<PurchaseBomHead>();
        for (Map<String, Object> data : dataList) {
            PurchaseBomHead entity = (PurchaseBomHead)((Object)JSON.parseObject((String)JSON.toJSONString(data), PurchaseBomHead.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entityList.add(entity);
        }
        List headList = this.purchaseBomHeadMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant()));
        Map<String, String> headMap = headList.parallelStream().collect(Collectors.toMap(p -> p.getMaterialNumber() + "_" + p.getFactory() + "_" + p.getVersion(), BaseEntity::getId, (k1, k2) -> k1));
        for (int i = 0; i < entityList.size(); ++i) {
            PurchaseBomHead entity = (PurchaseBomHead)((Object)entityList.get(i));
            String key = entity.getMaterialNumber() + "_" + entity.getFactory() + "_" + entity.getVersion();
            if (!headMap.containsKey(key)) continue;
            int temp = ++i;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_HesIjWWWWWnWWWWcjWF_4041220f", (String)("\u7cfb\u7edf\u4e2d\u5df2\u6709Excel\u7b2c" + temp + "\u884c\u7684\u6570\u636e"), (String[])new String[]{temp + ""}));
        }
        this.purchaseBomHeadService.saveBatch(entityList);
        return dataList;
    }
}

