/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.organ.dto.PurchaserOrganHeadQueryDto;
import com.els.modules.organ.entity.PurchaserOrganAttractHotPushGoodsItem;
import com.els.modules.organ.entity.PurchaserOrganAttractHotPushShopItem;
import com.els.modules.organ.entity.PurchaserOrganAttractItem;
import com.els.modules.organ.entity.PurchaserOrganContractTalentItem;
import com.els.modules.organ.entity.PurchaserOrganDetailHeadEntity;
import com.els.modules.organ.entity.PurchaserOrganHead;
import com.els.modules.organ.entity.PurchaserOrganIndustryReleaseItem;
import com.els.modules.organ.entity.PurchaserOrganItem;
import com.els.modules.organ.entity.PurchaserOrganPushCategoryItem;
import com.els.modules.organ.mapper.PurchaserOrganAttractHotPushGoodsItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganAttractHotPushShopItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganAttractItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganContractTalentItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganFansReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganGradeReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganHeadMapper;
import com.els.modules.organ.mapper.PurchaserOrganIndustryReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganPushCategoryItemMapper;
import com.els.modules.organ.service.PurchaserOrganHeadService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaserOrganHeadServiceImpl
extends BaseServiceImpl<PurchaserOrganHeadMapper, PurchaserOrganHead>
implements PurchaserOrganHeadService {
    @Autowired
    private PurchaserOrganHeadMapper purchaserOrganHeadMapper;
    @Autowired
    private PurchaserOrganItemMapper purchaserOrganItemMapper;
    @Autowired
    private PurchaserOrganPushCategoryItemMapper purchaserOrganPushCategoryItemMapper;
    @Autowired
    private PurchaserOrganIndustryReleaseItemMapper purchaserOrganIndustryReleaseItemMapper;
    @Autowired
    private PurchaserOrganGradeReleaseItemMapper purchaserOrganGradeReleaseItemMapper;
    @Autowired
    private PurchaserOrganFansReleaseItemMapper purchaserOrganFansReleaseItemMapper;
    @Autowired
    private PurchaserOrganAttractItemMapper purchaserOrganAttractItemMapper;
    @Autowired
    private PurchaserOrganAttractHotPushGoodsItemMapper purchaserOrganAttractHotPushGoodsItemMapper;
    @Autowired
    private PurchaserOrganAttractHotPushShopItemMapper purchaserOrganAttractHotPushShopItemMapper;
    @Autowired
    private PurchaserOrganContractTalentItemMapper purchaserOrganContractTalentItemMapper;

    @Override
    public IPage<PurchaserOrganHead> mcnQueryPageList(Page<PurchaserOrganHead> page, HttpServletRequest req, PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        PurchaserOrganHead organHead = new PurchaserOrganHead();
        BeanUtils.copyProperties((Object)purchaserOrganHeadQueryDto, (Object)((Object)organHead));
        organHead.setOrganType(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)organHead), (Map)req.getParameterMap());
        if (!this.queryMcnParamIsNull(purchaserOrganHeadQueryDto)) {
            List<String> headIdList = this.purchaserOrganItemMapper.getHeadId(purchaserOrganHeadQueryDto);
            if (CollectionUtils.isNotEmpty(headIdList)) {
                queryWrapper.in((Object)"h.id", headIdList);
            } else {
                return new Page();
            }
        }
        ArrayList<String> organTypeList = new ArrayList<String>();
        organTypeList.add("0");
        organTypeList.add("2");
        queryWrapper.in((Object)"h.organ_type", organTypeList);
        IPage<PurchaserOrganHead> purchaserOrganHeadIPage = this.purchaserOrganHeadMapper.mcnQueryPageList((IPage<PurchaserOrganHead>)page, (QueryWrapper<PurchaserOrganHead>)queryWrapper);
        for (PurchaserOrganHead purchaserOrganHead : purchaserOrganHeadIPage.getRecords()) {
            purchaserOrganHead.setDays(PurchaserOrganHeadServiceImpl.getDays(new Date(), purchaserOrganHead.getSettledDate()));
            PurchaserOrganItem purchaserOrganItem = this.purchaserOrganItemMapper.queryByHeadId(purchaserOrganHead.getId());
            if (purchaserOrganItem == null) continue;
            List<PurchaserOrganIndustryReleaseItem> purchaserOrganIndustryReleaseItems = this.purchaserOrganIndustryReleaseItemMapper.getTopThreeData(purchaserOrganItem.getId());
            List<PurchaserOrganContractTalentItem> topData = this.purchaserOrganContractTalentItemMapper.getTopData(purchaserOrganHead.getId(), 0, 5);
            purchaserOrganItem.setPrchaserOrganIndustryReleaseItems(purchaserOrganIndustryReleaseItems);
            purchaserOrganItem.setPurchaserOrganContractTalentItems(topData);
            purchaserOrganHead.setPurchaserOrganItem(purchaserOrganItem);
        }
        return purchaserOrganHeadIPage;
    }

    @Override
    public IPage<PurchaserOrganHead> attractQueryPageList(Page<PurchaserOrganHead> page, HttpServletRequest req, PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        PurchaserOrganHead organHead = new PurchaserOrganHead();
        BeanUtils.copyProperties((Object)purchaserOrganHeadQueryDto, (Object)((Object)organHead));
        organHead.setOrganType(null);
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)organHead), (Map)req.getParameterMap());
        if (!this.queryAttractParamIsNull(purchaserOrganHeadQueryDto)) {
            PurchaserOrganAttractItem queryPurchaserOrganAttractItem = new PurchaserOrganAttractItem();
            BeanUtils.copyProperties((Object)purchaserOrganHeadQueryDto, (Object)((Object)queryPurchaserOrganAttractItem));
            QueryWrapper itemQueryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)queryPurchaserOrganAttractItem), (Map)req.getParameterMap());
            List purchaserOrganAttractItems = this.purchaserOrganAttractItemMapper.selectList((Wrapper)itemQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)purchaserOrganAttractItems)) {
                ArrayList<String> headIds = new ArrayList<String>();
                for (PurchaserOrganAttractItem by : purchaserOrganAttractItems) {
                    headIds.add(by.getHeadId());
                }
                queryWrapper.in(CollectionUtils.isNotEmpty(headIds), (Object)"h.id", headIds);
            } else {
                return new Page();
            }
        }
        ArrayList<String> organTypeList = new ArrayList<String>();
        organTypeList.add("1");
        organTypeList.add("2");
        queryWrapper.in((Object)"h.organ_type", organTypeList);
        IPage<PurchaserOrganHead> purchaserOrganHeadIPage = this.purchaserOrganHeadMapper.attractQueryPageList((IPage<PurchaserOrganHead>)page, (QueryWrapper<PurchaserOrganHead>)queryWrapper);
        for (PurchaserOrganHead purchaserOrganHead : purchaserOrganHeadIPage.getRecords()) {
            purchaserOrganHead.setDays(PurchaserOrganHeadServiceImpl.getDays(new Date(), purchaserOrganHead.getSettledDate()));
            PurchaserOrganAttractItem purchaserOrganAttractItem = this.purchaserOrganAttractItemMapper.getAttractItemData(purchaserOrganHead.getId(), null, null);
            if (purchaserOrganAttractItem == null) continue;
            List<PurchaserOrganPushCategoryItem> topThreeData = this.purchaserOrganPushCategoryItemMapper.getTopThreeData(purchaserOrganHead.getId());
            purchaserOrganAttractItem.setPurchaserOrganPushCategoryItems(topThreeData);
            purchaserOrganHead.setPurchaserOrganAttractItem(purchaserOrganAttractItem);
        }
        return purchaserOrganHeadIPage;
    }

    @Override
    public PurchaserOrganDetailHeadEntity detail(String id, String days, String category) {
        PurchaserOrganDetailHeadEntity purchaserOrganDetailHeadEntity = new PurchaserOrganDetailHeadEntity();
        PurchaserOrganHead purchaserOrganHead = (PurchaserOrganHead)((Object)this.purchaserOrganHeadMapper.selectById((Serializable)((Object)id)));
        purchaserOrganHead.setDays(PurchaserOrganHeadServiceImpl.getDays(new Date(), purchaserOrganHead.getSettledDate()));
        PurchaserOrganDetailHeadEntity.OrganBaseData organBaseData = new PurchaserOrganDetailHeadEntity.OrganBaseData();
        BeanUtils.copyProperties((Object)((Object)purchaserOrganHead), (Object)organBaseData);
        purchaserOrganDetailHeadEntity.setOrganBaseData(organBaseData);
        if ("0".equals(purchaserOrganHead.getOrganType())) {
            this.getAttractData(purchaserOrganDetailHeadEntity, id, days, category);
        }
        if ("1".equals(purchaserOrganHead.getOrganType())) {
            this.getMcnData(purchaserOrganDetailHeadEntity, id);
        }
        if ("2".equals(purchaserOrganHead.getOrganType())) {
            this.getAttractData(purchaserOrganDetailHeadEntity, id, days, category);
            this.getMcnData(purchaserOrganDetailHeadEntity, id);
        }
        return purchaserOrganDetailHeadEntity;
    }

    @Override
    public List<PurchaserOrganContractTalentItem> queryConContractTalentData(String headId) {
        ArrayList<PurchaserOrganContractTalentItem> purchaserOrganContractTalentItems = new ArrayList();
        if (!StringUtils.isNotEmpty((CharSequence)headId)) {
            throw new ELSBootException("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        purchaserOrganContractTalentItems = this.purchaserOrganContractTalentItemMapper.getTopData(headId, 0, 50);
        return purchaserOrganContractTalentItems;
    }

    private void getAttractData(PurchaserOrganDetailHeadEntity purchaserOrganDetailHeadEntity, String headId, String days, String category) {
        PurchaserOrganAttractItem categoryAttractItem;
        Object organGoodsData;
        PurchaserOrganAttractItem attractItemData;
        List<PurchaserOrganPushCategoryItem> hotPushCategory = this.purchaserOrganPushCategoryItemMapper.getHotPushCategory(headId);
        ArrayList<PurchaserOrganDetailHeadEntity.OrganHotPushData> organHotPushDataList = new ArrayList<PurchaserOrganDetailHeadEntity.OrganHotPushData>();
        if (CollectionUtils.isNotEmpty(hotPushCategory)) {
            for (PurchaserOrganPushCategoryItem purchaserOrganPushCategoryItem : hotPushCategory) {
                PurchaserOrganDetailHeadEntity.OrganHotPushData organHotPushData = new PurchaserOrganDetailHeadEntity.OrganHotPushData();
                BeanUtils.copyProperties((Object)((Object)purchaserOrganPushCategoryItem), (Object)organHotPushData);
                organHotPushDataList.add(organHotPushData);
            }
            purchaserOrganDetailHeadEntity.setOrganHotPushData(organHotPushDataList);
        }
        if ((attractItemData = this.purchaserOrganAttractItemMapper.getAttractItemData(headId, days, category)) != null) {
            PurchaserOrganDetailHeadEntity.OrganAttractData organAttractData = new PurchaserOrganDetailHeadEntity.OrganAttractData();
            BeanUtils.copyProperties((Object)((Object)attractItemData), (Object)organAttractData);
            purchaserOrganDetailHeadEntity.setOrganAttractData(organAttractData);
            organGoodsData = new PurchaserOrganDetailHeadEntity.OrganGoodsData();
            BeanUtils.copyProperties((Object)((Object)attractItemData), (Object)organGoodsData);
            purchaserOrganDetailHeadEntity.setOrganGoodsData((PurchaserOrganDetailHeadEntity.OrganGoodsData)organGoodsData);
        }
        if ((categoryAttractItem = this.purchaserOrganAttractItemMapper.getAttractItemData(headId, days, null)) != null) {
            organGoodsData = new PurchaserOrganDetailHeadEntity.OrganCategoryData();
            BeanUtils.copyProperties((Object)organGoodsData, (Object)((Object)categoryAttractItem));
            purchaserOrganDetailHeadEntity.setOrganCategoryData((PurchaserOrganDetailHeadEntity.OrganCategoryData)organGoodsData);
        }
    }

    private void getMcnData(PurchaserOrganDetailHeadEntity purchaserOrganDetailHeadEntity, String headId) {
        PurchaserOrganItem mcnItemData = this.purchaserOrganItemMapper.getMcnItemData(headId);
        if (mcnItemData != null) {
            PurchaserOrganDetailHeadEntity.OrganMcnTopData organMcnTopData = new PurchaserOrganDetailHeadEntity.OrganMcnTopData();
            BeanUtils.copyProperties((Object)((Object)mcnItemData), (Object)organMcnTopData);
            purchaserOrganDetailHeadEntity.setOrganMcnTopData(organMcnTopData);
            PurchaserOrganDetailHeadEntity.OrganMcnData organMcnData = new PurchaserOrganDetailHeadEntity.OrganMcnData();
            BeanUtils.copyProperties((Object)((Object)mcnItemData), (Object)organMcnData);
            purchaserOrganDetailHeadEntity.setOrganMcnData(organMcnData);
        }
    }

    @Override
    public IPage<PurchaserOrganAttractHotPushGoodsItem> hotSaleGoods(Page<PurchaserOrganAttractHotPushGoodsItem> page, HttpServletRequest req, PurchaserOrganAttractHotPushGoodsItem purchaserOrganAttractHotPushGoodsItem) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserOrganAttractHotPushGoodsItem), (Map)req.getParameterMap());
        Page purchaserOrganAttractHotPushGoodsItemPage = (Page)this.purchaserOrganAttractHotPushGoodsItemMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return purchaserOrganAttractHotPushGoodsItemPage;
    }

    @Override
    public IPage<PurchaserOrganAttractHotPushShopItem> hotSaleShop(Page<PurchaserOrganAttractHotPushShopItem> page, HttpServletRequest req, PurchaserOrganAttractHotPushShopItem purchaserOrganAttractHotPushShopItem) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserOrganAttractHotPushShopItem), (Map)req.getParameterMap());
        Page purchaserOrganAttractHotPushShopItemPage = (Page)this.purchaserOrganAttractHotPushShopItemMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return purchaserOrganAttractHotPushShopItemPage;
    }

    private boolean queryMcnParamIsNull(PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        return purchaserOrganHeadQueryDto.getQualityNum() == null && purchaserOrganHeadQueryDto.getQualityFansNum() == null && purchaserOrganHeadQueryDto.getPlayNum() == null && purchaserOrganHeadQueryDto.getPlayTalentNum() == null & StringUtils.isEmpty((CharSequence)purchaserOrganHeadQueryDto.getCategory());
    }

    private boolean queryAttractParamIsNull(PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        return purchaserOrganHeadQueryDto.getTotalSales() == null && purchaserOrganHeadQueryDto.getCommissionAvg() == null && purchaserOrganHeadQueryDto.getSingleQuantityAvg() == null && purchaserOrganHeadQueryDto.getServiceGoodsNum() == null && StringUtils.isEmpty((CharSequence)purchaserOrganHeadQueryDto.getCategory()) && purchaserOrganHeadQueryDto.getSingleGoodsNum() == null && purchaserOrganHeadQueryDto.getSingleStoreNum() == null;
    }

    public static String getDays(Date afterDate, Date beforDate) {
        int days = (int)((afterDate.getTime() - beforDate.getTime()) / 86400000L);
        String time = String.valueOf(days);
        return time;
    }
}

