/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.job;

import com.els.common.api.service.JobRpcService;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.job.utils.DataFormatUtils;
import com.els.modules.industryinfo.service.TopManInformationHeadService;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class TopManJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(TopManJob.class);
    @Resource
    private TopManInformationHeadService topManInformationHeadService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TOPMAN_DATA_NAME = "tb_topman_data";
    private final String TOPMAN_COLLECTION_NAME = "tb_doudian_daren_uid";
    private final String TOPMAN_DETAIL_NAME = "tb_doudian_daren_detail";
    private final int BATCH_SIZE = 5000;

    public void execute(String parameter) {
        log.info("------------start TopManJob-----------");
        int i = 0;
        try (MongoCursor cursor = this.mongoTemplate.getCollection("tb_doudian_daren_uid").find().noCursorTimeout(true).batchSize(5000).cursor();){
            ArrayList<TopManInformationHead> entityList = new ArrayList<TopManInformationHead>();
            log.info("------------start TopManJob cursor -----------1");
            while (cursor.hasNext()) {
                ++i;
                Document doc = (Document)cursor.next();
                try {
                    String id = doc.getString((Object)"_id");
                    Document inquerDoc = new Document();
                    inquerDoc.append("_id", (Object)id);
                    Document topmapData = (Document)this.mongoTemplate.getCollection("tb_topman_data").find((Bson)inquerDoc).first();
                    Document detail = (Document)this.mongoTemplate.getCollection("tb_doudian_daren_detail").find((Bson)inquerDoc).first();
                    entityList.add(this.genTopMan(doc, detail, topmapData));
                }
                catch (Exception e) {
                    log.error("doc error ", (Object)doc);
                    log.error("genTopMan error ", (Throwable)e);
                }
                if (i % 1000 != 0) continue;
                log.info("------------start TopManJob cursor -----------" + i);
                try {
                    this.topManInformationHeadService.saveOrUpdateBatch(entityList);
                }
                catch (Exception e) {
                    log.error("saveOrUpdateBatch error", (Throwable)e);
                }
                entityList = new ArrayList();
            }
            log.info("------------start TopManJob cursor -----------" + i);
            this.topManInformationHeadService.saveOrUpdateBatch(entityList);
        }
        catch (Exception e) {
            log.error("mongodb error", (Throwable)e);
        }
    }

    private TopManInformationHead genTopMan(Document doc, Document detail, Document topmapData) {
        Document base = (Document)doc.get((Object)"author_base");
        Document contact = (Document)doc.get((Object)"author_contact");
        TopManInformationHead bean = new TopManInformationHead();
        bean.setId(doc.getString((Object)"_id"));
        bean.setElsAccount("100000");
        bean.setPlatform("1");
        bean.setTopmanName(base.getString((Object)"nickname"));
        bean.setTopmanId(base.getString((Object)"uid"));
        bean.setTopmanAvatar(base.getString((Object)"avatar_big"));
        bean.setFansNum(DataFormatUtils.numberToBigDecimal(base.get((Object)"fans_num")));
        bean.setTopmanSex(DataFormatUtils.numberToString(base.getInteger((Object)"gender")));
        bean.setRegion(base.getString((Object)"city"));
        bean.setTopmanLevel(DataFormatUtils.numberToString(base.get((Object)"author_level")));
        bean.setMobile(contact.getString((Object)"phone"));
        bean.setWechat(contact.getString((Object)"wechat"));
        this.genData(topmapData, bean);
        this.genDetail(detail, bean);
        return bean;
    }

    private void genDetail(Document detail, TopManInformationHead bean) {
        if (detail != null && !detail.isEmpty()) {
            bean.setRemark(detail.getString((Object)"introduction"));
            bean.setGoodsWom(detail.getString((Object)"score"));
            bean.setCreditScore(DataFormatUtils.numberToString(detail.get((Object)"credit_score")));
        }
    }

    private void genData(Document topmanData, TopManInformationHead bean) {
        if (topmanData != null && !topmanData.isEmpty()) {
            bean.setXingtuTopman("1");
            bean.setQuoteOfLive(DataFormatUtils.stringToBigDecimal(topmanData.getString((Object)"price_60")));
        }
    }

    public void doScheduled() {
        log.info("------------start TopManJob Scheduled-----------");
        this.execute(null);
    }
}

