/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsFavorite;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsLiveItem;
import com.els.modules.industryinfo.entity.GoodsLiveRecord;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsVideoItem;
import com.els.modules.industryinfo.entity.GoodsVideoRecord;
import com.els.modules.industryinfo.mapper.GoodsFavoriteMapper;
import com.els.modules.industryinfo.mapper.GoodsHeadMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveItemMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveRecordMapper;
import com.els.modules.industryinfo.mapper.GoodsTopmanItemMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoItemMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoRecordMapper;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.vo.GoodsHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsHeadServiceImpl
extends BaseServiceImpl<GoodsHeadMapper, GoodsHead>
implements GoodsHeadService {
    @Autowired
    private GoodsHeadMapper goodsHeadMapper;
    @Autowired
    private GoodsTopmanItemMapper goodsTopmanItemMapper;
    @Autowired
    private GoodsVideoItemMapper goodsVideoItemMapper;
    @Autowired
    private GoodsVideoRecordMapper goodsVideoRecordMapper;
    @Autowired
    private GoodsLiveItemMapper goodsLiveItemMapper;
    @Autowired
    private GoodsLiveRecordMapper goodsLiveRecordMapper;
    @Autowired
    private GoodsFavoriteMapper goodsFavoriteMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public IPage<GoodsHead> queryPage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("1");
        }
        this.criteriaQuery(queryWrapper, queryDTO);
        Page goodsHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(goodsHeadPage.getRecords());
        return goodsHeadPage;
    }

    @Override
    public IPage<GoodsHead> queryFavoritePage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        List<GoodsFavorite> goodsFavoriteList = this.goodsFavoriteMapper.selectByElsAccount(elsAccount);
        if (!CollectionUtils.isEmpty(goodsFavoriteList)) {
            List goodsIds = goodsFavoriteList.stream().map(GoodsFavorite::getGoodsId).collect(Collectors.toList());
            queryWrapper.lambda().in(GoodsHead::getId, goodsIds);
            this.criteriaQuery(queryWrapper, queryDTO);
        } else {
            queryWrapper.lambda().eq(GoodsHead::getId, null);
        }
        Page goodsHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(goodsHeadPage.getRecords());
        return goodsHeadPage;
    }

    private void replenish(List<GoodsHead> records) {
        if (!CollectionUtils.isEmpty(records)) {
            for (GoodsHead goodsHead : records) {
                LoginUser loginUser = SysUtil.getLoginUser();
                String elsAccount = loginUser.getElsAccount();
                GoodsFavorite goodsFavorite = this.goodsFavoriteMapper.selectGoodsFavorite(goodsHead.getId(), elsAccount);
                goodsHead.setFavoriteGoods(false);
                if (goodsFavorite == null) continue;
                goodsHead.setFavoriteGoods(true);
            }
        }
    }

    @Override
    public QueryWrapper<GoodsHead> criteriaQuery(QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        String goodsRate;
        String goodsPrice;
        String timeSelect = queryDTO.getTimeSelect();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)timeSelect)) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getUpdateTime, (Object)selectDay, (Object)today);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodsPrice = queryDTO.getGoodsPrice()))) {
            String price;
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.lambda().gt(GoodsHead::getPrice, (Object)new BigDecimal(prices[0]));
                queryWrapper.lambda().le(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                price = goodsPrice.substring(goodsPrice.indexOf("<") + 1);
                queryWrapper.lambda().lt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                price = goodsPrice.substring(goodsPrice.indexOf(">") + 1);
                queryWrapper.lambda().gt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodsRate = queryDTO.getGoodsCommissionRate()))) {
            String[] strings;
            if (goodsRate.contains("-")) {
                strings = goodsRate.split("-");
                String split = strings[0].contains("%") ? strings[0].split("%")[0] : strings[0];
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().gt(GoodsHead::getCommissionRate, (Object)split);
                queryWrapper.lambda().le(GoodsHead::getCommissionRate, (Object)split1);
            }
            if (goodsRate.contains(">=")) {
                strings = goodsRate.split(">=");
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().ge(GoodsHead::getCommissionRate, (Object)split1);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        switch (timeSelect) {
            case "1": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String goodsBrowsesNum;
                String salesNum;
                String[] strings;
                String topman = queryDTO.getGoodsTopmanNum();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumDay, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(GoodsHead::getTopmanNumDay, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        String string = topman.substring(topman.indexOf(">") + 1);
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumDay, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(GoodsHead::getTopmanNumDay, (Object)topman);
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
                    if (salesNum.contains("-")) {
                        strings = salesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getSalesNumDay, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (salesNum.contains(">=")) {
                        strings = salesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getSalesNumDay, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
                    if (goodsBrowsesNum.contains("-")) {
                        strings = goodsBrowsesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getBrowsesNumDay, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (goodsBrowsesNum.contains(">=")) {
                        strings = goodsBrowsesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getBrowsesNumDay, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(GoodsHead::getLivesNumDay);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(GoodsHead::getVideosNumDay);
                break;
            }
            case "7": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String[] strings;
                String goodsBrowsesNum;
                String salesNum;
                String topman = queryDTO.getGoodsTopmanNum();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumWeek, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(GoodsHead::getTopmanNumWeek, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        String string = topman.substring(topman.indexOf(">") + 1);
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumWeek, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(GoodsHead::getTopmanNumWeek, (Object)topman);
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
                    if (salesNum.contains("-")) {
                        strings = salesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getSalesNumWeek, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (salesNum.contains(">=")) {
                        strings = salesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getSalesNumWeek, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
                    if (goodsBrowsesNum.contains("-")) {
                        strings = goodsBrowsesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getBrowsesNumWeek, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (goodsBrowsesNum.contains(">=")) {
                        strings = goodsBrowsesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getBrowsesNumWeek, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(GoodsHead::getLivesNumWeek);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(GoodsHead::getVideosNumWeek);
                break;
            }
            case "30": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String[] strings;
                String goodsBrowsesNum;
                String salesNum;
                String topman = queryDTO.getGoodsTopmanNum();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumMonth, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(GoodsHead::getTopmanNumMonth, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        String string = topman.substring(topman.indexOf(">") + 1);
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumMonth, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(GoodsHead::getTopmanNumMonth, (Object)topman);
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
                    if (salesNum.contains("-")) {
                        strings = salesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getSalesNumMonth, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (salesNum.contains(">=")) {
                        strings = salesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getSalesNumMonth, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
                    if (goodsBrowsesNum.contains("-")) {
                        strings = goodsBrowsesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getBrowsesNumMonth, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (goodsBrowsesNum.contains(">=")) {
                        strings = goodsBrowsesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getBrowsesNumMonth, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(GoodsHead::getLivesNumMonth);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(GoodsHead::getVideosNumMonth);
                break;
            }
            case "90": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String[] strings;
                String goodsBrowsesNum;
                String salesNum;
                String topman = queryDTO.getGoodsTopmanNum();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumSeason, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(GoodsHead::getTopmanNumSeason, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        String string = topman.substring(topman.indexOf(">") + 1);
                        queryWrapper.lambda().gt(GoodsHead::getTopmanNumSeason, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(GoodsHead::getTopmanNumSeason, (Object)topman);
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(salesNum = queryDTO.getGoodsSalesNum()))) {
                    if (salesNum.contains("-")) {
                        strings = salesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getSalesNumSeason, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (salesNum.contains(">=")) {
                        strings = salesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getSalesNumSeason, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(goodsBrowsesNum = queryDTO.getGoodsBrowsesNum()))) {
                    if (goodsBrowsesNum.contains("-")) {
                        strings = goodsBrowsesNum.split("-");
                        queryWrapper.lambda().between(GoodsHead::getBrowsesNumSeason, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
                    }
                    if (goodsBrowsesNum.contains(">=")) {
                        strings = goodsBrowsesNum.split(">=");
                        queryWrapper.lambda().ge(GoodsHead::getBrowsesNumSeason, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(GoodsHead::getLivesNumSeason);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(GoodsHead::getVideosNumSeason);
                break;
            }
        }
        return queryWrapper;
    }

    @Override
    public List<GoodsHead> collateList(List<GoodsHead> list, GoodsHeadQueryDTO queryDTO) {
        if (CollectionUtil.isNotEmpty(list)) {
            for (GoodsHead head : list) {
                String timeSelect = queryDTO.getTimeSelect();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)timeSelect)) {
                    timeSelect = "1";
                }
                BigDecimal salesNum = BigDecimal.ZERO;
                BigDecimal salesNumLive = BigDecimal.ZERO;
                BigDecimal salesNumVideo = BigDecimal.ZERO;
                BigDecimal topmanNum = BigDecimal.ZERO;
                BigDecimal videosNum = BigDecimal.ZERO;
                BigDecimal livesNum = BigDecimal.ZERO;
                BigDecimal browsesNum = BigDecimal.ZERO;
                BigDecimal convertRate = BigDecimal.ZERO;
                BigDecimal salesAmountMin = BigDecimal.ZERO;
                BigDecimal salesAmountMax = BigDecimal.ZERO;
                switch (timeSelect) {
                    case "1": {
                        salesNum = head.getSalesNumDay();
                        salesNumLive = head.getSalesNumDayLive();
                        salesNumVideo = head.getSalesNumDayVideo();
                        topmanNum = head.getTopmanNumDay();
                        salesAmountMin = head.getSalesAmountMinDay();
                        salesAmountMax = head.getSalesAmountMaxDay();
                        videosNum = head.getVideosNumDay();
                        livesNum = head.getLivesNumDay();
                        browsesNum = head.getBrowsesNumDay();
                        convertRate = head.getConvertRateDay();
                        break;
                    }
                    case "7": {
                        salesNum = head.getSalesNumWeek();
                        salesNumLive = head.getSalesNumWeekLive();
                        salesNumVideo = head.getSalesNumWeekVideo();
                        topmanNum = head.getTopmanNumWeek();
                        salesAmountMin = head.getSalesAmountMinWeek();
                        salesAmountMax = head.getSalesAmountMaxWeek();
                        videosNum = head.getVideosNumWeek();
                        livesNum = head.getLivesNumWeek();
                        browsesNum = head.getBrowsesNumWeek();
                        convertRate = head.getConvertRateWeek();
                        break;
                    }
                    case "30": {
                        salesNum = head.getSalesNumMonth();
                        salesNumLive = head.getSalesNumMonthLive();
                        salesNumVideo = head.getSalesNumMonthVideo();
                        topmanNum = head.getTopmanNumMonth();
                        salesAmountMin = head.getSalesAmountMinMonth();
                        salesAmountMax = head.getSalesAmountMaxMonth();
                        videosNum = head.getVideosNumMonth();
                        livesNum = head.getLivesNumMonth();
                        browsesNum = head.getBrowsesNumMonth();
                        convertRate = head.getConvertRateMonth();
                        break;
                    }
                    case "90": {
                        salesNum = head.getSalesNumSeason();
                        salesNumLive = head.getSalesNumSeasonLive();
                        salesNumVideo = head.getSalesNumSeasonVideo();
                        topmanNum = head.getTopmanNumSeason();
                        salesAmountMin = head.getSalesAmountMinSeason();
                        salesAmountMax = head.getSalesAmountMaxSeason();
                        videosNum = head.getVideosNumSeason();
                        livesNum = head.getLivesNumSeason();
                        browsesNum = head.getBrowsesNumSeason();
                        convertRate = head.getConvertRateSeason();
                        break;
                    }
                }
                head.setSalesNum(salesNum);
                head.setSalesNumLive(salesNumLive);
                head.setSalesNumVideo(salesNumVideo);
                head.setTopmanNum(topmanNum);
                head.setSalesAmountMin(salesAmountMin);
                head.setSalesAmountMax(salesAmountMax);
                head.setVideosNum(videosNum);
                head.setLivesNum(livesNum);
                head.setBrowsesNum(browsesNum);
                head.setConvertRate(convertRate);
                head.setQueryDay(timeSelect);
            }
        }
        return list;
    }

    @Override
    public GoodsHead collateById(String id, GoodsTopmanItemQueryDTO queryDTO) {
        GoodsHead head = (GoodsHead)((Object)((GoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head != null) {
            String timeSelect = queryDTO.getTopmanTimeSelect();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)timeSelect)) {
                timeSelect = "1";
            }
            BigDecimal salesNum = BigDecimal.ZERO;
            BigDecimal salesNumLive = BigDecimal.ZERO;
            BigDecimal salesNumVideo = BigDecimal.ZERO;
            BigDecimal topmanNum = BigDecimal.ZERO;
            BigDecimal videosNum = BigDecimal.ZERO;
            BigDecimal livesNum = BigDecimal.ZERO;
            BigDecimal browsesNum = BigDecimal.ZERO;
            BigDecimal convertRate = BigDecimal.ZERO;
            BigDecimal salesAmountMin = BigDecimal.ZERO;
            BigDecimal salesAmountMax = BigDecimal.ZERO;
            switch (timeSelect) {
                case "1": {
                    salesNum = head.getSalesNumDay();
                    salesNumLive = head.getSalesNumDayLive();
                    salesNumVideo = head.getSalesNumDayVideo();
                    topmanNum = head.getTopmanNumDay();
                    salesAmountMin = head.getSalesAmountMinDay();
                    salesAmountMax = head.getSalesAmountMaxDay();
                    videosNum = head.getVideosNumDay();
                    livesNum = head.getLivesNumDay();
                    browsesNum = head.getBrowsesNumDay();
                    convertRate = head.getConvertRateDay();
                    break;
                }
                case "7": {
                    salesNum = head.getSalesNumWeek();
                    salesNumLive = head.getSalesNumWeekLive();
                    salesNumVideo = head.getSalesNumWeekVideo();
                    topmanNum = head.getTopmanNumWeek();
                    salesAmountMin = head.getSalesAmountMinWeek();
                    salesAmountMax = head.getSalesAmountMaxWeek();
                    videosNum = head.getVideosNumWeek();
                    livesNum = head.getLivesNumWeek();
                    browsesNum = head.getBrowsesNumWeek();
                    convertRate = head.getConvertRateWeek();
                    break;
                }
                case "30": {
                    salesNum = head.getSalesNumMonth();
                    salesNumLive = head.getSalesNumMonthLive();
                    salesNumVideo = head.getSalesNumMonthVideo();
                    topmanNum = head.getTopmanNumMonth();
                    salesAmountMin = head.getSalesAmountMinMonth();
                    salesAmountMax = head.getSalesAmountMaxMonth();
                    videosNum = head.getVideosNumMonth();
                    livesNum = head.getLivesNumMonth();
                    browsesNum = head.getBrowsesNumMonth();
                    convertRate = head.getConvertRateMonth();
                    break;
                }
                case "90": {
                    salesNum = head.getSalesNumSeason();
                    salesNumLive = head.getSalesNumSeasonLive();
                    salesNumVideo = head.getSalesNumSeasonVideo();
                    topmanNum = head.getTopmanNumSeason();
                    salesAmountMin = head.getSalesAmountMinSeason();
                    salesAmountMax = head.getSalesAmountMaxSeason();
                    videosNum = head.getVideosNumSeason();
                    livesNum = head.getLivesNumSeason();
                    browsesNum = head.getBrowsesNumSeason();
                    convertRate = head.getConvertRateSeason();
                    break;
                }
            }
            head.setSalesNum(salesNum);
            head.setSalesNumLive(salesNumLive);
            head.setSalesNumVideo(salesNumVideo);
            head.setTopmanNum(topmanNum);
            head.setSalesAmountMin(salesAmountMin);
            head.setSalesAmountMax(salesAmountMax);
            head.setVideosNum(videosNum);
            head.setLivesNum(livesNum);
            head.setBrowsesNum(browsesNum);
            head.setConvertRate(convertRate);
        }
        return head;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.insert((Object)goodsHead);
        super.setHeadDefaultValue((BaseEntity)goodsHead);
        this.insertData(goodsHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.updateById((Object)goodsHead);
        this.goodsTopmanItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsVideoItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsLiveItemMapper.deleteByMainId(goodsHead.getId());
        this.insertData(goodsHead, headVO);
    }

    @Override
    public void favorite(String id) {
        GoodsHead goodsHead = (GoodsHead)((Object)((GoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        GoodsFavorite goodsFavorite = new GoodsFavorite();
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        goodsFavorite.setElsAccount(elsAccount);
        goodsFavorite.setGoodsId(goodsHead.getId());
        goodsFavorite.setPlatform(goodsHead.getPlatform());
        goodsFavorite.setFavoriteTime(new Date());
        this.goodsFavoriteMapper.insert((Object)goodsFavorite);
    }

    @Override
    public void cancelFavorite(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        this.goodsFavoriteMapper.deleteGoodsFavorite(id, elsAccount);
    }

    private void insertData(GoodsHead goodsHead, GoodsHeadVO headVO) {
        List<GoodsTopmanItem> goodsTopmanItemList = headVO.getGoodsTopmanItemList();
        List<GoodsVideoItem> goodsVideoItemList = headVO.getGoodsVideoItemList();
        List<GoodsVideoRecord> goodsVideoLists = headVO.getGoodsVideoRecordList();
        List<GoodsLiveItem> goodsLiveItemList = headVO.getGoodsLiveItemList();
        List<GoodsLiveRecord> goodsLiveLists = headVO.getGoodsLiveRecordList();
        if (!CollectionUtils.isEmpty(goodsTopmanItemList)) {
            for (GoodsTopmanItem goodsTopmanItem : goodsTopmanItemList) {
                goodsTopmanItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsTopmanItem, (BaseEntity)goodsHead);
            }
            if (!goodsTopmanItemList.isEmpty()) {
                this.goodsTopmanItemMapper.insertBatchSomeColumn(goodsTopmanItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoItemList)) {
            for (GoodsVideoItem goodsVideoItem : goodsVideoItemList) {
                goodsVideoItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoItem, (BaseEntity)goodsHead);
            }
            if (!goodsVideoItemList.isEmpty()) {
                this.goodsVideoItemMapper.insertBatchSomeColumn(goodsVideoItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoLists)) {
            for (GoodsVideoRecord goodsVideoRecord : goodsVideoLists) {
                goodsVideoRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoRecord, (BaseEntity)goodsHead);
            }
            if (!goodsVideoLists.isEmpty()) {
                this.goodsVideoRecordMapper.insertBatchSomeColumn(goodsVideoLists);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveItemList)) {
            for (GoodsLiveItem goodsLiveItem : goodsLiveItemList) {
                goodsLiveItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveItem, (BaseEntity)goodsHead);
            }
            if (!goodsLiveItemList.isEmpty()) {
                this.goodsLiveItemMapper.insertBatchSomeColumn(goodsLiveItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveLists)) {
            for (GoodsLiveRecord goodsLiveRecord : goodsLiveLists) {
                goodsLiveRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveRecord, (BaseEntity)goodsHead);
            }
            if (!goodsLiveLists.isEmpty()) {
                this.goodsLiveRecordMapper.insertBatchSomeColumn(goodsLiveLists);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.goodsTopmanItemMapper.deleteByMainId(id);
        this.goodsVideoItemMapper.deleteByMainId(id);
        this.goodsLiveItemMapper.deleteByMainId(id);
        this.goodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.goodsTopmanItemMapper.deleteByMainId(serializable.toString());
            this.goodsVideoItemMapper.deleteByMainId(serializable.toString());
            this.goodsLiveItemMapper.deleteByMainId(serializable.toString());
            this.goodsHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<CountVO> categoryCounts(GoodsHead goodsHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"store_id", (Object)goodsHead.getStoreId());
        queryWrapper.select(new String[]{"category", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"category");
        List list = this.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(GoodsHead::getCategory, GoodsHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("category", TenantContext.getTenant());
        for (DictDTO dto : dictDTOList) {
            Integer total;
            Integer n = total = countMap.get(dto.getValue()) == null ? Integer.valueOf(0) : countMap.get(dto.getValue());
            if (StringUtils.isBlank((CharSequence)dto.getValue())) {
                total = all;
            }
            result.add(new CountVO(I18nUtil.translate((String)dto.getTextI18nKey(), (String)dto.getText()), "category", dto.getValue(), total));
        }
        return result;
    }
}

