/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.StoreHeadQueryDTO;
import com.els.modules.industryinfo.entity.StoreFavorite;
import com.els.modules.industryinfo.entity.StoreHead;
import com.els.modules.industryinfo.entity.StoreTopmanItem;
import com.els.modules.industryinfo.mapper.StoreFavoriteMapper;
import com.els.modules.industryinfo.mapper.StoreHeadMapper;
import com.els.modules.industryinfo.mapper.StoreTopmanItemMapper;
import com.els.modules.industryinfo.service.StoreHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StoreHeadServiceImpl
extends BaseServiceImpl<StoreHeadMapper, StoreHead>
implements StoreHeadService {
    @Autowired
    private StoreHeadMapper storeHeadMapper;
    @Autowired
    private StoreTopmanItemMapper storeTopmanItemMapper;
    @Autowired
    private StoreFavoriteMapper storeFavoriteMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public IPage<StoreHead> queryPage(Page<StoreHead> page, QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        if (StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("1");
        }
        this.criteriaQuery(queryWrapper, queryDTO);
        Page storeHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(storeHeadPage.getRecords());
        return storeHeadPage;
    }

    @Override
    public IPage<StoreHead> queryFavoritePage(Page<StoreHead> page, QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        List<StoreFavorite> goodsFavoriteList = this.storeFavoriteMapper.selectByElsAccount(elsAccount);
        if (!CollectionUtils.isEmpty(goodsFavoriteList)) {
            List storeIds = goodsFavoriteList.stream().map(StoreFavorite::getStoreId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, storeIds);
            this.criteriaQuery(queryWrapper, queryDTO);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        Page storeHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(storeHeadPage.getRecords());
        return storeHeadPage;
    }

    private void replenish(List<StoreHead> records) {
        if (!CollectionUtils.isEmpty(records)) {
            for (StoreHead storeHead : records) {
                LoginUser loginUser = SysUtil.getLoginUser();
                String elsAccount = loginUser.getElsAccount();
                StoreFavorite storeFavorite = this.storeFavoriteMapper.selectGoodsFavorite(storeHead.getId(), elsAccount);
                storeHead.setFavoriteStore(false);
                if (storeFavorite == null) continue;
                storeHead.setFavoriteStore(true);
            }
        }
    }

    @Override
    public QueryWrapper<StoreHead> criteriaQuery(QueryWrapper<StoreHead> queryWrapper, StoreHeadQueryDTO queryDTO) {
        String experienceNum;
        String timeSelect = queryDTO.getTimeSelect();
        if (StringUtils.isNotBlank((CharSequence)timeSelect)) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getUpdateTime, (Object)selectDay, (Object)today);
        }
        if (StringUtils.isNotBlank((CharSequence)(experienceNum = queryDTO.getStoreExperienceNum())) && experienceNum.contains("~")) {
            String[] strings = experienceNum.split("~");
            queryWrapper.lambda().gt(StoreHead::getExperienceNum, (Object)new BigDecimal(strings[0]));
            queryWrapper.lambda().le(StoreHead::getExperienceNum, (Object)new BigDecimal(strings[1]));
        }
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        switch (timeSelect) {
            case "1": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String salesAmount;
                String videosNum;
                String[] strings;
                String topman = queryDTO.getStoreTopmanNum();
                if (StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumDay, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getTopmanNumDay, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumDay, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(StoreHead::getTopmanNumDay, (Object)topman);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
                    if (videosNum.contains("-")) {
                        strings = videosNum.split("-");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumDay, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getVideosNumDay, (Object)new BigDecimal(strings[1]));
                    }
                    if (videosNum.contains(">")) {
                        strings = videosNum.split(">");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumDay, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
                    if (salesAmount.contains("-")) {
                        strings = salesAmount.split("-");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxDay, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getSalesAmountMaxDay, (Object)new BigDecimal(strings[1]));
                    }
                    if (salesAmount.contains(">")) {
                        strings = salesAmount.split(">");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxDay, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(StoreHead::getLivesNumDay);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(StoreHead::getVideosNumDay);
                break;
            }
            case "7": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String salesAmount;
                String[] strings;
                String videosNum;
                String topman = queryDTO.getStoreTopmanNum();
                if (StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumWeek, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getTopmanNumWeek, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumWeek, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(StoreHead::getTopmanNumWeek, (Object)topman);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
                    if (videosNum.contains("-")) {
                        strings = videosNum.split("-");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumWeek, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getVideosNumWeek, (Object)new BigDecimal(strings[1]));
                    }
                    if (videosNum.contains(">")) {
                        strings = videosNum.split(">");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumWeek, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
                    if (salesAmount.contains("-")) {
                        strings = salesAmount.split("-");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxWeek, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getSalesAmountMaxWeek, (Object)new BigDecimal(strings[1]));
                    }
                    if (salesAmount.contains(">")) {
                        strings = salesAmount.split(">");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxWeek, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(StoreHead::getLivesNumWeek);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(StoreHead::getVideosNumWeek);
                break;
            }
            case "30": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String salesAmount;
                String[] strings;
                String videosNum;
                String topman = queryDTO.getStoreTopmanNum();
                if (StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumMonth, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getTopmanNumMonth, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumMonth, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(StoreHead::getTopmanNumMonth, (Object)topman);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
                    if (videosNum.contains("-")) {
                        strings = videosNum.split("-");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumMonth, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getVideosNumMonth, (Object)new BigDecimal(strings[1]));
                    }
                    if (videosNum.contains(">")) {
                        strings = videosNum.split(">");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumMonth, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
                    if (salesAmount.contains("-")) {
                        strings = salesAmount.split("-");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxMonth, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getSalesAmountMaxMonth, (Object)new BigDecimal(strings[1]));
                    }
                    if (salesAmount.contains(">")) {
                        strings = salesAmount.split(">");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxMonth, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(StoreHead::getLivesNumMonth);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(StoreHead::getVideosNumMonth);
                break;
            }
            case "90": {
                Boolean goodsVideo;
                Boolean goodsLive;
                String salesAmount;
                String[] strings;
                String videosNum;
                String topman = queryDTO.getStoreTopmanNum();
                if (StringUtils.isNotBlank((CharSequence)topman)) {
                    if (topman.contains("-")) {
                        strings = topman.split("-");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumSeason, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getTopmanNumSeason, (Object)new BigDecimal(strings[1]));
                    } else if (topman.contains(">")) {
                        strings = topman.split(">");
                        queryWrapper.lambda().gt(StoreHead::getTopmanNumSeason, (Object)new BigDecimal(strings[1]));
                    } else {
                        queryWrapper.lambda().eq(StoreHead::getTopmanNumSeason, (Object)topman);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
                    if (videosNum.contains("-")) {
                        strings = videosNum.split("-");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumSeason, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getVideosNumSeason, (Object)new BigDecimal(strings[1]));
                    }
                    if (videosNum.contains(">")) {
                        strings = videosNum.split(">");
                        queryWrapper.lambda().gt(StoreHead::getVideosNumSeason, (Object)new BigDecimal(strings[1]));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
                    if (salesAmount.contains("-")) {
                        strings = salesAmount.split("-");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxSeason, (Object)new BigDecimal(strings[0]));
                        queryWrapper.lambda().le(StoreHead::getSalesAmountMaxSeason, (Object)new BigDecimal(strings[1]));
                    }
                    if (salesAmount.contains(">")) {
                        strings = salesAmount.split(">");
                        queryWrapper.lambda().gt(StoreHead::getSalesAmountMaxSeason, (Object)new BigDecimal(strings[1]));
                    }
                }
                if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
                    queryWrapper.lambda().isNotNull(StoreHead::getLivesNumSeason);
                }
                if ((goodsVideo = queryDTO.getGoodsVideo()) == null || !goodsVideo.booleanValue()) break;
                queryWrapper.lambda().isNotNull(StoreHead::getVideosNumSeason);
                break;
            }
        }
        return queryWrapper;
    }

    @Override
    public List<StoreHead> collateList(List<StoreHead> list, StoreHeadQueryDTO queryDTO) {
        if (CollectionUtil.isNotEmpty(list)) {
            for (StoreHead head : list) {
                String timeSelect = queryDTO.getTimeSelect();
                if (StringUtils.isBlank((CharSequence)timeSelect)) {
                    timeSelect = "1";
                }
                BigDecimal salesNum = BigDecimal.ZERO;
                BigDecimal salesAmountMin = BigDecimal.ZERO;
                BigDecimal salesAmountMax = BigDecimal.ZERO;
                BigDecimal goodsNum = BigDecimal.ZERO;
                BigDecimal topmanNum = BigDecimal.ZERO;
                BigDecimal videosNum = BigDecimal.ZERO;
                BigDecimal livesNum = BigDecimal.ZERO;
                switch (timeSelect) {
                    case "1": {
                        salesNum = head.getSalesNumDay();
                        salesAmountMin = head.getSalesAmountMinDay();
                        salesAmountMax = head.getSalesAmountMaxDay();
                        goodsNum = head.getGoodsNumDay();
                        topmanNum = head.getTopmanNumDay();
                        videosNum = head.getVideosNumDay();
                        livesNum = head.getLivesNumDay();
                        break;
                    }
                    case "7": {
                        salesNum = head.getSalesNumWeek();
                        salesAmountMin = head.getSalesAmountMinWeek();
                        salesAmountMax = head.getSalesAmountMaxWeek();
                        goodsNum = head.getGoodsNumWeek();
                        topmanNum = head.getTopmanNumWeek();
                        videosNum = head.getVideosNumWeek();
                        livesNum = head.getLivesNumWeek();
                        break;
                    }
                    case "30": {
                        salesNum = head.getSalesNumMonth();
                        salesAmountMin = head.getSalesAmountMinMonth();
                        salesAmountMax = head.getSalesAmountMaxMonth();
                        goodsNum = head.getGoodsNumMonth();
                        topmanNum = head.getTopmanNumMonth();
                        videosNum = head.getVideosNumMonth();
                        livesNum = head.getLivesNumMonth();
                        break;
                    }
                    case "90": {
                        salesNum = head.getSalesNumSeason();
                        salesAmountMin = head.getSalesAmountMinSeason();
                        salesAmountMax = head.getSalesAmountMaxSeason();
                        goodsNum = head.getGoodsNumSeason();
                        topmanNum = head.getTopmanNumSeason();
                        videosNum = head.getVideosNumSeason();
                        livesNum = head.getLivesNumSeason();
                        break;
                    }
                }
                head.setSalesNum(salesNum);
                head.setSalesAmountMin(salesAmountMin);
                head.setSalesAmountMax(salesAmountMax);
                head.setGoodsNum(goodsNum);
                head.setTopmanNum(topmanNum);
                head.setVideosNum(videosNum);
                head.setLivesNum(livesNum);
                head.setQueryDay(timeSelect);
            }
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(StoreHead storeHead, List<StoreTopmanItem> storeTopmanItemList) {
        String platform = storeHead.getPlatform();
        String account = storeHead.getBusAccount();
        storeHead.setStoreCode(platform + account + this.invokeBaseRpcService.getNextCode("mcnSrmStoreCode", (Object)storeHead));
        this.storeHeadMapper.insert((Object)storeHead);
        super.setHeadDefaultValue((BaseEntity)storeHead);
        this.insertData(storeHead, storeTopmanItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(StoreHead storeHead, List<StoreTopmanItem> storeTopmanItemList) {
        this.storeHeadMapper.updateById((Object)storeHead);
        this.storeTopmanItemMapper.deleteByMainId(storeHead.getId());
        this.insertData(storeHead, storeTopmanItemList);
    }

    @Override
    public void favorite(String id) {
        StoreHead storeHead = (StoreHead)((Object)((StoreHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        StoreFavorite storeFavorite = new StoreFavorite();
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        storeFavorite.setElsAccount(elsAccount);
        storeFavorite.setStoreId(storeHead.getId());
        storeFavorite.setPlatform(storeHead.getPlatform());
        storeFavorite.setFavoriteTime(new Date());
        this.storeFavoriteMapper.insert((Object)storeFavorite);
    }

    @Override
    public void cancelFavorite(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        this.storeFavoriteMapper.deleteGoodsFavorite(id, elsAccount);
    }

    private void insertData(StoreHead storeHead, List<StoreTopmanItem> storeTopmanItemList) {
        if (!CollectionUtils.isEmpty(storeTopmanItemList)) {
            for (StoreTopmanItem entity : storeTopmanItemList) {
                entity.setHeadId(storeHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)storeHead);
            }
            if (!storeTopmanItemList.isEmpty()) {
                this.storeTopmanItemMapper.insertBatchSomeColumn(storeTopmanItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.storeTopmanItemMapper.deleteByMainId(id);
        this.storeHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.storeTopmanItemMapper.deleteByMainId(serializable.toString());
            this.storeHeadMapper.deleteById(serializable);
        }
    }
}

