/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.vo;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.exception.TopManException;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TopManInformationVO
implements Serializable {
    private static final long serialVersionUID = 21589665413145L;
    private String platformType;
    private ScreenItem screenItem;
    private String[] ids;

    public void initQueryWrapper(QueryWrapper<TopManParamEntity> queryWrapper) throws IllegalAccessException {
        if (this.ids != null) {
            queryWrapper.lambda().in(BaseEntity::getId, (Object[])this.ids);
        }
        if (this.platformType != null && this.platformType.trim().length() > 0) {
            queryWrapper.lambda().eq(TopManParamEntity::getPlatform, (Object)this.platformType);
        }
        if (this.screenItem != null) {
            this.screenItem.initQueryWrapper(queryWrapper);
        }
    }

    public String getPlatformType() {
        return this.platformType;
    }

    public ScreenItem getScreenItem() {
        return this.screenItem;
    }

    public String[] getIds() {
        return this.ids;
    }

    public void setPlatformType(String platformType) {
        this.platformType = platformType;
    }

    public void setScreenItem(ScreenItem screenItem) {
        this.screenItem = screenItem;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopManInformationVO)) {
            return false;
        }
        TopManInformationVO other = (TopManInformationVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$platformType = this.getPlatformType();
        String other$platformType = other.getPlatformType();
        if (this$platformType == null ? other$platformType != null : !this$platformType.equals(other$platformType)) {
            return false;
        }
        ScreenItem this$screenItem = this.getScreenItem();
        ScreenItem other$screenItem = other.getScreenItem();
        if (this$screenItem == null ? other$screenItem != null : !((Object)this$screenItem).equals(other$screenItem)) {
            return false;
        }
        return Arrays.deepEquals(this.getIds(), other.getIds());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopManInformationVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $platformType = this.getPlatformType();
        result = result * 59 + ($platformType == null ? 43 : $platformType.hashCode());
        ScreenItem $screenItem = this.getScreenItem();
        result = result * 59 + ($screenItem == null ? 43 : ((Object)$screenItem).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIds());
        return result;
    }

    public String toString() {
        return "TopManInformationVO(platformType=" + this.getPlatformType() + ", screenItem=" + this.getScreenItem() + ", ids=" + Arrays.deepToString(this.getIds()) + ")";
    }

    public static interface InitMethod<T> {
        public void initQueryWrapper(QueryWrapper<T> var1, TopManParamDic var2);

        public static void scopeHandle(QueryWrapper<TopManParamEntity> queryWrapper, TopManParamDic bean, SFunction<TopManParamEntity, ?> sFunction) {
            String splitMark = "-";
            String value = bean.getActive();
            if (splitMark.equals(value)) {
                return;
            }
            if (value.startsWith(splitMark)) {
                queryWrapper.lambda().le(sFunction, (Object)value.substring(1));
                return;
            }
            if (value.endsWith(splitMark)) {
                queryWrapper.lambda().ge(sFunction, (Object)value.substring(0, value.length() - 1));
                return;
            }
            String[] split = value.split(splitMark);
            if (split.length != 2) {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
            queryWrapper.lambda().between(sFunction, (Object)split[0], (Object)split[1]);
        }
    }

    static enum OtherInformationEnum {
        averageLiveView("\u76f4\u64ad\u5e73\u5747\u573a\u89c2", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getOnlineLiveViewerAvg)),
        averageFieldSales("\u76f4\u64ad\u573a\u5747\u9500\u552e\u989d", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getLiveSalesAvg)),
        liveGPM("\u76f4\u64adGPM", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getLiveGpm)),
        expectedVideoLikes("\u9884\u671f\u89c6\u9891\u70b9\u8d5e\u6570", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getLiveQuantity)),
        hideNewsNumber("\u9690\u85cf\u65b0\u95fb\u53f7", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().like(TopManParamEntity::getTopManName, (Object)"\u65b0\u95fb");
        }),
        haveContactNo("\u6709\u8054\u7cfb\u65b9\u5f0f", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().isNotNull(TopManParamEntity::getMobile);
        });

        private final InitMethod<TopManParamEntity> initMethod;
        private final String title;

        private OtherInformationEnum(String title, InitMethod<TopManParamEntity> initMethod) {
            this.title = title;
            this.initMethod = initMethod;
        }

        public InitMethod<TopManParamEntity> getInitMethod() {
            return this.initMethod;
        }

        public String getTitle() {
            return this.title;
        }

        public static OtherInformationEnum getEnum(String title) {
            for (OtherInformationEnum informationEnum : OtherInformationEnum.values()) {
                if (!informationEnum.getTitle().equals(title)) continue;
                return informationEnum;
            }
            return null;
        }
    }

    static enum CargoInformationEnum {
        cargoLevel("\u5e26\u8d27\u6c34\u5e73", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getLiveSalesAvg)),
        priceOfGoodsWithGoods("\u5e26\u8d27\u5546\u54c1\u4ef7\u683c", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getPriceAvg)),
        wordOfMouth("\u5e26\u8d27\u53e3\u7891", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getGoodsWom));

        private final InitMethod<TopManParamEntity> initMethod;
        private final String title;

        private CargoInformationEnum(String title, InitMethod<TopManParamEntity> initMethod) {
            this.title = title;
            this.initMethod = initMethod;
        }

        public InitMethod<TopManParamEntity> getInitMethod() {
            return this.initMethod;
        }

        public String getTitle() {
            return this.title;
        }

        public static CargoInformationEnum getEnum(String title) {
            for (CargoInformationEnum informationEnum : CargoInformationEnum.values()) {
                if (!informationEnum.getTitle().equals(title)) continue;
                return informationEnum;
            }
            return null;
        }
    }

    static enum TalentInformationEnum {
        sex("\u8fbe\u4eba\u6027\u522b", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getTopManSex, (Object)b.active);
        }),
        age("\u8fbe\u4eba\u5e74\u9f84", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getTopManAge)),
        region("\u5730\u533a", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getTopManRegion, (Object)b.active);
        }),
        fansNum("\u7c89\u4e1d\u6570", (a, b) -> InitMethod.scopeHandle((QueryWrapper<TopManParamEntity>)a, b, TopManParamEntity::getFansNum)),
        deliveryMode("\u5e26\u8d27\u65b9\u5f0f", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getLiveOrVideoMain, (Object)b.active);
        }),
        certificationType("\u8ba4\u8bc1\u7c7b\u578b", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getAuthType, (Object)b.active);
        }),
        brandSelfBroadcast("\u54c1\u724c\u81ea\u64ad", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getCooperationBrand, (Object)1);
        }),
        storeBroadcast("\u5e97\u64ad", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getCooperationShop, (Object)1);
        }),
        xingTuTopMan("\u661f\u56fe\u8fbe\u4eba", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getXingTuTopMan, (Object)"Y");
        }),
        darkHorse("\u9ed1\u9a6c", (a, b) -> {
            a.lambda().lt(TopManParamEntity::getFansNum, (Object)100000);
            a.lambda().gt(TopManParamEntity::getLiveSalesAvg, (Object)100000);
        }),
        shopWindowTalent("\u5546\u54c1\u6a71\u7a97\u8fbe\u4eba", (a, b) -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.lambda().eq(TopManParamEntity::getGoodsShopWindow, (Object)"Y");
        });

        private final InitMethod<TopManParamEntity> initMethod;
        private final String title;

        private TalentInformationEnum(String title, InitMethod<TopManParamEntity> initMethod) {
            this.title = title;
            this.initMethod = initMethod;
        }

        public InitMethod<TopManParamEntity> getInitMethod() {
            return this.initMethod;
        }

        public String getTitle() {
            return this.title;
        }

        public static TalentInformationEnum getEnum(String title) {
            for (TalentInformationEnum informationEnum : TalentInformationEnum.values()) {
                if (!informationEnum.getTitle().equals(title)) continue;
                return informationEnum;
            }
            return null;
        }
    }

    public static class TopManParamDic
    extends DictModel {
        private List<DictModel> option;
        private String fatherType;
        private String active;
        private String start;
        private String end;
        private boolean isDropDownList;
        private String selectedTitle;

        public List<DictModel> getOption() {
            return this.option;
        }

        public String getFatherType() {
            return this.fatherType;
        }

        public String getActive() {
            return this.active;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public boolean isDropDownList() {
            return this.isDropDownList;
        }

        public String getSelectedTitle() {
            return this.selectedTitle;
        }

        public void setOption(List<DictModel> option) {
            this.option = option;
        }

        public void setFatherType(String fatherType) {
            this.fatherType = fatherType;
        }

        public void setActive(String active) {
            this.active = active;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public void setDropDownList(boolean isDropDownList) {
            this.isDropDownList = isDropDownList;
        }

        public void setSelectedTitle(String selectedTitle) {
            this.selectedTitle = selectedTitle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopManParamDic)) {
                return false;
            }
            TopManParamDic other = (TopManParamDic)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isDropDownList() != other.isDropDownList()) {
                return false;
            }
            List<DictModel> this$option = this.getOption();
            List<DictModel> other$option = other.getOption();
            if (this$option == null ? other$option != null : !((Object)this$option).equals(other$option)) {
                return false;
            }
            String this$fatherType = this.getFatherType();
            String other$fatherType = other.getFatherType();
            if (this$fatherType == null ? other$fatherType != null : !this$fatherType.equals(other$fatherType)) {
                return false;
            }
            String this$active = this.getActive();
            String other$active = other.getActive();
            if (this$active == null ? other$active != null : !this$active.equals(other$active)) {
                return false;
            }
            String this$start = this.getStart();
            String other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            String this$end = this.getEnd();
            String other$end = other.getEnd();
            if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
                return false;
            }
            String this$selectedTitle = this.getSelectedTitle();
            String other$selectedTitle = other.getSelectedTitle();
            return !(this$selectedTitle == null ? other$selectedTitle != null : !this$selectedTitle.equals(other$selectedTitle));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TopManParamDic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDropDownList() ? 79 : 97);
            List<DictModel> $option = this.getOption();
            result = result * 59 + ($option == null ? 43 : ((Object)$option).hashCode());
            String $fatherType = this.getFatherType();
            result = result * 59 + ($fatherType == null ? 43 : $fatherType.hashCode());
            String $active = this.getActive();
            result = result * 59 + ($active == null ? 43 : $active.hashCode());
            String $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            String $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            String $selectedTitle = this.getSelectedTitle();
            result = result * 59 + ($selectedTitle == null ? 43 : $selectedTitle.hashCode());
            return result;
        }

        public String toString() {
            return "TopManInformationVO.TopManParamDic(option=" + this.getOption() + ", fatherType=" + this.getFatherType() + ", active=" + this.getActive() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", isDropDownList=" + this.isDropDownList() + ", selectedTitle=" + this.getSelectedTitle() + ")";
        }
    }

    public static class ScreenItem {
        @ApiModelProperty(value="\u5e26\u8d27\u5206\u7c7b")
        @JsonProperty(value="CargoClassification")
        private List<TopManParamDic> cargoClassification;
        @ApiModelProperty(value="\u8fbe\u4eba\u5206\u7c7b")
        @JsonProperty(value="TalentClassification")
        private List<TopManParamDic> talentClassification;
        @ApiModelProperty(value="\u8fbe\u4eba\u753b\u50cf")
        @JsonProperty(value="TalentInformation")
        private List<TopManParamDic> talentInformation;
        @ApiModelProperty(value="\u5e26\u8d27\u4fe1\u606f")
        @JsonProperty(value="CargoInformation")
        private List<TopManParamDic> cargoInformation;
        @ApiModelProperty(value="\u5176\u4ed6\u9009\u9879")
        private List<TopManParamDic> other;

        public void initQueryWrapper(QueryWrapper<TopManParamEntity> queryWrapper) throws IllegalAccessException {
            Enum anEnum;
            String text;
            if (this.cargoClassification != null && this.cargoClassification.size() > 0) {
                List cargoClassificationValues = this.cargoClassification.stream().map(DictModel::getValue).collect(Collectors.toList());
                queryWrapper.lambda().in(TopManParamEntity::getGoodsCategory, cargoClassificationValues);
            }
            if (this.talentClassification != null && this.talentClassification.size() > 0) {
                List talentClassificationValues = this.talentClassification.stream().map(DictModel::getValue).collect(Collectors.toList());
                queryWrapper.lambda().in(TopManParamEntity::getContentType, talentClassificationValues);
            }
            if (this.talentInformation != null) {
                for (TopManParamDic tDic : this.talentInformation) {
                    text = tDic.getText();
                    anEnum = TalentInformationEnum.getEnum(text);
                    if (anEnum == null) continue;
                    ((TalentInformationEnum)anEnum).getInitMethod().initQueryWrapper(queryWrapper, tDic);
                }
            }
            if (this.cargoInformation != null) {
                for (TopManParamDic cDic : this.cargoInformation) {
                    text = cDic.getText();
                    anEnum = CargoInformationEnum.getEnum(text);
                    if (anEnum == null) continue;
                    ((CargoInformationEnum)anEnum).getInitMethod().initQueryWrapper(queryWrapper, cDic);
                }
            }
            if (this.other != null) {
                for (TopManParamDic oDic : this.other) {
                    text = oDic.getText();
                    anEnum = OtherInformationEnum.getEnum(text);
                    if (anEnum == null) continue;
                    ((OtherInformationEnum)anEnum).getInitMethod().initQueryWrapper(queryWrapper, oDic);
                }
            }
        }

        public List<TopManParamDic> getCargoClassification() {
            return this.cargoClassification;
        }

        public List<TopManParamDic> getTalentClassification() {
            return this.talentClassification;
        }

        public List<TopManParamDic> getTalentInformation() {
            return this.talentInformation;
        }

        public List<TopManParamDic> getCargoInformation() {
            return this.cargoInformation;
        }

        public List<TopManParamDic> getOther() {
            return this.other;
        }

        @JsonProperty(value="CargoClassification")
        public void setCargoClassification(List<TopManParamDic> cargoClassification) {
            this.cargoClassification = cargoClassification;
        }

        @JsonProperty(value="TalentClassification")
        public void setTalentClassification(List<TopManParamDic> talentClassification) {
            this.talentClassification = talentClassification;
        }

        @JsonProperty(value="TalentInformation")
        public void setTalentInformation(List<TopManParamDic> talentInformation) {
            this.talentInformation = talentInformation;
        }

        @JsonProperty(value="CargoInformation")
        public void setCargoInformation(List<TopManParamDic> cargoInformation) {
            this.cargoInformation = cargoInformation;
        }

        public void setOther(List<TopManParamDic> other) {
            this.other = other;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScreenItem)) {
                return false;
            }
            ScreenItem other = (ScreenItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<TopManParamDic> this$cargoClassification = this.getCargoClassification();
            List<TopManParamDic> other$cargoClassification = other.getCargoClassification();
            if (this$cargoClassification == null ? other$cargoClassification != null : !((Object)this$cargoClassification).equals(other$cargoClassification)) {
                return false;
            }
            List<TopManParamDic> this$talentClassification = this.getTalentClassification();
            List<TopManParamDic> other$talentClassification = other.getTalentClassification();
            if (this$talentClassification == null ? other$talentClassification != null : !((Object)this$talentClassification).equals(other$talentClassification)) {
                return false;
            }
            List<TopManParamDic> this$talentInformation = this.getTalentInformation();
            List<TopManParamDic> other$talentInformation = other.getTalentInformation();
            if (this$talentInformation == null ? other$talentInformation != null : !((Object)this$talentInformation).equals(other$talentInformation)) {
                return false;
            }
            List<TopManParamDic> this$cargoInformation = this.getCargoInformation();
            List<TopManParamDic> other$cargoInformation = other.getCargoInformation();
            if (this$cargoInformation == null ? other$cargoInformation != null : !((Object)this$cargoInformation).equals(other$cargoInformation)) {
                return false;
            }
            List<TopManParamDic> this$other = this.getOther();
            List<TopManParamDic> other$other = other.getOther();
            return !(this$other == null ? other$other != null : !((Object)this$other).equals(other$other));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScreenItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TopManParamDic> $cargoClassification = this.getCargoClassification();
            result = result * 59 + ($cargoClassification == null ? 43 : ((Object)$cargoClassification).hashCode());
            List<TopManParamDic> $talentClassification = this.getTalentClassification();
            result = result * 59 + ($talentClassification == null ? 43 : ((Object)$talentClassification).hashCode());
            List<TopManParamDic> $talentInformation = this.getTalentInformation();
            result = result * 59 + ($talentInformation == null ? 43 : ((Object)$talentInformation).hashCode());
            List<TopManParamDic> $cargoInformation = this.getCargoInformation();
            result = result * 59 + ($cargoInformation == null ? 43 : ((Object)$cargoInformation).hashCode());
            List<TopManParamDic> $other = this.getOther();
            result = result * 59 + ($other == null ? 43 : ((Object)$other).hashCode());
            return result;
        }

        public String toString() {
            return "TopManInformationVO.ScreenItem(cargoClassification=" + this.getCargoClassification() + ", talentClassification=" + this.getTalentClassification() + ", talentInformation=" + this.getTalentInformation() + ", cargoInformation=" + this.getCargoInformation() + ", other=" + this.getOther() + ")";
        }
    }
}

