/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.industryinfo.dto.StoreTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.StoreTopmanItem;
import com.els.modules.industryinfo.entity.StoreTopmanRecord;
import com.els.modules.industryinfo.mapper.StoreTopmanItemMapper;
import com.els.modules.industryinfo.mapper.StoreTopmanRecordMapper;
import com.els.modules.industryinfo.service.StoreTopmanItemService;
import com.els.modules.industryinfo.service.StoreTopmanRecordService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreTopmanRecordServiceImpl
extends BaseServiceImpl<StoreTopmanRecordMapper, StoreTopmanRecord>
implements StoreTopmanRecordService {
    @Autowired
    private StoreTopmanRecordMapper storeTopmanRecordMapper;
    @Autowired
    private StoreTopmanItemMapper storeTopmanItemMapper;
    @Autowired
    private StoreTopmanItemService storeTopmanItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public List<StoreTopmanRecord> selectByMainId(String mainId) {
        return this.storeTopmanRecordMapper.selectByMainId(mainId);
    }

    @Override
    public IPage<StoreTopmanRecord> queryTopmanPage(Page<StoreTopmanRecord> page, QueryWrapper<StoreTopmanRecord> queryWrapper, StoreTopmanItemQueryDTO queryDTO) {
        this.criteriaQuery(queryWrapper, queryDTO);
        Page goodsHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(goodsHeadPage.getRecords(), queryDTO);
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public List<StoreTopmanRecord> replenish(List<StoreTopmanRecord> records, StoreTopmanItemQueryDTO queryDTO) {
        if (!CollectionUtils.isEmpty(records)) {
            for (StoreTopmanRecord record : records) {
                StoreTopmanItem item = this.storeTopmanItemMapper.selectGoodsTopmanItem(record.getId(), queryDTO.getTopmanTimeSelect());
                if (item == null) continue;
                record.setGoodsNum(item.getGoodsNum());
                record.setVideosNum(item.getVideosNum());
                record.setLivesNum(item.getLivesNum());
                record.setSalesNum(item.getSalesNum());
                record.setSalesAmountMin(item.getSalesAmountMin());
                record.setSalesAmountMax(item.getSalesAmountMax());
                record.setQueryDay(item.getQueryDay());
            }
        }
        return records;
    }

    @Override
    public QueryWrapper<StoreTopmanRecord> criteriaQuery(QueryWrapper<StoreTopmanRecord> queryWrapper, StoreTopmanItemQueryDTO queryDTO) {
        List<StoreTopmanItem> records;
        Boolean phoneNumber;
        String goodsWom;
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        if (timeSelect.length() < 10) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)selectDay, (Object)today);
        } else if (timeSelect.contains("\u81f3")) {
            String[] strings = timeSelect.split("\u81f3");
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)strings[0], (Object)strings[1]);
        }
        String fansNum = queryDTO.getTopmanFansNum();
        if (StringUtils.isNotBlank((CharSequence)fansNum)) {
            String[] strings;
            if (fansNum.contains("-")) {
                strings = fansNum.split("-");
                queryWrapper.lambda().gt(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains("<")) {
                strings = fansNum.split("<");
                queryWrapper.lambda().lt(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
            if (fansNum.contains(">")) {
                strings = fansNum.split(">");
                queryWrapper.lambda().gt(StoreTopmanRecord::getFansNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsWom = queryDTO.getTopmanGoodsWom()))) {
            String[] strings;
            if (goodsWom.contains("-")) {
                strings = goodsWom.split("-");
                queryWrapper.lambda().between(StoreTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (goodsWom.contains("<")) {
                strings = goodsWom.split("<");
                queryWrapper.lambda().lt(StoreTopmanRecord::getGoodsWom, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(StoreTopmanRecord::getGoodsWom, (Object)new BigDecimal(goodsWom));
            }
        }
        if ((phoneNumber = queryDTO.getTopmanPhoneNumber()) != null && phoneNumber.booleanValue()) {
            queryWrapper.lambda().isNotNull(StoreTopmanRecord::getPhoneNumber);
        }
        if (CollectionUtil.isNotEmpty(records = this.storeTopmanItemService.queryList(queryDTO))) {
            List recordIds = records.stream().map(StoreTopmanItem::getRecordId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, recordIds);
        }
        return queryWrapper;
    }

    @Override
    public List<CountVO> contentTypeCounts(StoreTopmanRecord topmanRecord, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topmanRecord), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"head_id", (Object)topmanRecord.getHeadId());
        queryWrapper.select(new String[]{"content_type", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"content_type");
        List list = this.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(StoreTopmanRecord::getContentType, StoreTopmanRecord::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("et-ContentType", TenantContext.getTenant());
        for (DictDTO dto : dictDTOList) {
            Integer total;
            Integer n = total = countMap.get(dto.getValue()) == null ? Integer.valueOf(0) : countMap.get(dto.getValue());
            if (StringUtils.isBlank((CharSequence)dto.getValue())) {
                total = all;
            }
            result.add(new CountVO(I18nUtil.translate((String)dto.getTextI18nKey(), (String)dto.getText()), "et-ContentType", dto.getValue(), total));
        }
        return result;
    }

    @Override
    public List<CountVO> goodsWomCounts(StoreTopmanRecord topmanRecord, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topmanRecord), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"head_id", (Object)topmanRecord.getHeadId());
        List list = this.list((Wrapper)queryWrapper);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "topmanGoodsWom", null, Integer.valueOf(list.size())));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("topmanGoodsWom", TenantContext.getTenant());
        for (DictDTO dto : dictDTOList) {
            long total = 0L;
            if (dto.getValue().contains("-")) {
                String[] strings = dto.getValue().split("-");
                total = list.stream().filter(h -> h.getGoodsWom().compareTo(new BigDecimal(strings[0])) >= 0 && h.getGoodsWom().compareTo(new BigDecimal(strings[1])) <= 0).count();
            }
            result.add(new CountVO(I18nUtil.translate((String)dto.getTextI18nKey(), (String)dto.getText()), "topmanGoodsWom", dto.getValue(), Integer.valueOf((int)total)));
        }
        return result;
    }
}

