/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.dto.GoodsTopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsFavorite;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.GoodsItem;
import com.els.modules.industryinfo.entity.GoodsLiveItem;
import com.els.modules.industryinfo.entity.GoodsLiveRecord;
import com.els.modules.industryinfo.entity.GoodsTopmanItem;
import com.els.modules.industryinfo.entity.GoodsTopmanRecord;
import com.els.modules.industryinfo.entity.GoodsVideoItem;
import com.els.modules.industryinfo.entity.GoodsVideoRecord;
import com.els.modules.industryinfo.mapper.GoodsFavoriteMapper;
import com.els.modules.industryinfo.mapper.GoodsHeadMapper;
import com.els.modules.industryinfo.mapper.GoodsItemMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveItemMapper;
import com.els.modules.industryinfo.mapper.GoodsLiveRecordMapper;
import com.els.modules.industryinfo.mapper.GoodsTopmanItemMapper;
import com.els.modules.industryinfo.mapper.GoodsTopmanRecordMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoItemMapper;
import com.els.modules.industryinfo.mapper.GoodsVideoRecordMapper;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.GoodsItemService;
import com.els.modules.industryinfo.vo.GoodsHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class GoodsHeadServiceImpl
extends BaseServiceImpl<GoodsHeadMapper, GoodsHead>
implements GoodsHeadService {
    @Autowired
    private GoodsHeadMapper goodsHeadMapper;
    @Autowired
    private GoodsItemService goodsItemService;
    @Autowired
    private GoodsItemMapper goodsItemMapper;
    @Autowired
    private GoodsTopmanItemMapper goodsTopmanItemMapper;
    @Autowired
    private GoodsTopmanRecordMapper goodsTopmanRecordMapper;
    @Autowired
    private GoodsVideoItemMapper goodsVideoItemMapper;
    @Autowired
    private GoodsVideoRecordMapper goodsVideoRecordMapper;
    @Autowired
    private GoodsLiveItemMapper goodsLiveItemMapper;
    @Autowired
    private GoodsLiveRecordMapper goodsLiveRecordMapper;
    @Autowired
    private GoodsFavoriteMapper goodsFavoriteMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public IPage<GoodsHead> queryPage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        if (StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("1");
        }
        this.criteriaQuery(queryWrapper, queryDTO);
        Page goodsHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(goodsHeadPage.getRecords(), queryDTO);
        return goodsHeadPage;
    }

    @Override
    public IPage<GoodsHead> queryFavoritePage(Page<GoodsHead> page, QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        List<GoodsFavorite> goodsFavoriteList = this.goodsFavoriteMapper.selectByElsAccount(elsAccount);
        if (!CollectionUtils.isEmpty(goodsFavoriteList)) {
            List goodsIds = goodsFavoriteList.stream().map(GoodsFavorite::getGoodsId).collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, goodsIds);
            this.criteriaQuery(queryWrapper, queryDTO);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        Page goodsHeadPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
        this.replenish(goodsHeadPage.getRecords(), queryDTO);
        return goodsHeadPage;
    }

    @Override
    public List<GoodsHead> replenish(List<GoodsHead> list, GoodsHeadQueryDTO queryDTO) {
        if (!CollectionUtils.isEmpty(list)) {
            for (GoodsHead goodsHead : list) {
                GoodsItem goodsItem = this.goodsItemService.queryGoodsItem(goodsHead.getId(), queryDTO.getTimeSelect());
                if (goodsItem != null) {
                    goodsHead.setSalesNum(goodsItem.getSalesNum());
                    goodsHead.setSalesAmountMin(goodsItem.getSalesAmountMin());
                    goodsHead.setSalesAmountMax(goodsItem.getSalesAmountMax());
                    goodsHead.setSalesNumLive(goodsItem.getSalesNumLive());
                    goodsHead.setSalesNumVideo(goodsItem.getSalesNumVideo());
                    goodsHead.setTopmanNum(goodsItem.getTopmanNum());
                    goodsHead.setLivesNum(goodsItem.getLivesNum());
                    goodsHead.setVideosNum(goodsItem.getVideosNum());
                    goodsHead.setBrowsesNum(goodsItem.getBrowsesNum());
                    goodsHead.setConvertRate(goodsItem.getConvertRate());
                }
                LoginUser loginUser = SysUtil.getLoginUser();
                String elsAccount = loginUser.getElsAccount();
                GoodsFavorite goodsFavorite = this.goodsFavoriteMapper.selectGoodsFavorite(goodsHead.getId(), elsAccount);
                goodsHead.setFavoriteGoods(false);
                if (goodsFavorite == null) continue;
                goodsHead.setFavoriteGoods(true);
            }
        }
        return list;
    }

    @Override
    public QueryWrapper<GoodsHead> criteriaQuery(QueryWrapper<GoodsHead> queryWrapper, GoodsHeadQueryDTO queryDTO) {
        List<GoodsItem> goodsItems;
        String goodsRate;
        String goodsPrice;
        String timeSelect = queryDTO.getTimeSelect();
        if (StringUtils.isNotBlank((CharSequence)timeSelect)) {
            Calendar cal = Calendar.getInstance();
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            Date today = cal.getTime();
            cal.set(cal.get(1), cal.get(2), cal.get(5) - Integer.valueOf(timeSelect), 0, 0, 0);
            Date selectDay = cal.getTime();
            queryWrapper.lambda().between(BaseEntity::getCreateTime, (Object)selectDay, (Object)today);
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsPrice = queryDTO.getGoodsPrice()))) {
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.lambda().gt(GoodsHead::getPrice, (Object)new BigDecimal(prices[0]));
                queryWrapper.lambda().le(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                queryWrapper.lambda().lt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                queryWrapper.lambda().gt(GoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsRate = queryDTO.getGoodsCommissionRate()))) {
            String[] strings;
            if (goodsRate.contains("-")) {
                strings = goodsRate.split("-");
                String split = strings[0].contains("%") ? strings[0].split("%")[0] : strings[0];
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().gt(GoodsHead::getCommissionRate, (Object)split);
                queryWrapper.lambda().le(GoodsHead::getCommissionRate, (Object)split1);
            }
            if (goodsRate.contains(">=")) {
                strings = goodsRate.split(">=");
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().ge(GoodsHead::getCommissionRate, (Object)split1);
            }
        }
        if (CollectionUtil.isNotEmpty(goodsItems = this.goodsItemService.queryList(queryDTO))) {
            List ids = goodsItems.stream().map(GoodsItem::getGoodsId).distinct().collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, ids);
        }
        return queryWrapper;
    }

    @Override
    public GoodsHead collateById(String id, GoodsTopmanItemQueryDTO queryDTO) {
        GoodsItem goodsItem;
        GoodsHead head = (GoodsHead)((Object)((GoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head != null && (goodsItem = this.goodsItemService.queryGoodsItem(head.getId(), queryDTO.getTopmanTimeSelect())) != null) {
            head.setSalesNum(goodsItem.getSalesNum());
            head.setSalesNumLive(goodsItem.getSalesNumLive());
            head.setSalesNumVideo(goodsItem.getSalesNumVideo());
            head.setTopmanNum(goodsItem.getTopmanNum());
            head.setSalesAmountMin(goodsItem.getSalesAmountMin());
            head.setSalesAmountMax(goodsItem.getSalesAmountMax());
            head.setVideosNum(goodsItem.getVideosNum());
            head.setLivesNum(goodsItem.getLivesNum());
            head.setBrowsesNum(goodsItem.getBrowsesNum());
            head.setConvertRate(goodsItem.getConvertRate());
        }
        return head;
    }

    @Override
    public GoodsHeadVO queryById(String id) {
        GoodsHeadVO goodsHeadVO = new GoodsHeadVO();
        GoodsHead goodsHead = (GoodsHead)((Object)this.getById((Serializable)((Object)id)));
        if (goodsHead == null) {
            return goodsHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsHeadVO));
        String timeSelect = "30";
        GoodsItem goodsItem = this.goodsItemService.queryGoodsItem(id, timeSelect);
        if (goodsItem != null) {
            goodsHeadVO.setSalesNum(goodsItem.getSalesNum());
            goodsHeadVO.setSalesAmountMin(goodsItem.getSalesAmountMin());
            goodsHeadVO.setSalesAmountMax(goodsItem.getSalesAmountMax());
            goodsHeadVO.setSalesNumLive(goodsItem.getSalesNumLive());
            goodsHeadVO.setSalesNumVideo(goodsItem.getSalesNumVideo());
            goodsHeadVO.setTopmanNum(goodsItem.getTopmanNum());
            goodsHeadVO.setLivesNum(goodsItem.getLivesNum());
            goodsHeadVO.setVideosNum(goodsItem.getVideosNum());
            goodsHeadVO.setBrowsesNum(goodsItem.getBrowsesNum());
            goodsHeadVO.setConvertRate(goodsItem.getConvertRate());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        GoodsFavorite goodsFavorite = this.goodsFavoriteMapper.selectGoodsFavorite(goodsHead.getId(), elsAccount);
        goodsHeadVO.setFavoriteGoods(false);
        if (goodsFavorite != null) {
            goodsHeadVO.setFavoriteGoods(true);
        }
        return goodsHeadVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.insert((Object)goodsHead);
        super.setHeadDefaultValue((BaseEntity)goodsHead);
        this.insertData(goodsHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(GoodsHead goodsHead, GoodsHeadVO headVO) {
        this.goodsHeadMapper.updateById((Object)goodsHead);
        this.goodsTopmanItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsVideoItemMapper.deleteByMainId(goodsHead.getId());
        this.goodsLiveItemMapper.deleteByMainId(goodsHead.getId());
        this.insertData(goodsHead, headVO);
    }

    @Override
    public void favorite(String id) {
        GoodsHead goodsHead = (GoodsHead)((Object)((GoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        GoodsFavorite goodsFavorite = new GoodsFavorite();
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        goodsFavorite.setElsAccount(elsAccount);
        goodsFavorite.setGoodsId(goodsHead.getId());
        goodsFavorite.setPlatform(goodsHead.getPlatform());
        goodsFavorite.setFavoriteTime(new Date());
        this.goodsFavoriteMapper.insert((Object)goodsFavorite);
    }

    @Override
    public void cancelFavorite(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        this.goodsFavoriteMapper.deleteGoodsFavorite(id, elsAccount);
    }

    private void insertData(GoodsHead goodsHead, GoodsHeadVO headVO) {
        List<GoodsTopmanRecord> records;
        List<GoodsItem> goodsItemList = headVO.getGoodsItemList();
        List<GoodsTopmanItem> goodsTopmanItemList = headVO.getGoodsTopmanItemList();
        List<GoodsTopmanRecord> goodsTopmanRecordList = headVO.getGoodsTopmanRecordList();
        List<GoodsVideoItem> goodsVideoItemList = headVO.getGoodsVideoItemList();
        List<GoodsVideoRecord> goodsVideoRecordList = headVO.getGoodsVideoRecordList();
        List<GoodsLiveItem> goodsLiveItemList = headVO.getGoodsLiveItemList();
        List<GoodsLiveRecord> goodsLiveRecordList = headVO.getGoodsLiveRecordList();
        if (!CollectionUtils.isEmpty(goodsItemList)) {
            for (GoodsItem goodsItem : goodsItemList) {
                goodsItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsItem, (BaseEntity)goodsHead);
            }
            if (!goodsItemList.isEmpty()) {
                this.goodsItemMapper.insertBatchSomeColumn(goodsItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsTopmanRecordList)) {
            for (GoodsTopmanRecord goodsTopmanRecord : goodsTopmanRecordList) {
                goodsTopmanRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsTopmanRecord, (BaseEntity)goodsHead);
            }
            if (!goodsTopmanRecordList.isEmpty()) {
                this.goodsTopmanRecordMapper.insertBatchSomeColumn(goodsTopmanRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(records = this.goodsTopmanRecordMapper.selectByMainId(goodsHead.getId()))) {
            for (GoodsTopmanRecord goodsTopmanRecord : records) {
                if (CollectionUtils.isEmpty(goodsTopmanItemList)) continue;
                for (GoodsTopmanItem entity2 : goodsTopmanItemList) {
                    entity2.setRecordId(goodsTopmanRecord.getId());
                    SysUtil.setSysParam((BaseEntity)entity2, (BaseEntity)goodsHead);
                }
                if (goodsTopmanItemList.isEmpty()) continue;
                this.goodsTopmanItemMapper.insertBatchSomeColumn(goodsTopmanItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoItemList)) {
            for (GoodsVideoItem goodsVideoItem : goodsVideoItemList) {
                goodsVideoItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoItem, (BaseEntity)goodsHead);
            }
            if (!goodsVideoItemList.isEmpty()) {
                this.goodsVideoItemMapper.insertBatchSomeColumn(goodsVideoItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsVideoRecordList)) {
            for (GoodsVideoRecord goodsVideoRecord : goodsVideoRecordList) {
                goodsVideoRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsVideoRecord, (BaseEntity)goodsHead);
            }
            if (!goodsVideoRecordList.isEmpty()) {
                this.goodsVideoRecordMapper.insertBatchSomeColumn(goodsVideoRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveItemList)) {
            for (GoodsLiveItem goodsLiveItem : goodsLiveItemList) {
                goodsLiveItem.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveItem, (BaseEntity)goodsHead);
            }
            if (!goodsLiveItemList.isEmpty()) {
                this.goodsLiveItemMapper.insertBatchSomeColumn(goodsLiveItemList);
            }
        }
        if (!CollectionUtils.isEmpty(goodsLiveRecordList)) {
            for (GoodsLiveRecord goodsLiveRecord : goodsLiveRecordList) {
                goodsLiveRecord.setGoodsId(goodsHead.getId());
                SysUtil.setSysParam((BaseEntity)goodsLiveRecord, (BaseEntity)goodsHead);
            }
            if (!goodsLiveRecordList.isEmpty()) {
                this.goodsLiveRecordMapper.insertBatchSomeColumn(goodsLiveRecordList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.goodsTopmanItemMapper.deleteByMainId(id);
        this.goodsVideoItemMapper.deleteByMainId(id);
        this.goodsLiveItemMapper.deleteByMainId(id);
        this.goodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.goodsTopmanItemMapper.deleteByMainId(serializable.toString());
            this.goodsVideoItemMapper.deleteByMainId(serializable.toString());
            this.goodsLiveItemMapper.deleteByMainId(serializable.toString());
            this.goodsHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<CountVO> categoryCounts(GoodsHead goodsHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"store_id", (Object)goodsHead.getStoreId());
        queryWrapper.select(new String[]{"category", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"category");
        List list = this.list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(GoodsHead::getCategory, GoodsHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("category", TenantContext.getTenant());
        for (DictDTO dto : dictDTOList) {
            Integer total;
            Integer n = total = countMap.get(dto.getValue()) == null ? Integer.valueOf(0) : countMap.get(dto.getValue());
            if (StringUtils.isBlank((CharSequence)dto.getValue())) {
                total = all;
            }
            result.add(new CountVO(I18nUtil.translate((String)dto.getTextI18nKey(), (String)dto.getText()), "category", dto.getValue(), total));
        }
        return result;
    }
}

