/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.organ.dto.PurchaserOrganHeadQueryDto;
import com.els.modules.organ.entity.PurchaserOrganAttractBodyData;
import com.els.modules.organ.entity.PurchaserOrganAttractHotPushGoodsItem;
import com.els.modules.organ.entity.PurchaserOrganAttractHotPushShopItem;
import com.els.modules.organ.entity.PurchaserOrganContractTalentItem;
import com.els.modules.organ.entity.PurchaserOrganDetailAttractData;
import com.els.modules.organ.entity.PurchaserOrganDetailMcnData;
import com.els.modules.organ.entity.PurchaserOrganDetailTopData;
import com.els.modules.organ.entity.PurchaserOrganHead;
import com.els.modules.organ.entity.PurchaserOrganMcnBodyData;
import com.els.modules.organ.mapper.PurchaserOrganAttractHotPushGoodsItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganAttractHotPushShopItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganAttractItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganContractTalentItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganFansReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganGradeReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganHeadMapper;
import com.els.modules.organ.mapper.PurchaserOrganIndustryReleaseItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganItemMapper;
import com.els.modules.organ.mapper.PurchaserOrganPushCategoryItemMapper;
import com.els.modules.organ.service.PurchaserOrganHeadService;
import com.els.modules.organ.utils.QueryAttractParam;
import com.els.modules.organ.utils.QueryMcnParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaserOrganHeadServiceImpl
extends BaseServiceImpl<PurchaserOrganHeadMapper, PurchaserOrganHead>
implements PurchaserOrganHeadService {
    @Autowired
    private PurchaserOrganHeadMapper purchaserOrganHeadMapper;
    @Autowired
    private PurchaserOrganItemMapper purchaserOrganItemMapper;
    @Autowired
    private PurchaserOrganPushCategoryItemMapper purchaserOrganPushCategoryItemMapper;
    @Autowired
    private PurchaserOrganIndustryReleaseItemMapper purchaserOrganIndustryReleaseItemMapper;
    @Autowired
    private PurchaserOrganGradeReleaseItemMapper purchaserOrganGradeReleaseItemMapper;
    @Autowired
    private PurchaserOrganFansReleaseItemMapper purchaserOrganFansReleaseItemMapper;
    @Autowired
    private PurchaserOrganAttractItemMapper purchaserOrganAttractItemMapper;
    @Autowired
    private PurchaserOrganAttractHotPushGoodsItemMapper purchaserOrganAttractHotPushGoodsItemMapper;
    @Autowired
    private PurchaserOrganAttractHotPushShopItemMapper purchaserOrganAttractHotPushShopItemMapper;
    @Autowired
    private PurchaserOrganContractTalentItemMapper purchaserOrganContractTalentItemMapper;

    @Override
    public IPage<PurchaserOrganMcnBodyData> pageMcnList(Page<PurchaserOrganMcnBodyData> page, HttpServletRequest req, PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        QueryWrapper<PurchaserOrganHeadQueryDto> queryMcnWrapper = QueryMcnParam.getQueryParam(purchaserOrganHeadQueryDto);
        IPage<PurchaserOrganMcnBodyData> purchaserOrganMcnBodyDataIPage = this.purchaserOrganHeadMapper.pageMcnList((IPage<PurchaserOrganMcnBodyData>)page, (Wrapper<PurchaserOrganHeadQueryDto>)queryMcnWrapper);
        return purchaserOrganMcnBodyDataIPage;
    }

    @Override
    public IPage<PurchaserOrganAttractBodyData> pageAttractList(Page<PurchaserOrganAttractBodyData> page, HttpServletRequest req, PurchaserOrganHeadQueryDto purchaserOrganHeadQueryDto) {
        QueryWrapper<PurchaserOrganHeadQueryDto> queryAttractParam = QueryAttractParam.getQueryParam(purchaserOrganHeadQueryDto);
        String category = purchaserOrganHeadQueryDto.getCategory();
        List<String> categoryList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)purchaserOrganHeadQueryDto.getCategory()) && StringUtils.isNotBlank((CharSequence)category)) {
            if (category.contains("-")) {
                categoryList = Arrays.asList(category.split("-"));
            } else {
                categoryList.add(category);
            }
        }
        queryAttractParam.orderByDesc((Object)"id");
        IPage<PurchaserOrganAttractBodyData> purchaserOrganAttractBodyDataIPage = this.purchaserOrganHeadMapper.pageAttractList((IPage<PurchaserOrganAttractBodyData>)page, (Wrapper<PurchaserOrganHeadQueryDto>)queryAttractParam, purchaserOrganHeadQueryDto.getPlatform(), categoryList);
        return purchaserOrganAttractBodyDataIPage;
    }

    @Override
    public List<PurchaserOrganContractTalentItem> queryConContractTalentData(String headId) {
        ArrayList<PurchaserOrganContractTalentItem> purchaserOrganContractTalentItems = new ArrayList();
        if (!StringUtils.isNotEmpty((CharSequence)headId)) {
            throw new ELSBootException("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        purchaserOrganContractTalentItems = this.purchaserOrganContractTalentItemMapper.getTopData(headId, 0, 50);
        return purchaserOrganContractTalentItems;
    }

    @Override
    public PurchaserOrganDetailTopData detailTop(String headId) {
        PurchaserOrganDetailTopData purchaserOrganDetailTopData = this.purchaserOrganHeadMapper.detailTop(headId);
        if (purchaserOrganDetailTopData != null) {
            List<PurchaserOrganDetailTopData.OrganMainPushData> mainPushCategory = this.purchaserOrganPushCategoryItemMapper.getMainPushCategory(headId);
            purchaserOrganDetailTopData.setOrganMainPushData(mainPushCategory);
        }
        return purchaserOrganDetailTopData;
    }

    @Override
    public PurchaserOrganDetailAttractData detailAttract(String id, String days, String categoryId) {
        PurchaserOrganDetailAttractData purchaserOrganDetailAttractData = this.purchaserOrganHeadMapper.detailAttract(id, days, categoryId);
        if (purchaserOrganDetailAttractData != null) {
            List<PurchaserOrganDetailAttractData.OrganOperateCategoryData> operateCategory = this.purchaserOrganAttractItemMapper.getOperateCategory(id, days);
            purchaserOrganDetailAttractData.setOrganOperateCategoryData(operateCategory);
        }
        return purchaserOrganDetailAttractData;
    }

    @Override
    public PurchaserOrganDetailMcnData detailMcn(String headId) {
        PurchaserOrganDetailMcnData purchaserOrganDetailMcnData = this.purchaserOrganItemMapper.queryByHeadId(headId);
        return purchaserOrganDetailMcnData;
    }

    @Override
    public IPage<PurchaserOrganAttractHotPushGoodsItem> hotSaleGoods(Page<PurchaserOrganAttractHotPushGoodsItem> page, HttpServletRequest req, PurchaserOrganAttractHotPushGoodsItem purchaserOrganAttractHotPushGoodsItem) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserOrganAttractHotPushGoodsItem), (Map)req.getParameterMap());
        Page purchaserOrganAttractHotPushGoodsItemPage = (Page)this.purchaserOrganAttractHotPushGoodsItemMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return purchaserOrganAttractHotPushGoodsItemPage;
    }

    @Override
    public IPage<PurchaserOrganAttractHotPushShopItem> hotSaleShop(Page<PurchaserOrganAttractHotPushShopItem> page, HttpServletRequest req, PurchaserOrganAttractHotPushShopItem purchaserOrganAttractHotPushShopItem) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserOrganAttractHotPushShopItem), (Map)req.getParameterMap());
        Page purchaserOrganAttractHotPushShopItemPage = (Page)this.purchaserOrganAttractHotPushShopItemMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return purchaserOrganAttractHotPushShopItemPage;
    }
}

