/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.entity.SaleInformationRecordsRequestHead;
import com.els.modules.price.entity.SaleInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.mapper.PurchaseInformationRecordsRequestHeadMapper;
import com.els.modules.price.mapper.SaleInformationRecordsRequestHeadMapper;
import com.els.modules.price.mapper.SaleInformationRecordsRequestItemMapper;
import com.els.modules.price.service.SaleInformationRecordsRequestHeadService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleInformationRecordsRequestHeadServiceImpl
extends BaseServiceImpl<SaleInformationRecordsRequestHeadMapper, SaleInformationRecordsRequestHead>
implements SaleInformationRecordsRequestHeadService {
    @Autowired
    private SaleInformationRecordsRequestHeadMapper saleInformationRecordsRequestHeadMapper;
    @Autowired
    private SaleInformationRecordsRequestItemMapper saleInformationRecordsRequestItemMapper;
    @Autowired
    private PurchaseInformationRecordsRequestHeadMapper purchaseInformationRecordsRequestHeadMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(SaleInformationRecordsRequestHead head, List<SaleInformationRecordsRequestItem> itemList) {
        this.saleInformationRecordsRequestHeadMapper.insert((Object)head);
        super.setHeadDefaultValue((BaseEntity)head);
        this.insertData(head, itemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(SaleInformationRecordsRequestHead head, List<SaleInformationRecordsRequestItem> itemList) {
        this.saleInformationRecordsRequestHeadMapper.updateById((Object)head);
        this.saleInformationRecordsRequestItemMapper.deleteByMainId(head.getId());
        this.insertData(head, itemList);
    }

    private void insertData(SaleInformationRecordsRequestHead saleInformationRecordsRequestHead, List<SaleInformationRecordsRequestItem> saleInformationRecordsRequestItemList) {
        if (!CollectionUtils.isEmpty(saleInformationRecordsRequestItemList)) {
            for (SaleInformationRecordsRequestItem entity : saleInformationRecordsRequestItemList) {
                entity.setHeadId(saleInformationRecordsRequestHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleInformationRecordsRequestHead);
            }
            if (!saleInformationRecordsRequestItemList.isEmpty()) {
                this.saleInformationRecordsRequestItemMapper.insertBatchSomeColumn(saleInformationRecordsRequestItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleInformationRecordsRequestItemMapper.deleteByMainId(id);
        this.saleInformationRecordsRequestHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleInformationRecordsRequestItemMapper.deleteByMainId(serializable.toString());
            this.saleInformationRecordsRequestHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirmed(String headId, String remark) {
        this.confirmedOrRejected(headId, remark, PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue());
    }

    public void confirmedOrRejected(String headId, String remark, String status) {
        SaleInformationRecordsRequestHead oldRequestHead = (SaleInformationRecordsRequestHead)((Object)((SaleInformationRecordsRequestHeadMapper)this.baseMapper).selectById((Serializable)((Object)headId)));
        if (null == oldRequestHead) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFxMK_c3d350df", (String)"\u6570\u636e\u4e0d\u5b58\u5728"));
        }
        if (!"1".equals(oldRequestHead.getNeedSaleConfirm())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u9700\u8981\u4f9b\u5e94\u5546\u786e\u8ba4"));
        }
        if (!PriceRequestStatusEnum.TO_BE_CONFIRMED.getValue().equals(oldRequestHead.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        SaleInformationRecordsRequestHead requestHead = new SaleInformationRecordsRequestHead();
        requestHead.setId(headId);
        requestHead.setStatus(status);
        requestHead.setConfirmRemark(remark);
        int count = ((SaleInformationRecordsRequestHeadMapper)this.baseMapper).updateById((Object)requestHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        PurchaseInformationRecordsRequestHead head = new PurchaseInformationRecordsRequestHead();
        head.setId(oldRequestHead.getRelationId());
        head.setStatus(status);
        head.setConfirmRemark(remark);
        this.purchaseInformationRecordsRequestHeadMapper.updateById((Object)head);
        String urlParam = "id=" + oldRequestHead.getRelationId();
        if ("3".equals(status)) {
            super.sendMsg(oldRequestHead.getToElsAccount(), oldRequestHead.getBusAccount(), (Object)oldRequestHead, urlParam, "informationRecordsRequest", "refund");
        } else {
            super.sendMsg(oldRequestHead.getToElsAccount(), oldRequestHead.getBusAccount(), (Object)oldRequestHead, urlParam, "informationRecordsRequest", "confirm");
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void rejected(String headId, String remark) {
        this.confirmedOrRejected(headId, remark, PriceRequestStatusEnum.REJECTED.getValue());
    }
}

