/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialCreateOpenServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialCreateOpenServiceImpl.class);
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PurchaseMaterialItemService purchaseMaterialItemService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseMaterialHead> headList = new ArrayList<PurchaseMaterialHead>();
        ArrayList allItem = new ArrayList();
        JSONArray HeadArray = new JSONArray();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)JSON.parseObject((String)object.toString(), PurchaseMaterialHead.class));
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            head.setTemplateAccount(templateHead.getElsAccount());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)head), (String[])new String[0]);
            head.setId(IdWorker.getIdStr());
            headList.add(head);
            JSONObject headObj = SysUtil.objectToJSON((Object)((Object)head));
            HeadArray.add((Object)headObj);
            JSONArray itemListJsonArray = null;
            if (object.containsKey((Object)"purchaseMaterialItemList")) {
                itemListJsonArray = object.getJSONArray("purchaseMaterialItemList");
            } else if (object.containsKey((Object)"itemList")) {
                itemListJsonArray = object.getJSONArray("itemList");
            }
            try {
                List itemList;
                if (null == itemListJsonArray || itemListJsonArray.isEmpty() || null == (itemList = JSON.parseArray((String)itemListJsonArray.toJSONString(), PurchaseMaterialItem.class))) continue;
                for (PurchaseMaterialItem item : itemList) {
                    item.setId(IdWorker.getIdStr());
                    item.setHeadId(head.getId());
                    item.setElsAccount(account);
                    item.setCreateTime(currentTime);
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                    BeanUtil.copyProperties(defaultItemMap, (Object)((Object)item), (String[])new String[0]);
                }
                allItem.addAll(itemList);
            }
            catch (Exception e) {
                log.error("{}==>ItemList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
            }
        }
        if (!headList.isEmpty()) {
            this.purchaseMaterialHeadService.saveBatch(headList, 2000);
        }
        if (!allItem.isEmpty()) {
            this.purchaseMaterialItemService.saveBatch(allItem, 2000);
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", (Object)HeadArray);
        return resultObj;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "material";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseMaterialHeadVO.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"purchaseMaterialItemList"});
    }
}

