/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.delivery.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.delivery.entity.PurchaseCaseConvertRuleHead;
import com.els.modules.delivery.entity.PurchaseCaseConvertRuleHeadHis;
import com.els.modules.delivery.entity.SaleCaseConvertRuleHead;
import com.els.modules.delivery.enumerate.ConvertRuleStatusEnum;
import com.els.modules.delivery.mapper.PurchaseCaseConvertRuleHeadHisMapper;
import com.els.modules.delivery.mapper.PurchaseCaseConvertRuleHeadMapper;
import com.els.modules.delivery.mapper.SaleCaseConvertRuleHeadMapper;
import com.els.modules.delivery.service.PurchaseCaseConvertRuleHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseCaseConvertRuleHeadServiceImpl
extends BaseServiceImpl<PurchaseCaseConvertRuleHeadMapper, PurchaseCaseConvertRuleHead>
implements PurchaseCaseConvertRuleHeadService {
    @Resource
    private SaleCaseConvertRuleHeadMapper saleCaseConvertRuleHeadMapper;
    @Resource
    private PurchaseCaseConvertRuleHeadHisMapper convertRuleHeadHisMapper;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void savePurchaseCaseConvertRuleHead(PurchaseCaseConvertRuleHead convertRuleHead) {
        this.checkConvertRuleHead(convertRuleHead);
        convertRuleHead.setConvertRuleVersion("1");
        if (StringUtils.isBlank((CharSequence)convertRuleHead.getConvertRuleNumber())) {
            convertRuleHead.setConvertRuleNumber(this.baseRpcService.getNextCode("convertRuleNumber", (Object)convertRuleHead));
        }
        if (StringUtils.isBlank((CharSequence)convertRuleHead.getDocumentId())) {
            convertRuleHead.setDocumentId(IdWorker.getIdStr());
        }
        ((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).insert((Object)convertRuleHead);
    }

    private void checkConvertRuleHead(PurchaseCaseConvertRuleHead convertRuleHead) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)convertRuleHead.getPurchaseOrg()), (String)I18nUtil.translate((String)"", (String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a"));
        List convertRuleHeadList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)convertRuleHead.getPurchaseOrg()), PurchaseCaseConvertRuleHead::getPurchaseOrg, (Object)convertRuleHead.getPurchaseOrg())).eq(StrUtil.isNotBlank((CharSequence)convertRuleHead.getFactory()), PurchaseCaseConvertRuleHead::getFactory, (Object)convertRuleHead.getFactory())).eq(StrUtil.isNotBlank((CharSequence)convertRuleHead.getCateCode()), PurchaseCaseConvertRuleHead::getCateCode, (Object)convertRuleHead.getCateCode())).eq(StrUtil.isNotBlank((CharSequence)convertRuleHead.getMaterialNumber()), PurchaseCaseConvertRuleHead::getMaterialNumber, (Object)convertRuleHead.getMaterialNumber())).eq(StrUtil.isNotBlank((CharSequence)convertRuleHead.getToElsAccount()), PurchaseCaseConvertRuleHead::getToElsAccount, (Object)convertRuleHead.getToElsAccount())).ne(StrUtil.isNotBlank((CharSequence)convertRuleHead.getConvertRuleNumber()), PurchaseCaseConvertRuleHead::getConvertRuleNumber, (Object)convertRuleHead.getConvertRuleNumber())).list();
        if (CollUtil.isNotEmpty((Collection)convertRuleHeadList)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u6570\u636e\u3010${0}\u3011\uff0c\u4e0d\u53ef\u91cd\u590d\u65b0\u589e\uff0c\u53ef\u524d\u5f80\u66f4\u65b0\u7248\u672c\uff01", (String[])new String[]{convertRuleHead.getConvertRuleNumber()}));
        }
    }

    @Override
    public void updatePurchaseCaseConvertRuleHead(PurchaseCaseConvertRuleHead purchaseCaseConvertRuleHead) {
        this.checkConvertRuleHead(purchaseCaseConvertRuleHead);
        int count = ((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).updateById((Object)purchaseCaseConvertRuleHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void frozenCaseConvertRuleHead(String id) {
        PurchaseCaseConvertRuleHead record = (PurchaseCaseConvertRuleHead)((Object)((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setStatus(ConvertRuleStatusEnum.FROZEN.getValue());
        int count = ((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawCaseConvertRuleHead(String id) {
        PurchaseCaseConvertRuleHead record = (PurchaseCaseConvertRuleHead)((Object)((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setStatus(ConvertRuleStatusEnum.EFFECTIVE.getValue());
        int count = ((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void upgradeConvertRuleVersion(PurchaseCaseConvertRuleHead convertRuleHead) {
        this.generateConvertRuleHistory(convertRuleHead);
        int convertRuleVersion = 1;
        if (!StringUtils.isEmpty((CharSequence)convertRuleHead.getConvertRuleVersion())) {
            convertRuleVersion = Integer.parseInt(convertRuleHead.getConvertRuleVersion()) + 1;
        }
        if (!StringUtils.isEmpty((CharSequence)convertRuleHead.getRelationId())) {
            SaleCaseConvertRuleHead saleCaseConvertRuleHead = new SaleCaseConvertRuleHead();
            saleCaseConvertRuleHead.setElsAccount(convertRuleHead.getToElsAccount());
            saleCaseConvertRuleHead.setId(convertRuleHead.getRelationId());
            saleCaseConvertRuleHead.setStatus(ConvertRuleStatusEnum.VERSION_CHANGED.getValue());
            saleCaseConvertRuleHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
            saleCaseConvertRuleHead.setUpdateTime(new Date());
            saleCaseConvertRuleHead.setConvertRuleVersion(convertRuleVersion + "");
            this.saleCaseConvertRuleHeadMapper.updateById((Object)saleCaseConvertRuleHead);
        }
        convertRuleHead.setStatus(ConvertRuleStatusEnum.VERSION_CHANGED.getValue());
        convertRuleHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        convertRuleHead.setUpdateTime(new Date());
        convertRuleHead.setConvertRuleVersion(convertRuleVersion + "");
        ((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).updateById((Object)convertRuleHead);
    }

    private void generateConvertRuleHistory(PurchaseCaseConvertRuleHead convertRuleHead) {
        Assert.notNull((Object)convertRuleHead.getId(), (String)I18nUtil.translate((String)"i18n_alert_ItWWxOLVW_8c4bea83", (String)"\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a!"));
        PurchaseCaseConvertRuleHead dbConvertRuleHead = (PurchaseCaseConvertRuleHead)((Object)((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).selectById((Serializable)((Object)convertRuleHead.getId())));
        PurchaseCaseConvertRuleHeadHis convertRuleHeadHis = new PurchaseCaseConvertRuleHeadHis();
        BeanUtils.copyProperties((Object)((Object)dbConvertRuleHead), (Object)((Object)convertRuleHeadHis));
        convertRuleHeadHis.setId(null);
        convertRuleHeadHis.setRelationId(dbConvertRuleHead.getId());
        convertRuleHeadHis.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        convertRuleHeadHis.setCreateTime(new Date());
        convertRuleHeadHis.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        convertRuleHeadHis.setUpdateTime(new Date());
        this.convertRuleHeadHisMapper.insert((Object)convertRuleHeadHis);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseCaseConvertRuleHead ruleHead) {
        try {
            PurchaseCaseConvertRuleHead convertRuleHead = new PurchaseCaseConvertRuleHead();
            BeanUtils.copyProperties((Object)((Object)ruleHead), (Object)((Object)convertRuleHead));
            convertRuleHead.setStatus(ConvertRuleStatusEnum.EFFECTIVE.getValue());
            if (StringUtils.isBlank((CharSequence)convertRuleHead.getRelationId())) {
                convertRuleHead.setRelationId(IdWorker.getIdStr());
            }
            if (StrUtil.isEmpty((CharSequence)convertRuleHead.getId())) {
                this.savePurchaseCaseConvertRuleHead(convertRuleHead);
            } else {
                PurchaseCaseConvertRuleHead dbConvertRuleHead = (PurchaseCaseConvertRuleHead)((Object)((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).selectById((Serializable)((Object)convertRuleHead.getId())));
                Assert.isTrue((boolean)dbConvertRuleHead.getStatus().equals(ruleHead.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_ItzEhbrAWVXVItW_58ecfdbf", (String)"\u5355\u636e\u72b6\u6001\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u5355\u636e!"));
                this.updatePurchaseCaseConvertRuleHead(convertRuleHead);
            }
            SaleCaseConvertRuleHead saleHead = (SaleCaseConvertRuleHead)((Object)this.saleCaseConvertRuleHeadMapper.selectById((Serializable)((Object)convertRuleHead.getRelationId())));
            if (null == saleHead) {
                saleHead = new SaleCaseConvertRuleHead();
                BeanUtils.copyProperties((Object)((Object)convertRuleHead), (Object)((Object)saleHead));
                saleHead.setId(convertRuleHead.getRelationId());
                saleHead.setRelationId(convertRuleHead.getId());
                saleHead.setElsAccount(convertRuleHead.getToElsAccount());
                saleHead.setToElsAccount(convertRuleHead.getElsAccount());
                this.saleCaseConvertRuleHeadMapper.insert((Object)saleHead);
            } else {
                BeanUtils.copyProperties((Object)((Object)convertRuleHead), (Object)((Object)saleHead));
                saleHead.setId(convertRuleHead.getRelationId());
                saleHead.setRelationId(convertRuleHead.getId());
                saleHead.setElsAccount(convertRuleHead.getToElsAccount());
                saleHead.setToElsAccount(convertRuleHead.getElsAccount());
                this.saleCaseConvertRuleHeadMapper.updateById((Object)saleHead);
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @Override
    public void delPurchaseCaseConvertRuleHead(String id) {
        ((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseCaseConvertRuleHead(List<String> idList) {
        ((PurchaseCaseConvertRuleHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }
}

