/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.license.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.license.entity.PurchaseMaterialLicense;
import com.els.modules.license.entity.SaleMaterialLicense;
import com.els.modules.license.enumerate.MaterialLicenseCreatePortEnum;
import com.els.modules.license.enumerate.MaterialLicenseOptStatusEnum;
import com.els.modules.license.enumerate.MaterialLicenseSourceTypeEnum;
import com.els.modules.license.mapper.SaleMaterialLicenseMapper;
import com.els.modules.license.service.PurchaseMaterialLicenseService;
import com.els.modules.license.service.SaleMaterialLicenseService;
import com.els.modules.license.vo.SaleMaterialLicenseVo;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SaleMaterialLicenseServiceImpl
extends BaseServiceImpl<SaleMaterialLicenseMapper, SaleMaterialLicense>
implements SaleMaterialLicenseService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialLicenseService purchaseMaterialLicenseService;

    @Override
    public void saveSaleMaterialLicense(SaleMaterialLicense saleMaterialLicense) {
        saleMaterialLicense.setCreatePort(MaterialLicenseCreatePortEnum.SALE.getValue());
        saleMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.SALE_CREATE.getValue());
        saleMaterialLicense.setValidStatus("0");
        saleMaterialLicense.setSourceType(MaterialLicenseSourceTypeEnum.SALE_CREATE.getValue());
        saleMaterialLicense.setRequirePort(SysUtil.getUserRealName());
        saleMaterialLicense.setBusAccount(SysUtil.getPurchaseAccount());
        ((SaleMaterialLicenseMapper)this.baseMapper).insert((Object)saleMaterialLicense);
    }

    @Override
    public void updateSaleMaterialLicense(SaleMaterialLicenseVo saleMaterialLicenseVo) {
        SaleMaterialLicense saleMaterialLicense = new SaleMaterialLicense();
        BeanUtil.copyProperties((Object)((Object)saleMaterialLicenseVo), (Object)((Object)saleMaterialLicense), (String[])new String[0]);
        List<SaleAttachmentDTO> attachmentList = saleMaterialLicenseVo.getAttachmentList();
        SaleMaterialLicense dbSaleMaterialLicense = (SaleMaterialLicense)((Object)this.getById((Serializable)((Object)saleMaterialLicense.getId())));
        Assert.notNull((Object)((Object)dbSaleMaterialLicense), (String)I18nUtil.translate((String)"", (String)"\u5546\u54c1\u8bc1\u7167\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.equalsAny((CharSequence)dbSaleMaterialLicense.getOptStatus(), (CharSequence[])new CharSequence[]{MaterialLicenseOptStatusEnum.SALE_CREATE.getValue(), MaterialLicenseOptStatusEnum.PURCHASE_RETURN.getValue()}), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u4f9b\u5e94\u5546\u65b0\u5efa\u3001\u91c7\u8d2d\u9000\u56de\u7684\u5355\u636e\u53ef\u4ee5\u7f16\u8f91"), (Object[])new Object[0]);
        ((SaleMaterialLicenseMapper)this.baseMapper).updateById((Object)saleMaterialLicense);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleMaterialLicense.getId());
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            for (SaleAttachmentDTO entity : attachmentList) {
                entity.setId(null);
                entity.setHeadId(saleMaterialLicense.getId());
                entity.setElsAccount(saleMaterialLicense.getElsAccount());
                entity.setCreateBy(saleMaterialLicense.getCreateBy());
                entity.setCreateTime(saleMaterialLicense.getCreateTime());
                entity.setUpdateBy(saleMaterialLicense.getUpdateBy());
                entity.setUpdateTime(saleMaterialLicense.getUpdateTime());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    public void delSaleMaterialLicense(String id) {
        ((SaleMaterialLicenseMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleMaterialLicense(List<String> idList) {
        ((SaleMaterialLicenseMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public SaleMaterialLicenseVo getCustomById(String id) {
        SaleMaterialLicense saleMaterialLicense = (SaleMaterialLicense)((Object)this.getById((Serializable)((Object)id)));
        SaleMaterialLicenseVo saleMaterialLicenseVo = (SaleMaterialLicenseVo)((Object)SysUtil.copyProperties((Object)((Object)saleMaterialLicense), SaleMaterialLicenseVo.class));
        List saleAttachmentDtos = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleMaterialLicenseVo.setAttachmentList(saleAttachmentDtos);
        return saleMaterialLicenseVo;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void commit(SaleMaterialLicense saleMaterialLicense) {
        SaleMaterialLicense dbSaleMaterialLicense = (SaleMaterialLicense)((Object)this.getById((Serializable)((Object)saleMaterialLicense.getId())));
        Assert.notNull((Object)((Object)dbSaleMaterialLicense), (String)I18nUtil.translate((String)"", (String)"\u5546\u54c1\u8bc1\u7167\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.equalsAny((CharSequence)dbSaleMaterialLicense.getOptStatus(), (CharSequence[])new CharSequence[]{MaterialLicenseOptStatusEnum.SALE_CREATE.getValue(), MaterialLicenseOptStatusEnum.PURCHASE_RETURN.getValue()}), (String)I18nUtil.translate((String)"", (String)"\u53ea\u6709\u4f9b\u5e94\u5546\u65b0\u5efa\u3001\u91c7\u8d2d\u9000\u56de\u7684\u5355\u636e\u53ef\u4ee5\u63d0\u4ea4"), (Object[])new Object[0]);
        PurchaseMaterialLicense purchaseMaterialLicense = (PurchaseMaterialLicense)((Object)SysUtil.copyProperties((Object)((Object)dbSaleMaterialLicense), PurchaseMaterialLicense.class));
        purchaseMaterialLicense.setId(StrUtil.isBlank((CharSequence)dbSaleMaterialLicense.getRelationId()) ? IdWorker.getIdStr() : dbSaleMaterialLicense.getRelationId());
        purchaseMaterialLicense.setRelationId(dbSaleMaterialLicense.getId());
        purchaseMaterialLicense.setElsAccount(SysUtil.getPurchaseAccount());
        purchaseMaterialLicense.setToElsAccount(dbSaleMaterialLicense.getElsAccount());
        purchaseMaterialLicense.setCreateTime(new Date());
        purchaseMaterialLicense.setUpdateTime(new Date());
        purchaseMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.WAIT_PURCHASE_CONFIRM.getValue());
        purchaseMaterialLicense.setValidStatus("0");
        this.purchaseMaterialLicenseService.saveOrUpdate((Object)purchaseMaterialLicense);
        dbSaleMaterialLicense.setRelationId(purchaseMaterialLicense.getId());
        dbSaleMaterialLicense.setOptStatus(MaterialLicenseOptStatusEnum.WAIT_PURCHASE_CONFIRM.getValue());
        ((SaleMaterialLicenseServiceImpl)SpringUtil.getBean(this.getClass())).updateById((Object)dbSaleMaterialLicense);
        List saleAttachmentDtos = this.invokeBaseRpcService.selectSaleAttachmentByMainId(saleMaterialLicense.getId());
        if (CollUtil.isNotEmpty((Collection)saleAttachmentDtos)) {
            List purchaseAttachmentDtos = saleAttachmentDtos.stream().map(saleAttachmentDto -> {
                PurchaseAttachmentDTO purchaseAttachmentDto = (PurchaseAttachmentDTO)SysUtil.copyProperties((Object)saleAttachmentDto, PurchaseAttachmentDTO.class);
                purchaseAttachmentDto.setId(IdWorker.getIdStr());
                purchaseAttachmentDto.setHeadId(purchaseMaterialLicense.getId());
                purchaseAttachmentDto.setRelationId(saleAttachmentDto.getId());
                purchaseAttachmentDto.setCreateTime(new Date());
                purchaseAttachmentDto.setUpdateTime(new Date());
                saleAttachmentDto.setRelationId(purchaseAttachmentDto.getId());
                return purchaseAttachmentDto;
            }).collect(Collectors.toList());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(dbSaleMaterialLicense.getRelationId());
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentDtos);
            this.invokeBaseRpcService.updateSaleAttachmentBatchById(saleAttachmentDtos);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void batchCommit(List<SaleMaterialLicense> saleMaterialLicenses) {
    }

    @Override
    public List<SaleMaterialLicense> selectWithoutElsAccountList(Wrapper<SaleMaterialLicense> wrapper) {
        return ((SaleMaterialLicenseMapper)this.baseMapper).selectWithoutElsAccountList(wrapper);
    }
}

