/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseMaterialExcelHandler")
public class PurchaseMaterialExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @SrmTransaction(rollbackFor={Exception.class})
    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("material");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERSLdWFESIrW_6a8566c6", (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f\u3002"));
        ArrayList entityList = new ArrayList();
        LambdaQueryWrapper wrapperAll = new LambdaQueryWrapper();
        wrapperAll.eq(BaseEntity::getDeleted, (Object)"0");
        List purchaseMaterialHeadListAll = this.purchaseMaterialHeadService.list((Wrapper)wrapperAll);
        ArrayList<String> materialList = new ArrayList<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String materialNumber = (String)data.get("materialNumber");
            String autoCreateCode = (String)data.get("autoCreateCode");
            if (!CharSequenceUtil.isNotBlank((CharSequence)materialNumber) || "1".equals(autoCreateCode)) continue;
            if (materialList.contains(materialNumber)) {
                String msg = I18nUtil.translate((String)"i18n_alert_uNWFsjVBjSLAy_f67be2d2", (String)"\u5bfc\u5165\u6570\u636e\u4e2d\u6709\u91cd\u590d\u7684\u7269\u6599\u7f16\u53f7");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            materialList.add(materialNumber);
        }
        ArrayList<PurchaseMaterialHead> updateList = new ArrayList<PurchaseMaterialHead>();
        for (Map data : dataList) {
            String materialNumber = (String)data.get("materialNumber");
            List collect = purchaseMaterialHeadListAll.stream().filter(purchaseMaterialHead -> purchaseMaterialHead.getMaterialNumber().equals(materialNumber)).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(collect)) {
                String msg = I18nUtil.translate((String)"i18n_alert_HesMKdejSLAy_bdd4e8c8", (String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u8be5\u7269\u6599\u7f16\u53f7");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            PurchaseMaterialHead purchaseMaterialHead2 = (PurchaseMaterialHead)((Object)collect.get(0));
            PurchaseMaterialHead entity = (PurchaseMaterialHead)((Object)this.transferEntity(data, PurchaseMaterialHead.class, excelImportDTO));
            if (StringUtils.isNotBlank((CharSequence)entity.getIsHazardousChemical())) {
                purchaseMaterialHead2.setIsHazardousChemical(entity.getIsHazardousChemical());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getStorageConditions())) {
                purchaseMaterialHead2.setStorageConditions(entity.getStorageConditions());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getStorageConditionsDetails())) {
                purchaseMaterialHead2.setStorageConditionsDetails(entity.getStorageConditionsDetails());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getIsMedicalDevice())) {
                purchaseMaterialHead2.setIsMedicalDevice(entity.getIsMedicalDevice());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getIsDisinfectant())) {
                purchaseMaterialHead2.setIsDisinfectant(entity.getIsDisinfectant());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getIsDrug())) {
                purchaseMaterialHead2.setIsDrug(entity.getIsDrug());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getIsScientific())) {
                purchaseMaterialHead2.setIsScientific(entity.getIsScientific());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getIsImported())) {
                purchaseMaterialHead2.setIsImported(entity.getIsImported());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getOriginalBrand())) {
                purchaseMaterialHead2.setOriginalBrand(entity.getOriginalBrand());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getBrand())) {
                purchaseMaterialHead2.setBrand(entity.getBrand());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getMaterialBrand())) {
                purchaseMaterialHead2.setMaterialBrand(entity.getMaterialBrand());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getSourceArea())) {
                purchaseMaterialHead2.setSourceArea(entity.getSourceArea());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getManufacturer())) {
                purchaseMaterialHead2.setManufacturer(entity.getManufacturer());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getProducer())) {
                purchaseMaterialHead2.setProducer(entity.getProducer());
            }
            updateList.add(purchaseMaterialHead2);
        }
        this.purchaseMaterialHeadService.updateBatchById(updateList);
        if (entityList.isEmpty()) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

