/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.job;

import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class SrmSynPurchaseOrgJob
implements JobRpcService {
    private static final Logger logger = LoggerFactory.getLogger(SrmSynPurchaseOrgJob.class);
    private final String LOCK_PREFIX = "purchaseOrg_schedule_srmSynPurchaseOrgJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;

    public void execute(String parameter) {
        String requestId;
        TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
        LoginUser loginUser = SysUtil.getLoginUser();
        if (loginUser == null) {
            loginUser = new LoginUser();
            loginUser.setElsAccount(SysUtil.getPurchaseAccount());
            loginUser.setSubAccount("1001");
            LoginUserContext.setUser((LoginUser)loginUser);
        }
        if (!this.redisUtil.tryGetDistributedLock("purchaseOrg_schedule_srmSynPurchaseOrgJob", requestId = TenantContext.getTenant(), 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u540c\u6b65\u4e2d\u53f0\u7ec4\u7ec7\u4fe1\u606f\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            logger.info("srmSynPurchaseOrgJob start");
            this.purchaseOrganizationInfoService.srmSynPurchaseOrgJob();
            logger.info("srmSynPurchaseOrgJob end");
        }
        catch (Exception e) {
            logger.info(Thread.currentThread().getName() + "\u540c\u6b65\u4e2d\u53f0\u7ec4\u7ec7\u4fe1\u606f\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("purchaseOrg_schedule_srmSynPurchaseOrgJob", requestId);
        }
    }

    @Scheduled(cron="0 20 0 ? * *")
    public void doScheduled() {
        this.execute(null);
    }
}

