/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bankLocations.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.modules.bankLocations.entity.BankLocations;
import com.els.modules.bankLocations.service.BankLocationsService;
import com.els.modules.order.api.service.QuartzJobRpcService;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

@Service(value="bankLocationsCreatedPushSAPJob")
public class bankLocationsCreatedPushSAPJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(bankLocationsCreatedPushSAPJob.class);
    @Autowired
    private BankLocationsService bankLocationsService;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    @Resource
    private QuartzJobRpcService quartzJobRpcService;
    @Autowired
    private PlatformTransactionManager txManager;

    @Transactional
    public void execute(String parameter) {
        List<Object> entityList = new ArrayList();
        Date lastExecutionTime = this.quartzJobRpcService.findByJobNameKey("bankLocationsCreatedPushSAPJob");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        entityList = this.getBankLocationsFromBaoLongView(lastExecutionTime);
        entityList.forEach(it -> it.setElsAccount("2359110"));
        List stringList = entityList.stream().map(BankLocations::getCode).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{BankLocations::getCode, BaseEntity::getId});
        wrapper.in(BankLocations::getCode, stringList);
        List bankLocationsList = this.bankLocationsService.list((Wrapper)wrapper);
        List<Object> entityInsertList = new ArrayList();
        ArrayList<BankLocations> entityUpdateList = new ArrayList<BankLocations>();
        ReturnSRMBaseVO returnSRMBaseVO = new ReturnSRMBaseVO();
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus transactionStatus = this.txManager.getTransaction((TransactionDefinition)def);
        if (bankLocationsList.size() > 0) {
            entityInsertList = entityList.stream().filter(item -> !bankLocationsList.stream().map(e -> e.getCode()).collect(Collectors.toList()).contains(item.getCode())).collect(Collectors.toList());
            for (BankLocations once : bankLocationsList) {
                for (BankLocations bankLocations : entityList) {
                    if (bankLocations.getCode() == null || !bankLocations.getCode().equals(once.getCode())) continue;
                    bankLocations.setId(once.getId());
                    entityUpdateList.add(bankLocations);
                }
            }
            if (entityInsertList.size() > 0) {
                this.bankLocationsService.saveBatch(entityInsertList);
                returnSRMBaseVO = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_BankLocations_SAP.getValue(), this.toJsonForBankLocations("I", entityInsertList));
            }
            if (entityUpdateList.size() > 0) {
                this.bankLocationsService.updateBatchById(entityUpdateList);
                returnSRMBaseVO = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_BankLocations_SAP.getValue(), this.toJsonForBankLocations("U", entityUpdateList));
            }
        } else {
            this.bankLocationsService.saveBatch(entityList);
            returnSRMBaseVO = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_BankLocations_SAP.getValue(), this.toJsonForBankLocations("I", entityList));
        }
        if (null != lastExecutionTime) {
            this.quartzJobRpcService.updateByJobNameKey("bankLocationsCreatedPushSAPJob", new Date());
        } else {
            try {
                Date date1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sdf.format(new Date()) + " 00:00:00");
                this.quartzJobRpcService.updateByJobNameKey("bankLocationsCreatedPushSAPJob", date1);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        this.txManager.commit(transactionStatus);
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        Map map = returnMap.getInnerMap();
        List list = (List)map.get("IT_DATA");
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"SAP\u8fd4\u56de\u6d88\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u627e\u539f\u56e0"));
        }
        list.forEach(tReturn -> {
            if (null == tReturn.get("TYPE")) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u627e\u539f\u56e0"));
            }
            String type = tReturn.get("TYPE").toString();
            if (!type.equals("S")) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + tReturn.get("MESSAGE").toString())));
            }
        });
    }

    private String toJsonForBankLocations(String flag, List<BankLocations> bankLocationsListPushSap) {
        SimpleDateFormat stf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap all = new HashMap();
        HashMap<String, String> parameterList = new HashMap<String, String>();
        HashMap<String, Object> IT_DATA = new HashMap<String, Object>();
        IT_DATA.put("tableName", "IT_DATA");
        ArrayList IT_ITEMList = new ArrayList();
        bankLocationsListPushSap.forEach(item -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("BANKS", "CN");
            if (!flag.equals("U")) {
                map.put("BANKL", item.getCode());
            }
            map.put("BANKA", item.getBankname());
            map.put("BRNCH", item.getCode());
            IT_ITEMList.add(map);
        });
        IT_DATA.put("tableFields0", IT_ITEMList);
        parameterList.put("I_BS", flag);
        all.put("IT_DATA", IT_DATA);
        all.put("parameterList", parameterList);
        String jsonString = JSON.toJSONString(all);
        return jsonString;
    }

    private ReturnSRMBaseVO callSAPOrderInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }

    public List<BankLocations> getBankLocationsFromBaoLongView(Date lastExecutionTime) {
        List<BankLocations> dataBankLocations = new ArrayList<BankLocations>();
        String URL2 = "jdbc:mysql://192.168.34.78:3306/atsdb";
        String USER = "outsysuser";
        String PASSWORD = "fingard@1!";
        Statement sta = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            con = DriverManager.getConnection(URL2, USER, PASSWORD);
            LocalDate localDate = null;
            localDate = null != lastExecutionTime ? lastExecutionTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : LocalDate.now();
            log.info("localDate:" + localDate);
            sta = con.createStatement();
            String sql = "SELECT t. CODE as code,t. NAME as name,t.BANKNAME as bankname,t.ISACTIVE  as isactive,t.AREANAME as areaname,t.LASTMODIFIEDON as lastmodifiedon FROM t_sy_banklocations_view t WHERE t.LASTMODIFIEDON >= '" + localDate.toString() + "'";
            rs = sta.executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            int columnNum = metaData.getColumnCount();
            ArrayList list = new ArrayList();
            while (rs.next()) {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                for (int i = 1; i <= columnNum; ++i) {
                    rowData.put(metaData.getColumnName(i).toLowerCase(), rs.getObject(i));
                }
                list.add(rowData);
            }
            if (!list.isEmpty()) {
                dataBankLocations = JSONArray.parseArray((String)JSON.toJSONString(list), BankLocations.class);
            } else {
                Assert.notEmpty(dataBankLocations, (String)("\u589e\u91cf\u65f6\u95f4\uff1a" + localDate + "--\u81f3\u5f53\u524d\u65f6\u95f4\uff0c\u62c9\u53d6\u5b9d\u9f99\u89c6\u56fe\u94f6\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u4e0d\u6267\u884c\uff01"));
            }
            rs.close();
            sta.close();
            con.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dataBankLocations;
    }
}

