/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.mapper.PurchaseMaterialItemMapper;
import com.els.modules.material.vo.MaterialFactorySAPToSRM;
import com.els.modules.material.vo.MaterialSAP;
import com.els.modules.order.api.service.QuartzJobRpcService;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pullMaterialFactoryJob")
public class PullMaterialFactoryJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PullMaterialFactoryJob.class);
    @Resource
    private PurchaseMaterialItemMapper purchaseMaterialItemMapper;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    @Resource
    private QuartzJobRpcService quartzJobRpcService;

    public void execute(String parameter) {
        Date lastExecutionTime = this.quartzJobRpcService.findByJobNameKey("pullMaterialFactoryJob");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdft = new SimpleDateFormat("HH:mm:ss");
        ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_MATERIAL_FACTORY_SAP.getValue(), this.toJson("ET_MARC", null, lastExecutionTime, sdf, sdft));
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        String e_type = returnMap.getString("E_TYPE");
        if ("E".equals(e_type)) {
            throw new ELSBootException("\u7269\u6599\u5de5\u5382" + returnMap.getString("E_MESSAGE"));
        }
        String et_marc = returnMap.getString("ET_MARC");
        List list = JSONArray.parseArray((String)et_marc, MaterialFactorySAPToSRM.class);
        list.forEach(var -> {
            var.setMaterialNumber(var.getMaterialNumber().replaceAll("^0*", ""));
            var.setId(IdWorker.getIdStr());
            var.setElsAccount(TenantContext.getTenant());
            var.setCreateBy("interface");
            if (StringUtils.isNotBlank((CharSequence)var.getFbk1())) {
                var.setFbk1("1");
            } else {
                var.setFbk1("0");
            }
        });
        this.purchaseMaterialItemMapper.replaceMaterialFactory(list);
        if (null != lastExecutionTime) {
            this.quartzJobRpcService.updateByJobNameKey("pullMaterialFactoryJob", new Date());
        } else {
            try {
                Date date1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sdf.format(new Date()) + " 00:00:00");
                this.quartzJobRpcService.updateByJobNameKey("pullMaterialFactoryJob", date1);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String toJson(String type, List<MaterialSAP> materialSAP, Date lastExecutionTime, SimpleDateFormat sdf, SimpleDateFormat sdft) {
        HashMap all = new HashMap();
        HashMap<String, String> ET_MARA = new HashMap<String, String>();
        ET_MARA.put("tableName", "ET_MARA");
        HashMap<String, String> I_MATNR = new HashMap<String, String>();
        I_MATNR.put("tableName", "I_MATNR");
        HashMap<String, String> I_MTART = new HashMap<String, String>();
        I_MTART.put("tableName", "I_MTART");
        HashMap<String, String> I_MATKL = new HashMap<String, String>();
        I_MATKL.put("tableName", "I_MATKL");
        HashMap<String, String> ET_MARC = new HashMap<String, String>();
        ET_MARC.put("tableName", "ET_MARC");
        HashMap<String, String> ET_MVKE = new HashMap<String, String>();
        ET_MVKE.put("tableName", "ET_MVKE");
        HashMap<String, String> I_VKORG = new HashMap<String, String>();
        I_VKORG.put("tableName", "I_VKORG");
        HashMap<String, String> I_WERKS = new HashMap<String, String>();
        I_WERKS.put("tableName", "I_WERKS");
        HashMap<String, String> parameterList = new HashMap<String, String>();
        parameterList.put("I_CHAR", "B");
        if (null != lastExecutionTime) {
            parameterList.put("I_DATUM", sdf.format(lastExecutionTime));
            parameterList.put("I_UTIME", sdft.format(lastExecutionTime));
        } else {
            parameterList.put("I_DATUM", sdf.format(new Date()));
            parameterList.put("I_UTIME", "00:00:00");
        }
        all.put("ET_MARA", ET_MARA);
        all.put("I_MATNR", I_MATNR);
        all.put("I_MTART", I_MTART);
        all.put("I_MATKL", I_MATKL);
        all.put("ET_MARC", ET_MARC);
        all.put("ET_MVKE", ET_MVKE);
        all.put("I_VKORG", I_VKORG);
        all.put("I_WERKS", I_WERKS);
        all.put("parameterList", parameterList);
        String jsonString = JSON.toJSONString(all);
        return jsonString;
    }

    private ReturnSRMBaseVO callSAPInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }
}

