/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.job;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.api.service.JobRpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.mapper.PurchaseMaterialCodeMapper;
import com.els.modules.material.mapper.PurchaseMaterialHeadMapper;
import com.els.modules.material.vo.MaterialSAPToSRM;
import com.els.modules.order.api.service.QuartzJobRpcService;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pullMaterialJob")
public class PullMaterialJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PullMaterialJob.class);
    @Resource
    private PurchaseMaterialHeadMapper purchaseMaterialHeadMapper;
    @Resource
    private PurchaseMaterialCodeMapper purchaseMaterialCodeMapper;
    @Resource
    private TemplateHeadService templateHeadService;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    @Resource
    private QuartzJobRpcService quartzJobRpcService;

    public void execute(String parameter) {
        String elsAccount = JSONObject.parseObject((String)parameter).getString("elsAccount");
        TemplateHead templateHead = this.getTemplateHead(elsAccount);
        Date lastExecutionTime = this.quartzJobRpcService.findByJobNameKey("pullMaterialJob");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdft = new SimpleDateFormat("HH:mm:ss");
        ReturnSRMBaseVO returnSRMBaseVO = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_MATERIAL_SAP.getValue(), this.toJson(lastExecutionTime, sdf, sdft));
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        String e_type = returnMap.getString("E_TYPE");
        if ("E".equals(e_type)) {
            throw new ELSBootException("\u7269\u6599\u4e3b\u6570\u636e" + returnMap.getString("E_MESSAGE"));
        }
        String et_mara = returnMap.getString("ET_MARA");
        List list = JSONArray.parseArray((String)et_mara, MaterialSAPToSRM.class);
        list.forEach(var -> {
            var.setMaterialNumber(var.getMaterialNumber().replaceAll("^0*", ""));
            var.setId(IdWorker.getIdStr());
            var.setElsAccount(elsAccount);
            var.setCreateBy("interface");
            var.setUpdateBy("interface");
            var.setBlocDel("0");
            var.setCreateTime(new Date());
            var.setUpdateTime(new Date());
            var.setSourceSystem("SAP");
            var.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            var.setMaterialName(var.getMaterialDesc());
            var.setTemplateAccount(templateHead.getElsAccount());
            var.setTemplateNumber(templateHead.getTemplateNumber());
            var.setTemplateVersion(templateHead.getTemplateVersion());
            var.setTemplateName(templateHead.getTemplateName());
            if (StringUtils.isNotBlank((CharSequence)var.getFreeze())) {
                var.setFreeze("1");
            } else {
                var.setFreeze("0");
            }
        });
        this.purchaseMaterialHeadMapper.replaceMaterial(list);
        if (null != lastExecutionTime) {
            this.quartzJobRpcService.updateByJobNameKey("pullMaterialJob", new Date());
        } else {
            try {
                Date date1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sdf.format(new Date()) + " 00:00:00");
                this.quartzJobRpcService.updateByJobNameKey("pullMaterialJob", date1);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String toJson(Date lastExecutionTime, SimpleDateFormat sdf, SimpleDateFormat sdft) {
        HashMap all = new HashMap();
        HashMap<String, String> ET_MARA = new HashMap<String, String>();
        ET_MARA.put("tableName", "ET_MARA");
        HashMap<String, String> I_MATNR = new HashMap<String, String>();
        I_MATNR.put("tableName", "I_MATNR");
        HashMap<String, String> I_MTART = new HashMap<String, String>();
        I_MTART.put("tableName", "I_MTART");
        HashMap<String, String> I_MATKL = new HashMap<String, String>();
        I_MATKL.put("tableName", "I_MATKL");
        HashMap<String, String> ET_MARC = new HashMap<String, String>();
        ET_MARC.put("tableName", "ET_MARC");
        HashMap<String, String> ET_MVKE = new HashMap<String, String>();
        ET_MVKE.put("tableName", "ET_MVKE");
        HashMap<String, String> I_VKORG = new HashMap<String, String>();
        I_VKORG.put("tableName", "I_VKORG");
        HashMap<String, String> I_WERKS = new HashMap<String, String>();
        I_WERKS.put("tableName", "I_WERKS");
        HashMap<String, String> parameterList = new HashMap<String, String>();
        parameterList.put("I_CHAR", "A");
        if (null != lastExecutionTime) {
            parameterList.put("I_DATUM", sdf.format(lastExecutionTime));
            parameterList.put("I_UTIME", sdft.format(lastExecutionTime));
        } else {
            parameterList.put("I_DATUM", sdf.format(new Date()));
            parameterList.put("I_UTIME", "00:00:00");
        }
        all.put("ET_MARA", ET_MARA);
        all.put("I_MATNR", I_MATNR);
        all.put("I_MTART", I_MTART);
        all.put("I_MATKL", I_MATKL);
        all.put("ET_MARC", ET_MARC);
        all.put("ET_MVKE", ET_MVKE);
        all.put("I_VKORG", I_VKORG);
        all.put("I_WERKS", I_WERKS);
        all.put("parameterList", parameterList);
        String jsonString = JSON.toJSONString(all);
        return jsonString;
    }

    private ReturnSRMBaseVO callSAPOrderInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }

    public static long getTodayStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime().getTime();
    }

    private TemplateHead getTemplateHead(String elsAccount) {
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        List list = this.templateHeadService.getAllByAccountAndType(elsAccount, "material");
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return (TemplateHead)list.get(0);
    }

    private void setMaterialCode(List<MaterialSAPToSRM> list) {
        ArrayList cateCodeList = new ArrayList();
        list.forEach(head -> {
            PurchaseMaterialCode purchaseMaterialCode;
            if (StringUtils.isNotBlank((CharSequence)head.getFbk1())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateCode(head.getFbk1());
                purchaseMaterialCode.setUpCateCode(head.getFbk2());
                purchaseMaterialCode.setCateName(head.getFbk1());
                purchaseMaterialCode.setUpCateName(head.getFbk2());
                cateCodeList.add(purchaseMaterialCode);
            }
            if (StringUtils.isNotBlank((CharSequence)head.getFbk2())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateCode(head.getFbk2());
                purchaseMaterialCode.setUpCateCode(head.getFbk3());
                purchaseMaterialCode.setCateName(head.getFbk2());
                purchaseMaterialCode.setUpCateName(head.getFbk3());
                cateCodeList.add(purchaseMaterialCode);
            }
            if (StringUtils.isNotBlank((CharSequence)head.getFbk3())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateCode(head.getFbk3());
                purchaseMaterialCode.setUpCateCode(head.getFbk4());
                purchaseMaterialCode.setCateName(head.getFbk3());
                purchaseMaterialCode.setUpCateName(head.getFbk4());
                cateCodeList.add(purchaseMaterialCode);
            }
            if (StringUtils.isNotBlank((CharSequence)head.getFbk4())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateName(head.getFbk4());
                purchaseMaterialCode.setCateCode(head.getFbk4());
                cateCodeList.add(purchaseMaterialCode);
            }
        });
        ArrayList collect = cateCodeList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseMaterialCode>(Comparator.comparing(o -> o.getCateName() + ";" + o.getUpCateName() + ";" + o.getCateCode() + ";" + o.getUpCateCode()))), ArrayList::new));
        for (PurchaseMaterialCode cate : collect) {
            Integer integer;
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)cate.getCateName())) {
                queryWrapper.eq((Object)"cate_name", (Object)cate.getCateName());
            }
            if (StringUtils.isNotBlank((CharSequence)cate.getUpCateName())) {
                queryWrapper.eq((Object)"up_cate_name", (Object)cate.getUpCateName());
            }
            if ((integer = this.purchaseMaterialCodeMapper.selectCount((Wrapper)queryWrapper)) > 0) continue;
            this.purchaseMaterialCodeMapper.insert((Object)cate);
        }
    }
}

