/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.job;

import cn.hutool.core.lang.UUID;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseMaterialSourceJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialSourceJob.class);
    private final String LOCK_PREFIX = "purchaseMaterialSource_schedule_purchaseMaterialSourceJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;

    public void execute(String parameter) {
        block6: {
            String requestId = UUID.fastUUID().toString();
            try {
                if (this.redisUtil.tryGetDistributedLock("purchaseMaterialSource_schedule_purchaseMaterialSourceJob", requestId, 50000L)) {
                    log.info(":::\u8d27\u6e90\u6e05\u5355PurchaseMaterialSourceJob start");
                    this.purchaseMaterialSourceService.changeSourceStatusForJob();
                    log.info(":::\u8d27\u6e90\u6e05\u5355PurchaseMaterialSourceJob end");
                    break block6;
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFzEHrLSiKRcWVxPVBRc_268e90d8", (String)" \u8d27\u6e90\u6570\u636e\u72b6\u6001\u66f4\u6539\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
            }
            catch (Exception e) {
                log.info(Thread.currentThread().getName() + "\u8d27\u6e90\u6e05\u5355\u6570\u636e\u72b6\u6001\u66f4\u6539\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
            finally {
                this.redisUtil.releaseDistributedLock("purchaseMaterialSource_schedule_purchaseMaterialSourceJob", requestId);
            }
        }
    }
}

