/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.mapper.PurchaseMaterialCodeMapper;
import com.els.modules.material.mapper.PurchaseMaterialHeadMapper;
import com.els.modules.material.mapper.PurchaseMaterialItemMapper;
import com.els.modules.material.mapper.PurchaseMaterialUnitMapper;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import com.els.modules.material.vo.MaterialFactorySAPToSRM;
import com.els.modules.material.vo.MaterialSAP;
import com.els.modules.material.vo.MaterialSAPToSRM;
import com.els.modules.material.vo.MaterialSAPVO;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.mapper.PurchaseOrganizationInfoMapper;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseMaterialHeadServiceImpl
extends ServiceImpl<PurchaseMaterialHeadMapper, PurchaseMaterialHead>
implements PurchaseMaterialHeadService {
    @Resource
    private PurchaseMaterialHeadMapper purchaseMaterialHeadMapper;
    @Resource
    private PurchaseMaterialItemMapper purchaseMaterialItemMapper;
    @Resource
    private PurchaseMaterialCodeMapper purchaseMaterialCodeMapper;
    @Resource
    private PurchaseOrganizationInfoMapper purchaseOrganizationInfoMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialUnitMapper purchaseMaterialUnitMapper;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private TemplateHeadService templateHeadService;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";
    private static final String PURCHASE_MATERIAL_UNIT_IS_DEFAULT = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseMaterialHead head, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        this.checkMaterialNumber(head);
        purchaseMaterialUnitList = this.generateUnit(head, purchaseMaterialUnitList);
        for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
            if (unit.getObjectUnit() == null || "".equals(unit.getObjectUnit())) {
                unit.setObjectUnit(head.getBaseUnit());
            }
            if (PURCHASE_UNIT_TYPE.equals(unit.getType())) {
                head.setPurchaseUnit(unit.getObjectUnit());
                continue;
            }
            if (!"1".equals(unit.getType())) continue;
            head.setRepertoryUnit(unit.getObjectUnit());
        }
        this.checkMaterialItem(purchaseMaterialItemList);
        if (!"1".equals(head.getNeedAudit())) {
            head.setNeedAudit(PURCHASE_UNIT_TYPE);
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        head.setSubmitStatus(PURCHASE_UNIT_TYPE);
        this.purchaseMaterialHeadMapper.insert((Object)head);
        this.insertData(head, purchaseMaterialItemList, purchaseMaterialUnitList);
    }

    @Override
    public IPage<PurchaseMaterialHead> selectPage(Page<PurchaseMaterialHead> page, QueryWrapper<PurchaseMaterialHead> queryWrapper) {
        return this.purchaseMaterialHeadMapper.selectAllPage(page, queryWrapper);
    }

    @Override
    public List<PurchaseMaterialHead> selectByMaterialNumber(LambdaQueryWrapper<PurchaseMaterialHead> queryWrapper) {
        return this.purchaseMaterialHeadMapper.selectByMaterialNumber(queryWrapper);
    }

    private List<PurchaseMaterialUnit> generateUnit(PurchaseMaterialHead purchaseMaterialHead, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        if (purchaseMaterialUnitList == null || CollectionUtil.isEmpty(purchaseMaterialUnitList)) {
            purchaseMaterialUnitList = new ArrayList<PurchaseMaterialUnit>();
            PurchaseMaterialUnit purchaseUnit = new PurchaseMaterialUnit();
            purchaseUnit.setType(PURCHASE_UNIT_TYPE);
            purchaseUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
            purchaseUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
            purchaseUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
            purchaseUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
            purchaseUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
            purchaseUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
            purchaseUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
            purchaseUnit.setDeleted(purchaseMaterialHead.getDeleted());
            purchaseUnit.setBasicAmount(BigDecimal.ONE);
            purchaseUnit.setObjectAmount(BigDecimal.ONE);
            purchaseUnit.setChangeUnit("=");
            purchaseUnit.setIsDefault("1");
            purchaseMaterialUnitList.add(purchaseUnit);
            PurchaseMaterialUnit repertoryUnit = new PurchaseMaterialUnit();
            repertoryUnit.setType("1");
            repertoryUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
            repertoryUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
            repertoryUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
            repertoryUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
            repertoryUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
            repertoryUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
            repertoryUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
            repertoryUnit.setDeleted(purchaseMaterialHead.getDeleted());
            repertoryUnit.setBasicAmount(BigDecimal.ONE);
            repertoryUnit.setObjectAmount(BigDecimal.ONE);
            repertoryUnit.setChangeUnit("=");
            repertoryUnit.setIsDefault("1");
            purchaseMaterialUnitList.add(repertoryUnit);
        }
        return purchaseMaterialUnitList;
    }

    private void checkMaterialNumber(PurchaseMaterialHead purchaseMaterialHead) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)purchaseMaterialHead.getMaterialNumber())).ne(StrUtil.isNotBlank((CharSequence)purchaseMaterialHead.getId()), BaseEntity::getId, (Object)purchaseMaterialHead.getId())).last(" limit 1");
        PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)((PurchaseMaterialHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (null != head) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_MKdejSLAyWWWWWW_fe5429fb", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u7f16\u53f7\uff1a" + purchaseMaterialHead.getMaterialNumber()), (String[])new String[]{purchaseMaterialHead.getMaterialNumber()}));
        }
    }

    private void checkMaterialItem(List<PurchaseMaterialItem> purchaseMaterialItemList) {
        List stringList = purchaseMaterialItemList.stream().map(PurchaseMaterialItem::getFactory).collect(Collectors.toList());
        long count = stringList.stream().distinct().count();
        if ((long)stringList.size() != count) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_SLcsMKdejRHW_ba2f6f5", (String)"\u7269\u6599\u884c\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5de5\u5382\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMaterialHead head, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        if ("1".equals(head.getAutoCreateCode()) && StrUtil.isBlank((CharSequence)head.getMaterialNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmMaterialNumber", (Object)head);
            head.setMaterialNumber(nextCode);
        } else if (StrUtil.isBlank((CharSequence)head.getMaterialNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoxOLVW_47edf9d6", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        this.checkMaterialNumber(head);
        this.checkMaterialItem(purchaseMaterialItemList);
        purchaseMaterialUnitList = this.generateUnit(head, purchaseMaterialUnitList);
        for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
            if (unit.getObjectUnit() == null || "".equals(unit.getObjectUnit())) {
                unit.setObjectUnit(head.getBaseUnit());
            }
            if (PURCHASE_UNIT_TYPE.equals(unit.getType())) {
                head.setPurchaseUnit(unit.getObjectUnit());
                continue;
            }
            if (!"1".equals(unit.getType())) continue;
            head.setRepertoryUnit(unit.getObjectUnit());
        }
        if (!"1".equals(head.getNeedAudit())) {
            head.setNeedAudit(PURCHASE_UNIT_TYPE);
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus()) || CharSequenceUtil.isEmpty((CharSequence)head.getFlowId())) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            head.setSubmitStatus(PURCHASE_UNIT_TYPE);
        }
        int count = this.purchaseMaterialHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseMaterialItemMapper.deleteByMainId(head.getId());
        this.purchaseMaterialUnitMapper.deleteByMainId(head.getId());
        this.insertData(head, purchaseMaterialItemList, purchaseMaterialUnitList);
    }

    private void insertData(PurchaseMaterialHead purchaseMaterialHead, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        if (CollectionUtil.isNotEmpty(purchaseMaterialItemList)) {
            for (PurchaseMaterialItem entity : purchaseMaterialItemList) {
                entity.setHeadId(purchaseMaterialHead.getId());
                entity.setMaterialNumber(purchaseMaterialHead.getMaterialNumber());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseMaterialHead);
            }
            ((PurchaseMaterialItemService)SpringContextUtils.getBean(PurchaseMaterialItemService.class)).saveBatch(purchaseMaterialItemList);
        }
        if (CollectionUtil.isNotEmpty(purchaseMaterialUnitList)) {
            for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
                unit.setHeadId(purchaseMaterialHead.getId());
                unit.setElsAccount(purchaseMaterialHead.getElsAccount());
                SysUtil.setSysParam((BaseEntity)unit, (BaseEntity)purchaseMaterialHead);
            }
            ((PurchaseMaterialUnitService)SpringContextUtils.getBean(PurchaseMaterialUnitService.class)).saveBatch(purchaseMaterialUnitList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseMaterialItemMapper.deleteByMainId(id);
        this.purchaseMaterialHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delHead(String id) {
        this.purchaseMaterialItemMapper.updateByHeadId(id);
        this.purchaseMaterialHeadMapper.updateByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseMaterialItemMapper.deleteByMainId(serializable.toString());
            this.purchaseMaterialHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public PurchaseMaterialHead getMaterialHeadByNumber(String materialNumber) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)materialNumber);
        List materialList = this.list((Wrapper)wrapper);
        return materialList.isEmpty() ? null : (PurchaseMaterialHead)((Object)materialList.get(0));
    }

    @Override
    public List<PurchaseMaterialHead> getMaterialHeadByNumbers(List<String> materialNumbers) {
        if (CollUtil.isEmpty(materialNumbers)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PurchaseMaterialHead::getMaterialNumber, materialNumbers);
        return ((PurchaseMaterialHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public PurchaseMaterialHead queryMaterialItemByFactory(PurchaseMaterialHead purchaseMaterialHeadPage) {
        List purchaseMaterialItemList;
        LambdaQueryWrapper purchaseMaterialHeadLambdaQueryWrapper = new LambdaQueryWrapper();
        purchaseMaterialHeadLambdaQueryWrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)purchaseMaterialHeadPage.getMaterialNumber());
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadMapper.selectOne((Wrapper)purchaseMaterialHeadLambdaQueryWrapper));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_number", (Object)purchaseMaterialHeadPage.getMaterialNumber());
        List materialItemList = this.purchaseMaterialItemMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)materialItemList) && CollectionUtil.isNotEmpty(purchaseMaterialItemList = materialItemList.stream().filter(item -> purchaseMaterialHeadPage.getFactory().equals(item.getFactory())).collect(Collectors.toList()))) {
            PurchaseMaterialItem purchaseMaterialItem = (PurchaseMaterialItem)((Object)purchaseMaterialItemList.get(0));
            purchaseMaterialHead.setJit(purchaseMaterialItem.getJit());
            purchaseMaterialHead.setDeliveryArrange(purchaseMaterialItem.getDeliveryArrange());
            purchaseMaterialHead.setBatch(purchaseMaterialItem.getBatch());
        }
        return purchaseMaterialHead;
    }

    @Override
    public void getDataByErp(PurchaseMaterialHead materialHead) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getMaterialData", (Object)new JSONObject());
    }

    @Override
    public void pushMaterialByManual(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List materialList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseMaterialHead head2 : materialList) {
            this.pushMaterial(head2);
        }
    }

    @Override
    public void pushMaterial(PurchaseMaterialHead head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushMaterialToERP", (Object)head);
    }

    @Override
    public IPage<PurchaseMaterialHead> pageHeadOrItem(Page<PurchaseMaterialHead> page, QueryWrapper<PurchaseMaterialHead> queryWrapper) {
        return ((PurchaseMaterialHeadMapper)this.baseMapper).pageHeadOrItem(page, queryWrapper);
    }

    @Override
    @Transactional
    public void pullMaterialSAP(List<MaterialSAP> materialSAP) {
        String elsAccount = TenantContext.getTenant();
        TemplateHead templateHead = this.getTemplateHead(elsAccount);
        ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_MATERIAL_SAP.getValue(), this.toJson("ET_MARA", materialSAP));
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        String e_type = returnMap.getString("E_TYPE");
        if ("E".equals(e_type)) {
            throw new ELSBootException("\u7269\u6599\u4e3b\u6570\u636e" + returnMap.getString("E_MESSAGE"));
        }
        String et_mara = returnMap.getString("ET_MARA");
        List list = JSONArray.parseArray((String)et_mara, MaterialSAPToSRM.class);
        list.forEach(var -> {
            var.setId(IdWorker.getIdStr());
            var.setMaterialNumber(var.getMaterialNumber().replaceAll("^0*", ""));
            var.setElsAccount(elsAccount);
            var.setCreateBy("interface");
            var.setUpdateBy("interface");
            var.setBlocDel(PURCHASE_UNIT_TYPE);
            var.setCreateTime(new Date());
            var.setUpdateTime(new Date());
            var.setSourceSystem("SAP");
            var.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            var.setMaterialName(var.getMaterialDesc());
            var.setTemplateAccount(templateHead.getElsAccount());
            var.setTemplateNumber(templateHead.getTemplateNumber());
            var.setTemplateVersion(templateHead.getTemplateVersion());
            var.setTemplateName(templateHead.getTemplateName());
            if (StringUtils.isNotBlank((CharSequence)var.getFreeze())) {
                var.setFreeze("1");
            } else {
                var.setFreeze(PURCHASE_UNIT_TYPE);
            }
        });
        this.purchaseMaterialHeadMapper.replaceMaterial(list);
        if (StringUtils.isNotBlank((CharSequence)materialSAP.get(0).getFactory())) {
            ReturnSRMBaseVO returnSRMBaseVO1 = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_MATERIAL_FACTORY_SAP.getValue(), this.toJson("ET_MARC", materialSAP));
            String data1 = returnSRMBaseVO1.getData();
            JSONObject returnMap1 = JSON.parseObject((String)data1);
            String e_type1 = returnMap1.getString("E_TYPE");
            if ("E".equals(e_type1)) {
                throw new ELSBootException("\u7269\u6599\u5de5\u5382" + returnMap1.getString("E_MESSAGE"));
            }
            String et_marc = returnMap1.getString("ET_MARC");
            List list1 = JSONArray.parseArray((String)et_marc, MaterialFactorySAPToSRM.class);
            list1.forEach(var -> {
                var.setMaterialNumber(var.getMaterialNumber().replaceAll("^0*", ""));
                var.setId(IdWorker.getIdStr());
                var.setElsAccount(TenantContext.getTenant());
                var.setCreateBy("interface");
                if (StringUtils.isNotBlank((CharSequence)var.getFbk1())) {
                    var.setFbk1("1");
                } else {
                    var.setFbk1(PURCHASE_UNIT_TYPE);
                }
            });
            this.purchaseMaterialItemMapper.replaceMaterialFactory(list1);
        }
    }

    private void setMaterialCode(List<MaterialSAPToSRM> list) {
        ArrayList cateCodeList = new ArrayList();
        list.forEach(head -> {
            PurchaseMaterialCode purchaseMaterialCode;
            if (StringUtils.isNotBlank((CharSequence)head.getFbk1())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateCode(head.getFbk1());
                purchaseMaterialCode.setUpCateCode(head.getFbk2());
                purchaseMaterialCode.setCateName(head.getFbk1());
                purchaseMaterialCode.setUpCateName(head.getFbk2());
                cateCodeList.add(purchaseMaterialCode);
            }
            if (StringUtils.isNotBlank((CharSequence)head.getFbk2())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateCode(head.getFbk2());
                purchaseMaterialCode.setUpCateCode(head.getFbk3());
                purchaseMaterialCode.setCateName(head.getFbk2());
                purchaseMaterialCode.setUpCateName(head.getFbk3());
                cateCodeList.add(purchaseMaterialCode);
            }
            if (StringUtils.isNotBlank((CharSequence)head.getFbk3())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateCode(head.getFbk3());
                purchaseMaterialCode.setUpCateCode(head.getFbk4());
                purchaseMaterialCode.setCateName(head.getFbk3());
                purchaseMaterialCode.setUpCateName(head.getFbk4());
                cateCodeList.add(purchaseMaterialCode);
            }
            if (StringUtils.isNotBlank((CharSequence)head.getFbk4())) {
                purchaseMaterialCode = new PurchaseMaterialCode();
                purchaseMaterialCode.setCateName(head.getFbk4());
                purchaseMaterialCode.setCateCode(head.getFbk4());
                cateCodeList.add(purchaseMaterialCode);
            }
        });
        ArrayList collect = cateCodeList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PurchaseMaterialCode>(Comparator.comparing(o -> o.getCateName() + ";" + o.getUpCateName() + ";" + o.getCateCode() + ";" + o.getUpCateCode()))), ArrayList::new));
        for (PurchaseMaterialCode cate : collect) {
            Integer integer;
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)cate.getCateName())) {
                queryWrapper.eq((Object)"cate_name", (Object)cate.getCateName());
            }
            if (StringUtils.isNotBlank((CharSequence)cate.getUpCateName())) {
                queryWrapper.eq((Object)"up_cate_name", (Object)cate.getUpCateName());
            }
            if ((integer = this.purchaseMaterialCodeMapper.selectCount((Wrapper)queryWrapper)) > 0) continue;
            this.purchaseMaterialCodeMapper.insert((Object)cate);
        }
    }

    private TemplateHead getTemplateHead(String elsAccount) {
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        List list = this.templateHeadService.getAllByAccountAndType(elsAccount, "material");
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return (TemplateHead)list.get(0);
    }

    private String toJson(String type, List<MaterialSAP> materialSAP) {
        HashMap all = new HashMap();
        HashMap<String, String> ET_MARA = new HashMap<String, String>();
        ET_MARA.put("tableName", "ET_MARA");
        HashMap<String, Object> I_MATNR = new HashMap<String, Object>();
        I_MATNR.put("tableName", "I_MATNR");
        HashMap<String, String> I_MTART = new HashMap<String, String>();
        I_MTART.put("tableName", "I_MTART");
        HashMap<String, String> I_MATKL = new HashMap<String, String>();
        I_MATKL.put("tableName", "I_MATKL");
        HashMap<String, String> ET_MARC = new HashMap<String, String>();
        ET_MARC.put("tableName", "ET_MARC");
        HashMap<String, String> ET_MVKE = new HashMap<String, String>();
        ET_MVKE.put("tableName", "ET_MVKE");
        HashMap<String, String> I_VKORG = new HashMap<String, String>();
        I_VKORG.put("tableName", "I_VKORG");
        HashMap<String, Object> I_WERKS = new HashMap<String, Object>();
        I_WERKS.put("tableName", "I_WERKS");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> parameterList = new HashMap<String, String>();
        if (type.equals("ET_MARA")) {
            ArrayList material = new ArrayList();
            HashMap<String, String> tableFields4 = new HashMap<String, String>();
            tableFields4.put("HIGH", materialSAP.get(0).getMaterialNumber());
            tableFields4.put("LOW", materialSAP.get(0).getMaterialNumber());
            tableFields4.put("OPTION", "EQ");
            tableFields4.put("SIGN", "I");
            material.add(tableFields4);
            I_MATNR.put("tableFields4", material);
            parameterList.put("I_CHAR", "A");
        }
        if (type.equals("ET_MARC") && StringUtils.isNotBlank((CharSequence)materialSAP.get(0).getFactory())) {
            ArrayList factory = new ArrayList();
            HashMap<String, String> tableFields7 = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)materialSAP.get(0).getFactory())) {
                ArrayList material = new ArrayList();
                HashMap<String, String> tableFields4 = new HashMap<String, String>();
                tableFields4.put("HIGH", materialSAP.get(0).getMaterialNumber());
                tableFields4.put("LOW", materialSAP.get(0).getMaterialNumber());
                tableFields4.put("OPTION", "EQ");
                tableFields4.put("SIGN", "I");
                material.add(tableFields4);
                I_MATNR.put("tableFields4", material);
                I_MATNR.put("tableFields4", material);
                tableFields7.put("LOW", ((PurchaseOrganizationInfo)((Object)this.purchaseOrganizationInfoMapper.selectById((Serializable)((Object)materialSAP.get(0).getFactory())))).getOrgCode());
                tableFields7.put("HIGH", ((PurchaseOrganizationInfo)((Object)this.purchaseOrganizationInfoMapper.selectById((Serializable)((Object)materialSAP.get(0).getFactory())))).getOrgCode());
                tableFields7.put("OPTION", "EQ");
                tableFields7.put("SIGN", "I");
                factory.add(tableFields7);
                I_WERKS.put("tableFields7", factory);
                parameterList.put("I_CHAR", "B");
            }
        }
        all.put("ET_MARA", ET_MARA);
        all.put("I_MATNR", I_MATNR);
        all.put("I_MTART", I_MTART);
        all.put("I_MATKL", I_MATKL);
        all.put("ET_MARC", ET_MARC);
        all.put("ET_MVKE", ET_MVKE);
        all.put("I_VKORG", I_VKORG);
        all.put("I_WERKS", I_WERKS);
        all.put("parameterList", parameterList);
        String jsonString = JSON.toJSONString(all);
        return jsonString;
    }

    private ReturnSRMBaseVO callSAPInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }

    @Override
    @Transactional
    public void pullMaterialSAPTest() {
        List<MaterialSAPVO> list = this.purchaseMaterialHeadMapper.findfbkfbk();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(var -> {
                ArrayList<MaterialSAP> materialSAPList = new ArrayList<MaterialSAP>();
                MaterialSAP materialSAP = new MaterialSAP();
                materialSAP.setMaterialNumber(var.getFbk1());
                PurchaseOrganizationInfo purchaseOrganizationInfo = (PurchaseOrganizationInfo)((Object)((Object)this.purchaseOrganizationInfoMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrganizationInfo::getOrgCode, (Object)var.getFbk2())).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"factory"))));
                materialSAP.setFactory(purchaseOrganizationInfo.getId());
                materialSAPList.add(materialSAP);
                this.pullMaterialSAP(materialSAPList);
            });
        }
    }
}

