/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.entity.TreeOrgNode;
import com.els.modules.org.enumerate.PurchaseOrgCategoryStatus;
import com.els.modules.org.enumerate.PurchaseOrganizationStatus;
import com.els.modules.org.mapper.PurchaseOrganizationInfoMapper;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.org.vo.PurchaseOrgInfoVO;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseOrganizationInfoServiceImpl
extends ServiceImpl<PurchaseOrganizationInfoMapper, PurchaseOrganizationInfo>
implements PurchaseOrganizationInfoService {
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseOrganizationInfoMapper purchaseOrganizationInfoMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    private static final String CATALOGUE = "sys:dict:";
    private static final String COLON = ":";
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void savePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        if (StrUtil.isNotEmpty((CharSequence)purchaseOrganizationInfo.getOrgCode())) {
            this.checkOrgData(purchaseOrganizationInfo);
        }
        ((PurchaseOrganizationInfoMapper)this.baseMapper).insert((Object)purchaseOrganizationInfo);
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    public void updatePurchaseOrganizationInfo(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        int count;
        if ("0".equals(purchaseOrganizationInfo.getOrgNature())) {
            purchaseOrganizationInfo.setSuperExecutiveId("");
            purchaseOrganizationInfo.setExecutivePerson("");
            purchaseOrganizationInfo.setExecutiveDesc("");
            purchaseOrganizationInfo.setExecutiveRegion("");
            purchaseOrganizationInfo.setExecutiveLevel("");
            purchaseOrganizationInfo.setExecutiveOrder("");
        } else if ("1".equals(purchaseOrganizationInfo.getOrgNature())) {
            purchaseOrganizationInfo.setSuperBusinessId("");
            purchaseOrganizationInfo.setBusinessPerson("");
            purchaseOrganizationInfo.setBusinessDesc("");
            purchaseOrganizationInfo.setBusinessRegion("");
            purchaseOrganizationInfo.setBusinessLevel("");
            purchaseOrganizationInfo.setBusinessOrder("");
        }
        if (StrUtil.isNotEmpty((CharSequence)purchaseOrganizationInfo.getOrgCode())) {
            this.checkOrgData(purchaseOrganizationInfo);
        }
        if ((count = ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)purchaseOrganizationInfo)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.deleteRedis("purchase_organization_info");
    }

    public void checkOrgData(PurchaseOrganizationInfo purchaseOrganizationInfo) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)purchaseOrganizationInfo.getOrgCategoryCode())).eq(PurchaseOrganizationInfo::getOrgCode, (Object)purchaseOrganizationInfo.getOrgCode())).ne(null != purchaseOrganizationInfo.getId(), BaseEntity::getId, (Object)purchaseOrganizationInfo.getId());
        Integer count = this.purchaseOrganizationInfoMapper.selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            throw new ELSBootException("\u5f53\u524d\u7684\u7ec4\u7ec7\u7f16\u7801\u548c\u7ec4\u7ec7\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728,\u8bf7\u68c0\u67e5!");
        }
    }

    @Override
    public void delPurchaseOrganizationInfo(String id) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.deleteRedis("purchase_organization_info");
    }

    @Override
    public void delBatchPurchaseOrganizationInfo(List<String> idList) {
        ((PurchaseOrganizationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, Object> getSuperiorOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectByElsAccount(TenantContext.getTenant());
        ArrayList<TreeOrgNode> copyList = new ArrayList<TreeOrgNode>();
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
            TreeOrgNode newNode = new TreeOrgNode();
            SysUtil.copyProperties((Object)node, (Object)newNode);
            copyList.add(newNode);
        }
        List superBusinessList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperBusinessId()) && !"1".equals(o.getOrgNature())).collect(Collectors.toList());
        List superExecutiveList = copyList.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId()) && !"0".equals(o.getOrgNature())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> businessCollect = list.parallelStream().filter(vo -> vo.getSuperBusinessId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperBusinessId));
        Map<String, List<TreeOrgNode>> executiveCollect = copyList.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superBusinessList) {
            this.forEach(businessCollect, node, 1);
        }
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("business", superBusinessList);
        resultMap.put("executive", superExecutiveList);
        return resultMap;
    }

    @Override
    public List<TreeOrgNode> getExecutiveOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectExecutiveTree(TenantContext.getTenant());
        for (TreeOrgNode node : list) {
            node.setKey(node.getId());
            node.setValue(node.getId());
        }
        List<TreeOrgNode> superExecutiveList = list.stream().filter(o -> StringUtils.isBlank((CharSequence)o.getSuperExecutiveId())).collect(Collectors.toList());
        Map<String, List<TreeOrgNode>> executiveCollect = list.parallelStream().filter(vo -> vo.getSuperExecutiveId() != null).collect(Collectors.groupingBy(TreeOrgNode::getSuperExecutiveId));
        for (TreeOrgNode node : superExecutiveList) {
            this.forEach(executiveCollect, node, 1);
        }
        return superExecutiveList;
    }

    @Override
    public List<TreeOrgNode> getFactoryOrganization() {
        List<TreeOrgNode> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrganization(TenantContext.getTenant(), "factory");
        list.forEach(node -> {
            node.setKey(node.getId());
            node.setValue(node.getId());
        });
        return list;
    }

    @Override
    public void frozen(String id, String status) {
        PurchaseOrganizationInfo org = new PurchaseOrganizationInfo();
        org.setId(id);
        org.setStatus(status);
        if (PurchaseOrganizationStatus.NORMAL.getValue().equals(status)) {
            org.setEnableTime(new Date());
        } else if (PurchaseOrganizationStatus.FROZEN.getValue().equals(status)) {
            org.setFreezeTime(new Date());
        }
        int count = ((PurchaseOrganizationInfoMapper)this.baseMapper).updateById((Object)org);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    private void forEach(Map<String, List<TreeOrgNode>> collect, TreeOrgNode treeOrgNode, Integer level) {
        List<TreeOrgNode> treeOrgNodelist = collect.get(treeOrgNode.getValue());
        treeOrgNode.setLevel(level);
        if (collect.get(treeOrgNode.getValue()) != null) {
            treeOrgNode.setChildren(treeOrgNodelist);
            treeOrgNode.setHasChildren(true);
            Integer n = level;
            Integer n2 = level = Integer.valueOf(level + 1);
            Integer finalLevel = level;
            treeOrgNode.getChildren().forEach(t -> this.forEach(collect, (TreeOrgNode)t, finalLevel));
        }
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgBySubAccount(String subAccount) {
        String elsAccount = TenantContext.getTenant();
        ElsSubAccountDTO subUser = this.invokeAccountRpcService.getAccount(elsAccount, subAccount);
        List<PurchaseOrganizationInfo> orgList = new ArrayList<PurchaseOrganizationInfo>();
        if (subUser != null && StringUtils.isNotBlank((CharSequence)subUser.getOrgCode())) {
            List<String> userOrgCodeId = Arrays.asList(subUser.getOrgCode().split(","));
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)orgWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(BaseEntity::getId, userOrgCodeId)).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
            orgList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)orgWrapper);
        }
        return orgList;
    }

    @Override
    public Map<String, String> getOrganizationByCode(String elsAccount, String orgCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)orgCode);
        List deptOrg = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)deptOrg)) {
            return deptOrg.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, purchaseOrganizationInfo -> purchaseOrganizationInfo.getOrgName() == null ? "" : purchaseOrganizationInfo.getOrgName()));
        }
        return new HashMap<String, String>();
    }

    @Override
    public List<PurchaseOrganizationInfo> getOrgForCalendar(String elsAccount, String orgCategoryCode) {
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).selectOrgCalendar(elsAccount, orgCategoryCode);
    }

    @Override
    public List<TreeOrgNode> getOrgCascader() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseOrganizationInfo::getStatus, (Object)PurchaseOrganizationStatus.NORMAL.getValue());
        List orgList = this.list((Wrapper)queryWrapper);
        ArrayList<TreeOrgNode> orgTreeList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrganizationInfo org : orgList) {
            TreeOrgNode tree = new TreeOrgNode();
            tree.setKey(org.getId());
            tree.setTitle(org.getOrgName());
            tree.setValue(org.getOrgCode());
            tree.setOrgType(org.getOrgCategoryCode());
            orgTreeList.add(tree);
        }
        Map<String, List<TreeOrgNode>> orgMap = orgTreeList.stream().filter(vo -> StringUtils.isNotBlank((CharSequence)vo.getValue()) && StringUtils.isNotBlank((CharSequence)vo.getOrgType())).collect(Collectors.groupingBy(TreeOrgNode::getOrgType));
        ArrayList<TreeOrgNode> categoryList = new ArrayList<TreeOrgNode>();
        for (PurchaseOrgCategoryStatus orgCategoryStatus : PurchaseOrgCategoryStatus.values()) {
            if (!orgMap.containsKey(orgCategoryStatus.getValue())) continue;
            TreeOrgNode categoryTree = new TreeOrgNode();
            categoryTree.setValue(orgCategoryStatus.getValue());
            categoryTree.setTitle(orgCategoryStatus.getDesc());
            categoryTree.setChildren(orgMap.get(orgCategoryStatus.getValue()));
            categoryList.add(categoryTree);
        }
        return categoryList;
    }

    @Override
    public Map<String, String> listDeptOrganization(List<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getOrgCode, PurchaseOrganizationInfo::getOrgName});
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, ids);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().collect(Collectors.toMap(BaseEntity::getId, x -> x.getOrgCode() + "_" + x.getOrgName(), (v1, v2) -> v2));
    }

    private void deleteRedis(String table) {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append(table);
        this.redisUtil.deleteByPrex(redisKey.toString());
    }

    @Override
    public Map<String, String> getDeptOrganization(String elsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"dept");
        List deptOrg = this.list((Wrapper)queryWrapper);
        return deptOrg.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId));
    }

    @Override
    public Map<String, String> mapIdsByOrgCodeAndOrgCategoryCode(List<String> all) {
        if (CollUtil.isEmpty(all)) {
            return Maps.newHashMap();
        }
        List<PurchaseOrganizationInfoDTO> list = ((PurchaseOrganizationInfoMapper)this.baseMapper).listOrganizationInfoByTypeAndCode(all, TenantContext.getTenant());
        return list.stream().collect(Collectors.toMap(x -> x.getOrgCategoryCode() + "," + x.getOrgCode(), BaseDTO::getId, (v1, v2) -> v2));
    }

    @Override
    public Map<String, String> mapIdsByOrgCode(List<String> orgCodeList) {
        if (CollUtil.isEmpty(orgCodeList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseOrganizationInfo::getOrgCode, PurchaseOrganizationInfo::getOrgName, PurchaseOrganizationInfo::getOrgCategoryCode});
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(PurchaseOrganizationInfo::getOrgCode, orgCodeList);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().collect(Collectors.toMap(PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId, (v1, v2) -> v2));
    }

    @Override
    public int countOrgCode(List<String> codes, String elsAccount) {
        if (CollUtil.isEmpty(codes)) {
            return 0;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(PurchaseOrganizationInfo::getOrgCode, codes)).eq(BaseEntity::getElsAccount, (Object)elsAccount);
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkOrgCode(String orgCode) {
        List<String> orgCodeList = Arrays.asList(orgCode.split(","));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(BaseEntity::getId, orgCodeList);
        List organizationInfoList = ((PurchaseOrganizationInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return organizationInfoList.stream().anyMatch(a -> "companyCode".equals(a.getOrgCategoryCode()));
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        interfaceUtil.callInterface(elsAccount, "getDeptData", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseOrganizationInfoList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseOrganizationInfo organizationInfo : purchaseOrganizationInfoList) {
            this.pushDataToErp(organizationInfo);
        }
    }

    private void pushDataToErp(PurchaseOrganizationInfo organizationInfo) {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        interfaceUtil.callInterface(elsAccount, "pushOrgData", (Object)organizationInfo);
    }

    @Override
    public IPage<PurchaseOrgInfoVO> saleDeliveryList(Page<PurchaseOrgInfoVO> page, QueryWrapper<PurchaseOrgInfoVO> queryWrapper, String keyWord) {
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).saleDeliveryList(page, queryWrapper, keyWord);
    }

    @Override
    public IPage<PurchaseOrgInfoVO> saleDeliveryFactoryList(Page<PurchaseOrgInfoVO> page, QueryWrapper<PurchaseOrgInfoVO> queryWrapper, String keyWord) {
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).saleDeliveryFactoryList(page, queryWrapper, keyWord);
    }

    @Override
    public List<PurchaseOrgInfoVO> recordsFactoryList(List<String> factoryCode) {
        return ((PurchaseOrganizationInfoMapper)this.baseMapper).recordsFactoryList(factoryCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void pullCompanyAndPurchaseOrgAndPurchaseGroupFromSAP() {
        String dataForPurchaseGroup;
        JSONObject returnMapForPurchaseGroup;
        Map mapForPurchaseGroup;
        List tReturnListForPurchaseGroup;
        String dataForPurchaseOrg;
        JSONObject returnMapForPurchaseOrg;
        Map mapForPurchaseOrg;
        List tReturnListPurchaseOrg;
        Date currentTime = new Date();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("org");
        ReturnSRMBaseVO returnSRMBaseVOForCompany = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_Company_SAP.getValue(), "{\"IT_BUKRS\":{\"tableName\":\"IT_BUKRS\"}}");
        ReturnSRMBaseVO returnSRMBaseVOForPurchaseOrg = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_PurchaseOrg_SAP.getValue(), "{\"IT_EKORG\":{\"tableName\":\"IT_EKORG\"}}");
        ReturnSRMBaseVO returnSRMBaseVOForPurchaseGroup = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_PurchaseGroup_SAP.getValue(), "{\"ZSRM_EKGRP\":{\"tableName\":\"ZSRM_EKGRP\"}}");
        ArrayList<Object> entityInsertListTotal = new ArrayList<Object>();
        ArrayList entityUpdateListTotal = new ArrayList();
        String dataForCompany = returnSRMBaseVOForCompany.getData();
        JSONObject returnMapForCompany = JSON.parseObject((String)dataForCompany);
        Map mapForCompany = returnMapForCompany.getInnerMap();
        List tReturnListForCompany = JSONArray.parseArray((String)JSON.toJSONString(mapForCompany.get("IT_BUKRS")), PurchaseOrganizationInfo.class);
        if (!tReturnListForCompany.isEmpty()) {
            tReturnListForCompany.stream().forEach(o -> {
                o.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                o.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                o.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                o.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
                o.setTemplateAccount("100000");
                o.setElsAccount("2359110");
                o.setCreateTime(currentTime);
                o.setCreateBy("interfaceForSAP");
                o.setUpdateBy("interfaceForSAP");
                o.setUpdateTime(currentTime);
                o.setDeleted(CommonConstant.DEL_FLAG_0);
                o.setOrgCategoryCode("companyCode");
                o.setOrgNature("0");
                o.setStatus("1");
                o.setSourceSystem("SAP");
            });
            List stringList = tReturnListForCompany.stream().map(PurchaseOrganizationInfo::getBUKRS).collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"companyCode");
            wrapper.select(new SFunction[]{PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId});
            wrapper.in(PurchaseOrganizationInfo::getOrgCode, stringList);
            List companyInfoInfoList = this.list((Wrapper)wrapper);
            if (companyInfoInfoList.size() > 0) {
                List<Object> entityInsertList = new ArrayList();
                ArrayList<PurchaseOrganizationInfo> entityUpdateList = new ArrayList<PurchaseOrganizationInfo>();
                entityInsertList = tReturnListForCompany.stream().filter(item -> !companyInfoInfoList.stream().map(e -> e.getOrgCode()).collect(Collectors.toList()).contains(item.getBUKRS())).collect(Collectors.toList());
                for (PurchaseOrganizationInfo once : companyInfoInfoList) {
                    for (PurchaseOrganizationInfo onceall : tReturnListForCompany) {
                        if (!onceall.getBUKRS().equals(once.getOrgCode())) continue;
                        entityUpdateList.add(once.setOrgName(onceall.getBUTXT()));
                    }
                }
                if (entityInsertList.size() > 0) {
                    entityInsertListTotal.addAll(entityInsertList);
                }
                if (entityUpdateList.size() > 0) {
                    entityUpdateListTotal.addAll(entityUpdateList);
                }
            } else {
                entityInsertListTotal.addAll(tReturnListForCompany);
            }
        }
        if (!(tReturnListPurchaseOrg = JSONArray.parseArray((String)JSON.toJSONString((mapForPurchaseOrg = (returnMapForPurchaseOrg = JSON.parseObject((String)(dataForPurchaseOrg = returnSRMBaseVOForPurchaseOrg.getData()))).getInnerMap()).get("IT_EKORG")), PurchaseOrganizationInfo.class)).isEmpty()) {
            tReturnListPurchaseOrg.stream().forEach(o -> {
                o.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                o.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                o.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                o.setTemplateAccount("100000");
                o.setElsAccount("2359110");
                o.setCreateTime(currentTime);
                o.setCreateBy("interfaceForSAP");
                o.setUpdateBy("interfaceForSAP");
                o.setUpdateTime(currentTime);
                o.setDeleted(CommonConstant.DEL_FLAG_0);
                o.setOrgCategoryCode("purchaseOrganization");
                o.setOrgNature("0");
                o.setStatus("1");
                o.setSourceSystem("SAP");
            });
            List stringList = tReturnListPurchaseOrg.stream().map(PurchaseOrganizationInfo::getEKORG).collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"purchaseOrganization");
            wrapper.select(new SFunction[]{PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId});
            wrapper.in(PurchaseOrganizationInfo::getOrgCode, stringList);
            List organizationInfoList = this.list((Wrapper)wrapper);
            if (organizationInfoList.size() > 0) {
                List<Object> entityInsertList = new ArrayList();
                ArrayList<PurchaseOrganizationInfo> entityUpdateList = new ArrayList<PurchaseOrganizationInfo>();
                entityInsertList = tReturnListPurchaseOrg.stream().filter(item -> !organizationInfoList.stream().map(e -> e.getOrgCode()).collect(Collectors.toList()).contains(item.getEKORG())).collect(Collectors.toList());
                for (PurchaseOrganizationInfo once : organizationInfoList) {
                    for (PurchaseOrganizationInfo onceall : tReturnListPurchaseOrg) {
                        if (!onceall.getEKORG().equals(once.getOrgCode())) continue;
                        entityUpdateList.add(once.setOrgName(onceall.getEKOTX()));
                    }
                }
                if (entityInsertList.size() > 0) {
                    entityInsertListTotal.addAll(entityInsertList);
                }
                if (entityUpdateList.size() > 0) {
                    entityUpdateListTotal.addAll(entityUpdateList);
                }
            } else {
                entityInsertListTotal.addAll(tReturnListPurchaseOrg);
            }
        }
        if (!(tReturnListForPurchaseGroup = JSONArray.parseArray((String)JSON.toJSONString((mapForPurchaseGroup = (returnMapForPurchaseGroup = JSON.parseObject((String)(dataForPurchaseGroup = returnSRMBaseVOForPurchaseGroup.getData()))).getInnerMap()).get("ZSRM_EKGRP")), PurchaseOrganizationInfo.class)).isEmpty()) {
            tReturnListForPurchaseGroup.stream().forEach(o -> {
                o.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                o.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                o.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                o.setTemplateAccount("100000");
                o.setElsAccount("2359110");
                o.setCreateTime(currentTime);
                o.setCreateBy("interfaceForSAP");
                o.setUpdateBy("interfaceForSAP");
                o.setUpdateTime(currentTime);
                o.setDeleted(CommonConstant.DEL_FLAG_0);
                o.setOrgCategoryCode("purchaseGroup");
                o.setOrgNature("0");
                o.setStatus("1");
                o.setSourceSystem("SAP");
            });
            List stringList = tReturnListForPurchaseGroup.stream().map(PurchaseOrganizationInfo::getEKGRP).collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"purchaseGroup");
            wrapper.select(new SFunction[]{PurchaseOrganizationInfo::getOrgCode, BaseEntity::getId});
            wrapper.in(PurchaseOrganizationInfo::getOrgCode, stringList);
            List organizationGroupInfoList = this.list((Wrapper)wrapper);
            if (organizationGroupInfoList.size() > 0) {
                List<Object> entityInsertList = new ArrayList();
                ArrayList<PurchaseOrganizationInfo> entityUpdateList = new ArrayList<PurchaseOrganizationInfo>();
                entityInsertList = tReturnListForPurchaseGroup.stream().filter(item -> !organizationGroupInfoList.stream().map(e -> e.getOrgCode()).collect(Collectors.toList()).contains(item.getEKGRP())).collect(Collectors.toList());
                for (PurchaseOrganizationInfo once : organizationGroupInfoList) {
                    for (PurchaseOrganizationInfo onceall : tReturnListForPurchaseGroup) {
                        if (!onceall.getEKGRP().equals(once.getOrgCode())) continue;
                        entityUpdateList.add(once.setOrgName(onceall.getEKNAM()));
                    }
                }
                if (entityInsertList.size() > 0) {
                    entityInsertListTotal.addAll(entityInsertList);
                }
                if (entityUpdateList.size() > 0) {
                    entityUpdateListTotal.addAll(entityUpdateList);
                }
            } else {
                entityInsertListTotal.addAll(organizationGroupInfoList);
            }
        }
        if (entityInsertListTotal.size() > 0) {
            for (int i = 0; i < entityInsertListTotal.size(); ++i) {
                if (((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getOrgCategoryCode().equals("companyCode")) {
                    ((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).setOrgCode(((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getBUKRS());
                    ((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).setOrgName(((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getBUTXT());
                }
                if (((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getOrgCategoryCode().equals("purchaseOrganization")) {
                    ((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).setOrgCode(((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getEKORG());
                    ((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).setOrgName(((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getEKOTX());
                }
                if (!((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getOrgCategoryCode().equals("purchaseGroup")) continue;
                ((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).setOrgCode(((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getEKGRP());
                ((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).setOrgName(((PurchaseOrganizationInfo)((Object)entityInsertListTotal.get(i))).getEKNAM());
            }
            this.saveBatch(entityInsertListTotal.stream().distinct().collect(Collectors.toList()));
        }
        if (entityUpdateListTotal.size() > 0) {
            this.updateBatchById(entityUpdateListTotal);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void companyFactoryRelationsCreatedFromSAP() {
        Date currentTime = new Date();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("org");
        ReturnSRMBaseVO returnSRMBaseVOForCompanyFactoryRelations = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_CompanyFactoryRelations_SAP.getValue(), "{\"TAB_OUT\":{\"tableName\":\"TAB_OUT\"}}");
        String dataForCompanyFactoryRelations = returnSRMBaseVOForCompanyFactoryRelations.getData();
        JSONObject returnMapForCompanyFactoryRelations = JSON.parseObject((String)dataForCompanyFactoryRelations);
        Map mapForCompanyFactoryRelations = returnMapForCompanyFactoryRelations.getInnerMap();
        List tReturnListForCompanyFactoryRelations = JSONArray.parseArray((String)JSON.toJSONString(mapForCompanyFactoryRelations.get("TAB_OUT")), PurchaseOrganizationInfo.class);
        if (!tReturnListForCompanyFactoryRelations.isEmpty()) {
            tReturnListForCompanyFactoryRelations.stream().forEach(o -> {
                o.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                o.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                o.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                o.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
                o.setElsAccount("2359110");
                o.setCreateTime(currentTime);
                o.setCreateBy("interfaceForSAP");
                o.setUpdateBy("interfaceForSAP");
                o.setUpdateTime(currentTime);
                o.setDeleted(CommonConstant.DEL_FLAG_0);
                o.setOrgCategoryCode("factory");
                o.setOrgNature("0");
                o.setStatus("1");
                o.setSourceSystem("SAP");
            });
            ArrayList<PurchaseOrganizationInfo> entityInsertList = new ArrayList<PurchaseOrganizationInfo>();
            ArrayList<PurchaseOrganizationInfo> entityUpdateList = new ArrayList<PurchaseOrganizationInfo>();
            for (PurchaseOrganizationInfo once : tReturnListForCompanyFactoryRelations) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"companyCode");
                wrapper.eq(PurchaseOrganizationInfo::getOrgCode, (Object)once.getBUKRS());
                PurchaseOrganizationInfo companyInfoInfoList = (PurchaseOrganizationInfo)((Object)this.getOne((Wrapper)wrapper));
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"factory");
                wrapper2.eq(PurchaseOrganizationInfo::getOrgCode, (Object)once.getWERKS());
                PurchaseOrganizationInfo factoryInfoList = (PurchaseOrganizationInfo)((Object)this.getOne((Wrapper)wrapper2));
                if (companyInfoInfoList == null) continue;
                if (factoryInfoList != null) {
                    factoryInfoList.setSuperBusinessId(companyInfoInfoList.getId());
                    factoryInfoList.setOrgName(once.getNAME1());
                    factoryInfoList.setUpdateTime(new Date());
                    entityUpdateList.add(factoryInfoList);
                    continue;
                }
                once.setSuperBusinessId(companyInfoInfoList.getId());
                once.setOrgCode(once.getWERKS());
                once.setOrgName(once.getNAME1());
                entityInsertList.add(once);
            }
            if (entityInsertList.size() > 0) {
                this.saveBatch(entityInsertList.stream().distinct().collect(Collectors.toList()));
            }
            if (entityUpdateList.size() > 0) {
                this.updateBatchById(entityUpdateList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void storageLocationFactoryRelationsCreatedFromSAP() {
        Date currentTime = new Date();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("org");
        ReturnSRMBaseVO returnSRMBaseVOForStorageLocationFactoryRelations = this.callSAPOrderInterFace(SrmInterfaceCodeEnum.PULL_StorageLocationFactoryRelations_SAP.getValue(), "{\"ZSRM_LGORT\":{\"tableName\":\"ZSRM_LGORT\"}}");
        String dataForStorageLocationFactoryRelations = returnSRMBaseVOForStorageLocationFactoryRelations.getData();
        JSONObject returnMapStorageLocationFactoryRelations = JSON.parseObject((String)dataForStorageLocationFactoryRelations);
        Map mapForStorageLocationFactoryRelations = returnMapStorageLocationFactoryRelations.getInnerMap();
        List tReturnListForStorageLocationFactoryRelations = JSONArray.parseArray((String)JSON.toJSONString(mapForStorageLocationFactoryRelations.get("ZSRM_LGORT")), PurchaseOrganizationInfo.class);
        if (!tReturnListForStorageLocationFactoryRelations.isEmpty()) {
            tReturnListForStorageLocationFactoryRelations.stream().forEach(o -> {
                o.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                o.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                o.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                o.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
                o.setElsAccount("2359110");
                o.setCreateTime(currentTime);
                o.setCreateBy("interfaceForSAP");
                o.setUpdateBy("interfaceForSAP");
                o.setUpdateTime(currentTime);
                o.setDeleted(CommonConstant.DEL_FLAG_0);
                o.setOrgCategoryCode("location");
                o.setOrgNature("0");
                o.setStatus("1");
                o.setSourceSystem("SAP");
            });
            ArrayList<PurchaseOrganizationInfo> entityInsertList = new ArrayList<PurchaseOrganizationInfo>();
            ArrayList<PurchaseOrganizationInfo> entityUpdateList = new ArrayList<PurchaseOrganizationInfo>();
            for (PurchaseOrganizationInfo once : tReturnListForStorageLocationFactoryRelations) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"factory");
                wrapper.eq(PurchaseOrganizationInfo::getOrgCode, (Object)once.getWERKS());
                PurchaseOrganizationInfo factoryInfoInfoList = (PurchaseOrganizationInfo)((Object)this.getOne((Wrapper)wrapper));
                if (factoryInfoInfoList == null) continue;
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                wrapper2.eq(PurchaseOrganizationInfo::getOrgCategoryCode, (Object)"location");
                wrapper2.eq(PurchaseOrganizationInfo::getSuperBusinessId, (Object)factoryInfoInfoList.getId());
                wrapper2.eq(PurchaseOrganizationInfo::getOrgCode, (Object)once.getLGORT());
                PurchaseOrganizationInfo locationInfoList = (PurchaseOrganizationInfo)((Object)this.getOne((Wrapper)wrapper2));
                if (locationInfoList != null) {
                    locationInfoList.setSuperBusinessId(factoryInfoInfoList.getId());
                    locationInfoList.setOrgName(once.getLGOBE());
                    locationInfoList.setUpdateTime(new Date());
                    entityUpdateList.add(locationInfoList);
                    continue;
                }
                once.setSuperBusinessId(factoryInfoInfoList.getId());
                once.setOrgCode(once.getLGORT());
                once.setOrgName(once.getLGOBE());
                entityInsertList.add(once);
            }
            if (entityInsertList.size() > 0) {
                this.saveBatch(entityInsertList.stream().distinct().collect(Collectors.toList()));
            }
            if (entityUpdateList.size() > 0) {
                this.updateBatchById(entityUpdateList);
            }
        }
    }

    private ReturnSRMBaseVO callSAPOrderInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }
}

