/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.org.vo.PurchaseOrgInfoVO;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.api.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.service.SupplierMasterDataService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseInformationRecordsExcelHandler")
public class PurchaseInformationRecordsExcelHandler
implements ExcelImportRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;
    @Resource
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Resource
    private SupplierMasterDataService supplierMasterDataService;

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        List headList;
        Map collect;
        List taxCode;
        List<String> supplierCode;
        Object head;
        Map collect2;
        List headList2;
        List code;
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        com.els.common.util.Assert.isNotNull((Object)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u4ef7\u683c\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f\u3002");
        ArrayList<PurchaseInformationRecords> entityList = new ArrayList<PurchaseInformationRecords>();
        Boolean result = new Boolean(true);
        StringBuffer strError = new StringBuffer();
        for (int i = 0; i < dataList.size(); ++i) {
            int item = i + 3;
            StringBuffer strErrorRecords = new StringBuffer();
            PurchaseInformationRecords entity = (PurchaseInformationRecords)((Object)JSON.parseObject((String)JSON.toJSONString(dataList.get(i)), PurchaseInformationRecords.class));
            this.handleMain(entity, templateList);
            result = this.checkExpiryDate(entity, item, result, strErrorRecords);
            result = this.checkSupplier(entity, item, result, strErrorRecords);
            result = this.checkTaxCode(entity, item, result, strErrorRecords);
            result = this.checkDropDown(entity, item, result, strErrorRecords);
            result = this.checkDeliveryDays(entity, item, result, strErrorRecords);
            QueryWrapper materialHeadWrapper = new QueryWrapper();
            materialHeadWrapper.eq((Object)"material_number", (Object)entity.getMaterialNumber());
            PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadService.getOne((Wrapper)materialHeadWrapper));
            if (null != purchaseMaterialHead && !StringUtils.isBlank((CharSequence)purchaseMaterialHead.getFreeze()) && purchaseMaterialHead.getFreeze().equals("1")) {
                result = false;
                if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                    strErrorRecords.append(",\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                } else {
                    strErrorRecords.append("\u7b2c" + item + "\u884c,\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                }
            }
            entity.setFbk19(purchaseMaterialHead.getBaseUnit());
            if (entity.getFbk1().equals("1")) {
                if (StringUtils.isEmpty((CharSequence)entity.getFbk2())) {
                    result = false;
                    if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                        strErrorRecords.append(",\u4ef7\u683c\u8986\u76d6\u8303\u56f4\u4e3a\u57fa\u5730\u7ef4\u5ea6\u65f6\uff0c\u57fa\u5730\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    } else {
                        strErrorRecords.append("\u7b2c" + item + "\u884c,\u4ef7\u683c\u8986\u76d6\u8303\u56f4\u4e3a\u57fa\u5730\u7ef4\u5ea6\u65f6\uff0c\u57fa\u5730\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                }
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"fbk3", (Object)entity.getFbk2());
                List factories = this.purchaseOrganizationInfoService.list((Wrapper)wrapper);
                if (factories.isEmpty()) {
                    result = false;
                    if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                        strErrorRecords.append(",\u5f53\u524d\u57fa\u5730\u6ca1\u6709\u5339\u914d\u5230\u5173\u8054\u7684\u5de5\u5382\uff01");
                    } else {
                        strErrorRecords.append("\u7b2c" + item + "\u884c,\u5f53\u524d\u57fa\u5730\u6ca1\u6709\u5339\u914d\u5230\u5173\u8054\u7684\u5de5\u5382\uff01");
                    }
                }
                for (PurchaseOrganizationInfo once : factories) {
                    PurchaseInformationRecords on = new PurchaseInformationRecords();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)on));
                    on.setInfoRecordNumber(this.invokeBaseRpcService.getNextCode("srmPriceNumber", (Object)entity));
                    on.setFactory(once.getOrgCode());
                    on.setSourceType(PriceSourceTypeEnum.SRM.getValue());
                    if (StrUtil.isEmpty((CharSequence)entity.getAuditStatus())) {
                        on.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                    }
                    on.setRecordStatus(PriceStatusEnum.NEW.getValue());
                    on.setQuoteDate(entity.getQuoteDate() == null ? new Date() : entity.getQuoteDate());
                    String fbk20 = entity.getFbk20();
                    if (StringUtils.isNotBlank((CharSequence)fbk20) && fbk20.equals("0")) {
                        entity.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                        entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                        entity.setReturnState("0");
                    }
                    if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(entity.getAuditStatus())) {
                        this.purchaseInformationRecordsService.cutOffPriceDate(on, false);
                        on.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    }
                    QueryWrapper materialWrapper = new QueryWrapper();
                    materialWrapper.eq((Object)"material_number", (Object)entity.getMaterialNumber());
                    materialWrapper.eq((Object)"factory", (Object)once.getOrgCode());
                    PurchaseMaterialItem one = (PurchaseMaterialItem)((Object)this.purchaseMaterialItemService.getOne((Wrapper)materialWrapper));
                    if (one == null) continue;
                    if (!StringUtils.isBlank((CharSequence)one.getFbk1()) && one.getFbk1().equals("1")) {
                        result = false;
                        if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                            strErrorRecords.append(",\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                        } else {
                            strErrorRecords.append("\u7b2c" + item + "\u884c,\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5728\u5de5\u5382" + once.getOrgCode() + "\u4e0b\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                        }
                    } else {
                        on.setMaterialDesc(one.getMaterialDesc());
                    }
                    String purchaseUnit = on.getPurchaseUnit();
                    String fbk19 = on.getFbk19();
                    if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && purchaseUnit.equals(fbk19)) {
                        on.setFbk17("1");
                        on.setFbk18("1");
                    } else if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && !purchaseUnit.equals(fbk19)) {
                        String orderUnit = one.getOrderUnit();
                        if (StringUtils.isNotBlank((CharSequence)orderUnit) && StringUtils.isNotBlank((CharSequence)purchaseUnit) && orderUnit.equals(purchaseUnit)) {
                            if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk7()) && !purchaseMaterialHead.getFbk7().equals("0")) {
                                on.setFbk17(purchaseMaterialHead.getFbk7());
                            } else {
                                on.setFbk17("1");
                            }
                            if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk6()) && !purchaseMaterialHead.getFbk6().equals("0")) {
                                on.setFbk18(purchaseMaterialHead.getFbk6());
                            } else {
                                on.setFbk18("1");
                            }
                        } else {
                            result = false;
                            if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                                strErrorRecords.append(",\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                            } else {
                                strErrorRecords.append("\u7b2c" + item + "\u884c,\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5728\u5de5\u5382" + once.getOrgCode() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                            }
                        }
                    }
                    entityList.add(on);
                }
            } else if (entity.getFbk1().equals("3")) {
                if (StringUtils.isEmpty((CharSequence)entity.getFactory())) {
                    result = false;
                    if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                        strErrorRecords.append(",\u4ef7\u683c\u8986\u76d6\u8303\u56f4\u4e3a\u5de5\u5382\u7ef4\u5ea6\u65f6\uff0c\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    } else {
                        strErrorRecords.append("\u7b2c" + item + "\u884c,\u4ef7\u683c\u8986\u76d6\u8303\u56f4\u4e3a\u5de5\u5382\u7ef4\u5ea6\u65f6\uff0c\u5de5\u5382\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                }
                QueryWrapper materialWrapper = new QueryWrapper();
                materialWrapper.eq((Object)"material_number", (Object)entity.getMaterialNumber());
                materialWrapper.eq((Object)"factory", (Object)entity.getFactory());
                PurchaseMaterialItem one = (PurchaseMaterialItem)((Object)this.purchaseMaterialItemService.getOne((Wrapper)materialWrapper));
                if (null == one) {
                    result = false;
                    if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                        strErrorRecords.append(",SRM\u7269\u6599\u4e3b\u6570\u636e\u5f53\u524d\u57fa\u5730\u4e2d\u6240\u6709\u5de5\u5382\u4e0b\u65e0\u8be5\u7269\u6599");
                    } else {
                        strErrorRecords.append("\u7b2c" + item + "\u884c,SRM\u7269\u6599\u4e3b\u6570\u636e\u5f53\u524d\u57fa\u5730\u4e2d\u6240\u6709\u5de5\u5382\u4e0b\u65e0\u8be5\u7269\u6599");
                    }
                } else if (!StringUtils.isBlank((CharSequence)one.getFbk1()) && one.getFbk1().equals("1")) {
                    result = false;
                    if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                        strErrorRecords.append(",\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                    } else {
                        strErrorRecords.append("\u7b2c" + item + "\u884c,\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5728\u5de5\u5382" + entity.getFactory() + "\u4e0b\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                    }
                }
                String purchaseUnit = entity.getPurchaseUnit();
                String fbk19 = entity.getFbk19();
                if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && purchaseUnit.equals(fbk19)) {
                    entity.setFbk17("1");
                    entity.setFbk18("1");
                } else if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && !purchaseUnit.equals(fbk19)) {
                    String orderUnit = one.getOrderUnit();
                    if (StringUtils.isNotBlank((CharSequence)orderUnit) && StringUtils.isNotBlank((CharSequence)purchaseUnit) && orderUnit.equals(purchaseUnit)) {
                        if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk7()) && !purchaseMaterialHead.getFbk7().equals("0")) {
                            entity.setFbk17(purchaseMaterialHead.getFbk7());
                        } else {
                            entity.setFbk17("1");
                        }
                        if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk6()) && !purchaseMaterialHead.getFbk6().equals("0")) {
                            entity.setFbk18(purchaseMaterialHead.getFbk6());
                        } else {
                            entity.setFbk18("1");
                        }
                    } else {
                        result = false;
                        if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                            strErrorRecords.append(",\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                        } else {
                            strErrorRecords.append("\u7b2c" + item + "\u884c,\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5728\u5de5\u5382" + entity.getFactory() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                        }
                    }
                }
                String fbk20 = entity.getFbk20();
                if (StringUtils.isNotBlank((CharSequence)fbk20) && fbk20.equals("0")) {
                    entity.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                    entity.setReturnState("0");
                }
                entityList.add(entity);
            } else if (entity.getFbk1().equals("4")) {
                String fbk20;
                String fbk13 = entity.getFbk13();
                if (StringUtils.isNotBlank((CharSequence)fbk13) && (fbk13.equals("2") || fbk13.equals("2")) && entity.getFbk1().equals("4")) {
                    result = false;
                    if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                        strErrorRecords.append(",\u975e\u7edf\u91c7\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u7ef4\u5ea6\uff0c\u7ef4\u62a4\u4ef7\u683c");
                    } else {
                        strErrorRecords.append("\u7b2c" + item + "\u884c,\u975e\u7edf\u91c7\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u7ef4\u5ea6\uff0c\u7ef4\u62a4\u4ef7\u683c");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(fbk20 = entity.getFbk20())) && fbk20.equals("0")) {
                    entity.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                    entity.setReturnState("0");
                }
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"material_number", (Object)purchaseMaterialHead.getMaterialNumber());
                List<PurchaseMaterialItem> itemList = this.purchaseMaterialItemService.selectByMaterialNumber((QueryWrapper<PurchaseMaterialItem>)queryWrapper);
                String purchaseUnit = entity.getPurchaseUnit();
                String fbk19 = entity.getFbk19();
                if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && purchaseUnit.equals(fbk19)) {
                    entity.setFbk17("1");
                    entity.setFbk18("1");
                } else if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && !purchaseUnit.equals(fbk19)) {
                    if (CollectionUtils.isNotEmpty(itemList)) {
                        Boolean resultItem = true;
                        for (PurchaseMaterialItem purchaseMaterialItem : itemList) {
                            String orderUnit = purchaseMaterialItem.getOrderUnit();
                            if (StringUtils.isNotBlank((CharSequence)orderUnit) && StringUtils.isNotBlank((CharSequence)purchaseUnit) && orderUnit.equals(purchaseUnit)) continue;
                            result = false;
                            resultItem = false;
                            if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                                strErrorRecords.append(",\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                                continue;
                            }
                            strErrorRecords.append("\u7b2c" + item + "\u884c,\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u5728\u5de5\u5382" + entity.getFactory() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                        }
                        if (resultItem.booleanValue()) {
                            if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk7()) && !purchaseMaterialHead.getFbk7().equals("0")) {
                                entity.setFbk17(purchaseMaterialHead.getFbk7());
                            } else {
                                entity.setFbk17("1");
                            }
                            if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk6()) && !purchaseMaterialHead.getFbk6().equals("0")) {
                                entity.setFbk18(purchaseMaterialHead.getFbk6());
                            } else {
                                entity.setFbk18("1");
                            }
                        }
                    } else {
                        result = false;
                        if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                            strErrorRecords.append(",\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u672a\u7ef4\u62a4\u7269\u6599\u660e\u7ec6");
                        } else {
                            strErrorRecords.append("\u7b2c" + item + "\u884c,\u8be5\u7269\u6599" + entity.getMaterialNumber() + "\u672a\u7ef4\u62a4\u7269\u6599\u660e\u7ec6");
                        }
                    }
                }
                entityList.add(entity);
            }
            if (!StringUtils.isNotBlank((CharSequence)strErrorRecords)) continue;
            if (StringUtils.isNotBlank((CharSequence)strError)) {
                strError.append(";");
            }
            strError.append(strErrorRecords);
        }
        if (!result.booleanValue()) {
            throw new ELSBootException("\u5bfc\u5165\u62a5\u9519\uff0c\u62a5\u9519\u4fe1\u606f\u5982\u4e0b\uff1a" + strError.toString());
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPriceNumber", entityList.get(0), size);
        Assert.notEmpty((Collection)nextCodes, (String)"\u5bfc\u5165\u7269\u6599\u4e3b\u6570\u636e\u7f16\u7801\u751f\u6210\u5f02\u5e38");
        int codeIndex = 0;
        for (PurchaseInformationRecords e : entityList) {
            e.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
        }
        List<String> factoryList = entityList.stream().map(PurchaseInformationRecords::getFactory).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(factoryList)) {
            List<PurchaseOrgInfoVO> list = this.purchaseOrganizationInfoService.recordsFactoryList(factoryList);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                PurchaseOrgInfoVO purchaseOrgInfoVO = list.get(i);
                map.put(purchaseOrgInfoVO.getOrgCode(), purchaseOrgInfoVO.getParentOrgCode());
            }
            Iterator i = entityList.iterator();
            while (i.hasNext()) {
                PurchaseInformationRecords r;
                r.setCompany(null != map.get((r = (PurchaseInformationRecords)((Object)i.next())).getFactory()) ? map.get(r.getFactory()).toString() : "");
            }
        }
        if (CollUtil.isNotEmpty(code = entityList.stream().map(PurchaseInformationRecords::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList()))) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialHead::getMaterialNumber, PurchaseMaterialHead::getMaterialName, PurchaseMaterialHead::getMaterialDesc, PurchaseMaterialHead::getMaterialGroup, PurchaseMaterialHead::getBaseUnit});
            wrapper.in(PurchaseMaterialHead::getMaterialNumber, code);
            headList2 = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
            collect2 = headList2.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v1));
            if (CollUtil.isNotEmpty(collect2)) {
                for (PurchaseInformationRecords r : entityList) {
                    head = (PurchaseMaterialHead)((Object)collect2.get(r.getMaterialNumber()));
                    if (null == head) continue;
                    r.setMaterialName(head.getMaterialName());
                    r.setMaterialDesc(head.getMaterialDesc());
                    r.setMaterialGroup(head.getMaterialGroup());
                }
            }
        }
        if (CollUtil.isNotEmpty(supplierCode = entityList.stream().map(PurchaseInformationRecords::getSupplierCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList())) && CollUtil.isNotEmpty(collect2 = (headList2 = this.priceInvokeSupplierRpcService.getSupplierMasterDataBySupplierCode(supplierCode)).stream().collect(Collectors.toMap(SupplierMasterDataDTO::getSupplierCode, Function.identity(), (v1, v2) -> v1)))) {
            for (PurchaseInformationRecords r : entityList) {
                head = (SupplierMasterDataDTO)collect2.get(r.getSupplierCode());
                if (null == head) continue;
                r.setSupplierCode(head.getSupplierCode());
                r.setSupplierName(head.getSupplierName());
                r.setToElsAccount(head.getToElsAccount());
            }
        }
        if (CollUtil.isNotEmpty(taxCode = entityList.stream().map(PurchaseInformationRecords::getTaxCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList())) && CollUtil.isNotEmpty(collect = (headList = this.invokeBaseRpcService.getElsTaxByCode(taxCode)).stream().collect(Collectors.toMap(ElsTaxDTO::getTaxCode, Function.identity(), (v1, v2) -> v1)))) {
            for (PurchaseInformationRecords r : entityList) {
                ElsTaxDTO head2 = (ElsTaxDTO)collect.get(r.getTaxCode());
                if (null != head2) {
                    r.setTaxCode(head2.getTaxCode());
                    r.setTaxRate(head2.getTaxRate().toString());
                    continue;
                }
                r.setTaxCode(null);
                r.setTaxRate(null);
            }
        }
        for (PurchaseInformationRecords entity : entityList) {
            this.purchaseInformationRecordsService.calculatePrice(entity);
        }
        this.purchaseInformationRecordsService.addBatch(entityList);
        return dataList;
    }

    Boolean checkDropDown(PurchaseInformationRecords entity, int item, Boolean result, StringBuffer strErrorRecords) {
        StringBuffer str = new StringBuffer();
        if (entity.getPurchaseGroup().equals("null")) {
            str.append("\u91c7\u8d2d\u7ec4\u7f16\u7801");
        }
        if (entity.getPurchaseOrg().equals("null")) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                str.append("\u3001\u91c7\u8d2d\u7ec4\u7ec7\u7f16\u7801");
            } else {
                str.append("\u91c7\u8d2d\u7ec4\u7ec7\u7f16\u7801");
            }
        }
        if (entity.getPurchaseUnit().equals("null")) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                str.append("\u3001\u91c7\u8d2d\u5355\u4f4d");
            } else {
                str.append("\u91c7\u8d2d\u5355\u4f4d");
            }
        }
        if (entity.getPriceUnit().equals("null")) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                str.append("\u3001SAP\u4ef7\u683c\u5355\u4f4d");
            } else {
                str.append("SAP\u4ef7\u683c\u5355\u4f4d");
            }
        }
        if (entity.getFbk1().equals("null")) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                str.append("\u3001\u4ef7\u683c\u8986\u76d6\u8303\u56f4");
            } else {
                str.append("\u4ef7\u683c\u8986\u76d6\u8303\u56f4");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getPayTermsCode()) && entity.getPayTermsCode().equals("null")) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                str.append("\u3001\u4ed8\u6b3e\u6761\u4ef6");
            } else {
                str.append("\u4ed8\u6b3e\u6761\u4ef6");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getFactory()) && entity.getFactory().equals("null")) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                str.append("\u3001\u5de5\u5382");
            } else {
                str.append("\u5de5\u5382");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getFbk2()) && entity.getFbk2().equals("null")) {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                str.append("\u3001\u57fa\u5730");
            } else {
                str.append("\u57fa\u5730");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                strErrorRecords.append("," + str + "\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u4e0b\u62c9\u9009\u62e9\u6b63\u786e\u503c");
            } else {
                strErrorRecords.append("\u7b2c" + item + "\u884c," + str + "\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u4e0b\u62c9\u9009\u62e9\u6b63\u786e\u503c");
            }
            return false;
        }
        return result;
    }

    Boolean checkDeliveryDays(PurchaseInformationRecords entity, int item, Boolean result, StringBuffer strErrorRecords) {
        Integer deliveryDays = entity.getDeliveryDays();
        if (deliveryDays.compareTo(0) <= 0 || deliveryDays.compareTo(999) != 0 && deliveryDays.compareTo(999) >= 0) {
            if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                strErrorRecords.append(",0<\u8ba1\u5212\u4ea4\u8d27\u5929\u6570<=999");
            } else {
                strErrorRecords.append("\u7b2c" + item + "\u884c,0<\u8ba1\u5212\u4ea4\u8d27\u5929\u6570<=999");
            }
            return false;
        }
        return result;
    }

    Boolean checkTaxCode(PurchaseInformationRecords entity, int item, Boolean result, StringBuffer strErrorRecords) {
        ArrayList<String> taxCode = new ArrayList<String>();
        taxCode.add(entity.getTaxCode());
        List headTaxList = this.invokeBaseRpcService.getElsTaxByCode(taxCode);
        if (CollectionUtils.isEmpty((Collection)headTaxList)) {
            if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                strErrorRecords.append(",\u7a0e\u7801\u5728SRM\u4e2d\u4e0d\u5b58\u5728");
            } else {
                strErrorRecords.append("\u7b2c" + item + "\u884c,\u7a0e\u7801\u5728SRM\u4e2d\u4e0d\u5b58\u5728");
            }
            return false;
        }
        return result;
    }

    Boolean checkSupplier(PurchaseInformationRecords entity, int item, Boolean result, StringBuffer strErrorRecords) {
        ArrayList<String> supplierCode = new ArrayList<String>();
        supplierCode.add(entity.getSupplierCode());
        List<SupplierMasterDataDTO> headList = this.priceInvokeSupplierRpcService.getSupplierMasterDataBySupplierCode(supplierCode);
        if (CollectionUtils.isEmpty(headList)) {
            if (StringUtils.isNotBlank((CharSequence)strErrorRecords)) {
                strErrorRecords.append(",\u4f9b\u5e94\u5546\u5728SRM\u4e2d\u4e0d\u5b58\u5728/\u975e\u6f5c\u5728/\u975e\u5408\u683c");
            } else {
                strErrorRecords.append("\u7b2c" + item + "\u884c,\u4f9b\u5e94\u5546\u5728SRM\u4e2d\u4e0d\u5b58\u5728/\u975e\u6f5c\u5728/\u975e\u5408\u683c");
            }
            return false;
        }
        return result;
    }

    Boolean checkExpiryDate(PurchaseInformationRecords entity, int item, Boolean result, StringBuffer strErrorRecords) {
        if (null != entity.getExpiryDate() && null != entity.getEffectiveDate() && entity.getExpiryDate().before(entity.getEffectiveDate())) {
            strErrorRecords.append("\u7b2c" + item + "\u884c\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f");
            return false;
        }
        return result;
    }

    void handleMain(PurchaseInformationRecords entity, List<TemplateHeadDTO> templateList) {
        entity.setTemplateNumber(templateList.get(0).getTemplateNumber());
        entity.setTemplateName(templateList.get(0).getTemplateName());
        entity.setTemplateVersion(templateList.get(0).getTemplateVersion());
        entity.setTemplateAccount(templateList.get(0).getElsAccount());
        entity.setElsAccount(TenantContext.getTenant());
        entity.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        entity.setTaxRate(null);
        entity.setCurrencyCode("CNY");
        entity.setRecordType(PriceRecordTypeEnum.STANDARD.getValue());
        entity.setPriceType(PurchaseInformationPriceTypeEnum.MATERIAL.getValue());
    }
}

