/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.job;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.RedisUtil;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="informationRecordsSendSAPJob")
public class InformationRecordsSendSAPJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(InformationRecordsSendSAPJob.class);
    private final String LOCK_PREFIX = "informationRecords_schedule_informationRecords";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;

    public void execute(String parameter) {
        block6: {
            String requestId = UUID.fastUUID().toString();
            String elsAccount = JSONObject.parseObject((String)parameter).getString("elsAccount");
            try {
                if (this.redisUtil.tryGetDistributedLock("informationRecords_schedule_informationRecords", requestId, 50000L)) {
                    log.info(":::\u5b9a\u65f6\u4efb\u52a1\u6279\u91cf\u63a8\u9001\u4ef7\u683c\u4e3b\u6570\u636e start");
                    this.purchaseInformationRecordsService.sendSAPJob(elsAccount);
                    log.info(":::\u5b9a\u65f6\u4efb\u52a1\u6279\u91cf\u63a8\u9001\u4ef7\u683c\u4e3b\u6570\u636e end");
                    break block6;
                }
                throw new ELSBootException("\u5b9a\u65f6\u4efb\u52a1\u6279\u91cf\u63a8\u9001\u4ef7\u683c\u4e3b\u6570\u636e\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c");
            }
            catch (Exception e) {
                log.info(Thread.currentThread().getName() + "\u5b9a\u65f6\u4efb\u52a1\u6279\u91cf\u63a8\u9001\u4ef7\u683c\u4e3b\u6570\u636e\u5904\u7406\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
            finally {
                this.redisUtil.releaseDistributedLock("informationRecords_schedule_informationRecords", requestId);
            }
        }
    }

    @Scheduled(cron="0 20 0 ? * *")
    public void doScheduled() {
        this.execute(null);
    }
}

