/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.job;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.service.JobRpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.enumerate.MaterialSourceTypeEnum;
import com.els.modules.material.mapper.PurchaseMaterialSourceMapper;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.order.api.service.QuartzJobRpcService;
import com.els.modules.price.enumerate.MaterialCreateSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.mapper.PurchaseInformationRecordsMapper;
import com.els.modules.price.vo.PurchaseInformationRecordsSAPVO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.service.ElsTaxService;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pullPriceJob")
public class PullPriceJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(PullPriceJob.class);
    private static final Logger logger = LoggerFactory.getLogger(PullPriceJob.class);
    @Resource
    private PurchaseInformationRecordsMapper purchaseInformationRecordsMapper;
    @Resource
    private PurchaseMaterialSourceMapper purchaseMaterialSourceMapper;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Autowired
    private ElsTaxService elsTaxService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Resource
    private TemplateHeadService templateHeadService;
    @Resource
    private QuartzJobRpcService quartzJobRpcService;

    public void execute(String parameter) {
        logger.info("sys price  start ----------------");
        Date lastExecutionTime = this.quartzJobRpcService.findByJobNameKey("pullPriceJob");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdft = new SimpleDateFormat("HH:mm:ss");
        ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_PRICE_SAP.getValue(), this.toJson(lastExecutionTime, sdf, sdft));
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        String e_type = returnMap.getString("E_TYPE");
        if ("E".equals(e_type)) {
            logger.error("\u5b9a\u65f6\u4efb\u52a1\u4ef7\u683c\u4e3b\u6570\u636e\u540c\u6b65\u5931\u8d25:{}", (Object)returnMap.getString("E_MESSAGE"));
            throw new ELSBootException("\u5b9a\u65f6\u4efb\u52a1\u4ef7\u683c\u4e3b\u6570\u636e" + returnMap.getString("E_MESSAGE"));
        }
        String elsAccount = JSONObject.parseObject((String)parameter).getString("elsAccount");
        TemplateHead templateHead = this.getTemplateHead(elsAccount);
        String et_eina = returnMap.getString("ET_EINA");
        List list = JSONArray.parseArray((String)et_eina, PurchaseInformationRecordsSAPVO.class);
        Set<String> InfoNumberSet = list.stream().map(PurchaseInformationRecordsSAPVO::getSourceNumber).collect(Collectors.toSet());
        this.purchaseInformationRecordsMapper.deleteByInfoNumber(InfoNumberSet);
        ArrayList informationRecordsSAPVOList = new ArrayList();
        list.forEach(var -> {
            var.setInfoRecordNumber(this.codeGeneratorService.getNextCode("srmPriceNumber", (Object)""));
            var.setSourceType("SAP");
            if (var.getDeleted().equals("X")) {
                var.setDeleted("1");
            } else {
                var.setDeleted("0");
            }
            var.setSupplierCode(var.getSupplierCode().replaceAll("^0*", ""));
            log.info("\u5f53\u524d\u7269\u6599\u7f16\u7801var.getMaterialNumber()\uff1a" + var.getMaterialNumber());
            var.setMaterialNumber(var.getMaterialNumber().replaceAll("^0*", ""));
            var.setFactory(var.getFactory() + "_" + var.getFbk30());
            var.setId(IdWorker.getIdStr());
            var.setElsAccount(elsAccount);
            var.setCreateBy("interface");
            var.setUpdateBy("interface");
            var.setCreateTime(new Date());
            var.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            var.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
            var.setUpdateTime(new Date());
            var.setTemplateAccount(templateHead.getElsAccount());
            var.setTemplateNumber(templateHead.getTemplateNumber());
            var.setTemplateVersion(templateHead.getTemplateVersion());
            var.setTemplateName(templateHead.getTemplateName());
            var.setFactory(var.getFactory().split("_")[0]);
            if (StringUtils.isNotBlank((CharSequence)var.getPriceUnit()) && ("1".equals(var.getPriceUnit()) || "10".equals(var.getPriceUnit()) || "100".equals(var.getPriceUnit()) || "1000".equals(var.getPriceUnit()) || "10000".equals(var.getPriceUnit()))) {
                var.setPrice(var.getPrice().divide(new BigDecimal(var.getPriceUnit()).setScale(6, RoundingMode.HALF_UP)));
            }
            if (StringUtils.isNotBlank((CharSequence)var.getTaxCode())) {
                ElsTax oneElsTaxByCode = this.elsTaxService.getOneElsTaxByCode(elsAccount, var.getTaxCode());
                var.setTaxRate(oneElsTaxByCode.getTaxRate() + "");
                BigDecimal netPrice = var.getPrice().divide(BigDecimal.ONE.add(new BigDecimal(oneElsTaxByCode.getTaxRate()).divide(new BigDecimal(100))), 6, 4);
                var.setNetPrice(netPrice);
            }
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SupplierMasterData::getSupplierCode, (Object)var.getSupplierCode().replaceAll("^0*", ""))).last("limit 1");
            SupplierMasterData supplierMasterData = (SupplierMasterData)this.supplierMasterDataMapper.selectOne((Wrapper)lambdaQueryWrapper);
            if (supplierMasterData != null && var.getNetPrice().compareTo(BigDecimal.ZERO) == 1 && var.getEffectiveDate() != null && var.getExpiryDate() != null) {
                var.setToElsAccount(supplierMasterData.getToElsAccount());
                var.setSupplierName(supplierMasterData.getSupplierName());
                informationRecordsSAPVOList.add(var);
            }
        });
        this.purchaseInformationRecordsMapper.replaceAllPriceRecord(list);
        if (null != lastExecutionTime) {
            this.quartzJobRpcService.updateByJobNameKey("pullPriceJob", new Date());
        } else {
            try {
                Date date1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sdf.format(new Date()) + " 00:00:00");
                this.quartzJobRpcService.updateByJobNameKey("pullPriceJob", date1);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u540c\u6b65\u4ef7\u683c\u4e3b\u6570\u636e\u6210\u529f");
        logger.info("\u5f00\u59cb\u521b\u5efa\u7269\u6599\u8d27\u6e90\u6e05\u5355----start-------");
        this.createMaterialSource(list);
        logger.info("\u5f00\u59cb\u521b\u5efa\u7269\u6599\u8d27\u6e90\u6e05\u5355----end-------");
    }

    private void createMaterialSource(List<PurchaseInformationRecordsSAPVO> list) {
        ArrayList<PurchaseMaterialSource> sourceList = new ArrayList<PurchaseMaterialSource>();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("materialSource");
        for (PurchaseInformationRecordsSAPVO records : list) {
            PurchaseMaterialSource source;
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getMaterialNumber, (Object)records.getMaterialNumber());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getFactory, (Object)records.getFactory());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getPurchaseOrg, (Object)records.getPurchaseOrg());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getFbk3, (Object)records.getSupplierCode());
            List materialSourcesList = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
            if (materialSourcesList.size() > 0) {
                source = new PurchaseMaterialSource();
                source.setEffectiveDate(records.getEffectiveDate());
                source.setExpiryDate(records.getExpiryDate());
                this.purchaseMaterialSourceService.update((Object)source, (Wrapper)wrapper);
                continue;
            }
            source = new PurchaseMaterialSource();
            BeanUtils.copyProperties((Object)records, (Object)((Object)source));
            source.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            source.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            source.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion().toString());
            source.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            source.setToElsDesc(records.getSupplierName());
            source.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)source));
            source.setMaterialDesc(records.getMaterialName());
            source.setFbk2(records.getPurchaseUnit());
            source.setFbk3(records.getSupplierCode());
            source.setId(IdWorker.getIdStr());
            source.setDeleted(CommonConstant.DEL_FLAG_0);
            source.setSourceSystem("SAP");
            source.setMaterialSourceType(MaterialSourceTypeEnum.MATERIAL.getValue());
            source.setCreateTime(new Date());
            source.setUpdateTime(new Date());
            source.setFlowId(null);
            source.setFactory(records.getFactory());
            source.setFactoryName(records.getFbk30());
            source.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            source.setStatus(MaterialSourceStatusEnum.EFFECTIVE.getValue());
            source.setSourceType(MaterialCreateSourceTypeEnum.PRICE.getValue());
            sourceList.add(source);
        }
        this.purchaseMaterialSourceMapper.replaceAllMaterialSource(sourceList);
    }

    private String toJson(Date lastExecutionTime, SimpleDateFormat sdf, SimpleDateFormat sdft) {
        HashMap all = new HashMap();
        HashMap<String, String> IT_WERKS = new HashMap<String, String>();
        IT_WERKS.put("tableName", "IT_WERKS");
        HashMap<String, String> ET_EINA = new HashMap<String, String>();
        ET_EINA.put("tableName", "ET_EINA");
        HashMap<String, String> IT_LIFNR = new HashMap<String, String>();
        IT_LIFNR.put("tableName", "IT_LIFNR");
        HashMap<String, String> parameterList = new HashMap<String, String>();
        if (null != lastExecutionTime) {
            parameterList.put("I_DATUM", sdf.format(lastExecutionTime));
            parameterList.put("I_UTIME", sdft.format(lastExecutionTime));
        } else {
            parameterList.put("I_DATUM", sdf.format(new Date()));
            parameterList.put("I_UTIME", "00:00:00");
        }
        HashMap<String, String> IT_MATNR = new HashMap<String, String>();
        IT_MATNR.put("tableName", "IT_MATNR");
        all.put("IT_WERKS", IT_WERKS);
        all.put("ET_EINA", ET_EINA);
        all.put("IT_LIFNR", IT_LIFNR);
        all.put("parameterList", parameterList);
        all.put("IT_MATNR", IT_MATNR);
        return JSON.toJSONString(all);
    }

    private TemplateHead getTemplateHead(String elsAccount) {
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        List list = this.templateHeadService.getAllByAccountAndType(elsAccount, "price");
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return (TemplateHead)list.get(0);
    }

    private ReturnSRMBaseVO callSAPInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }
}

