/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.enumerate.MaterialSourceTypeEnum;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.order.api.service.PurchaseReconciliationRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.modules.org.vo.PurchaseOrgInfoVO;
import com.els.modules.price.api.dto.PurchaseInformationRecordsDTO;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.MaterialCreateSourceTypeEnum;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.price.mapper.PurchaseInformationRecordsMapper;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.vo.HisQuotePriceTrendVO;
import com.els.modules.price.vo.PurchaseInformationRecordsSAPVO;
import com.els.modules.price.vo.PurchaseInformationRecordsSubmitDTVO;
import com.els.modules.price.vo.PurchaseInformationRecordsSubmitVO;
import com.els.modules.price.vo.QueryPriceVO;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.system.entity.DictModel;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.enums.SrmInterfaceCodeEnum;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsTaxService;
import com.els.modules.system.util.SrmCallInterfaceUtil;
import com.els.modules.system.vo.ReturnSRMBaseVO;
import com.els.modules.system.vo.SRMRequestBaseVO;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseInformationRecordsServiceImpl
extends ServiceImpl<PurchaseInformationRecordsMapper, PurchaseInformationRecords>
implements PurchaseInformationRecordsService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseInformationRecordsServiceImpl.class);
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Resource
    private PurchaseInformationRecordsMapper purchaseInformationRecordsMapper;
    @Resource
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Resource
    private TemplateHeadService templateHeadService;
    @Autowired
    private ElsTaxService elsTaxService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private SrmCallInterfaceUtil srmCallInterfaceUtil;
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;
    @Resource
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Resource
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;
    @Autowired
    private PlatformTransactionManager txManager;
    @Resource
    private PurchaseReconciliationRpcService purchaseReconciliationRpcService;
    @Resource
    private DictService dictService;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;

    @Override
    public void savePurchaseInformationRecords(PurchaseInformationRecords records) {
        if (null != records.getExpiryDate() && null != records.getEffectiveDate() && records.getExpiryDate().before(records.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        QueryWrapper materialHeadWrapper = new QueryWrapper();
        materialHeadWrapper.eq((Object)"material_number", (Object)records.getMaterialNumber());
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadService.getOne((Wrapper)materialHeadWrapper));
        if (null != purchaseMaterialHead && !StringUtils.isBlank((CharSequence)purchaseMaterialHead.getFreeze()) && purchaseMaterialHead.getFreeze().equals("1")) {
            throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
        }
        if (records.getFbk1().equals("1")) {
            if (StringUtils.isEmpty((CharSequence)records.getFbk2())) {
                throw new ELSBootException("\u4ef7\u683c\u8986\u76d6\u8303\u56f4\u4e3a\u57fa\u5730\u7ef4\u5ea6\u65f6\uff0c\u57fa\u5730\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            ArrayList<PurchaseInformationRecords> insert = new ArrayList<PurchaseInformationRecords>();
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"fbk3", (Object)records.getFbk2());
            List factories = this.purchaseOrganizationInfoService.list((Wrapper)wrapper);
            if (factories.isEmpty()) {
                throw new ELSBootException("\u5f53\u524d\u57fa\u5730\u6ca1\u6709\u5339\u914d\u5230\u5173\u8054\u7684\u5de5\u5382\uff01");
            }
            List<String> factoryList = factories.stream().map(PurchaseOrganizationInfo::getOrgCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
            List<PurchaseOrgInfoVO> list = this.purchaseOrganizationInfoService.recordsFactoryList(factoryList);
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                PurchaseOrgInfoVO purchaseOrgInfoVO = list.get(i);
                map.put(purchaseOrgInfoVO.getOrgCode(), purchaseOrgInfoVO.getParentOrgCode());
            }
            for (PurchaseOrganizationInfo once : factories) {
                PurchaseInformationRecords on = new PurchaseInformationRecords();
                BeanUtils.copyProperties((Object)((Object)records), (Object)((Object)on));
                on.setInfoRecordNumber(this.baseRpcService.getNextCode("srmPriceNumber", (Object)records));
                on.setFactory(once.getOrgCode());
                on.setCompany(null != map.get(on.getFactory()) ? map.get(on.getFactory()).toString() : "");
                on.setSourceType(PriceSourceTypeEnum.SRM.getValue());
                if (StrUtil.isEmpty((CharSequence)records.getAuditStatus())) {
                    on.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                }
                on.setRecordStatus(PriceStatusEnum.NEW.getValue());
                on.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
                String fbk20 = on.getFbk20();
                if (StringUtils.isNotBlank((CharSequence)fbk20) && fbk20.equals("0")) {
                    on.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    on.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                    on.setReturnState("0");
                }
                if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(records.getAuditStatus())) {
                    this.cutOffPriceDate(on, false);
                    on.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                }
                QueryWrapper materialWrapper = new QueryWrapper();
                materialWrapper.eq((Object)"material_number", (Object)records.getMaterialNumber());
                materialWrapper.eq((Object)"factory", (Object)once.getOrgCode());
                PurchaseMaterialItem one = (PurchaseMaterialItem)((Object)this.purchaseMaterialItemService.getOne((Wrapper)materialWrapper));
                if (one == null) continue;
                if (!StringUtils.isBlank((CharSequence)purchaseMaterialHead.getFreeze()) && purchaseMaterialHead.getFreeze().equals("1")) {
                    throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5728\u5de5\u5382" + once.getOrgCode() + "\u4e0b\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                }
                on.setMaterialDesc(one.getMaterialDesc());
                String purchaseUnit = on.getPurchaseUnit();
                String fbk19 = on.getFbk19();
                if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && purchaseUnit.equals(fbk19)) {
                    on.setFbk17("1");
                    on.setFbk18("1");
                } else if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && !purchaseUnit.equals(fbk19)) {
                    String orderUnit = one.getOrderUnit();
                    if (StringUtils.isNotBlank((CharSequence)orderUnit) && StringUtils.isNotBlank((CharSequence)purchaseUnit) && orderUnit.equals(purchaseUnit)) {
                        if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk7()) && !purchaseMaterialHead.getFbk7().equals("0")) {
                            on.setFbk17(purchaseMaterialHead.getFbk7());
                        } else {
                            on.setFbk17("1");
                        }
                        if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk6()) && !purchaseMaterialHead.getFbk6().equals("0")) {
                            on.setFbk18(purchaseMaterialHead.getFbk6());
                        } else {
                            on.setFbk18("1");
                        }
                    } else {
                        throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5728\u5de5\u5382" + once.getOrgCode() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                    }
                }
                insert.add(on);
            }
            if (CollectionUtils.isEmpty(insert)) {
                throw new ELSBootException("SRM\u7269\u6599\u4e3b\u6570\u636e\u5f53\u524d\u57fa\u5730\u4e2d\u6240\u6709\u5de5\u5382\u4e0b\u65e0\u8be5\u7269\u6599:" + records.getMaterialNumber() + "\uff0c\u8bf7\u786e\u8ba4!");
            }
            this.saveBatch(insert);
        } else {
            this.handleFbk1(records);
            String fbk13 = records.getFbk13();
            if (StringUtils.isNotBlank((CharSequence)fbk13) && (fbk13.equals("2") || fbk13.equals("2")) && records.getFbk1().equals("4")) {
                throw new ELSBootException("\u975e\u7edf\u91c7\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u7ef4\u5ea6\uff0c\u7ef4\u62a4\u4ef7\u683c");
            }
            if (records.getFbk1().equals("3")) {
                this.checkFactoryDimensionality(records, purchaseMaterialHead);
            } else if (records.getFbk1().equals("4")) {
                this.checkPurchaseGroupDimensionality(records, purchaseMaterialHead);
            }
            if (StringUtils.isBlank((CharSequence)records.getInfoRecordNumber())) {
                records.setInfoRecordNumber(this.baseRpcService.getNextCode("srmPriceNumber", (Object)records));
            }
            records.setSourceType(PriceSourceTypeEnum.SRM.getValue());
            if (StrUtil.isEmpty((CharSequence)records.getAuditStatus())) {
                records.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            records.setRecordStatus(PriceStatusEnum.NEW.getValue());
            records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
            String fbk20 = records.getFbk20();
            if (StringUtils.isNotBlank((CharSequence)fbk20) && fbk20.equals("0")) {
                records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                records.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                records.setReturnState("0");
            }
            if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(records.getAuditStatus())) {
                this.cutOffPriceDate(records, false);
                records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            }
            ((PurchaseInformationRecordsMapper)this.baseMapper).insert((Object)records);
        }
    }

    void checkPurchaseGroupDimensionality(PurchaseInformationRecords records, PurchaseMaterialHead purchaseMaterialHead) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"material_number", (Object)purchaseMaterialHead.getMaterialNumber());
        List<PurchaseMaterialItem> itemList = this.purchaseMaterialItemService.selectByMaterialNumber((QueryWrapper<PurchaseMaterialItem>)queryWrapper);
        String purchaseUnit = records.getPurchaseUnit();
        String fbk19 = records.getFbk19();
        if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && purchaseUnit.equals(fbk19)) {
            records.setFbk17("1");
            records.setFbk18("1");
        } else if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && !purchaseUnit.equals(fbk19)) {
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(itemList)) {
                Boolean resultItem = true;
                for (PurchaseMaterialItem purchaseMaterialItem : itemList) {
                    String orderUnit = purchaseMaterialItem.getOrderUnit();
                    if (StringUtils.isNotBlank((CharSequence)orderUnit) && StringUtils.isNotBlank((CharSequence)purchaseUnit) && orderUnit.equals(purchaseUnit)) continue;
                    throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5728\u5de5\u5382" + records.getFactory() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
                }
                if (resultItem.booleanValue()) {
                    if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk7()) && !purchaseMaterialHead.getFbk7().equals("0")) {
                        records.setFbk17(purchaseMaterialHead.getFbk7());
                    } else {
                        records.setFbk17("1");
                    }
                    if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk6()) && !purchaseMaterialHead.getFbk6().equals("0")) {
                        records.setFbk18(purchaseMaterialHead.getFbk6());
                    } else {
                        records.setFbk18("1");
                    }
                }
            } else {
                throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u672a\u7ef4\u62a4\u7269\u6599\u660e\u7ec6");
            }
        }
    }

    void checkFactoryDimensionality(PurchaseInformationRecords records, PurchaseMaterialHead purchaseMaterialHead) {
        String purchaseUnit = records.getPurchaseUnit();
        String fbk19 = records.getFbk19();
        if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && purchaseUnit.equals(fbk19)) {
            records.setFbk17("1");
            records.setFbk18("1");
        } else if (StringUtils.isNotBlank((CharSequence)purchaseUnit) && StringUtils.isNotBlank((CharSequence)fbk19) && !purchaseUnit.equals(fbk19)) {
            QueryWrapper materialWrapper = new QueryWrapper();
            materialWrapper.eq((Object)"material_number", (Object)records.getMaterialNumber());
            materialWrapper.eq((Object)"factory", (Object)records.getFactory());
            PurchaseMaterialItem one = (PurchaseMaterialItem)((Object)this.purchaseMaterialItemService.getOne((Wrapper)materialWrapper));
            if (null == one) {
                throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5728\u5de5\u5382" + records.getFactory() + "\u672a\u67e5\u8be2\u5230\u7269\u6599\u660e\u7ec6");
            }
            if (!StringUtils.isBlank((CharSequence)one.getFbk1()) && one.getFbk1().equals("1")) {
                throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5728\u5de5\u5382" + records.getFactory() + "\u7269\u6599\u5de5\u5382\u5df2\u51bb\u7ed3");
            }
            String orderUnit = one.getOrderUnit();
            if (StringUtils.isNotBlank((CharSequence)orderUnit) && StringUtils.isNotBlank((CharSequence)purchaseUnit) && orderUnit.equals(purchaseUnit)) {
                if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk7()) && !purchaseMaterialHead.getFbk7().equals("0")) {
                    records.setFbk17(purchaseMaterialHead.getFbk7());
                } else {
                    records.setFbk17("1");
                }
                if (StringUtils.isNotBlank((CharSequence)purchaseMaterialHead.getFbk6()) && !purchaseMaterialHead.getFbk6().equals("0")) {
                    records.setFbk18(purchaseMaterialHead.getFbk6());
                } else {
                    records.setFbk18("1");
                }
            } else {
                throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5728\u5de5\u5382" + records.getFactory() + "\u672a\u7ef4\u62a4\u76f8\u5173\u8ba2\u5355\u5355\u4f4d\u6216\u7ef4\u62a4\u7684\u8ba2\u5355\u5355\u4f4d\u4e0e\u5b9e\u9645\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u4fee\u6539");
            }
        }
    }

    void handleFbk1(PurchaseInformationRecords records) {
        if (records.getFbk1().equals("3")) {
            String materialNumber = records.getMaterialNumber();
            if (StringUtils.isBlank((CharSequence)records.getFactory())) {
                throw new ELSBootException("\u5de5\u5382\u7ef4\u5ea6\u4e0b\u5de5\u5382\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String factory = records.getFactory();
            if (StringUtils.isNotBlank((CharSequence)materialNumber) && StringUtils.isNotBlank((CharSequence)factory)) {
                QueryWrapper materialWrapper = new QueryWrapper();
                materialWrapper.eq((Object)"material_number", (Object)materialNumber);
                materialWrapper.eq((Object)"factory", (Object)factory);
                PurchaseMaterialItem one = (PurchaseMaterialItem)((Object)this.purchaseMaterialItemService.getOne((Wrapper)materialWrapper));
                if (one == null) {
                    throw new ELSBootException("SRM\u7269\u6599\u4e3b\u6570\u636e\u4e2d\u8be5\u5de5\u5382:" + factory + "\u4e0b\u65e0\u8be5\u7269\u6599:" + materialNumber + "\uff0c\u8bf7\u786e\u8ba4!");
                }
                if (!StringUtils.isBlank((CharSequence)one.getFbk1()) && one.getFbk1().equals("1")) {
                    throw new ELSBootException("\u8be5\u7269\u6599" + records.getMaterialNumber() + "\u5728\u5de5\u5382" + factory + "\u4e0b\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
                }
                records.setMaterialDesc(one.getMaterialDesc());
            }
        }
    }

    @Override
    public void calculatePrice(PurchaseInformationRecords records) {
        BigDecimal taxRate = StrUtil.isBlank((CharSequence)records.getTaxRate()) ? BigDecimal.ZERO : new BigDecimal(records.getTaxRate()).divide(BigDecimal.valueOf(100L));
        BigDecimal price = records.getPrice() == null ? BigDecimal.ZERO : records.getPrice();
        BigDecimal freight = records.getFreight() == null ? BigDecimal.ZERO : records.getFreight();
        BigDecimal discount = records.getDiscount() == null ? BigDecimal.ZERO : records.getDiscount();
        BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        BigDecimal theNetPrice = price.add(freight).subtract(discount);
        records.setNetPrice(netPrice);
        records.setTheNetPrice(theNetPrice);
    }

    @Override
    public String createMaterialSource(List<PurchaseInformationRecords> recordsList) {
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(recordsList), (String)I18nUtil.translate((String)"i18n_alert_ViFTPsSjumdWFc_6498c6ee", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u8f6c\u6362\u7684\u4ef7\u683c\u4e3b\u6570\u636e\u884c"));
        ArrayList<PurchaseMaterialSource> sourceList = new ArrayList<PurchaseMaterialSource>();
        ArrayList<PurchaseMaterialSource> updateList = new ArrayList<PurchaseMaterialSource>();
        for (int index = 0; index < recordsList.size(); ++index) {
            PurchaseInformationRecords records = recordsList.get(index);
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialSource::getSourceId});
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getMaterialNumber, (Object)records.getMaterialNumber());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getFactory, (Object)records.getFactory());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getCompany, (Object)records.getCompany());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getPurchaseOrg, (Object)records.getPurchaseOrg());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getToElsAccount, (Object)records.getToElsAccount());
            List list = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
            if (list.size() > 0) {
                PurchaseMaterialSource purchaseMaterialSource = (PurchaseMaterialSource)((Object)list.get(0));
                BeanUtils.copyProperties((Object)((Object)records), (Object)((Object)purchaseMaterialSource));
                this.handleInfo(purchaseMaterialSource, records);
                updateList.add(purchaseMaterialSource);
                continue;
            }
            PurchaseMaterialSource source = new PurchaseMaterialSource();
            BeanUtils.copyProperties((Object)((Object)records), (Object)((Object)source));
            this.handleInfo(source, records);
            sourceList.add(source);
        }
        this.purchaseMaterialSourceService.addBatch(sourceList);
        this.purchaseMaterialSourceService.updateBatchById(updateList);
        String sourceStr = "";
        if (!CollectionUtils.isEmpty(sourceList)) {
            sourceStr = sourceList.stream().map(PurchaseMaterialSource::getSourceId).collect(Collectors.toList()).toString();
        }
        String updateStr = "";
        if (!CollectionUtils.isEmpty(updateList)) {
            updateStr = updateList.stream().map(PurchaseMaterialSource::getSourceId).collect(Collectors.toList()).toString();
        }
        return sourceStr + updateStr;
    }

    void handleInfo(PurchaseMaterialSource source, PurchaseInformationRecords records) {
        source.setToElsDesc(records.getSupplierName());
        source.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)source));
        source.setFbk1(records.getMaterialName());
        source.setFbk2(records.getPurchaseUnit());
        source.setFbk3(records.getSupplierCode());
        source.setFbk4(records.getSupplierName());
        source.setId(null);
        source.setMaterialSourceType(MaterialSourceTypeEnum.MATERIAL.getValue());
        source.setCreateTime(new Date());
        source.setUpdateTime(new Date());
        source.setFlowId(null);
        source.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        source.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
        source.setSourceType(MaterialCreateSourceTypeEnum.PRICE.getValue());
    }

    @Override
    public void addBatch(List<PurchaseInformationRecords> recordsList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        if (CollectionUtil.isNotEmpty(recordsList) && CollectionUtil.isNotEmpty((Collection)templateList)) {
            PurchaseInformationRecords entity = recordsList.get(0);
            long size = recordsList.stream().filter(x -> StrUtil.isBlank((CharSequence)x.getInfoRecordNumber())).count();
            List nextCodes = this.baseRpcService.getNextCodes("srmPriceNumber", (Object)entity, (int)size);
            int codeIndex = 0;
            for (PurchaseInformationRecords records : recordsList) {
                SysUtil.setNullCreate((BaseEntity)records);
                records.setUpdateBy(null);
                records.setUpdateTime(null);
                records.setId(null);
                if (StringUtils.isBlank((CharSequence)records.getInfoRecordNumber())) {
                    records.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
                }
                records.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                records.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                records.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                records.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
                records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
                records.setRecordStatus(PriceStatusEnum.NEW.getValue());
                String fbk20 = entity.getFbk20();
                if (StringUtils.isNotBlank((CharSequence)fbk20) && fbk20.equals("0")) {
                    entity.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                    entity.setReturnState("0");
                }
                if (!AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(records.getAuditStatus())) continue;
                this.cutOffPriceDate(records, false);
            }
            this.saveBatch(recordsList);
        }
    }

    @Override
    public void updatePurchaseInformationRecords(PurchaseInformationRecords purchaseInformationRecords) {
        int count;
        if (null != purchaseInformationRecords.getPrice() && purchaseInformationRecords.getPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_xfuxOXUEUWW_3bbae979", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01"));
        }
        if (null != purchaseInformationRecords.getExpiryDate() && null != purchaseInformationRecords.getEffectiveDate() && purchaseInformationRecords.getExpiryDate().before(purchaseInformationRecords.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getPriceType()), (String)I18nUtil.translate((String)"i18n_alert_umAclS_b641dd5b", (String)"\u4ef7\u683c\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLKWSLAylS_a87995e2", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u7269\u6599\u7f16\u53f7\u5fc5\u586b"));
        } else if ("2".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLVKWSLVlS_dce240f5", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        Assert.isTrue((StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getFactory()) || StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getPurchaseOrg()) ? 1 : 0) != 0, (String)"\u5de5\u5382\u548c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a");
        QueryWrapper materialHeadWrapper = new QueryWrapper();
        materialHeadWrapper.eq((Object)"material_number", (Object)purchaseInformationRecords.getMaterialNumber());
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadService.getOne((Wrapper)materialHeadWrapper));
        if (null != purchaseMaterialHead && !StringUtils.isBlank((CharSequence)purchaseMaterialHead.getFreeze()) && purchaseMaterialHead.getFreeze().equals("1")) {
            throw new ELSBootException("\u8be5\u7269\u6599" + purchaseInformationRecords.getMaterialNumber() + "\u5df2\u88ab\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4ef7\u683c\uff01");
        }
        purchaseInformationRecords.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        String fbk20 = purchaseInformationRecords.getFbk20();
        if (StringUtils.isNotBlank((CharSequence)fbk20) && fbk20.equals("0")) {
            purchaseInformationRecords.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            purchaseInformationRecords.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            purchaseInformationRecords.setReturnState("0");
        }
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseInformationRecords.getAuditStatus())) {
            this.cutOffPriceDate(purchaseInformationRecords, false);
        }
        this.calculatePrice(purchaseInformationRecords);
        this.handleFbk1(purchaseInformationRecords);
        String fbk13 = purchaseInformationRecords.getFbk13();
        if (StringUtils.isNotBlank((CharSequence)fbk13) && (fbk13.equals("2") || fbk13.equals("2")) && purchaseInformationRecords.getFbk1().equals("4")) {
            throw new ELSBootException("\u975e\u7edf\u91c7\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u7ef4\u5ea6\uff0c\u7ef4\u62a4\u4ef7\u683c");
        }
        if (!purchaseInformationRecords.getFbk1().equals("1")) {
            if (purchaseInformationRecords.getFbk1().equals("3")) {
                this.checkFactoryDimensionality(purchaseInformationRecords, purchaseMaterialHead);
            } else if (purchaseInformationRecords.getFbk1().equals("4")) {
                this.checkPurchaseGroupDimensionality(purchaseInformationRecords, purchaseMaterialHead);
            }
        }
        if ((count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)purchaseInformationRecords)) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cutOffPriceDate(PurchaseInformationRecords records, boolean onlyCheck) {
        LambdaQueryWrapper countWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)countWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)records.getToElsAccount())).eq(PurchaseInformationRecords::getPriceType, (Object)records.getPriceType());
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)records.getToElsAccount())).eq(PurchaseInformationRecords::getPriceType, (Object)records.getPriceType());
        if (PurchaseInformationPriceTypeEnum.MATERIAL.getValue().equals(records.getPriceType())) {
            countWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)records.getMaterialNumber());
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)records.getMaterialNumber());
        } else if (PurchaseInformationPriceTypeEnum.MATERIAL_GROUP.getValue().equals(records.getPriceType())) {
            countWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)records.getMaterialGroup());
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)records.getMaterialGroup());
        } else {
            String msg = CharSequenceUtil.isEmpty((CharSequence)records.getId()) ? "" : "[ " + records.getId() + " ]";
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFWWWWWWWWumAcLV_910b114f", (String)"\u4ef7\u683c\u4e3b\u6570\u636e${0}\u4ef7\u683c\u7c7b\u578b\u4e3a\u7a7a", (String[])new String[]{msg}));
        }
        if (StringUtils.isNotBlank((CharSequence)records.getFactory())) {
            countWrapper.eq(PurchaseInformationRecords::getFactory, (Object)records.getFactory());
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)records.getFactory());
        } else {
            countWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)records.getPurchaseOrg());
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)records.getPurchaseOrg());
        }
        ArrayList recordStatusList = Lists.newArrayList((Object[])new String[]{PriceStatusEnum.NORMAL.getValue(), PriceStatusEnum.FROZEN.getValue(), PriceStatusEnum.EFFECTIVE.getValue()});
        ArrayList auditStatusList = Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()});
        ((LambdaQueryWrapper)countWrapper.in(PurchaseInformationRecords::getAuditStatus, (Collection)auditStatusList)).in(PurchaseInformationRecords::getRecordStatus, (Collection)recordStatusList);
        ((LambdaQueryWrapper)queryWrapper.in(PurchaseInformationRecords::getAuditStatus, (Collection)auditStatusList)).in(PurchaseInformationRecords::getRecordStatus, (Collection)recordStatusList);
        countWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.or(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.le(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).le(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate());
            });
        });
        countWrapper.ne(CharSequenceUtil.isNotBlank((CharSequence)records.getId()), BaseEntity::getId, (Object)records.getId());
        countWrapper.select(new SFunction[]{PurchaseInformationRecords::getInfoRecordNumber});
        List recordsList = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)countWrapper);
        int count = recordsList.size();
        Assert.isTrue((count == 0 ? 1 : 0) != 0, (String)(I18nUtil.translate((String)"i18n_alert_APsubXKIIqBrWTLRGvumtHW_b32e3bba", (String)"\u5f53\u524d\u62a5\u4ef7\u751f\u6548\u65f6\u95f4\u5df2\u88ab\u8986\u76d6\uff0c\u9700\u4eba\u5de5\u5904\u7406\u4ef7\u683c\u8bb0\u5f55!") + ":" + recordsList.stream().map(PurchaseInformationRecords::getInfoRecordNumber).collect(Collectors.joining(","))));
        queryWrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.le(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).le(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)records.getEffectiveDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseInformationRecords::getEffectiveDate, (Object)records.getEffectiveDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)records.getExpiryDate())).le(PurchaseInformationRecords::getEffectiveDate, (Object)records.getExpiryDate());
            });
        });
        queryWrapper.select(new SFunction[]{BaseEntity::getId, PurchaseInformationRecords::getEffectiveDate, PurchaseInformationRecords::getExpiryDate});
        List disRecords = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        Assert.isTrue((disRecords.size() <= 2 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_umdWFOTjXAKBAVsW_ecc56066", (String)"\u5f53\u524d\u62a5\u4ef7\u751f\u6548\u65f6\u95f4\u5df2\u88ab\u8986\u76d6\uff0c\u9700\u4eba\u5de5\u5904\u7406\u4ef7\u683c\u8bb0\u5f55!"));
        if (disRecords.isEmpty()) {
            return;
        }
        int maxStartTime = 0;
        for (PurchaseInformationRecords disRecord : disRecords) {
            Calendar calendar = Calendar.getInstance();
            if (disRecord.getEffectiveDate().after(records.getEffectiveDate()) && disRecord.getExpiryDate().after(records.getExpiryDate())) {
                calendar.setTime(records.getExpiryDate());
                calendar.add(5, 1);
                disRecord.setEffectiveDate(calendar.getTime());
                ++maxStartTime;
                continue;
            }
            if (disRecord.getEffectiveDate().before(records.getEffectiveDate()) && disRecord.getExpiryDate().before(records.getExpiryDate())) {
                calendar.setTime(records.getEffectiveDate());
                calendar.add(5, -1);
                disRecord.setExpiryDate(calendar.getTime());
                continue;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APsubXKIIqBrWTLRGvumtHW_b32e3bba", (String)"\u5f53\u524d\u62a5\u4ef7\u751f\u6548\u65f6\u95f4\u5df2\u88ab\u8986\u76d6\uff0c\u9700\u4eba\u5de5\u5904\u7406\u4ef7\u683c\u8bb0\u5f55!"));
        }
        if (disRecords.size() == 2 && maxStartTime != 1) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APsubXKIIqBrWTLRGvumtHW_b32e3bba", (String)"\u5f53\u524d\u62a5\u4ef7\u751f\u6548\u65f6\u95f4\u5df2\u88ab\u8986\u76d6\uff0c\u9700\u4eba\u5de5\u5904\u7406\u4ef7\u683c\u8bb0\u5f55!"));
        }
        if (onlyCheck) {
            return;
        }
        for (PurchaseInformationRecords disRecord : disRecords) {
            disRecord.setUpdateTime(new Date());
            disRecord.setUpdateBy(TenantContext.getTenant());
            ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)disRecord);
        }
    }

    @Override
    public void frozenPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.FROZEN.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void checkStatus(PurchaseInformationRecords record) {
    }

    @Override
    public void thawPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelBySourceNumber(String sourceType, String sourceNumber, List<String> itemNumberList) {
        String elsAccount = TenantContext.getTenant();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseInformationRecords::getSourceNumber, (Object)sourceNumber)).eq(PurchaseInformationRecords::getSourceType, (Object)sourceType)).in(PurchaseInformationRecords::getSourceItemNumber, itemNumberList);
        PurchaseInformationRecords records = new PurchaseInformationRecords();
        records.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        ((PurchaseInformationRecordsMapper)this.baseMapper).update((Object)records, (Wrapper)updateWrapper);
    }

    @Override
    public void delPurchaseInformationRecords(String id) {
        ((PurchaseInformationRecordsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseInformationRecords(List<String> idList) {
        ((PurchaseInformationRecordsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public HisQuotePriceTrendVO findTrendByMaterial(QueryPriceVO queryPriceVO) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)queryPriceVO.getMaterialNumber());
        wrapper.in(PurchaseInformationRecords::getToElsAccount, queryPriceVO.getToElsAccountList());
        wrapper.orderByAsc(PurchaseInformationRecords::getQuoteDate);
        List itemList = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)wrapper);
        HisQuotePriceTrendVO trendVO = new HisQuotePriceTrendVO();
        Map<String, List<PurchaseInformationRecords>> itemMap = itemList.stream().filter(item -> item.getQuoteDate() != null).collect(Collectors.groupingBy(item -> DateUtil.format((Date)item.getQuoteDate(), (String)"yyyy-MM-dd")));
        ArrayList<String> xAxisData = new ArrayList<String>(itemMap.keySet());
        trendVO.setXAxisData(xAxisData);
        List<String> legendData = itemList.stream().map(PurchaseInformationRecords::getSupplierName).distinct().collect(Collectors.toList());
        trendVO.setLegendData(legendData);
        JSONArray series = new JSONArray();
        for (String supplierName : legendData) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"line");
            ArrayList<BigDecimal> dataList = new ArrayList<BigDecimal>();
            for (String quoteDate : xAxisData) {
                List masterList = itemMap.get(quoteDate).stream().filter(record -> supplierName.equals(record.getSupplierName())).collect(Collectors.toList());
                if (!masterList.isEmpty()) {
                    BigDecimal minPrice = masterList.stream().filter(x -> x.getPrice() != null).map(PurchaseInformationRecords::getPrice).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
                    dataList.add(minPrice);
                    continue;
                }
                dataList.add(BigDecimal.ZERO);
            }
            object.put("data", dataList);
            series.add((Object)object);
        }
        trendVO.setSeries(series);
        return trendVO;
    }

    @Override
    public PurchaseInformationRecords getEffectiveRecord(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String priceType = StringUtils.isNotBlank((CharSequence)materialNumber) ? "1" : "2";
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)toElsAccount)).eq(PurchaseInformationRecords::getPriceType, (Object)priceType);
        if (StringUtils.isNotBlank((CharSequence)materialNumber)) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)materialNumber);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)materialGroup);
        }
        if (StringUtils.isNotBlank((CharSequence)factory)) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)factory);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseOrg);
        }
        queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getEffectiveDate, (Object)new Date())).gt(PurchaseInformationRecords::getExpiryDate, (Object)new Date());
        });
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return record;
    }

    @Override
    public List<PurchaseInformationRecords> getEffectiveRecordList(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)materialNumber) && StringUtils.isBlank((CharSequence)materialGroup)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLSSLVRRTPjIm_f8fc5a66", (String)"\u7269\u6599\u6216\u7269\u6599\u7ec4\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a"));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String priceType = StringUtils.isNotBlank((CharSequence)materialNumber) ? "1" : "2";
        queryWrapper.eq(PurchaseInformationRecords::getPriceType, (Object)priceType);
        if (StringUtils.isNotBlank((CharSequence)toElsAccount)) {
            queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)toElsAccount);
        }
        if (StringUtils.isNotBlank((CharSequence)materialNumber)) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)materialNumber);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)materialGroup);
        }
        if (StringUtils.isNotBlank((CharSequence)factory)) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)factory);
        } else if (StringUtils.isNotBlank((CharSequence)purchaseOrg)) {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseOrg);
        }
        queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getEffectiveDate, (Object)new Date())).gt(PurchaseInformationRecords::getExpiryDate, (Object)new Date());
        });
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<PurchaseInformationRecordsDTO> selectList(List<String> toElsAccounts, String auditStatus, String recordStatus, Date effectiveDate, Date expiryDate, String materialNumber, String purchaseOrg, String factory) {
        QueryWrapper purchaseInformationRecordsQueryWrapper = new QueryWrapper();
        if (CollectionUtil.isNotEmpty(toElsAccounts)) {
            purchaseInformationRecordsQueryWrapper.in((Object)"to_els_account", toElsAccounts);
        }
        purchaseInformationRecordsQueryWrapper.and(var -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)var.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq((Object)"audit_status", (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        });
        purchaseInformationRecordsQueryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qw.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or(qw1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)qw1.eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue());
            });
        });
        purchaseInformationRecordsQueryWrapper.le((Object)"effective_date", (Object)new Date());
        purchaseInformationRecordsQueryWrapper.ge((Object)"expiry_date", (Object)new Date());
        purchaseInformationRecordsQueryWrapper.eq((Object)"material_number", (Object)materialNumber);
        if (null != factory && null != purchaseOrg) {
            purchaseInformationRecordsQueryWrapper.eq((Object)"purchase_org", (Object)purchaseOrg);
            purchaseInformationRecordsQueryWrapper.eq((Object)"factory", (Object)factory);
        } else if (null != purchaseOrg) {
            purchaseInformationRecordsQueryWrapper.eq((Object)"purchase_org", (Object)purchaseOrg);
            purchaseInformationRecordsQueryWrapper.and(var -> ((QueryWrapper)((QueryWrapper)var.isNull((Object)"factory")).or()).eq((Object)"factory", (Object)""));
        } else if (null != factory) {
            purchaseInformationRecordsQueryWrapper.eq((Object)"factory", (Object)factory);
        }
        purchaseInformationRecordsQueryWrapper.orderByDesc((Object)"id");
        List purchaseInformationRecordsList = this.purchaseInformationRecordsMapper.selectList((Wrapper)purchaseInformationRecordsQueryWrapper);
        ArrayList purchaseInformationRecordsDTOList = null;
        if (CollectionUtil.isNotEmpty((Collection)purchaseInformationRecordsList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)purchaseInformationRecordsList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    @Override
    public List<PurchaseInformationRecordsDTO> selectListByOrderUpdate(String toElsAccount, String materialNumber, String purchaseOrg, String factory) {
        QueryWrapper recordsQueryWrapper = new QueryWrapper();
        recordsQueryWrapper.eq((Object)"to_els_account", (Object)toElsAccount);
        recordsQueryWrapper.and(var -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)var.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq((Object)"audit_status", (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        });
        recordsQueryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qw.eq((Object)"record_status", (Object)PriceStatusEnum.NORMAL.getValue())).or(qw1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)qw1.eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue());
            });
        });
        recordsQueryWrapper.le((Object)"effective_date", (Object)new Date());
        recordsQueryWrapper.ge((Object)"expiry_date", (Object)new Date());
        recordsQueryWrapper.eq((Object)"material_number", (Object)materialNumber);
        recordsQueryWrapper.eq((Object)"purchase_org", (Object)purchaseOrg);
        recordsQueryWrapper.eq((Object)"factory", (Object)factory);
        recordsQueryWrapper.orderByDesc((Object)"id");
        List purchaseInformationRecordsList = this.purchaseInformationRecordsMapper.selectList((Wrapper)recordsQueryWrapper);
        ArrayList purchaseInformationRecordsDTOList = null;
        if (CollectionUtil.isNotEmpty((Collection)purchaseInformationRecordsList)) {
            purchaseInformationRecordsDTOList = SysUtil.copyProperties((List)purchaseInformationRecordsList, PurchaseInformationRecordsDTO.class);
        }
        return purchaseInformationRecordsDTOList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void approvalOfPurchaseInformationRecords(JSONObject object, String auditStatus) {
        List headList = this.list((Wrapper)new LambdaQueryWrapper().eq(PurchaseInformationRecords::getFbk4, (Object)((String)object.get((Object)"oaId"))));
        if (CollectionUtils.isEmpty((Collection)headList)) {
            throw new RuntimeException("SRM\u4e2d\u4e0d\u5b58\u5728\u8be5\u4ef7\u683c\u4e3b\u6570\u636e\u8bb0\u5f55");
        }
        PurchaseInformationRecords records = (PurchaseInformationRecords)((Object)headList.get(0));
        if (null != records && !records.getAuditStatus().equals("2")) {
            if (auditStatus.equals("S")) {
                // empty if block
            }
            PurchaseInformationRecords param = new PurchaseInformationRecords();
            if (auditStatus.equals("S")) {
                param.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
                param.setReturnState("0");
                param.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            } else {
                param.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
            }
            this.update((Object)param, (Wrapper)new LambdaUpdateWrapper().eq(PurchaseInformationRecords::getFbk4, (Object)((String)object.get((Object)"oaId"))));
        }
    }

    void sendSAP(List<PurchaseInformationRecords> headList) {
        ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_PriceMasterData_SAP.getValue(), this.toJsonForPriceMasterData(headList, null));
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        Map map = returnMap.getInnerMap();
        List tReturnList = (List)map.get("T_DATA");
        if (tReturnList.isEmpty()) {
            headList.forEach(o -> o.setReturnState("2").setInterfaceMsg("SAP\u8fd4\u56de\u6d88\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u627e\u539f\u56e0").setRecordStatus(PriceStatusEnum.NORMAL.getValue()));
        }
        ArrayList<PurchaseInformationRecords> successList = new ArrayList<PurchaseInformationRecords>();
        tReturnList.forEach(tReturn -> headList.forEach(head -> {
            String ZINFNR = tReturn.get("ZINFNR").toString();
            if (StringUtils.isNotBlank((CharSequence)ZINFNR) && ZINFNR.equals(head.getInfoRecordNumber())) {
                String type;
                if (null == tReturn.get("TYPE")) {
                    head.setReturnState("2").setInterfaceMsg("SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u627e\u539f\u56e0").setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                }
                if (!(type = tReturn.get("TYPE").toString()).equals("S")) {
                    head.setReturnState("2").setInterfaceMsg(I18nUtil.translate((String)"", (String)("SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + tReturn.get("MESSAGE").toString()))).setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                } else {
                    head.setReturnState("1").setInterfaceMsg("").setSourceNumber(tReturn.get("INFNR").toString()).setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue()).setFbk17(tReturn.get("UMREZ").toString()).setFbk18(tReturn.get("UMREN").toString()).setFbk19(tReturn.get("LMEIN").toString());
                    successList.add((PurchaseInformationRecords)((Object)head));
                }
            }
        }));
        this.updateBatchById(headList);
        if (!CollectionUtils.isEmpty(successList)) {
            this.createMaterialSource(successList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitAudit(List<String> idList, PurchaseInformationRecordsSubmitVO submitVO) {
        List submitAuditLists = this.listByIds(idList);
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd");
        if (!submitAuditLists.isEmpty()) {
            HashMap<String, Object> all = new HashMap<String, Object>();
            ArrayList dt1 = new ArrayList();
            List dictModelList = this.dictService.queryDictItemsByCode("paymentTerm", TenantContext.getTenant(), "1");
            List dictModelPayWayList = this.dictService.queryDictItemsByCode("paymentMethod", TenantContext.getTenant(), "1");
            List priceFormIdList = this.dictService.queryDictItemsByCode("priceFormId", TenantContext.getTenant(), "1");
            submitAuditLists.forEach(item -> {
                DictModel dictModel;
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.handlePrice((PurchaseInformationRecords)((Object)item), (Map<String, Object>)map);
                map.put("clmc", item.getMaterialDesc());
                map.put("dw", item.getPurchaseUnit());
                map.put("ghdz", item.getAddress());
                map.put("gys", item.getSupplierName());
                map.put("wlbm", item.getMaterialNumber());
                map.put("djh", item.getInfoRecordNumber());
                map.put("sl", item.getTaxRate());
                if (!StringUtils.isBlank((CharSequence)item.getFbk12())) {
                    DictModel dictModelPayWay = dictModelPayWayList.stream().filter(head -> item.getFbk12().equals(head.getValue())).findAny().orElse(null);
                    if (null != dictModelPayWay) {
                        map.put("fkfs", dictModelPayWay.getText());
                    } else {
                        log.info("\u4ed8\u6b3e\u65b9\u5f0f \u672a\u67e5\u8be2\u5230\u5b57\u5178");
                    }
                }
                if (null != (dictModel = (DictModel)dictModelList.stream().filter(head -> item.getPayTermsCode().equals(head.getValue())).findAny().orElse(null))) {
                    map.put("zq", dictModel.getText());
                } else {
                    log.info("\u8d26\u671f \u4ed8\u6b3e\u6761\u4ef6 \u672a\u67e5\u8be2\u5230\u5b57\u5178");
                }
                map.put("jhzq", item.getDeliveryDays());
                PurchaseOrganizationInfoDTO factory = this.findOrgInfoByCode(item.getElsAccount(), "factory", item.getFactory());
                if (null != factory) {
                    map.put("ghjd", factory.getOrgName());
                }
                map.put("sxrq", null != item.getEffectiveDate() ? stf.format(item.getEffectiveDate()) : "");
                map.put("sxrq1", null != item.getExpiryDate() ? stf.format(item.getExpiryDate()) : "");
                dt1.add(map);
            });
            HashMap detail = new HashMap();
            detail.put("dt1", dt1);
            all.put("details", detail);
            this.handleDileInfo(submitVO, all);
            all.put("sqr", SysUtil.getLoginUser().getSubAccount());
            all.put("sqrq", stf.format(new Date()));
            all.put("bhlb", submitVO.getFbk5());
            all.put("jglb", submitVO.getFbk6());
            all.put("sfsyqs", submitVO.getFbk7());
            all.put("mj", submitVO.getFbk8());
            all.put("jgxj", submitVO.getFbk9());
            all.put("sqlb", submitVO.getFbk10());
            all.put("ztl", submitVO.getFbk11());
            all.put("djlx", "R");
            all.put("dyxt", "SRM");
            all.put("origin", "SRM");
            if (!CollectionUtils.isEmpty((Collection)priceFormIdList)) {
                DictModel dictModel = (DictModel)priceFormIdList.get(0);
                all.put("formid", dictModel.getValue());
            }
            all.put("createrid", SysUtil.getLoginUser().getSubAccount());
            PurchaseInformationRecords frist = (PurchaseInformationRecords)((Object)submitAuditLists.get(0));
            all.put("djsxrq", null != frist.getEffectiveDate() ? stf.format(frist.getEffectiveDate()) : null);
            String str = JSON.toJSONString(all);
            ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.SubmitAudit_PriceMasterData_OA.getValue(), str);
            JSONObject jsonObject = JSON.parseObject((String)returnSRMBaseVO.getData());
            Integer code = (Integer)jsonObject.get((Object)"code");
            if (null != code && code == 1) {
                throw new RuntimeException("\u63d0\u4ea4\u521b\u5efaOA\u6d41\u7a0b\u9519\u8bef:" + (String)jsonObject.get((Object)"msg"));
            }
            String errorCode = (String)jsonObject.get((Object)"errorCode");
            if (StringUtils.isNotBlank((CharSequence)errorCode) && errorCode.equals("002")) {
                throw new RuntimeException("\u63d0\u4ea4\u521b\u5efaOA\u6d41\u7a0b\u9519\u8bef:" + (String)jsonObject.get((Object)"msg"));
            }
            String data = (String)jsonObject.get((Object)"data");
            submitAuditLists.forEach(o -> o.setFbk4(data).setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue()));
            this.updateBatchById(submitAuditLists);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submitAuditNew(List<String> idList, PurchaseInformationRecordsSubmitVO submitVO) {
        List submitAuditLists = this.listByIds(idList);
        List<PurchaseInformationRecordsSubmitDTVO> submitDTVOS = submitVO.getSubmitDTVOS();
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd");
        if (!submitDTVOS.isEmpty()) {
            HashMap<String, Object> all = new HashMap<String, Object>();
            ArrayList dt1 = new ArrayList();
            List dictModelList = this.dictService.queryDictItemsByCode("paymentTerm", TenantContext.getTenant(), "1");
            List dictModelPayWayList = this.dictService.queryDictItemsByCode("paymentMethod", TenantContext.getTenant(), "1");
            List priceFormIdList = this.dictService.queryDictItemsByCode("priceFormId", TenantContext.getTenant(), "1");
            submitDTVOS.forEach(item -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("dzj", item.getPrice());
                map.put("ydjy", item.getPriceLast());
                map.put("cjc", item.getPriceSubtract());
                map.put("zfbfb", item.getIncrease());
                map.put("clmc", item.getMaterialDesc());
                map.put("dw", item.getPurchaseUnit());
                map.put("ghjd", item.getFactoryName());
                map.put("gys", item.getSupplierName());
                map.put("wlbm", item.getMaterialNumber());
                map.put("sl", item.getTaxRate());
                if (StringUtils.isNotBlank((CharSequence)item.getPaymentMethod())) {
                    DictModel dictModelPayWay = dictModelPayWayList.stream().filter(head -> item.getPaymentMethod().equals(head.getValue())).findAny().orElse(null);
                    if (null != dictModelPayWay) {
                        map.put("fkfs", dictModelPayWay.getText());
                    } else {
                        log.info("\u4ed8\u6b3e\u65b9\u5f0f \u672a\u67e5\u8be2\u5230\u5b57\u5178");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)item.getPayTermsCode())) {
                    DictModel dictModel = dictModelList.stream().filter(head -> item.getPayTermsCode().equals(head.getValue())).findAny().orElse(null);
                    if (null != dictModel) {
                        map.put("zq", dictModel.getText());
                    } else {
                        log.info("\u8d26\u671f \u4ed8\u6b3e\u6761\u4ef6 \u672a\u67e5\u8be2\u5230\u5b57\u5178");
                    }
                }
                map.put("jhzq", item.getDeliveryDays());
                dt1.add(map);
            });
            HashMap detail = new HashMap();
            detail.put("dt1", dt1);
            all.put("details", detail);
            this.handleDileInfo(submitVO, all);
            all.put("sqr", SysUtil.getLoginUser().getSubAccount());
            all.put("sqrq", stf.format(new Date()));
            all.put("bhlb", submitVO.getFbk5());
            all.put("jglb", submitVO.getFbk6());
            all.put("sfsyqs", submitVO.getFbk7());
            all.put("mj", submitVO.getFbk8());
            all.put("jgxj", submitVO.getFbk9());
            all.put("sqlb", submitVO.getFbk10());
            all.put("ztl", submitVO.getFbk11());
            all.put("djlx", "R");
            all.put("dyxt", "SRM");
            all.put("origin", "SRM");
            if (!CollectionUtils.isEmpty((Collection)priceFormIdList)) {
                DictModel dictModel = (DictModel)priceFormIdList.get(0);
                all.put("formid", dictModel.getValue());
            }
            all.put("createrid", SysUtil.getLoginUser().getSubAccount());
            PurchaseInformationRecords first = (PurchaseInformationRecords)((Object)submitAuditLists.get(0));
            all.put("djsxrq", null != first.getEffectiveDate() ? stf.format(first.getEffectiveDate()) : null);
            String str = JSON.toJSONString(all);
            ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.SubmitAudit_PriceMasterData_OA.getValue(), str);
            JSONObject jsonObject = JSON.parseObject((String)returnSRMBaseVO.getData());
            Integer code = (Integer)jsonObject.get((Object)"code");
            if (null != code && code == 1) {
                throw new RuntimeException("\u63d0\u4ea4\u521b\u5efaOA\u6d41\u7a0b\u9519\u8bef:" + (String)jsonObject.get((Object)"msg"));
            }
            String errorCode = (String)jsonObject.get((Object)"errorCode");
            if (StringUtils.isNotBlank((CharSequence)errorCode) && errorCode.equals("002")) {
                throw new RuntimeException("\u63d0\u4ea4\u521b\u5efaOA\u6d41\u7a0b\u9519\u8bef:" + (String)jsonObject.get((Object)"msg"));
            }
            String data = (String)jsonObject.get((Object)"data");
            submitAuditLists.forEach(o -> o.setFbk4(data).setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue()));
            this.updateBatchById(submitAuditLists);
        }
    }

    @Override
    public void submitAuditNoChoice(List<PurchaseInformationRecords> list, PurchaseInformationRecordsSubmitVO submitVO) {
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<String> idList = new ArrayList<String>();
            PurchaseInformationRecords records = list.get(0);
            list.forEach(var -> {
                if (!var.getAuditStatus().equals(AuditStatusEnum.AUDIT_NEW.getValue()) && !var.getAuditStatus().equals(AuditStatusEnum.AUDIT_REJECT.getValue())) {
                    throw new RuntimeException("\u4ef7\u683c\u8bb0\u5f55\u53f7" + var.getInfoRecordNumber() + "\u7684\u72b6\u6001\u4e0d\u6b63\u786e");
                }
                idList.add(var.getId());
            });
            List<PurchaseInformationRecordsSubmitDTVO> submitDTVOS = submitVO.getSubmitDTVOS();
            if (CollectionUtils.isEmpty(submitDTVOS)) {
                this.submitAudit(idList, submitVO);
            } else {
                this.submitAuditNew(idList, submitVO);
            }
        } else {
            throw new RuntimeException("\u5f53\u524d\u5355\u636e\u4e0b\u65e0\u53ef\u63d0\u4ea4\u5355\u636e");
        }
    }

    void handlePrice(PurchaseInformationRecords item, Map<String, Object> map) {
        BigDecimal price = item.getPrice();
        map.put("dzj", price);
        BigDecimal priceLast = this.purchaseReconciliationRpcService.findByInformationRecords(item.getMaterialNumber(), item.getFactory(), item.getToElsAccount());
        map.put("ydjy", priceLast);
        BigDecimal cj = price.subtract(priceLast);
        map.put("cjc", price.subtract(priceLast));
        if (priceLast.compareTo(new BigDecimal(0)) == 0) {
            map.put("zfbfb", "0");
        } else {
            map.put("zfbfb", cj.multiply(new BigDecimal(100)).divide(priceLast, 2, 4));
        }
    }

    void handleDileInfo(PurchaseInformationRecordsSubmitVO submitVO, Map<String, Object> all) {
        ArrayList fileMapList = new ArrayList();
        List<PurchaseAttachmentDTO> purchaseAttachmentList = submitVO.getPurchaseAttachmentList();
        String fjUrl = submitVO.getFjUrl();
        if (StringUtils.isNotBlank((CharSequence)fjUrl)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fjName", "\u4ef7\u683c\u660e\u7ec6.xls");
            map.put("fjUrl", fjUrl);
            fileMapList.add(map);
        }
        if (!CollectionUtils.isEmpty(purchaseAttachmentList)) {
            purchaseAttachmentList.forEach(fileItem -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fjName", fileItem.getFileName());
                map.put("fjUrl", this.fileStoreSignServiceImpl.getDownloadPath(fileItem.getFilePath(), fileItem.getSaveType()));
                fileMapList.add(map);
            });
        }
        all.put("fjsc", fileMapList);
    }

    private String toJsonForPriceMasterData(List<PurchaseInformationRecords> headList, String type) {
        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap all = new HashMap();
        HashMap<String, String> parameterList = new HashMap<String, String>();
        HashMap<String, Object> T_DATA = new HashMap<String, Object>();
        T_DATA.put("tableName", "T_DATA");
        ArrayList T_DATAList = new ArrayList();
        if (!CollectionUtils.isEmpty(headList)) {
            headList.forEach(applyHead -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("MATNR", applyHead.getMaterialNumber());
                map.put("MAKTX", applyHead.getMaterialDesc());
                map.put("LIFNR", applyHead.getSupplierCode());
                map.put("NAME1", applyHead.getSupplierName());
                map.put("ESOKZ", applyHead.getRecordType());
                map.put("EKORG", applyHead.getPurchaseOrg());
                String purchaseOrg = applyHead.getPurchaseOrg();
                PurchaseOrganizationInfoDTO purchaseOrgInfo = this.findOrgInfoByCode(applyHead.getElsAccount(), "purchaseOrganization", purchaseOrg);
                if (null != purchaseOrgInfo) {
                    map.put("EKOTX", purchaseOrgInfo.getOrgName());
                }
                map.put("WERKS", applyHead.getFactory());
                map.put("PLIFZ", applyHead.getDeliveryDays());
                map.put("EKGRP", applyHead.getPurchaseGroup());
                map.put("MWSKZ", applyHead.getTaxCode());
                map.put("UEBTO", applyHead.getOverDeliveryTolerance());
                map.put("DATAB", stf.format(applyHead.getEffectiveDate()));
                map.put("DATBI", stf.format(applyHead.getExpiryDate()));
                map.put("KSTBM", null);
                this.handleKBETR((PurchaseInformationRecords)((Object)applyHead), (Map<String, Object>)map);
                map.put("KONWA", applyHead.getCurrencyCode());
                map.put("KPEIN", applyHead.getPriceUnit());
                map.put("KMEIN", applyHead.getPurchaseUnit());
                map.put("KSTBM1", null);
                map.put("KBETR1", null);
                map.put("ZINFNR", applyHead.getInfoRecordNumber());
                map.put("MEINS", applyHead.getPurchaseUnit());
                map.put("UMREZ", applyHead.getFbk17());
                map.put("UMREN", applyHead.getFbk18());
                if (StringUtils.isNotBlank((CharSequence)type)) {
                    map.put("INFNR", applyHead.getSourceNumber());
                }
                T_DATAList.add(map);
            });
            PurchaseInformationRecords applyHeadOne = headList.get(0);
            if (StringUtils.isBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)applyHeadOne.getFbk13())) {
                parameterList.put("I_TGBS", applyHeadOne.getFbk13());
            } else {
                parameterList.put("I_TGBS", "4");
            }
        }
        T_DATA.put("tableFields0", T_DATAList);
        all.put("T_DATA", T_DATA);
        all.put("parameterList", parameterList);
        String jsonString = JSON.toJSONString(all);
        return jsonString;
    }

    void handleKBETR(PurchaseInformationRecords applyHead, Map<String, Object> map) {
        BigDecimal priceUnit;
        BigDecimal price = applyHead.getPrice();
        if (null != price.multiply(priceUnit = new BigDecimal(applyHead.getPriceUnit()))) {
            String KBETR = price.multiply(priceUnit).toString();
            if (KBETR.contains(".")) {
                String[] arr = KBETR.split("\\.");
                if (arr[1].length() > 2) {
                    String strF = arr[1].substring(0, 2);
                    String strS = arr[1].substring(2, arr[1].length()).replaceAll("0+$", "");
                    System.out.println();
                    map.put("KBETR", arr[0] + "." + strF + strS);
                } else {
                    map.put("KBETR", price.multiply(priceUnit) + "0");
                }
            } else {
                map.put("KBETR", price.multiply(priceUnit) + ".00");
            }
        }
    }

    PurchaseOrganizationInfoDTO findOrgInfoByCode(String elsAccount, String orgType, String orgCode) {
        PurchaseOrganizationInfoDTO orgInfo = this.purchaseOrganizationInfoRpcService.selectByElsAccountAndCode(elsAccount, orgType, orgCode);
        return orgInfo;
    }

    @Override
    public void insertInfomationRecordsBatch(ArrayList<PurchaseInformationRecords> copyProperties) {
        this.saveBatch(copyProperties);
    }

    @Override
    public boolean checkPriceIfCreateByType(PurchaseInformationRecords records) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseInformationRecords::getSourceNumber, (Object)records.getSourceNumber())).eq(PurchaseInformationRecords::getSourceItemNumber, (Object)records.getSourceItemNumber())).eq(PurchaseInformationRecords::getAuditStatus, (Object)records.getAuditStatus())).eq(PurchaseInformationRecords::getPriceType, (Object)records.getPriceType())).eq(PurchaseInformationRecords::getSourceType, (Object)records.getSourceType());
        return ((PurchaseInformationRecordsMapper)this.baseMapper).selectCount((Wrapper)wrapper) > 0;
    }

    @Override
    public List<String> checkPriceForSome(List<String> stringList) {
        List<PurchaseInformationRecords> purchaseInformationRecords = ((PurchaseInformationRecordsMapper)this.baseMapper).checkPriceForSome(stringList);
        return purchaseInformationRecords.parallelStream().map(o -> o.getMaterialNumber() + "_" + o.getFactory() + "_" + o.getPurchaseOrg()).distinct().collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePriceStatusForJob() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DateTime date = DateUtil.date();
        param.put("nowDate", date);
        List<PurchaseInformationRecords> records = ((PurchaseInformationRecordsMapper)this.baseMapper).selectWithoutElsAccountToChangeStatus(param);
        ArrayList<PurchaseInformationRecords> updateRecords = new ArrayList<PurchaseInformationRecords>(records.size() / 2);
        for (PurchaseInformationRecords item : records) {
            if (null != item.getEffectiveDate() && item.getEffectiveDate().before((Date)date)) {
                item.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
            }
            if (null != item.getExpiryDate() && item.getExpiryDate().before((Date)date)) {
                item.setRecordStatus(PriceStatusEnum.INVALID.getValue());
            }
            updateRecords.add(item);
        }
        this.updateBatchById(updateRecords);
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPriceMainData", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List recordsList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseInformationRecords records : recordsList) {
            this.pushDataToErp(records);
        }
    }

    @Override
    public void pullPriceSAP(String materialNumber) {
        String elsAccount = TenantContext.getTenant();
        TemplateHead templateHead = this.getTemplateHead(elsAccount);
        ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_PRICE_SAP.getValue(), this.toJson(materialNumber));
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        String e_type = returnMap.getString("E_TYPE");
        if ("E".equals(e_type)) {
            throw new ELSBootException("\u4ef7\u683c\u4e3b\u6570\u636e" + returnMap.getString("E_MESSAGE"));
        }
        String et_eina = returnMap.getString("ET_EINA");
        List list = JSONArray.parseArray((String)et_eina, PurchaseInformationRecordsSAPVO.class);
        Set<String> InfoNumberSet = list.stream().map(PurchaseInformationRecordsSAPVO::getSourceNumber).collect(Collectors.toSet());
        this.purchaseInformationRecordsMapper.deleteByInfoNumber(InfoNumberSet);
        ArrayList<PurchaseInformationRecordsSAPVO> informationRecordsSAPVOList = new ArrayList<PurchaseInformationRecordsSAPVO>();
        list.forEach(var -> {
            var.setInfoRecordNumber(this.codeGeneratorService.getNextCode("srmPriceNumber", (Object)""));
            var.setSourceType("SAP");
            if (var.getDeleted().equals("X")) {
                var.setDeleted("1");
            } else {
                var.setDeleted("0");
            }
            var.setSupplierCode(var.getSupplierCode().replaceAll("^0*", ""));
            var.setFactory(var.getFactory() + "_" + var.getFbk30());
            var.setMaterialNumber(var.getMaterialNumber().replaceAll("^0*", ""));
            var.setId(IdWorker.getIdStr());
            var.setElsAccount(elsAccount);
            var.setCreateBy("interface");
            var.setUpdateBy("interface");
            var.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            var.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
            var.setCreateTime(new Date());
            var.setUpdateTime(new Date());
            var.setTemplateAccount(templateHead.getElsAccount());
            var.setTemplateNumber(templateHead.getTemplateNumber());
            var.setTemplateVersion(templateHead.getTemplateVersion());
            var.setTemplateName(templateHead.getTemplateName());
            var.setPrice(var.getPrice().divide(new BigDecimal(var.getPriceUnit()).setScale(6, RoundingMode.HALF_UP)));
            var.setFactory(var.getFactory().split("_")[0]);
            if (StringUtils.isNotBlank((CharSequence)var.getTaxCode())) {
                ElsTax oneElsTaxByCode = this.elsTaxService.getOneElsTaxByCode(elsAccount, var.getTaxCode());
                var.setTaxRate(oneElsTaxByCode.getTaxRate() + "");
                BigDecimal netPrice = var.getPrice().divide(BigDecimal.ONE.add(new BigDecimal(oneElsTaxByCode.getTaxRate()).divide(new BigDecimal(100))), 6, 4);
                var.setNetPrice(netPrice);
            }
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)lambdaQueryWrapper.eq(SupplierMasterData::getSupplierCode, (Object)var.getSupplierCode().replaceAll("^0*", ""))).last("limit 1");
            SupplierMasterData supplierMasterData = (SupplierMasterData)this.supplierMasterDataMapper.selectOne((Wrapper)lambdaQueryWrapper);
            if (supplierMasterData != null && var.getPrice().compareTo(BigDecimal.ZERO) == 1 && var.getEffectiveDate() != null && var.getExpiryDate() != null) {
                var.setToElsAccount(supplierMasterData.getToElsAccount());
                var.setSupplierName(supplierMasterData.getSupplierName());
                informationRecordsSAPVOList.add((PurchaseInformationRecordsSAPVO)var);
            }
        });
        if (!CollectionUtils.isEmpty(informationRecordsSAPVOList)) {
            this.purchaseInformationRecordsMapper.replaceAllPriceRecord(informationRecordsSAPVOList);
        }
    }

    private String toJson(String materialNumber) {
        HashMap all = new HashMap();
        HashMap<String, String> IT_WERKS = new HashMap<String, String>();
        IT_WERKS.put("tableName", "IT_WERKS");
        HashMap<String, String> ET_EINA = new HashMap<String, String>();
        ET_EINA.put("tableName", "ET_EINA");
        HashMap<String, String> IT_LIFNR = new HashMap<String, String>();
        IT_LIFNR.put("tableName", "IT_LIFNR");
        HashMap parameterList = new HashMap();
        HashMap<String, Object> IT_MATNR = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("MATNR", materialNumber);
        list.add(hashMap);
        IT_MATNR.put("tableName", "IT_MATNR");
        IT_MATNR.put("tableFields2", list);
        all.put("IT_WERKS", IT_WERKS);
        all.put("ET_EINA", ET_EINA);
        all.put("IT_LIFNR", IT_LIFNR);
        all.put("parameterList", parameterList);
        all.put("IT_MATNR", IT_MATNR);
        return JSON.toJSONString(all);
    }

    private ReturnSRMBaseVO callSAPInterFace(String businessType, String json) {
        SRMRequestBaseVO baseVO = new SRMRequestBaseVO();
        baseVO.setElsAccount("100000");
        baseVO.setBusinessType(businessType);
        baseVO.setData(json);
        return this.srmCallInterfaceUtil.srmCallInterface(baseVO);
    }

    private TemplateHead getTemplateHead(String elsAccount) {
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        List list = this.templateHeadService.getAllByAccountAndType(elsAccount, "price");
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return (TemplateHead)list.get(0);
    }

    private void pushDataToErp(PurchaseInformationRecords records) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPriceMainData", (Object)records);
    }

    @Override
    public Map<String, PurchaseInformationRecords> refundPrice(PurchaseInformationRecords record) {
        List<PurchaseMaterialItem> materialList = record.getMaterialList();
        List<String> materialNumberList = materialList.stream().map(PurchaseMaterialItem::getMaterialNumber).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialList)) {
            throw new ELSBootException("\u7269\u6599\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)record.getToElsAccount())) {
            throw new ELSBootException("\u4f9b\u5e94\u5546\u79df\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)record.getFactory())) {
            throw new ELSBootException("\u5de5\u5382\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_deleted", (Object)"0");
        queryWrapper.in((Object)"material_number", materialNumberList);
        queryWrapper.eq((Object)"to_els_account", (Object)record.getToElsAccount());
        queryWrapper.eq((Object)"factory", (Object)record.getFactory());
        queryWrapper.eq((Object)"record_status", (Object)PriceStatusEnum.EFFECTIVE.getValue());
        List recordsList = this.list((Wrapper)queryWrapper);
        HashMap<String, PurchaseInformationRecords> map = new HashMap<String, PurchaseInformationRecords>();
        materialNumberList.forEach(materialNumber -> {
            List<PurchaseInformationRecords> list = recordsList.stream().filter(v -> v.getMaterialNumber().equals(materialNumber)).collect(Collectors.toList());
            PurchaseMaterialItem purchaseMaterialItem = materialList.stream().filter(v -> v.getMaterialNumber().equals(materialNumber)).findAny().orElse(null);
            if (!CollectionUtils.isEmpty(list)) {
                list.forEach(records -> {
                    records.setMaterialGroup(purchaseMaterialItem.getMaterialGroup());
                    records.setMaterialDesc(purchaseMaterialItem.getMaterialDesc());
                    this.handleDefault((PurchaseInformationRecords)((Object)((Object)records)));
                    if (map.containsKey(materialNumber)) {
                        PurchaseInformationRecords mapRecords = (PurchaseInformationRecords)((Object)((Object)((Object)map.get(materialNumber))));
                        if (records.getCreateTime().compareTo(mapRecords.getCreateTime()) > 0) {
                            map.put((String)materialNumber, (PurchaseInformationRecords)((Object)records));
                        }
                    } else {
                        map.put((String)materialNumber, (PurchaseInformationRecords)((Object)records));
                    }
                });
            } else {
                PurchaseInformationRecords records2 = new PurchaseInformationRecords();
                BeanUtils.copyProperties((Object)((Object)purchaseMaterialItem), (Object)((Object)records2), (String[])new String[]{"fbk2", "fbk3", "fbk4", "fbk5"});
                this.handleDefault(records2);
                records2.setPurchaseUnit(purchaseMaterialItem.getBaseUnit());
                map.put((String)materialNumber, records2);
            }
        });
        return map;
    }

    void handleDefault(PurchaseInformationRecords records) {
        records.setTaxRate(StringUtils.isNotBlank((CharSequence)records.getTaxRate()) ? records.getTaxRate() : "13");
        records.setTaxCode(StringUtils.isNotBlank((CharSequence)records.getTaxCode()) ? records.getTaxCode() : "J2");
        records.setCurrency("CNY");
        records.setFbk5(StringUtils.isNotBlank((CharSequence)records.getFbk5()) ? records.getFbk5() : "1");
        records.setFbk4("121");
        records.setItemStatus("1");
        records.setFbk11("0");
        records.setOverTolerance(new BigDecimal(5));
    }

    @Override
    public void purchasePriceCreate(List<String> idList) {
        if (!CollectionUtils.isEmpty(idList)) {
            if (idList.size() > 20) {
                throw new ELSBootException("\u5931\u8d25\u91cd\u65b0\u63a8\u9001SAP\u6700\u591a\u53ea\u80fd\u9009\u62e9\u4e8c\u5341\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus transactionStatus = this.txManager.getTransaction((TransactionDefinition)def);
            List headList = this.listByIds(idList);
            ArrayList<PurchaseInformationRecords> headNewList = new ArrayList<PurchaseInformationRecords>();
            int resultInt = 0;
            for (int i = 0; i < headList.size(); ++i) {
                PurchaseInformationRecords head = (PurchaseInformationRecords)((Object)headList.get(i));
                String returnState = head.getReturnState();
                if (StringUtils.isNotBlank((CharSequence)returnState) && returnState.equals("1")) {
                    ++resultInt;
                    continue;
                }
                headNewList.add(head);
            }
            if (resultInt == headList.size()) {
                throw new ELSBootException("\u5f53\u524d\u6240\u9009\u62e9\u6570\u636e\u5747\u5df2\u540c\u6b65\u6210\u529f\uff0c\u65e0\u9700\u91cd\u590d\u540c\u6b65");
            }
            Boolean result = this.sendSAPManual(headNewList);
            this.txManager.commit(transactionStatus);
            if (result.booleanValue()) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5b58\u5728\u540c\u6b65\u5931\u8d25\u7684\u6570\u636e\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u539f\u56e0\uff01"));
            }
        }
    }

    Boolean sendSAPManual(List<PurchaseInformationRecords> headList) {
        ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_PriceMasterData_SAP.getValue(), this.toJsonForPriceMasterData(headList, null));
        String status = returnSRMBaseVO.getStatus();
        if (StringUtils.isNotBlank((CharSequence)status) && status.equals("E")) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)returnSRMBaseVO.getMessage()));
        }
        String data = returnSRMBaseVO.getData();
        JSONObject returnMap = JSON.parseObject((String)data);
        Map map = returnMap.getInnerMap();
        List tReturnList = (List)map.get("T_DATA");
        Boolean result = false;
        if (tReturnList.isEmpty()) {
            result = true;
            headList.forEach(o -> o.setReturnState("2").setInterfaceMsg("SAP\u8fd4\u56de\u6d88\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u627e\u539f\u56e0").setRecordStatus(PriceStatusEnum.NORMAL.getValue()));
        }
        ArrayList<PurchaseInformationRecords> successList = new ArrayList<PurchaseInformationRecords>();
        for (Map tReturn : tReturnList) {
            for (PurchaseInformationRecords head : headList) {
                String type;
                String ZINFNR = tReturn.get("ZINFNR").toString();
                if (!StringUtils.isNotBlank((CharSequence)ZINFNR) || !ZINFNR.equals(head.getInfoRecordNumber())) continue;
                if (null == tReturn.get("TYPE")) {
                    head.setReturnState("2").setInterfaceMsg("SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u627e\u539f\u56e0").setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    result = true;
                }
                if (!(type = tReturn.get("TYPE").toString()).equals("S")) {
                    head.setReturnState("2").setInterfaceMsg(I18nUtil.translate((String)"", (String)("SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + tReturn.get("MESSAGE").toString()))).setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    result = true;
                    continue;
                }
                head.setReturnState("1").setInterfaceMsg("").setSourceNumber(tReturn.get("INFNR").toString()).setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue()).setFbk17(tReturn.get("UMREZ").toString()).setFbk18(tReturn.get("UMREN").toString()).setFbk19(tReturn.get("LMEIN").toString());
                successList.add(head);
            }
        }
        this.updateBatchById(headList);
        if (!CollectionUtils.isEmpty(successList)) {
            this.createMaterialSource(successList);
        }
        return result;
    }

    @Override
    public void sendSAPJob(String elsAccount) {
        List<Object> list = new ArrayList();
        TenantContext.setTenant((String)elsAccount);
        list = this.purchaseInformationRecordsMapper.selectListByStatus(PriceStatusEnum.NORMAL.getValue(), "0", elsAccount);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, List<PurchaseInformationRecords>> map = list.stream().filter(var -> StringUtils.isNotBlank((CharSequence)var.getFbk13())).collect(Collectors.groupingBy(PurchaseInformationRecords::getFbk13));
            for (String fbk13 : map.keySet()) {
                List<PurchaseInformationRecords> sendList = map.get(fbk13);
                if (sendList.size() <= 50) {
                    this.sendSAP(sendList);
                    continue;
                }
                List partition = Lists.partition(sendList, (int)50);
                if (CollectionUtils.isEmpty((Collection)partition)) continue;
                for (List varList : partition) {
                    this.sendSAP(varList);
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new ELSBootException("\u8bf7\u9009\u4e2d\u6570\u636e\u8fdb\u884c\u4f5c\u5e9f");
        }
        List list = this.listByIds(idList);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map<String, List<PurchaseInformationRecords>> map = list.stream().filter(var -> StringUtils.isNotBlank((CharSequence)var.getFbk13())).collect(Collectors.groupingBy(PurchaseInformationRecords::getFbk13));
            if (map.size() > 1) {
                throw new ELSBootException("\u5b58\u5728\u4e0d\u540c\u4ef7\u683c\u91c7\u8d2d\u6a21\u5f0f\u7684\u884c\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u63d0\u4ea4\u6279\u91cf\u4f5c\u5e9f");
            }
            StringBuffer sb = new StringBuffer();
            ArrayList<PurchaseInformationRecords> updateList = new ArrayList<PurchaseInformationRecords>();
            ArrayList<PurchaseInformationRecords> sendList = new ArrayList<PurchaseInformationRecords>();
            for (PurchaseInformationRecords records : list) {
                String auditStatus = records.getAuditStatus();
                if (StringUtils.isNotBlank((CharSequence)auditStatus) && !auditStatus.equals(AuditStatusEnum.AUDIT_FINISH.getValue()) && !auditStatus.equals(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue())) {
                    if (StringUtils.isNotBlank((CharSequence)sb) || sb.toString().equals("")) {
                        sb.append(records.getMaterialNumber() + "\u7269\u6599" + records.getFactory() + "\u5de5\u5382");
                    } else {
                        sb.append(records.getMaterialNumber() + "\u7269\u6599" + records.getFactory() + "\u5de5\u5382").append("\u3001");
                    }
                }
                records.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
                String returnState = records.getReturnState();
                String sourceType = records.getSourceType();
                if (StringUtils.isNotBlank((CharSequence)returnState) && returnState.equals("1") || StringUtils.isNotBlank((CharSequence)sourceType) && sourceType.equals("SAP")) {
                    sendList.add(records);
                    continue;
                }
                updateList.add(records);
            }
            if (StringUtils.isNotBlank((CharSequence)sb)) {
                throw new ELSBootException(sb + ",\u4e0d\u7b26\u5408\u4f5c\u5e9f\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            }
            ArrayList<PurchaseInformationRecords> sendSuccessList = new ArrayList<PurchaseInformationRecords>();
            this.sendSAPCancel(sendList, updateList, sendSuccessList);
        }
    }

    void sendSAPCancel(List<PurchaseInformationRecords> sendList, List<PurchaseInformationRecords> updateList, List<PurchaseInformationRecords> sendSuccessList) {
        StringBuffer sbFail = new StringBuffer();
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus transactionStatus = this.txManager.getTransaction((TransactionDefinition)def);
        if (!CollectionUtils.isEmpty(sendList)) {
            ReturnSRMBaseVO returnSRMBaseVO = this.callSAPInterFace(SrmInterfaceCodeEnum.PULL_PriceMasterData_SAP.getValue(), this.toJsonForPriceMasterData(sendList, PriceStatusEnum.FROZEN.getValue()));
            String data = returnSRMBaseVO.getData();
            JSONObject returnMap = JSON.parseObject((String)data);
            Map map = returnMap.getInnerMap();
            List tReturnList = (List)map.get("T_DATA");
            if (tReturnList.isEmpty()) {
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.updateBatchById(updateList);
                }
                this.txManager.commit(transactionStatus);
                throw new ELSBootException("SAP\u8fd4\u56de\u6d88\u606f\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u627e\u539f\u56e0");
            }
            tReturnList.forEach(tReturn -> sendList.forEach(head -> {
                String ZINFNR = tReturn.get("ZINFNR").toString();
                if (StringUtils.isNotBlank((CharSequence)ZINFNR) && ZINFNR.equals(head.getInfoRecordNumber())) {
                    if (null == tReturn.get("TYPE") || tReturn.get("TYPE").equals("")) {
                        if (StringUtils.isNotBlank((CharSequence)sbFail) || sbFail.toString().equals("")) {
                            sbFail.append(head.getMaterialNumber() + "\u7269\u6599" + head.getFactory() + "\u5de5\u5382SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
                        } else {
                            sbFail.append(head.getMaterialNumber() + "\u7269\u6599" + head.getFactory() + "\u5de5\u5382SAP\u8fd4\u56de\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a").append("\u3001");
                        }
                    } else {
                        String type = tReturn.get("TYPE").toString();
                        if (!type.equals("S")) {
                            if (StringUtils.isNotBlank((CharSequence)sbFail) || sbFail.toString().equals("")) {
                                sbFail.append(head.getMaterialNumber() + "\u7269\u6599" + head.getFactory() + "\u5de5\u5382" + tReturn.get("MESSAGE").toString());
                            } else {
                                sbFail.append(head.getMaterialNumber() + "\u7269\u6599" + head.getFactory() + "\u5de5\u5382" + tReturn.get("MESSAGE").toString()).append("\u3001");
                            }
                        } else {
                            sendSuccessList.add((PurchaseInformationRecords)((Object)head));
                        }
                    }
                }
            }));
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
        if (!CollectionUtils.isEmpty(sendSuccessList)) {
            this.updateBatchById(sendSuccessList);
        }
        this.txManager.commit(transactionStatus);
        if (StringUtils.isNotBlank((CharSequence)sbFail)) {
            throw new ELSBootException(sbFail.toString());
        }
    }
}

