/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.mapper.PurchaseMaterialHeadMapper;
import com.els.modules.material.mapper.PurchaseMaterialItemMapper;
import com.els.modules.material.mapper.PurchaseMaterialUnitMapper;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import com.els.modules.third.base.util.ClassCompareUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import com.els.rpc.service.ManualTransactionManagementService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseMaterialHeadServiceImpl
extends BaseOpenServiceImpl<PurchaseMaterialHeadMapper, PurchaseMaterialHead, PurchaseMaterialHeadVO>
implements PurchaseMaterialHeadService {
    @Resource
    private PurchaseMaterialHeadMapper purchaseMaterialHeadMapper;
    @Resource
    private PurchaseMaterialItemMapper purchaseMaterialItemMapper;
    @Resource
    private PurchaseMaterialItemService purchaseMaterialItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialUnitMapper purchaseMaterialUnitMapper;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private ManualTransactionManagementService manualTransactionManagementService;
    @Resource
    private RedisUtil redisUtil;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";
    private static final String PURCHASE_MATERIAL_UNIT_IS_DEFAULT = "1";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseMaterialHead head, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList, List<PurchaseAttachmentDTO> attachmentList) {
        this.checkMaterialNumber(head);
        purchaseMaterialUnitList = this.generateUnit(head, purchaseMaterialUnitList);
        for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
            if (unit.getObjectUnit() == null || "".equals(unit.getObjectUnit())) {
                unit.setObjectUnit(head.getBaseUnit());
            }
            if (PURCHASE_UNIT_TYPE.equals(unit.getType())) {
                head.setPurchaseUnit(unit.getObjectUnit());
                continue;
            }
            if (!"1".equals(unit.getType())) continue;
            head.setRepertoryUnit(unit.getObjectUnit());
        }
        this.checkMaterialItem(purchaseMaterialItemList);
        if (!"1".equals(head.getNeedAudit())) {
            head.setNeedAudit(PURCHASE_UNIT_TYPE);
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        head.setSubmitStatus(PURCHASE_UNIT_TYPE);
        this.purchaseMaterialHeadMapper.insert((Object)head);
        this.insertData(head, purchaseMaterialItemList, purchaseMaterialUnitList, attachmentList);
    }

    private List<PurchaseMaterialUnit> generateUnit(PurchaseMaterialHead purchaseMaterialHead, List<PurchaseMaterialUnit> purchaseMaterialUnitList) {
        if (purchaseMaterialUnitList == null || CollectionUtil.isEmpty(purchaseMaterialUnitList)) {
            purchaseMaterialUnitList = new ArrayList<PurchaseMaterialUnit>();
            PurchaseMaterialUnit purchaseUnit = new PurchaseMaterialUnit();
            purchaseUnit.setType(PURCHASE_UNIT_TYPE);
            purchaseUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
            purchaseUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
            purchaseUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
            purchaseUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
            purchaseUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
            purchaseUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
            purchaseUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
            purchaseUnit.setDeleted(purchaseMaterialHead.getDeleted());
            purchaseUnit.setBasicAmount(BigDecimal.ONE);
            purchaseUnit.setObjectAmount(BigDecimal.ONE);
            purchaseUnit.setChangeUnit("=");
            purchaseUnit.setIsDefault("1");
            purchaseMaterialUnitList.add(purchaseUnit);
            PurchaseMaterialUnit repertoryUnit = new PurchaseMaterialUnit();
            repertoryUnit.setType("1");
            repertoryUnit.setBasicUnit(purchaseMaterialHead.getBaseUnit());
            repertoryUnit.setObjectUnit(purchaseMaterialHead.getBaseUnit());
            repertoryUnit.setElsAccount(purchaseMaterialHead.getElsAccount());
            repertoryUnit.setCreateBy(purchaseMaterialHead.getCreateBy());
            repertoryUnit.setCreateTime(purchaseMaterialHead.getCreateTime());
            repertoryUnit.setUpdateBy(purchaseMaterialHead.getUpdateBy());
            repertoryUnit.setCreateTime(purchaseMaterialHead.getUpdateTime());
            repertoryUnit.setDeleted(purchaseMaterialHead.getDeleted());
            repertoryUnit.setBasicAmount(BigDecimal.ONE);
            repertoryUnit.setObjectAmount(BigDecimal.ONE);
            repertoryUnit.setChangeUnit("=");
            repertoryUnit.setIsDefault("1");
            purchaseMaterialUnitList.add(repertoryUnit);
        }
        return purchaseMaterialUnitList;
    }

    private void checkMaterialNumber(PurchaseMaterialHead purchaseMaterialHead) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)purchaseMaterialHead.getMaterialNumber())).ne(StrUtil.isNotBlank((CharSequence)purchaseMaterialHead.getId()), BaseEntity::getId, (Object)purchaseMaterialHead.getId())).last(" limit 1");
        PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)((PurchaseMaterialHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (null != head) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_MKdejSLAyWWWWWW_fe5429fb", (String)("\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u7f16\u53f7\uff1a" + purchaseMaterialHead.getMaterialNumber()), (String[])new String[]{purchaseMaterialHead.getMaterialNumber()}));
        }
    }

    private void checkMaterialItem(List<PurchaseMaterialItem> purchaseMaterialItemList) {
        List stringList = purchaseMaterialItemList.stream().map(PurchaseMaterialItem::getFactory).collect(Collectors.toList());
        long count = stringList.stream().distinct().count();
        if ((long)stringList.size() != count) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_SLcsMKdejRHW_ba2f6f5", (String)"\u7269\u6599\u884c\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u5de5\u5382\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMaterialHead head, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList, List<PurchaseAttachmentDTO> attachmentList) {
        if ("1".equals(head.getAutoCreateCode()) && StrUtil.isBlank((CharSequence)head.getMaterialNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmMaterialNumber", (Object)head);
            head.setMaterialNumber(nextCode);
        } else if (StrUtil.isBlank((CharSequence)head.getMaterialNumber())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLAoxOLVW_47edf9d6", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        this.checkMaterialNumber(head);
        this.checkMaterialItem(purchaseMaterialItemList);
        purchaseMaterialUnitList = this.generateUnit(head, purchaseMaterialUnitList);
        for (PurchaseMaterialUnit unit : purchaseMaterialUnitList) {
            if (unit.getObjectUnit() == null || "".equals(unit.getObjectUnit())) {
                unit.setObjectUnit(head.getBaseUnit());
            }
            if (PURCHASE_UNIT_TYPE.equals(unit.getType())) {
                head.setPurchaseUnit(unit.getObjectUnit());
                continue;
            }
            if (!"1".equals(unit.getType())) continue;
            head.setRepertoryUnit(unit.getObjectUnit());
        }
        if (!"1".equals(head.getNeedAudit())) {
            head.setNeedAudit(PURCHASE_UNIT_TYPE);
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else if (BooleanUtil.isTrue((Boolean)head.isFromEditPage()) || CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus()) || CharSequenceUtil.isEmpty((CharSequence)head.getFlowId())) {
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            head.setSubmitStatus(PURCHASE_UNIT_TYPE);
        }
        int count = this.purchaseMaterialHeadMapper.updateById((Object)head);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseMaterialItemMapper.deleteByMainId(head.getId());
        this.purchaseMaterialUnitMapper.deleteByMainId(head.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(head.getId());
        this.insertData(head, purchaseMaterialItemList, purchaseMaterialUnitList, attachmentList);
    }

    private void insertData(PurchaseMaterialHead head, List<PurchaseMaterialItem> purchaseMaterialItemList, List<PurchaseMaterialUnit> purchaseMaterialUnitList, List<PurchaseAttachmentDTO> attachmentList) {
        if (CollectionUtil.isNotEmpty(purchaseMaterialItemList)) {
            for (PurchaseMaterialItem purchaseMaterialItem : purchaseMaterialItemList) {
                purchaseMaterialItem.setHeadId(head.getId());
                purchaseMaterialItem.setMaterialNumber(head.getMaterialNumber());
                SysUtil.setSysParam((BaseEntity)purchaseMaterialItem, (BaseEntity)head);
            }
            ((PurchaseMaterialItemService)SpringContextUtils.getBean(PurchaseMaterialItemService.class)).saveBatch(purchaseMaterialItemList);
        }
        if (CollectionUtil.isNotEmpty(purchaseMaterialUnitList)) {
            for (PurchaseMaterialUnit purchaseMaterialUnit : purchaseMaterialUnitList) {
                purchaseMaterialUnit.setHeadId(head.getId());
                purchaseMaterialUnit.setElsAccount(head.getElsAccount());
                SysUtil.setSysParam((BaseEntity)purchaseMaterialUnit, (BaseEntity)head);
            }
            ((PurchaseMaterialUnitService)SpringContextUtils.getBean(PurchaseMaterialUnitService.class)).saveBatch(purchaseMaterialUnitList);
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : attachmentList) {
                purchaseAttachmentDTO.setId(null);
                purchaseAttachmentDTO.setHeadId(head.getId());
                purchaseAttachmentDTO.setElsAccount(head.getElsAccount());
                purchaseAttachmentDTO.setCreateBy(head.getCreateBy());
                purchaseAttachmentDTO.setCreateTime(head.getCreateTime());
                purchaseAttachmentDTO.setUpdateBy(head.getUpdateBy());
                purchaseAttachmentDTO.setUpdateTime(head.getUpdateTime());
                purchaseAttachmentDTO.setDeleted(CommonConstant.DEL_FLAG_0);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseMaterialItemMapper.deleteByMainId(id);
        this.purchaseMaterialHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delHead(String id) {
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadMapper.selectById((Serializable)((Object)id)));
        this.purchaseMaterialItemMapper.updateByHeadId(id);
        this.purchaseMaterialHeadMapper.updateByMainId(id);
        ArrayList<PurchaseMaterialHead> materialHeadList = new ArrayList<PurchaseMaterialHead>();
        materialHeadList.add(purchaseMaterialHead);
        this.sendMallDeleteEvent(materialHeadList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        LambdaQueryWrapper head = Wrappers.lambdaQuery();
        head.select(new SFunction[]{BaseEntity::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)head.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).ne(PurchaseMaterialHead::getAuditStatus, (Object)AuditStatusEnum.AUDIT_DOING.getValue())).eq(PurchaseMaterialHead::getBlocDel, (Object)PURCHASE_UNIT_TYPE)).in(BaseEntity::getId, idList);
        List materialHeadList = ((PurchaseMaterialHeadMapper)this.baseMapper).selectList((Wrapper)head);
        if (CollectionUtil.isEmpty((Collection)materialHeadList)) {
            return;
        }
        idList = materialHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.purchaseMaterialHeadMapper.updateByHeadIds(idList);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId});
        ((LambdaQueryWrapper)wrapper.in(PurchaseMaterialItem::getHeadId, idList)).eq(PurchaseMaterialItem::getFactoryDel, (Object)PURCHASE_UNIT_TYPE);
        List itemList = this.purchaseMaterialItemMapper.selectList((Wrapper)wrapper);
        List<String> itemIds = itemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(itemIds)) {
            this.purchaseMaterialItemMapper.updateByHeadIds(itemIds);
        }
        this.sendMallDeleteEvent(materialHeadList);
    }

    private void sendMallDeleteEvent(List<PurchaseMaterialHead> materialHeadList) {
        if (CollectionUtils.isEmpty(materialHeadList)) {
            return;
        }
        List collect = materialHeadList.stream().filter(x -> "1".equals(x.getCatalog())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            log.error("\u7269\u6599\u4e0d\u662f\u76ee\u5f55\u7269\u6599\uff0c\u65e0\u9700\u63a8\u9001\u5546\u57ce\u5220\u9664\uff01");
            return;
        }
        ArrayList list = SysUtil.copyProperties(collect, PurchaseMaterialHeadDTO.class);
        MqUtil.sendOperateEventMsg((String)TenantContext.getTenant(), (String)"Material", (String)"delete", (String)"deleteMaterialDataToMall", (Object)list);
    }

    @Override
    public PurchaseMaterialHead getMaterialHeadByNumber(String materialNumber) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)materialNumber);
        List materialList = this.list((Wrapper)wrapper);
        return materialList.isEmpty() ? null : (PurchaseMaterialHead)((Object)materialList.get(0));
    }

    @Override
    public List<PurchaseMaterialHead> getMaterialHeadByNumbers(List<String> materialNumbers) {
        if (CollUtil.isEmpty(materialNumbers)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PurchaseMaterialHead::getMaterialNumber, materialNumbers);
        return ((PurchaseMaterialHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public PurchaseMaterialHead queryMaterialItemByFactory(PurchaseMaterialHead purchaseMaterialHeadPage) {
        List purchaseMaterialItemList;
        LambdaQueryWrapper purchaseMaterialHeadLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)purchaseMaterialHeadLambdaQueryWrapper.eq(PurchaseMaterialHead::getMaterialNumber, (Object)purchaseMaterialHeadPage.getMaterialNumber())).last(" limit 1");
        PurchaseMaterialHead purchaseMaterialHead = (PurchaseMaterialHead)((Object)this.purchaseMaterialHeadMapper.selectOne((Wrapper)purchaseMaterialHeadLambdaQueryWrapper));
        List<PurchaseMaterialItem> materialItemList = this.purchaseMaterialItemMapper.selectByMainId(purchaseMaterialHead.getId());
        if (CollectionUtil.isNotEmpty(materialItemList) && CollectionUtil.isNotEmpty(purchaseMaterialItemList = materialItemList.stream().filter(item -> purchaseMaterialHeadPage.getFactory().equals(item.getFactory())).collect(Collectors.toList()))) {
            PurchaseMaterialItem purchaseMaterialItem = (PurchaseMaterialItem)((Object)purchaseMaterialItemList.get(0));
            purchaseMaterialHead.setJit(purchaseMaterialItem.getJit());
            purchaseMaterialHead.setDeliveryArrange(purchaseMaterialItem.getDeliveryArrange());
        }
        return purchaseMaterialHead;
    }

    @Override
    public void getDataByErp(PurchaseMaterialHead materialHead) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getMaterialData", (Object)new JSONObject());
    }

    @Override
    public void pushMaterialByManual(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List materialList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseMaterialHead head2 : materialList) {
            this.pushMaterial(head2);
        }
    }

    @Override
    public void pushMaterial(PurchaseMaterialHead head) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushMaterialToERP", (Object)head);
    }

    @Override
    public IPage<PurchaseMaterialHead> pageHeadOrItem(Page<PurchaseMaterialHead> page, QueryWrapper<PurchaseMaterialHead> queryWrapper) {
        return ((PurchaseMaterialHeadMapper)this.baseMapper).pageHeadOrItem(page, queryWrapper);
    }

    @Override
    public Map<String, PurchaseMaterialHead> listMaterialHeadByNumbers(List<String> materialNumberList, String elsAccount) {
        if (CollUtil.isEmpty(materialNumberList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).in(PurchaseMaterialHead::getMaterialNumber, materialNumberList);
        List materialHeadList = ((PurchaseMaterialHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return materialHeadList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
    }

    @Override
    public List<PurchaseMaterialHead> listByCatalog(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseMaterialHead::getCatalog, (Object)"1");
        return ((PurchaseMaterialHeadMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<PurchaseMaterialHead> listByNumbersBySale(List<String> materialNumbers, String elsAccount) {
        return ((PurchaseMaterialHeadMapper)this.baseMapper).listByNumbersBySale(materialNumbers, elsAccount);
    }

    protected List<PurchaseMaterialHeadVO> queryDetailByOpenApi(List<PurchaseMaterialHead> headList) {
        List headIds = headList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapperItem = Wrappers.lambdaQuery();
        wrapperItem.in(PurchaseMaterialItem::getHeadId, headIds);
        List purchaseMaterialItemList = this.purchaseMaterialItemMapper.selectList((Wrapper)wrapperItem);
        Map<String, List<PurchaseMaterialItem>> itemMap = purchaseMaterialItemList.stream().collect(Collectors.groupingBy(PurchaseMaterialItem::getHeadId));
        LambdaQueryWrapper wrapperUnit = Wrappers.lambdaQuery();
        wrapperUnit.in(PurchaseMaterialUnit::getHeadId, headIds);
        List purchaseMaterialMeterUnitList = this.purchaseMaterialUnitMapper.selectList((Wrapper)wrapperUnit);
        Map<String, List<PurchaseMaterialUnit>> unitMap = purchaseMaterialMeterUnitList.stream().collect(Collectors.groupingBy(PurchaseMaterialUnit::getHeadId));
        ArrayList<PurchaseMaterialHeadVO> result = new ArrayList<PurchaseMaterialHeadVO>();
        for (PurchaseMaterialHead head : headList) {
            PurchaseMaterialHeadVO vo = new PurchaseMaterialHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)vo));
            vo.setPurchaseMaterialItemList(itemMap.get(vo.getId()));
            vo.setPurchaseMaterialMeterUnitList(unitMap.get(vo.getId()));
            result.add(vo);
        }
        return result;
    }

    public void deleteDetailByOpenApi(List<String> headIds, String halfDelete) {
        this.purchaseMaterialHeadMapper.deleteBatchIds(headIds);
        for (String id : headIds) {
            this.purchaseMaterialItemMapper.deleteByMainId(id);
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainIds(headIds);
    }

    @Override
    public void batchSaveMain(List<PurchaseMaterialHeadVO> purchaseMaterialHeadVOList, List<String> saveColumn, Integer saveLeven, String sourceType) {
        if (null == purchaseMaterialHeadVOList || purchaseMaterialHeadVOList.size() <= 0) {
            throw new ELSBootException("\u4fdd\u5b58\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String elsAccount = TenantContext.getTenant();
        String key = "batchSavePurchaseMaterial:";
        LoginUser loginUser = SysUtil.getLoginUser();
        this.batchSave(purchaseMaterialHeadVOList, saveColumn, saveLeven, sourceType, elsAccount);
    }

    void batchSave(List<PurchaseMaterialHeadVO> purchaseMaterialHeadVOList, List<String> saveColumn, Integer saveLeven, String sourceType, String elsAccount) {
        ArrayList<PurchaseMaterialHead> insertHead = new ArrayList<PurchaseMaterialHead>();
        ArrayList<PurchaseMaterialHead> updateHead = new ArrayList<PurchaseMaterialHead>();
        ArrayList insertItem = new ArrayList();
        ArrayList updateItem = new ArrayList();
        String[] fieldMapping = saveColumn.toArray(new String[saveColumn.size()]);
        Map<String, PurchaseMaterialHead> dbMaterialMap = this.getThirdMaterial(elsAccount, sourceType, purchaseMaterialHeadVOList);
        for (PurchaseMaterialHeadVO materialHeadVO : purchaseMaterialHeadVOList) {
            List<PurchaseMaterialItem> items;
            PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)SysUtil.copyProperties((Object)((Object)materialHeadVO), PurchaseMaterialHead.class));
            if (StringUtils.isBlank((String)head.getFreeze())) {
                head.setFreeze(PURCHASE_UNIT_TYPE);
            }
            if (StringUtils.isBlank((String)head.getBlocDel())) {
                head.setBlocDel(PURCHASE_UNIT_TYPE);
            }
            if (StringUtils.isBlank((String)head.getAuditStatus())) {
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            if (dbMaterialMap.containsKey(head.getMaterialNumber())) {
                PurchaseMaterialHead material = dbMaterialMap.get(head.getMaterialNumber());
                if (!ClassCompareUtil.appointCompareObject((Object)((Object)material), (Object)((Object)head), (String[])fieldMapping)) {
                    head.setId(material.getId());
                    ClassCompareUtil.merger((Object)((Object)head), (Object)((Object)material));
                    updateHead.add(head);
                }
            } else {
                insertHead.add(head);
            }
            if (saveLeven >= 2 && null != (items = materialHeadVO.getPurchaseMaterialItemList()) && items.size() > 0) continue;
        }
        if (CollUtil.isNotEmpty(insertHead)) {
            this.saveBatch(insertHead, 2000);
        }
        if (CollUtil.isNotEmpty(updateHead)) {
            this.updateBatchById(updateHead, 2000);
        }
        if (CollUtil.isNotEmpty(insertItem)) {
            this.purchaseMaterialItemService.saveBatch(insertItem, 2000);
        }
        if (CollUtil.isNotEmpty(updateItem)) {
            this.purchaseMaterialItemService.updateBatchById(updateItem, 2000);
        }
    }

    private Map<String, PurchaseMaterialHead> getThirdMaterial(String elsAccount, String sourceType, List<PurchaseMaterialHeadVO> purchaseMaterialHeadVOList) {
        List numbers = purchaseMaterialHeadVOList.stream().map(PurchaseMaterialHead::getMaterialNumber).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.in(PurchaseMaterialHead::getMaterialNumber, numbers);
        wrapper.eq(PurchaseMaterialHead::getSourceType, (Object)sourceType);
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseMaterialHead>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
    }
}

