/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service(value="purchaseMaterialMeterUnitListImportImpl")
public class PurchaseMaterialMeterUnitListImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialMeterUnitListImportImpl.class);
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseMaterialUnitService purchaseMaterialUnitService;
    @Resource
    private BaseRpcService baseRpcService;
    private static final String PURCHASE_UNIT_TYPE = "0";
    private static final String REPERTORY_UNIT_TYPE = "1";

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List meterUnitTypeDict = this.baseRpcService.queryDictItemsByCode("meterUnitType", SysUtil.getPurchaseAccount());
        List unitCodeDict = this.baseRpcService.queryDictItemsByCode("unitCode", SysUtil.getPurchaseAccount());
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<PurchaseMaterialUnitDTO> list = new ArrayList<PurchaseMaterialUnitDTO>();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        for (Object data : dataList) {
            String materialNumber = (String)data.get("materialNumber");
            if (!CharSequenceUtil.isNotBlank((CharSequence)materialNumber) || materialNumberList.contains(materialNumber)) continue;
            materialNumberList.add(materialNumber);
        }
        Map<String, PurchaseMaterialHead> materialIdMap = this.purchaseMaterialHeadService.listMaterialHeadByNumbers(materialNumberList, TenantContext.getTenant());
        for (Object data : dataList) {
            String basicUnitDict;
            String objectUnitDict;
            String typeDict;
            String type;
            String materialNumber = (String)data.get("materialNumber");
            if (CharSequenceUtil.isBlank((CharSequence)materialNumber) || !materialIdMap.containsKey(materialNumber)) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoxMKSNLV_38650b31", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u8005\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, (Map)data);
                continue;
            }
            if (materialIdMap.containsKey(materialNumber)) {
                PurchaseMaterialHead head = materialIdMap.get(materialNumber);
                if (!(AuditStatusEnum.AUDIT_NEW.getValue().equals(head.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(head.getAuditStatus()) || AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(head.getAuditStatus()))) {
                    String msg = I18nUtil.translate((String)"i18n_alert_APSLzExiTHrtRtL_20dee8fa", (String)"\u5f53\u524d\u7269\u6599\u72b6\u6001\u4e0d\u5141\u8bb8\u66f4\u6539\u8ba1\u91cf\u5355\u4f4d");
                    this.errorAdd(excelImportDTO, msg, (Map)data);
                    continue;
                }
            }
            if (!ObjectUtils.isEmpty((Object)(type = (String)data.get("type"))) && ObjectUtils.isEmpty((Object)(typeDict = meterUnitTypeDict.parallelStream().filter(o -> o.getValue().equals(type)).map(DictDTO::getText).collect(Collectors.joining())))) {
                String msg = I18nUtil.translate((String)"i18n_alert_uNjtLAcLKJCsLDVIm_c0abeab6", (String)"\u5bfc\u5165\u7684\u5355\u4f4d\u7c7b\u578b\u672a\u5728\u5b57\u5178\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u68c0\u67e5\uff01");
                this.errorAdd(excelImportDTO, msg, (Map)data);
                continue;
            }
            String objectUnit = (String)data.get("objectUnit");
            if (!ObjectUtils.isEmpty((Object)objectUnit) && ObjectUtils.isEmpty((Object)(objectUnitDict = unitCodeDict.parallelStream().filter(o -> o.getValue().equals(objectUnit)).map(DictDTO::getText).collect(Collectors.joining())))) {
                String msg = I18nUtil.translate((String)"i18n_alert_uNjtRtLLKJCsLDVIm_eb2d4814", (String)"\u5bfc\u5165\u7684\u8ba1\u91cf\u5355\u4f4d\u672a\u5728\u5b57\u5178\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u68c0\u67e5\uff01");
                this.errorAdd(excelImportDTO, msg, (Map)data);
                continue;
            }
            String basicUnit = (String)data.get("basicUnit");
            if (!ObjectUtils.isEmpty((Object)basicUnit) && ObjectUtils.isEmpty((Object)(basicUnitDict = unitCodeDict.parallelStream().filter(o -> o.getValue().equals(basicUnit)).map(DictDTO::getText).collect(Collectors.joining())))) {
                String msg = I18nUtil.translate((String)"i18n_alert_uNjtvtLLKJCsLDVIm_7faecd38", (String)"\u5bfc\u5165\u7684\u57fa\u672c\u5355\u4f4d\u672a\u5728\u5b57\u5178\u4e2d\u7ef4\u62a4\uff0c\u8bf7\u68c0\u67e5\uff01");
                this.errorAdd(excelImportDTO, msg, (Map)data);
                continue;
            }
            PurchaseMaterialUnitDTO entity = (PurchaseMaterialUnitDTO)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseMaterialUnitDTO.class);
            entity.setChangeUnit("=");
            entity.setElsAccount(TenantContext.getTenant());
            entity.setIsDefault(CharSequenceUtil.emptyToDefault((CharSequence)entity.getIsDefault(), (String)REPERTORY_UNIT_TYPE));
            list.add(entity);
        }
        ArrayList<PurchaseMaterialUnit> result = new ArrayList<PurchaseMaterialUnit>();
        for (PurchaseMaterialUnitDTO dto : list) {
            if (!materialIdMap.containsKey(dto.getMaterialNumber())) continue;
            PurchaseMaterialUnit materialUnit = (PurchaseMaterialUnit)((Object)Convert.convert(PurchaseMaterialUnit.class, (Object)dto));
            materialUnit.setHeadId(materialIdMap.get(dto.getMaterialNumber()).getId());
            materialUnit.setElsAccount(TenantContext.getTenant());
            materialUnit.setDeleted(0);
            result.add(materialUnit);
        }
        if (CollUtil.isNotEmpty(result)) {
            Map<String, List<PurchaseMaterialUnit>> collect = result.stream().collect(Collectors.groupingBy(PurchaseMaterialUnit::getHeadId));
            ArrayList heads = new ArrayList();
            collect.forEach((headId, unitList) -> {
                PurchaseMaterialHead head = new PurchaseMaterialHead();
                head.setId((String)headId);
                for (PurchaseMaterialUnit unit : unitList) {
                    if (unit.getObjectUnit() == null || "".equals(unit.getObjectUnit())) {
                        unit.setObjectUnit(head.getBaseUnit());
                    }
                    if (PURCHASE_UNIT_TYPE.equals(unit.getType())) {
                        head.setPurchaseUnit(unit.getObjectUnit());
                        continue;
                    }
                    if (!REPERTORY_UNIT_TYPE.equals(unit.getType())) continue;
                    head.setRepertoryUnit(unit.getObjectUnit());
                }
                heads.add(head);
            });
            this.purchaseMaterialUnitService.saveBatch(result);
            this.purchaseMaterialHeadService.saveOrUpdateBatch(heads);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

