/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.api.service.InquiryByIntegratedApiService;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.enquiry.api.service.PurchaseEnquiryItemRpcService;
import com.els.modules.inquiry.api.dto.PurchaseEnquiryHeadDTO;
import com.els.modules.inquiry.api.enumerate.EnquiryStatusEnum;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.service.PurchaseInformationRecordsRequestHeadService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="purchasePriceUpdateAuditStatusServiceImpl")
public class PurchasePriceUpdateAuditStatusServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePriceUpdateAuditStatusServiceImpl.class);
    @Autowired
    private InquiryByIntegratedApiService inquiryByIntegratedApiService;
    @Autowired
    private PurchaseEnquiryItemRpcService purchaseEnquiryItemRpcService;
    @Autowired
    private PurchaseInformationRecordsRequestHeadService purchaseInformationRecordsRequestHeadService;

    @SrmTransaction(rollbackFor={Exception.class})
    public JSONObject invoke(JSONObject arg0) {
        log.info("OA\u56de\u5199\u4ef7\u683c\u7533\u8bf7\u5ba1\u6279\u7ed3\u679c\u81f3SRM,\u8bf7\u6c42\u53c2\u6570arg0:{}", (Object)arg0);
        String auditStatus = arg0.getString("auditStatus");
        String requestNumber = arg0.getString("requestNumber");
        JSONObject res = new JSONObject();
        if (!StringUtils.hasLength((String)auditStatus) || !StringUtils.hasLength((String)requestNumber)) {
            res.put("result", (Object)false);
            res.put("message", (Object)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a!");
            return res;
        }
        if (!AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            res.put("result", (Object)false);
            res.put("message", (Object)"\u5ba1\u6838\u72b6\u6001\u4e0d\u5bf9!");
            return res;
        }
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseInformationRecordsRequestHead::getRequestNumber, (Object)requestNumber)).eq(BaseEntity::getDeleted, (Object)0)).last("LIMIT 1")));
        if (purchaseInformationRecordsRequestHead != null) {
            ArrayList<PurchaseInformationRecordsRequestHead> updateList = new ArrayList<PurchaseInformationRecordsRequestHead>();
            PurchaseInformationRecordsRequestHead updateRequestHead = new PurchaseInformationRecordsRequestHead();
            updateRequestHead.setId(purchaseInformationRecordsRequestHead.getId());
            updateRequestHead.setAuditStatus(auditStatus);
            updateRequestHead.setUpdateTime(new Date());
            updateRequestHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
            updateRequestHead.setUpdateById(SysUtil.getLoginUser().getId());
            updateList.add(updateRequestHead);
            boolean flag = this.purchaseInformationRecordsRequestHeadService.updateBatchById(updateList);
            if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) && !"1".equals(purchaseInformationRecordsRequestHead.getNeedSaleConfirm())) {
                log.info("\u5ba1\u6279\u901a\u8fc7\u5e76\u4e14\u4e0d\u9700\u8981\u4f9b\u5e94\u5546\u786e\u8ba4\u7684,\u76f4\u63a5\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e:{}", (Object)purchaseInformationRecordsRequestHead.getId());
                this.purchaseInformationRecordsRequestHeadService.createPriceByHead(purchaseInformationRecordsRequestHead.getId());
            }
            res.put("flag", (Object)flag);
            log.info("OA\u56de\u5199\u4ef7\u683c\u7533\u8bf7\u5ba1\u6279\u7ed3\u679c\u81f3SRM,\u8fd4\u56de\u7ed3\u679cres:{}", (Object)res);
        } else {
            PurchaseEnquiryHeadDTO enquiryHead = this.inquiryByIntegratedApiService.getEnquiryHeadByEnquiryNumber(requestNumber);
            if (enquiryHead == null) {
                res.put("result", (Object)false);
                res.put("message", (Object)"\u672a\u67e5\u8be2\u5230\u6570\u636e!");
                return res;
            }
            PurchaseEnquiryHeadDTO updatePurchaseEnquiryHead = new PurchaseEnquiryHeadDTO();
            updatePurchaseEnquiryHead.setId(enquiryHead.getId());
            updatePurchaseEnquiryHead.setAuditStatus(auditStatus);
            updatePurchaseEnquiryHead.setAuditStatus(auditStatus);
            updatePurchaseEnquiryHead.setUpdateTime(new Date());
            updatePurchaseEnquiryHead.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
            updatePurchaseEnquiryHead.setUpdateById(SysUtil.getLoginUser().getId());
            boolean flag = this.inquiryByIntegratedApiService.updateEnquiryHeadById(updatePurchaseEnquiryHead);
            if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) && "1".equals(enquiryHead.getPriceCreateWay())) {
                log.info("\u5ba1\u6279\u901a\u8fc7\u5e76\u4e14\u81ea\u52a8\u751f\u6210\u65b9\u5f0f,\u76f4\u63a5\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e,\u76f4\u63a5\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e:{}", (Object)enquiryHead.getId());
                List pricedList = this.purchaseEnquiryItemRpcService.getEnquiryItemByHeadId(enquiryHead.getId());
                List acceptList = pricedList.stream().filter(item -> EnquiryStatusEnum.ACCEPT.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
                this.inquiryByIntegratedApiService.generatePriceRecordOA(enquiryHead, acceptList);
            }
            res.put("flag", (Object)flag);
            log.info("OA\u56de\u5199\u8be2\u4ef7\u7533\u8bf7\u5ba1\u6279\u7ed3\u679c\u81f3SRM,\u8fd4\u56de\u7ed3\u679cres:{}", (Object)res);
        }
        return res;
    }
}

