/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.extend.api.service.OaTokenUtil;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestItem;
import com.els.modules.price.service.PurchaseInformationRecordsPushOAService;
import com.els.modules.price.vo.PurchaseInformationRecordsRequestHeadVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseInformationRecordsPushOAServiceImpl
implements PurchaseInformationRecordsPushOAService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseInformationRecordsPushOAServiceImpl.class);
    @Resource
    private InterfaceUtil interfaceUtil;
    @Value(value="${SYS.OA.auth.appId}")
    private String appId;
    @Value(value="${SYS.OA.flowParam.purchaseEnquiry.id}")
    private String workFlowId;
    @Value(value="${SYS.OA.flowParam.purchaseEnquiry.title}")
    private String workFlowTitle;
    @Autowired
    private OaTokenUtil oaTokenUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${SYS.OA.orgCode}")
    private String orgCode;

    @Override
    public JSONObject submitOA(PurchaseInformationRecordsRequestHeadVO vo) {
        String elsAccount = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject baseInfo = new JSONObject();
        baseInfo.put("workflowId", (Object)this.workFlowId);
        baseInfo.put("requestName", (Object)this.workFlowTitle);
        baseInfo.put("mainData", this.getMainData(vo, loginUser));
        JSONObject headParam = new JSONObject();
        headParam.put("appid", (Object)this.appId);
        String spk = (String)this.redisUtil.get("oa_spk");
        RSA rsa = new RSA(null, spk);
        String encryptUserid = rsa.encryptBase64(loginUser.getSubAccount(), CharsetUtil.CHARSET_UTF_8, KeyType.PublicKey);
        headParam.put("userid", (Object)encryptUserid);
        JSONObject root = new JSONObject();
        root.put("body", (Object)baseInfo);
        JSONObject jsonObject = this.interfaceUtil.callInterface(elsAccount, null, root, null);
        log.info("result=={}", (Object)JSONObject.toJSONString((Object)jsonObject));
        return jsonObject;
    }

    private List<Map<String, Object>> getMainData(PurchaseInformationRecordsRequestHeadVO vo, LoginUser loginUser) {
        ArrayList<Map<String, Object>> mainData = new ArrayList<Map<String, Object>>();
        this.put("xjdj", "", mainData);
        this.put("jgsq", "", mainData);
        this.put("sqr", loginUser.getRealname(), mainData);
        this.put("sqsj", DateUtil.now(), mainData);
        this.put("sqbm", loginUser.getOrgCode(), mainData);
        this.put("sqfb", this.orgCode, mainData);
        this.put("lcbh", "", mainData);
        this.put("sqsy", "", mainData);
        this.put("zbdw", "", mainData);
        this.put("formtable_main_273_dt1", "", mainData);
        this.put("fkfs", "", mainData);
        this.put("tp", "", mainData);
        this.put("fj", "", mainData);
        this.put("bz", "", mainData);
        this.put("cgztgs", "", mainData);
        this.put("glzxwlcgsqhznsqxqsqdlc", "", mainData);
        this.put("lb", "", mainData);
        this.put("lylx", "\u4ef7\u683c\u7533\u8bf7", mainData);
        this.put("gllc", "", mainData);
        this.put("xjfw", "", mainData);
        this.put("xjdh", "", mainData);
        this.put("bb", "", mainData);
        this.put("xjrq", "", mainData);
        this.put("cgy", "", mainData);
        this.put("gysbm", StrUtil.emptyToDefault((CharSequence)vo.getSupplierCode(), (String)""), mainData);
        this.put("gysmc", StrUtil.emptyToDefault((CharSequence)vo.getSupplierName(), (String)""), mainData);
        this.put("jgsqbh", StrUtil.emptyToDefault((CharSequence)vo.getRequestNumber(), (String)""), mainData);
        return mainData;
    }

    private List<Map<String, Object>> getDetailData(PurchaseInformationRecordsRequestHeadVO vo) {
        List<PurchaseInformationRecordsRequestItem> itemList = vo.getInformationRecordsRequestItemList();
        if (!CollectionUtil.isEmpty(itemList)) {
            ArrayList<Map<String, Object>> detailData = new ArrayList<Map<String, Object>>();
            for (PurchaseInformationRecordsRequestItem item : itemList) {
                this.put("lb", StrUtil.emptyToDefault((CharSequence)item.getCateName(), (String)""), detailData);
                this.put("gysmc", StrUtil.emptyToDefault((CharSequence)item.getSupplierName(), (String)""), detailData);
                this.put("wlbh", StrUtil.emptyToDefault((CharSequence)item.getMaterialNumber(), (String)""), detailData);
                this.put("wlmc", StrUtil.emptyToDefault((CharSequence)item.getMaterialName(), (String)""), detailData);
                this.put("sl", "", detailData);
                this.put("wlgg", "", detailData);
                this.put("xqsl", "", detailData);
                this.put("xqsl", "", detailData);
                this.put("cgdw", StrUtil.emptyToDefault((CharSequence)item.getPurchaseUnit(), (String)""), detailData);
                if (item.getPrice() == null) {
                    this.put("dj", "", detailData);
                    this.put("hsdj", "", detailData);
                } else {
                    String price = item.getPrice().toString();
                    this.put("dj", price, detailData);
                    this.put("hsdj", price, detailData);
                }
                this.put("xqrq", "", detailData);
                this.put("zj", "", detailData);
                this.put("wsdj", "", detailData);
                this.put("gg", "", detailData);
                this.put("hsdj", "", detailData);
            }
        }
        return null;
    }

    private void put(String key, String value, List<Map<String, Object>> fields) {
        HashMap<String, String> zzhMap = new HashMap<String, String>();
        zzhMap.put("fieldName", key);
        zzhMap.put("fieldValue", value);
        fields.add(zzhMap);
    }
}

