/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.enumerate.PurchaseBomStatus;
import com.els.modules.material.excel.PurchaseBomHeadExportServiceImpl;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.vo.PurchaseBomHeadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/material/purchaseBomHead"})
@Api(tags={"BOM\u8868\u5934\u4fe1\u606f"})
@BusinessModule(module="bom")
public class PurchaseBomHeadController
extends BaseController<PurchaseBomHead, PurchaseBomHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBomHeadController.class);
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Autowired
    private PurchaseBomItemService purchaseBomItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:list"})
    @PermissionDataView(businessType="bom")
    public Result<?> queryPageList(PurchaseBomHead purchaseBomHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseBomHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseBomHeadService.page((IPage)page, (Wrapper)queryWrapper);
        pageList.getRecords().parallelStream().forEach(obj -> {
            if (!StringUtils.isEmpty((Object)obj.getNeedAudit()) && "0".equals(obj.getNeedAudit())) {
                obj.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
        });
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="BOM\u8868\u5355-\u6dfb\u52a0", operateType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:add"})
    public Result<?> add(@RequestBody PurchaseBomHeadVO purchaseBomHeadPage) {
        boolean flag;
        PurchaseBomHead purchaseBomHead = new PurchaseBomHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBomHeadPage), (Object)((Object)purchaseBomHead));
        if ("0".equals(purchaseBomHead.getNeedAudit())) {
            purchaseBomHead.setAuditStatus("");
        }
        boolean bl = flag = null != purchaseBomHeadPage.getEffectiveDate() && null != purchaseBomHeadPage.getExpiryDate() && purchaseBomHeadPage.getExpiryDate().before(purchaseBomHeadPage.getEffectiveDate());
        if (flag) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jXvKKIxOMUjXyWKI_d6139835", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f"));
        }
        purchaseBomHead.setBomStatus(PurchaseBomStatus.NEW.getValue());
        this.purchaseBomHeadService.saveMain(purchaseBomHead, purchaseBomHeadPage.getPurchaseBomItemList());
        return Result.ok((Object)((Object)purchaseBomHead));
    }

    @SrmValidated
    @AutoLog(value="BOM\u8868\u5355-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:edit"})
    @PermissionDataOpt(businessType="bom", beanClass=PurchaseBomHeadService.class)
    public Result<?> edit(@RequestBody PurchaseBomHeadVO purchaseBomHeadPage) {
        PurchaseBomHead purchaseBomHead = new PurchaseBomHead();
        BeanUtils.copyProperties((Object)((Object)purchaseBomHeadPage), (Object)((Object)purchaseBomHead));
        Assert.hasText((String)purchaseBomHead.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_VSMSLAo_a0c7ce40", (String)"\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801"));
        Assert.hasText((String)purchaseBomHead.getVersion(), (String)I18nUtil.translate((String)"i18n_alert_VSMrv_ddcd9169", (String)"\u8bf7\u586b\u5199\u7248\u672c"));
        this.purchaseBomHeadService.updateMain(purchaseBomHead, purchaseBomHeadPage.getPurchaseBomItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="BOM\u8868\u5355-\u901a\u8fc7id\u51bb\u7ed3")
    @ApiOperation(value="\u901a\u8fc7id\u51bb\u7ed3", notes="\u901a\u8fc7id\u51bb\u7ed3")
    @GetMapping(value={"/frozen"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:frozen"})
    @PermissionDataOpt(businessType="bom", beanClass=PurchaseBomHeadService.class)
    public Result<?> frozen(@RequestParam(name="id") String id) {
        this.purchaseBomHeadService.frozenBom(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="BOM\u8868\u5355-\u901a\u8fc7id\u89e3\u51bb")
    @ApiOperation(value="\u901a\u8fc7id\u89e3\u51bb", notes="\u901a\u8fc7id\u89e3\u51bb")
    @GetMapping(value={"/thaw"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:thaw"})
    @PermissionDataOpt(businessType="bom", beanClass=PurchaseBomHeadService.class)
    public Result<?> thaw(@RequestParam(name="id") String id) {
        this.purchaseBomHeadService.thawBom(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="BOM\u8868\u5355-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:cancel"})
    @PermissionDataOpt(businessType="bom", beanClass=PurchaseBomHeadService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        this.purchaseBomHeadService.cancelBom(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="BOM\u8868\u5355-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:delete"})
    @PermissionDataOpt(businessType="bom", beanClass=PurchaseBomHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseBomHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="BOM\u8868\u5355-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseBomHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="bom")
    @PermissionDataView(businessType="bom")
    @RequiresPermissions(value={"bom#PurchaseBomHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseBomHead purchaseBomHead = (PurchaseBomHead)((Object)this.purchaseBomHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseBomHeadVO purchaseBomHeadVO = new PurchaseBomHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseBomHead), (Object)((Object)purchaseBomHeadVO));
        List<PurchaseBomItem> purchaseBomItemList = this.purchaseBomItemService.selectByMainId(id);
        purchaseBomHeadVO.setPurchaseBomItemList(purchaseBomItemList);
        return Result.ok((Object)((Object)purchaseBomHeadVO));
    }

    @ApiOperation(value="BOM-\u9884\u89c8", notes="BOM-\u9884\u89c8")
    @GetMapping(value={"/preView"})
    @BusinessModule(module="bom")
    @RequiresPermissions(value={"bom#PurchaseBomHead:preView"})
    public Result<?> preView(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.purchaseBomHeadService.preView(id)));
    }

    @ApiOperation(value="\u901a\u8fc7BOM\u8868\u5934\u4fe1\u606fid\u67e5\u8be2BOM\u8868\u884c\u4fe1\u606f", notes="\u901a\u8fc7BOM\u8868\u5934\u4fe1\u606fid\u67e5\u8be2BOM\u8868\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryPurchaseBomItemByMainId"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:list"})
    public Result<?> queryPurchaseBomItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseBomItem> purchaseBomItemList = this.purchaseBomItemService.selectByMainId(id);
        return Result.ok(purchaseBomItemList);
    }

    @PermissionDataView(businessType="bom")
    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseBomHeadExportServiceImpl.class);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseBomHeadService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"bom#PurchaseBomHead:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseBomHeadService.pushDataToErp(ids);
        return Result.ok();
    }
}

