/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestSendStatusEnum;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.service.PurchaseInformationRecordsRequestHeadService;
import com.els.modules.price.service.PurchaseInformationRecordsRequestItemService;
import com.els.modules.price.vo.PurchaseInformationRecordsRequestHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/price/purchaseInformationRecordsRequest"})
@Api(tags={"\u4ef7\u683c\u7533\u8bf7\u5934"})
public class PurchaseInformationRecordsRequestHeadController
extends BaseController<PurchaseInformationRecordsRequestHead, PurchaseInformationRecordsRequestHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseInformationRecordsRequestHeadController.class);
    @Autowired
    private PurchaseInformationRecordsRequestHeadService purchaseInformationRecordsRequestHeadService;
    @Autowired
    private PurchaseInformationRecordsRequestItemService purchaseInformationRecordsRequestItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInformationRecordsRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInformationRecordsRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    private void baseDataBuild(PurchaseInformationRecordsRequestHead head) {
        if ("0".equals(head.getNeedAudit())) {
            head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            head.setNeedAudit("1");
            head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        head.setBusAccount(TenantContext.getTenant());
        head.setAutoPublish(CharSequenceUtil.emptyToDefault((CharSequence)head.getAutoPublish(), (String)"0"));
        head.setNeedSaleConfirm(CharSequenceUtil.emptyToDefault((CharSequence)head.getNeedSaleConfirm(), (String)"0"));
        head.setPartGeneratedPrice(CharSequenceUtil.emptyToDefault((CharSequence)head.getPartGeneratedPrice(), (String)"1"));
        head.setStatus(PriceRequestStatusEnum.NEW.getValue());
        head.setPublishStatus(PriceRequestSendStatusEnum.NO_PUBLISH.getValue());
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaseInformationRecordsRequestHeadVO purchaseInformationRecordsRequestHeadPage) {
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = new PurchaseInformationRecordsRequestHead();
        BeanUtils.copyProperties((Object)((Object)purchaseInformationRecordsRequestHeadPage), (Object)((Object)purchaseInformationRecordsRequestHead));
        this.baseDataBuild(purchaseInformationRecordsRequestHead);
        this.purchaseInformationRecordsRequestHeadService.saveMain(purchaseInformationRecordsRequestHead, purchaseInformationRecordsRequestHeadPage.getInformationRecordsRequestItemList(), purchaseInformationRecordsRequestHeadPage.getAttachmentList());
        return Result.ok((Object)((Object)purchaseInformationRecordsRequestHead));
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaseInformationRecordsRequestHeadVO purchaseInformationRecordsRequestHeadPage) {
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = new PurchaseInformationRecordsRequestHead();
        BeanUtils.copyProperties((Object)((Object)purchaseInformationRecordsRequestHeadPage), (Object)((Object)purchaseInformationRecordsRequestHead));
        this.baseDataBuild(purchaseInformationRecordsRequestHead);
        this.purchaseInformationRecordsRequestHeadService.updateMain(purchaseInformationRecordsRequestHead, purchaseInformationRecordsRequestHeadPage.getInformationRecordsRequestItemList(), purchaseInformationRecordsRequestHeadPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseInformationRecordsRequestHeadVO purchaseInformationRecordsRequestHeadPage) {
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = new PurchaseInformationRecordsRequestHead();
        BeanUtils.copyProperties((Object)((Object)purchaseInformationRecordsRequestHeadPage), (Object)((Object)purchaseInformationRecordsRequestHead));
        this.baseDataBuild(purchaseInformationRecordsRequestHead);
        this.purchaseInformationRecordsRequestHeadService.publish(purchaseInformationRecordsRequestHead, purchaseInformationRecordsRequestHeadPage.getInformationRecordsRequestItemList(), purchaseInformationRecordsRequestHeadPage.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e")
    @ApiOperation(value="\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e", notes="\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e")
    @PostMapping(value={"/createPrice/{headId}"})
    public Result<?> createPrice(@PathVariable(value="headId") String headId) {
        this.purchaseInformationRecordsRequestHeadService.createPriceByHead(headId);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u4ef7\u683c\u7533\u8bf7\u5934")
    @ApiOperation(value="\u4ef7\u683c\u7533\u8bf7\u5934\u4f5c\u5e9f", notes="\u4ef7\u683c\u7533\u8bf7\u5934\u4f5c\u5e9f")
    @PostMapping(value={"/cancel/{headId}"})
    public Result<?> cancel(@PathVariable(value="headId") String headId) {
        this.purchaseInformationRecordsRequestHeadService.cancel(headId);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseInformationRecordsRequestHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4ef7\u683c\u7533\u8bf7\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseInformationRecordsRequestHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseInformationRecordsRequestHead purchaseInformationRecordsRequestHead = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getById((Serializable)((Object)id)));
        PurchaseInformationRecordsRequestHeadVO purchaseInformationRecordsRequestHeadVO = new PurchaseInformationRecordsRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseInformationRecordsRequestHead), (Object)((Object)purchaseInformationRecordsRequestHeadVO));
        List<PurchaseInformationRecordsRequestItem> purchaseInformationRecordsRequestItemList = this.purchaseInformationRecordsRequestItemService.selectByMainId(id);
        purchaseInformationRecordsRequestHeadVO.setInformationRecordsRequestItemList(purchaseInformationRecordsRequestItemList);
        List attachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseInformationRecordsRequestHeadVO.setAttachmentList(attachmentDTOList);
        return Result.ok((Object)((Object)purchaseInformationRecordsRequestHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4ef7\u683c\u7533\u8bf7\u5934id\u67e5\u8be2\u4ef7\u683c\u7533\u8bf7\u884c", notes="\u901a\u8fc7\u4ef7\u683c\u7533\u8bf7\u5934id\u67e5\u8be2\u4ef7\u683c\u7533\u8bf7\u884c")
    @GetMapping(value={"/queryPurchaseInformationRecordsRequestItemByMainId"})
    public Result<?> queryPurchaseInformationRecordsRequestItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseInformationRecordsRequestItem> purchaseInformationRecordsRequestItemList = this.purchaseInformationRecordsRequestItemService.selectByMainId(id);
        return Result.ok(purchaseInformationRecordsRequestItemList);
    }
}

