/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialUnitDTO;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialMeterUnitListImportImpl")
public class PurchaseMaterialMeterUnitListImportImpl
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialMeterUnitListImportImpl.class);
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseMaterialUnitService purchaseMaterialUnitService;

    public List<Map<String, Object>> importExcel(List<Map<String, Object>> dataList) {
        ArrayList<PurchaseMaterialUnitDTO> list = new ArrayList<PurchaseMaterialUnitDTO>();
        for (Map<String, Object> data : dataList) {
            PurchaseMaterialUnitDTO entity = (PurchaseMaterialUnitDTO)JSON.parseObject((String)JSON.toJSONString(data), PurchaseMaterialUnitDTO.class);
            entity.setChangeUnit("=");
            entity.setElsAccount(TenantContext.getTenant());
            entity.setIsDefault(CharSequenceUtil.emptyToDefault((CharSequence)entity.getIsDefault(), (String)"1"));
            list.add(entity);
        }
        List dtoList = list.stream().filter(x -> CharSequenceUtil.isNotBlank((CharSequence)x.getMaterialNumber())).collect(Collectors.toList());
        List<String> materialNumberList = dtoList.stream().map(PurchaseMaterialUnitDTO::getMaterialNumber).distinct().collect(Collectors.toList());
        Map<String, PurchaseMaterialHead> materialIdMap = this.purchaseMaterialHeadService.listMaterialHeadByNumbers(materialNumberList, TenantContext.getTenant());
        List disEditList = materialIdMap.values().stream().filter(x -> !AuditStatusEnum.AUDIT_NEW.getValue().equals(x.getAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(x.getAuditStatus())).map(PurchaseMaterialHead::getMaterialNumber).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(disEditList)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u5f53\u524d\u7269\u6599\u4e0d\u5141\u8bb8\u66f4\u6539\u8ba1\u91cf\u5355\u4f4d:" + String.join((CharSequence)",", disEditList))));
        }
        ArrayList<PurchaseMaterialUnit> result = new ArrayList<PurchaseMaterialUnit>();
        for (PurchaseMaterialUnitDTO dto : dtoList) {
            if (!materialIdMap.containsKey(dto.getMaterialNumber())) continue;
            PurchaseMaterialUnit materialUnit = (PurchaseMaterialUnit)((Object)Convert.convert(PurchaseMaterialUnit.class, (Object)dto));
            materialUnit.setHeadId(materialIdMap.get(dto.getMaterialNumber()).getId());
            materialUnit.setElsAccount(TenantContext.getTenant());
            result.add(materialUnit);
        }
        if (CollUtil.isNotEmpty(result)) {
            this.purchaseMaterialUnitService.saveBatch(result);
        }
        return dataList;
    }
}

