/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.entity.SaleMaterialRelation;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialRelationService;
import com.els.modules.material.service.SaleMaterialRelationService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="saleMaterialRelationImportImpl")
public class SaleMaterialRelationImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired
    private PurchaseMaterialRelationService purchaseMaterialRelationService;
    @Autowired
    private SaleMaterialRelationService saleMaterialRelationService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = dataList.size();
        String elsAccount = TenantContext.getTenant();
        ArrayList<SaleMaterialRelation> list = new ArrayList<SaleMaterialRelation>();
        Date currentTime = new Date();
        ArrayList elsToElsAccountList = Lists.newArrayList();
        for (Map data : dataList) {
            elsToElsAccountList.add((String)data.get("toElsAccount") + "_" + (String)data.get("elsAccount"));
        }
        List supplierMasterDataDTOList = this.supplierMasterDataRpcService.listByElsAndToElsAccount((List)elsToElsAccountList);
        Map supplierMap = supplierMasterDataDTOList.stream().collect(Collectors.toMap(BaseDTO::getElsAccount, Function.identity(), (v1, v2) -> v1));
        HashMap materialMap = Maps.newHashMap();
        ArrayList<String> toElsMaterialNumber = new ArrayList<String>();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        for (Map data : dataList) {
            PurchaseMaterialHead materialHead;
            SaleMaterialRelation materialRelation = (SaleMaterialRelation)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), SaleMaterialRelation.class));
            materialRelation.setId(IdWorker.getIdStr());
            materialRelation.setRelationId(IdWorker.getIdStr());
            materialRelation.setElsAccount(elsAccount);
            materialRelation.setCreateAccount(elsAccount);
            materialRelation.setDeleted(CommonConstant.DEL_FLAG_0);
            materialRelation.setCreateTime(currentTime);
            if (StrUtil.isBlank((CharSequence)materialRelation.getBlocked())) {
                materialRelation.setBlocked("0");
            }
            materialRelation.setCreateBy(SysUtil.getUserRealName());
            materialRelation.setUpdateTime(currentTime);
            materialRelation.setUpdateBy(materialRelation.getCreateBy());
            String toElsAccount = materialRelation.getToElsAccount();
            SupplierMasterDataDTO masterData = (SupplierMasterDataDTO)supplierMap.get(toElsAccount);
            if (null == masterData) {
                String msg = I18nUtil.translate((String)"i18n_alert_RdXWWWeyWWWWWWxMKWVnIWFW_77bcc1ac", (String)("\u4f9b\u5e94\u5546ELS\u8d26\u53f7\uff1a" + toElsAccount + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01"), (String[])new String[]{toElsAccount});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            materialRelation.setSupplierCode(masterData.getSupplierCode());
            materialRelation.setSupplierName(masterData.getSupplierName());
            String materialNumber = materialRelation.getMaterialNumber();
            if (materialMap.containsKey(materialNumber)) {
                materialHead = (PurchaseMaterialHead)((Object)materialMap.get(materialNumber));
            } else {
                TenantContext.setTenant((String)toElsAccount);
                List materialList = this.purchaseMaterialHeadService.list((Wrapper)new QueryWrapper().eq((Object)"material_number", (Object)materialNumber));
                if (materialList.isEmpty()) {
                    String msg = I18nUtil.translate((String)"i18n_alert_SLAoWWxMK_c3a38ed4", (String)"\u7269\u6599\u7f16\u7801${0}\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                    this.errorAdd(excelImportDTO, msg, data);
                    continue;
                }
                materialHead = (PurchaseMaterialHead)((Object)materialList.get(0));
                materialMap.put(materialNumber, materialHead);
                materialNumberList.add(materialNumber);
            }
            materialRelation.setMaterialDesc(materialHead.getMaterialDesc());
            materialRelation.setMaterialSpec(materialHead.getMaterialSpec());
            list.add(materialRelation);
            String key = materialRelation.getToElsAccount() + materialRelation.getMaterialNumber();
            if (excelImportDTO.getOldDataMap().containsKey(key)) {
                ((List)excelImportDTO.getOldDataMap().get(key)).add(data);
            } else {
                excelImportDTO.getOldDataMap().put(key, Lists.newArrayList((Object[])new Map[]{data}));
            }
            toElsMaterialNumber.add(materialRelation.getToElsAccount() + "_" + materialRelation.getMaterialNumber());
        }
        if (CollectionUtil.isEmpty(toElsMaterialNumber)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        TenantContext.setTenant((String)elsAccount);
        List materialRelationList = this.saleMaterialRelationService.list((Wrapper)new QueryWrapper().in((Object)"concat(to_els_account,'_',material_number)", toElsMaterialNumber));
        Map relationMap = materialRelationList.stream().collect(Collectors.toMap(k -> k.getToElsAccount() + k.getMaterialNumber(), Function.identity(), (v1, v2) -> v2));
        ArrayList<PurchaseMaterialRelation> insertList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> insertSaleList = new ArrayList<SaleMaterialRelation>();
        ArrayList<PurchaseMaterialRelation> updateList = new ArrayList<PurchaseMaterialRelation>();
        ArrayList<SaleMaterialRelation> updateSaleList = new ArrayList<SaleMaterialRelation>();
        for (SaleMaterialRelation relation : list) {
            if (relationMap.containsKey(relation.getToElsAccount() + relation.getMaterialNumber())) {
                SaleMaterialRelation materialRelation = (SaleMaterialRelation)((Object)relationMap.get(relation.getToElsAccount() + relation.getMaterialNumber()));
                relation.setId(materialRelation.getId());
                relation.setRelationId(materialRelation.getRelationId());
                if (!elsAccount.equals(materialRelation.getCreateAccount())) {
                    String msg = I18nUtil.translate((String)"i18n_alert_nRCWWWeyWWWWWWWWnRCSLAyWWWWWWjtHnRCIOcIWxqKmcIW_6e9f438d", (String)("\u91c7\u8d2d\u65b9ELS\u8d26\u53f7\uff1a" + materialRelation.getToElsAccount() + " , \u91c7\u8d2d\u65b9\u7269\u6599\u7f16\u53f7\uff1a" + materialRelation.getMaterialNumber() + " \u7684\u8bb0\u5f55\u91c7\u8d2d\u65b9\u5df2\u7ecf\u521b\u5efa\uff0c\u4e0d\u53ef\u518d\u6b21\u521b\u5efa\uff01"), (String[])new String[]{materialRelation.getToElsAccount(), materialRelation.getMaterialNumber()});
                    List objectList = (List)excelImportDTO.getOldDataMap().get(relation.getToElsAccount() + relation.getMaterialNumber());
                    objectList.forEach(d -> {
                        d.put(this.getErrorTitle(), msg);
                        excelImportDTO.getErrorDataList().add(d);
                    });
                    continue;
                }
                updateSaleList.add(relation);
                PurchaseMaterialRelation purcahseMaterialRelation = new PurchaseMaterialRelation();
                BeanUtils.copyProperties((Object)((Object)relation), (Object)((Object)purcahseMaterialRelation));
                purcahseMaterialRelation.setId(relation.getRelationId());
                purcahseMaterialRelation.setRelationId(relation.getId());
                purcahseMaterialRelation.setElsAccount(relation.getToElsAccount());
                purcahseMaterialRelation.setToElsAccount(relation.getElsAccount());
                updateList.add(purcahseMaterialRelation);
                continue;
            }
            insertSaleList.add(relation);
            PurchaseMaterialRelation purcahseMaterialRelation = new PurchaseMaterialRelation();
            BeanUtils.copyProperties((Object)((Object)relation), (Object)((Object)purcahseMaterialRelation));
            purcahseMaterialRelation.setId(relation.getRelationId());
            purcahseMaterialRelation.setRelationId(relation.getId());
            purcahseMaterialRelation.setElsAccount(relation.getToElsAccount());
            purcahseMaterialRelation.setToElsAccount(relation.getElsAccount());
            insertList.add(purcahseMaterialRelation);
        }
        if (!insertList.isEmpty()) {
            this.purchaseMaterialRelationService.saveBatch(insertList, 2000);
            this.saleMaterialRelationService.saveBatch(insertSaleList, 2000);
        }
        if (!updateList.isEmpty()) {
            this.purchaseMaterialRelationService.updateBatchById(updateList, 2000);
            this.saleMaterialRelationService.updateBatchById(updateSaleList, 2000);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

