/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.entity.PurchaseMaterialRelation;
import com.els.modules.material.entity.SaleMaterialRelation;
import com.els.modules.material.excel.PurchaseMaterialRelationExportServiceImpl;
import com.els.modules.material.service.PurchaseMaterialRelationService;
import com.els.modules.material.service.SaleMaterialRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb"})
@RestController
@RequestMapping(value={"/material/purchaseMaterialRelation"})
public class PurchaseMaterialRelationController
extends BaseController<PurchaseMaterialRelation, PurchaseMaterialRelationService> {
    @Autowired
    private PurchaseMaterialRelationService purchaseMaterialRelationService;
    @Autowired
    private SaleMaterialRelationService saleMaterialRelationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:list"})
    @PermissionDataView(businessType="materialRelation")
    public Result<?> queryPageList(PurchaseMaterialRelation purchaseMaterialRelation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseMaterialRelation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseMaterialRelationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:add"})
    public Result<?> add(@RequestBody PurchaseMaterialRelation purchaseMaterialRelation) {
        this.purchaseMaterialRelationService.savePurchaseMaterialRelation(purchaseMaterialRelation);
        return Result.ok((Object)((Object)purchaseMaterialRelation));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:edit"})
    public Result<?> edit(@RequestBody PurchaseMaterialRelation purchaseMaterialRelation) {
        this.purchaseMaterialRelationService.updatePurchaseMaterialRelation(purchaseMaterialRelation);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u51bb\u7ed3/\u89e3\u51bb")
    @ApiOperation(value="\u51bb\u7ed3/\u89e3\u51bb", notes="\u51bb\u7ed3/\u89e3\u51bb")
    @GetMapping(value={"/blockOpt"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:blockOpt"})
    public Result<?> blockOpt(@RequestParam(name="id") String id) {
        PurchaseMaterialRelation materialRelation = (PurchaseMaterialRelation)((Object)this.purchaseMaterialRelationService.getById((Serializable)((Object)id)));
        if (!TenantContext.getTenant().equals(materialRelation.getCreateAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ROtkvCcIjWFW_e703a08d", (String)"\u53ea\u80fd\u64cd\u4f5c\u672c\u65b9\u521b\u5efa\u7684\u6570\u636e\uff01"));
        }
        PurchaseMaterialRelation relation = new PurchaseMaterialRelation();
        relation.setId(id);
        if ("1".equals(materialRelation.getBlocked())) {
            relation.setBlocked("0");
        } else {
            relation.setBlocked("1");
        }
        this.purchaseMaterialRelationService.updateById((Object)relation);
        SaleMaterialRelation saleMaterialRelation = new SaleMaterialRelation();
        saleMaterialRelation.setBlocked(relation.getBlocked());
        saleMaterialRelation.setId(materialRelation.getRelationId());
        this.saleMaterialRelationService.updateById((Object)saleMaterialRelation);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseMaterialRelationService.delPurchaseMaterialRelation(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseMaterialRelationService.delBatchPurchaseMaterialRelation(idList);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9500\u552e\u7269\u6599\u5173\u7cfb-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseMaterialRelation purchaseMaterialRelation = (PurchaseMaterialRelation)((Object)this.purchaseMaterialRelationService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)purchaseMaterialRelation));
    }

    @GetMapping(value={"/exportXls"})
    @PermissionDataView(businessType="materialRelation")
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseMaterialRelationExportServiceImpl.class);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseMaterialRelationService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"materialRelation#PurchaseMaterialRelation:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseMaterialRelationService.pushDataToErp(ids);
        return Result.ok();
    }
}

