/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.material.entity.PurchaseBomHead;
import com.els.modules.material.entity.PurchaseBomItem;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.service.PurchaseBomHeadService;
import com.els.modules.material.service.PurchaseBomItemService;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseBomItemImportImpl")
public class PurchaseBomItemImportImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseBomItemImportImpl.class);
    @Autowired
    private PurchaseBomHeadService purchaseBomHeadService;
    @Autowired
    private PurchaseBomItemService purchaseBomItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    private String headId;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            PurchaseBomHead dbHead = (PurchaseBomHead)((Object)this.purchaseBomHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseBomItem> itemList = this.purchaseBomItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return Lists.newArrayList(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List configItemList = this.getTemplate(excelImportDTO.getExcelByConfigDTO()).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber"};
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        editColumn.addAll(Arrays.asList(excludeColumn));
        ArrayList mastrialNumbers = Lists.newArrayList();
        for (Map data : dataList) {
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            String materialNumber = (String)data.get("materialNumber");
            if (!CharSequenceUtil.isNotEmpty((CharSequence)materialNumber)) continue;
            mastrialNumbers.add(materialNumber);
        }
        List<PurchaseMaterialHead> masterialList = this.purchaseMaterialHeadService.getMaterialHeadByNumbers(mastrialNumbers);
        Map materialHeadMap = masterialList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Field[] fields;
            Map data = (Map)iterator.next();
            String materialNumber = (String)data.get("materialNumber");
            if (!CharSequenceUtil.isNotEmpty((CharSequence)materialNumber)) continue;
            PurchaseMaterialHead head = (PurchaseMaterialHead)((Object)materialHeadMap.get(materialNumber));
            if (null == head) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoWWxMK_c3a38ed4", (String)"\u7269\u6599\u7f16\u7801${0}\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            data.put("materialId", head.getId());
            for (Field field : fields = ConvertUtils.getAllFields((Object)((Object)head))) {
                if (!data.containsKey(field.getName()) || !MATER_STRING.contains(field.getName())) continue;
                try {
                    field.setAccessible(true);
                    data.put(field.getName(), field.get((Object)head));
                }
                catch (IllegalAccessException e) {
                    log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

