/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialItemService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseMaterialListItemImportImpl")
public class PurchaseMaterialListItemImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseMaterialListItemImportImpl.class);
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Resource
    private PurchaseMaterialItemService purchaseMaterialItemService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String materialNumber = (String)data.get("materialNumber");
            if (CharSequenceUtil.isEmpty((CharSequence)materialNumber)) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoxOLVW_47edf9d6", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
            }
            if (materialNumberList.contains(materialNumber)) continue;
            materialNumberList.add(materialNumber);
        }
        Map<String, PurchaseMaterialHead> materialIdMap = this.purchaseMaterialHeadService.listMaterialHeadByNumbers(materialNumberList, TenantContext.getTenant());
        ArrayList<PurchaseMaterialItem> itemList = new ArrayList<PurchaseMaterialItem>();
        for (Map data : dataList) {
            String msg;
            String materialNumber = (String)data.get("materialNumber");
            PurchaseMaterialHead materialHead = materialIdMap.get(materialNumber);
            if (null == materialHead) {
                msg = I18nUtil.translate((String)"i18n_alert_SLAo0xMK_cf1be15e", (String)"\u7269\u6599\u7f16\u7801${0}\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (AuditStatusEnum.AUDIT_DOING.getValue().equals(materialHead.getAuditStatus())) {
                msg = I18nUtil.translate((String)"i18n_alert_SLAo0UzsxquNcWF_3a6c74e9", (String)"\u7269\u6599\u7f16\u7801${0}\u5ba1\u6279\u4e2d\uff0c\u4e0d\u53ef\u5bfc\u5165\u884c\u6570\u636e", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if ("1".equals(materialHead.getBlocDel())) {
                msg = I18nUtil.translate((String)"i18n_alert_SLAo0IteQGxquNcWF_ac76d886", (String)"\u7269\u6599\u7f16\u7801${0}\u5df2\u96c6\u56e2\u5220\u9664\uff0c\u4e0d\u53ef\u5bfc\u5165\u884c\u6570\u636e", (String[])new String[]{materialNumber});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            PurchaseMaterialItem entity = (PurchaseMaterialItem)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseMaterialItem.class));
            entity.setHeadId(materialHead.getId());
            entity.setElsAccount(materialHead.getElsAccount());
            entity.setMaterialNumber(materialNumber);
            itemList.add(entity);
        }
        if (CollUtil.isNotEmpty(itemList)) {
            this.purchaseMaterialItemService.saveBatch(itemList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

