/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.third.u8.api.job;

import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

@RpcService
public class MaterialCodeFromLuoShiJobRpcServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(MaterialCodeFromLuoShiJobRpcServiceImpl.class);
    private final String LOCK_PREFIX = "material_schedule_materialFromLuoShiJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;

    public void execute(String parameter) {
        String requestId;
        TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        if (loginUser == null) {
            loginUser = new LoginUserDTO();
            loginUser.setElsAccount(SysUtil.getPurchaseAccount());
            loginUser.setSubAccount("1001");
            LoginUserContext.setUser((LoginUserDTO)loginUser);
        }
        if (!this.redisUtil.tryGetDistributedLock("material_schedule_materialFromLuoShiJob", requestId = "materialFromLuoShiJob", 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LSiKRcWVxPVBRc_38df5694", (String)"\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            log.info("\u7269\u6599\u5206\u7c7b\u5b9a\u65f6\u4efb\u52a1 MaterialJobRpcServiceImpl \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
            this.purchaseMaterialCodeService.getDataByErp();
            log.info("\u7269\u6599\u5206\u7c7b\u5b9a\u65f6\u4efb\u52a1 MaterialJobRpcServiceImpl \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        }
        catch (Exception e) {
            log.info(Thread.currentThread().getName() + "\u83b7\u53d6U8C\u7269\u6599\u4e3b\u6570\u636e\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("material_schedule_materialFromLuoShiJob", requestId);
        }
    }

    @Scheduled(cron="0 59 23 * * *")
    public void doScheduled() {
        this.execute(null);
    }
}

