/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.api.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="price_create")
public class PurchasePriceCreateServiceImpl
implements OpenApiRpcService {
    @Autowired
    private PurchaseInformationRecordsService purchaseInformationRecordsService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        String account = TenantContext.getTenant();
        Date currentTime = new Date();
        ArrayList<PurchaseInformationRecords> headList = new ArrayList<PurchaseInformationRecords>();
        ArrayList<String> code = new ArrayList<String>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseInformationRecords head = (PurchaseInformationRecords)((Object)ConvertUtils.convertDefault(PurchaseInformationRecords.class, (JSONObject)object, defaultHeadMap));
            if (null != head.getExpiryDate() && null != head.getEffectiveDate() && head.getExpiryDate().before(head.getEffectiveDate())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
            }
            String materialNumber = head.getMaterialNumber();
            String toElsAccount = head.getToElsAccount();
            if (CharSequenceUtil.isNotEmpty((CharSequence)materialNumber) && !code.contains(materialNumber)) {
                code.add(materialNumber);
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)toElsAccount) && !toElsAccountList.contains(toElsAccount)) {
                toElsAccountList.add(toElsAccount);
            }
            head.setElsAccount(account);
            head.setCreateTime(currentTime);
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setBusAccount(account);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion(templateHead.getTemplateVersion());
            if (CharSequenceUtil.isEmpty((CharSequence)head.getAuditStatus())) {
                head.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            if (CharSequenceUtil.isEmpty((CharSequence)head.getRecordStatus())) {
                head.setRecordStatus(PriceStatusEnum.NEW.getValue());
            }
            headList.add(head);
        }
        if (!headList.isEmpty()) {
            PurchaseInformationRecords entity = (PurchaseInformationRecords)((Object)headList.get(0));
            int size = (int)headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getInfoRecordNumber())).count();
            List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPriceNumber", (Object)entity, size);
            int codeIndex = 0;
            for (PurchaseInformationRecords e : headList) {
                if (!CharSequenceUtil.isEmpty((CharSequence)e.getInfoRecordNumber())) continue;
                e.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
            }
            this.purchaseInformationRecordsService.saveBatch(headList);
        }
        return null;
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "price";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return ClassTypeBuilder.buildClassTypeList(PurchaseInformationRecords.class, null, null);
    }

    public List<String> supportItemList() {
        return Lists.newArrayList((Object[])new String[]{"itemList"});
    }
}

