/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.price.rpc.service.PriceInvokeSupplierRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseMaterialSourceImportRpcServiceImpl")
public class PurchaseMaterialSourceExcelHandler
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMaterialHeadService purchaseMaterialHeadService;
    @Autowired
    private PriceInvokeSupplierRpcService priceInvokeSupplierRpcService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        Object headList;
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("materialSource");
        ArrayList<PurchaseMaterialSource> entityList = new ArrayList<PurchaseMaterialSource>();
        ArrayList<String> code = new ArrayList<String>();
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        for (Map data : dataList) {
            String materialNumber = (String)data.get("materialNumber");
            String toElsAccount = (String)data.get("toElsAccount");
            if (CharSequenceUtil.isNotEmpty((CharSequence)materialNumber) && !code.contains(materialNumber)) {
                code.add(materialNumber);
            }
            if (!CharSequenceUtil.isNotEmpty((CharSequence)toElsAccount) || toElsAccountList.contains(toElsAccount)) continue;
            toElsAccountList.add(toElsAccount);
        }
        Map<Object, Object> collectMaterialMap = new HashMap();
        if (CollUtil.isNotEmpty(code)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialHead::getMaterialNumber, PurchaseMaterialHead::getMaterialName, PurchaseMaterialHead::getMaterialDesc, PurchaseMaterialHead::getMaterialGroup, ParentEntity::getId, PurchaseMaterialHead::getBaseUnit});
            wrapper.in(PurchaseMaterialHead::getMaterialNumber, code);
            headList = this.purchaseMaterialHeadService.list((Wrapper)wrapper);
            collectMaterialMap = headList.stream().collect(Collectors.toMap(PurchaseMaterialHead::getMaterialNumber, Function.identity(), (v1, v2) -> v1));
        }
        Map<Object, Object> collectMasterMap = new HashMap();
        if (CollUtil.isNotEmpty(toElsAccountList)) {
            headList = this.priceInvokeSupplierRpcService.listByElsAccount(toElsAccountList);
            collectMasterMap = headList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v1));
        }
        for (Map data : dataList) {
            PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)this.transferEntity(data, PurchaseMaterialSource.class, excelImportDTO));
            if (null == entity) continue;
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion().toString());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setElsAccount(SysUtil.getLoginUser().getElsAccount());
            if (null != entity.getExpiryDate() && null != entity.getEffectiveDate() && entity.getExpiryDate().before(entity.getEffectiveDate())) {
                String msg = I18nUtil.translate((String)"i18n_alert_jXyWBAxOQUjXvKBA_1c8fbe", (String)"\u6709\u6548\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u6709\u6548\u5f00\u59cb\u65e5\u671f");
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            PurchaseMaterialHead materialHead = (PurchaseMaterialHead)((Object)collectMaterialMap.get(entity.getMaterialNumber()));
            if (CharSequenceUtil.isNotEmpty((CharSequence)entity.getMaterialNumber()) && null == materialHead) {
                String msg = I18nUtil.translate((String)"i18n_alert_SLAoxMK_cdf9d7c2", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728") + entity.getMaterialNumber();
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (CharSequenceUtil.isBlank((CharSequence)entity.getMaterialNumber())) {
                entity.setMaterialId(null);
                entity.setMaterialDesc(null);
                entity.setMaterialGroup(null);
            }
            if (null != materialHead) {
                entity.setMaterialId(materialHead.getId());
                entity.setMaterialDesc(materialHead.getMaterialDesc());
                entity.setMaterialGroup(materialHead.getMaterialGroup());
            }
            SupplierMasterDataDTO masterDataDTO = (SupplierMasterDataDTO)collectMasterMap.get(entity.getToElsAccount());
            if (CharSequenceUtil.isBlank((CharSequence)entity.getToElsAccount())) {
                entity.setToElsAccount(null);
                entity.setToElsDesc(null);
                entity.setSupplierCode(null);
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)entity.getToElsAccount()) && null == masterDataDTO) {
                String msg = I18nUtil.translate((String)"i18n_alert_RdXWWWeyWWWWWWxMKWVnIWFW_77bcc1ac", (String)("\u4f9b\u5e94\u5546ELS\u8d26\u53f7\uff1a" + entity.getToElsAccount() + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\uff01"), (String[])new String[]{entity.getToElsAccount()});
                this.errorAdd(excelImportDTO, msg, data);
                continue;
            }
            if (null != masterDataDTO) {
                entity.setSupplierCode(masterDataDTO.getSupplierCode());
                entity.setToElsDesc(masterDataDTO.getSupplierName());
            }
            entity.setStatus(MaterialSourceStatusEnum.NEW.getValue());
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        PurchaseMaterialSource entity = (PurchaseMaterialSource)((Object)entityList.get(0));
        int size = entityList.size();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("materialSourceNumber", (Object)entity, size);
        int codeIndex = 0;
        for (PurchaseMaterialSource e : entityList) {
            e.setSourceId((String)nextCodes.get(codeIndex++));
        }
        this.purchaseMaterialSourceService.saveBatch(entityList);
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

