/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.material.api.rpc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.material.api.dto.PurchaseMaterialCodeDTO;
import com.els.modules.material.api.dto.PurchaseMaterialUnitNewDTO;
import com.els.modules.material.api.dto.TreeMaterialCodeNodeDTO;
import com.els.modules.material.api.service.PurchaseMaterialCodeRpcService;
import com.els.modules.material.entity.PurchaseMaterialCode;
import com.els.modules.material.service.PurchaseMaterialCodeService;
import com.els.modules.material.service.PurchaseMaterialUnitService;
import com.els.modules.material.vo.PurchaseMaterialUnitVO;
import com.els.modules.material.vo.TreeMaterialCodeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@RpcService
public class PurchaseMaterialCodeBeanServiceImpl
implements PurchaseMaterialCodeRpcService {
    @Autowired
    private PurchaseMaterialCodeService purchaseMaterialCodeService;
    @Autowired
    private PurchaseMaterialUnitService materialUnitService;

    public PurchaseMaterialCodeDTO selectById(String id) {
        PurchaseMaterialCode code = (PurchaseMaterialCode)((Object)this.purchaseMaterialCodeService.getById((Serializable)((Object)id)));
        return (PurchaseMaterialCodeDTO)SysUtil.copyProperties((Object)((Object)code), PurchaseMaterialCodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> selectMaterialCateListByCodeList(List<String> cateCodeList) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List<PurchaseMaterialCode> purchaseMaterialCodeList = this.purchaseMaterialCodeService.listByCodeList(cateCodeList, loginUser.getElsAccount());
        return SysUtil.copyProperties(purchaseMaterialCodeList, PurchaseMaterialCodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> listByIds(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseMaterialCodeList = this.purchaseMaterialCodeService.listByIds(idList);
        return SysUtil.copyProperties((List)purchaseMaterialCodeList, PurchaseMaterialCodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> listByElsAccount() {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        List<PurchaseMaterialCode> purchaseMaterialCodeList = this.purchaseMaterialCodeService.listByElsAccount(loginUser.getElsAccount());
        return SysUtil.copyProperties(purchaseMaterialCodeList, PurchaseMaterialCodeDTO.class);
    }

    public boolean updateBatchById(List<PurchaseMaterialCodeDTO> list) {
        ArrayList purchaseMaterialCodes = SysUtil.copyProperties(list, PurchaseMaterialCode.class);
        return this.purchaseMaterialCodeService.updateBatchById(purchaseMaterialCodes);
    }

    public List<TreeMaterialCodeNodeDTO> list(List<String> idList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!CollectionUtils.isEmpty(idList)) {
            queryWrapper.in((Object)"id", idList);
        }
        List<TreeMaterialCodeNode> materialCodeTree = this.purchaseMaterialCodeService.getMaterialCodeTree((QueryWrapper<PurchaseMaterialCode>)queryWrapper);
        return SysUtil.copyProperties(materialCodeTree, TreeMaterialCodeNodeDTO.class);
    }

    public List<PurchaseMaterialCodeDTO> listMaterialCodeBySale(List<String> codes, String elsAccount) {
        List<PurchaseMaterialCode> list = this.purchaseMaterialCodeService.listMaterialCodeBySale(codes, elsAccount);
        return SysUtil.copyProperties(list, PurchaseMaterialCodeDTO.class);
    }

    public List<PurchaseMaterialUnitNewDTO> getByMaterialNumber(String materialNumber) {
        List<PurchaseMaterialUnitVO> unitVOS = this.materialUnitService.getByMaterialNumber(materialNumber);
        return SysUtil.copyProperties(unitVOS, PurchaseMaterialUnitNewDTO.class);
    }
}

