/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.adapter;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestHead;
import com.els.modules.price.entity.PurchaseInformationRecordsRequestItem;
import com.els.modules.price.enumerate.PriceRequestStatusEnum;
import com.els.modules.price.service.PurchaseInformationRecordsRequestHeadService;
import com.els.modules.price.service.PurchaseInformationRecordsRequestItemService;
import com.els.modules.price.vo.PurchaseInformationRecordsRequestHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@RpcService(value="purchaseInformationRequestAuditDubboAdapter")
public class PurchaseInformationRecordsRequestAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    PurchaseInformationRecordsRequestHeadService purchaseInformationRecordsRequestHeadService;
    @Autowired
    PurchaseInformationRecordsRequestItemService purchaseInformationRecordsRequestItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        Map<String, Object> byId = this.getById(flowCallbackDTO.getBusinessId());
        PurchaseInformationRecordsRequestHeadVO records = (PurchaseInformationRecordsRequestHeadVO)((Object)JSON.parseObject((String)JSONObject.toJSONString(byId), PurchaseInformationRecordsRequestHeadVO.class));
        this.purchaseInformationRecordsRequestHeadService.checkPrice(records, records.getInformationRecordsRequestItemList(), true);
        this.updateRecordRequest(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseInformationRecordsRequestHead records = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        records.setId(flowCallbackDTO.getBusinessId());
        records.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        records.setFlowId(flowCallbackDTO.getProcessInstanceId());
        records.setAuditRemark(flowCallbackDTO.getOpinion());
        boolean count = this.purchaseInformationRecordsRequestHeadService.updateById((Object)records);
        if (!count) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        if ("1".equals(records.getAutoPublish())) {
            PurchaseInformationRecordsRequestHead head = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getById((Serializable)((Object)records.getId())));
            List<PurchaseInformationRecordsRequestItem> itemList = this.purchaseInformationRecordsRequestItemService.selectByMainId(records.getId());
            List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(records.getId());
            this.purchaseInformationRecordsRequestHeadService.publish(head, itemList, attachmentList);
        }
        if ("0".equals(records.getNeedSaleConfirm())) {
            records.setStatus(PriceRequestStatusEnum.WAIT_TO_CREATE_PRICE.getValue());
            this.purchaseInformationRecordsRequestHeadService.updateById((Object)records);
        }
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateRecordRequest(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateRecordRequest(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseInformationRecordsRequestHeadVO records = new PurchaseInformationRecordsRequestHeadVO();
        PurchaseInformationRecordsRequestHead byId = (PurchaseInformationRecordsRequestHead)((Object)this.purchaseInformationRecordsRequestHeadService.getById((Serializable)((Object)id)));
        List<PurchaseInformationRecordsRequestItem> purchaseInformationRecordsRequestItems = this.purchaseInformationRecordsRequestItemService.selectByMainId(id);
        BeanUtil.copyProperties((Object)((Object)byId), (Object)((Object)records), (String[])new String[0]);
        records.setInformationRecordsRequestItemList(purchaseInformationRecordsRequestItems);
        return SrmUtil.toJSONObject((Object)((Object)records));
    }

    private void updateRecordRequest(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseInformationRecordsRequestHead records = new PurchaseInformationRecordsRequestHead();
        records.setId(flowCallbackDTO.getBusinessId());
        records.setAuditStatus(auditStatus);
        records.setFlowId(flowCallbackDTO.getProcessInstanceId());
        records.setAuditRemark(flowCallbackDTO.getOpinion());
        boolean count = this.purchaseInformationRecordsRequestHeadService.updateById((Object)records);
        if (!count) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }
}

