/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="materialPriceGetByMaterial")
public class MaterialPriceGetByMaterialServiceImpl
implements SimpleOpenApiRpcService {
    public JSONObject invoke(JSONObject param) {
        List materialNumberList = param.getJSONArray("materialNumber").toJavaList(String.class);
        List materialNameList = new ArrayList();
        if (param.containsKey((Object)"materialName")) {
            JSONArray jsonArray = param.getJSONArray("materialName");
            materialNameList = jsonArray.toJavaList(String.class);
        }
        JSONObject result = new JSONObject();
        result.put("code", (Object)"200");
        if (CollectionUtil.isEmpty((Collection)materialNumberList) && CollectionUtil.isEmpty(materialNameList)) {
            result.put("result", (Object)"[]");
            return result;
        }
        String groupFiled = param.getString("groupFiled");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(CollectionUtil.isNotEmpty((Collection)materialNumberList), PurchaseInformationRecords::getMaterialNumber, (Collection)materialNumberList)).in(CollectionUtil.isNotEmpty(materialNameList), PurchaseInformationRecords::getMaterialDesc, materialNameList)).eq(PurchaseInformationRecords::getRecordStatus, (Object)"6");
        List list = ((PurchaseInformationRecordsService)SpringContextUtils.getBean(PurchaseInformationRecordsService.class)).list((Wrapper)wrapper);
        ArrayList<JSONObject> historyPriceList = new ArrayList<JSONObject>();
        for (PurchaseInformationRecords records : list) {
            String supplierName = records.getSupplierName();
            BigDecimal price = records.getPrice();
            BigDecimal netPrice = records.getNetPrice();
            Date quoteDate = records.getQuoteDate();
            if (null == quoteDate) {
                quoteDate = records.getEffectiveDate();
            }
            JSONObject item = new JSONObject();
            item.put("\u4f9b\u5e94\u5546\u540d\u79f0", (Object)supplierName);
            item.put("\u7269\u6599\u540d\u79f0", (Object)records.getMaterialDesc());
            item.put("\u7269\u6599\u7f16\u7801", (Object)records.getMaterialNumber());
            item.put("\u542b\u7a0e\u5355\u4ef7", (Object)price);
            item.put("\u4e0d\u542b\u7a0e\u5355\u4ef7", (Object)netPrice);
            String dateFormat = quoteDate == null ? "" : DateUtil.format((Date)quoteDate, (String)"yyyy-MM-dd");
            item.put("\u4ef7\u683c\u65e5\u671f", (Object)dateFormat);
            historyPriceList.add(item);
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)groupFiled)) {
            Map<String, List<JSONObject>> historyPriceListMap = historyPriceList.stream().collect(Collectors.groupingBy(x -> x.getString(groupFiled)));
            historyPriceListMap.forEach((key, subList) -> subList.sort(Comparator.comparing(json -> json.getString("\u4ef7\u683c\u65e5\u671f"), Comparator.nullsFirst(String::compareTo))));
            result.put("result", (Object)JSON.toJSONString(historyPriceListMap));
        } else {
            result.put("result", (Object)JSON.toJSONString(historyPriceList));
        }
        return result;
    }
}

